/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.tigr.microarray.mev.AcknowlegementDialog;
import org.tigr.microarray.mev.ArrayViewer;
import org.tigr.microarray.mev.DatabaseLoginDialog;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.ISlideDataElement;
import org.tigr.microarray.mev.InfoDisplay;
import org.tigr.microarray.mev.InformationPanel;
import org.tigr.microarray.mev.MevCitationDialog;
import org.tigr.microarray.mev.MultipleArrayData;
import org.tigr.microarray.mev.MultipleArrayMenubar;
import org.tigr.microarray.mev.MultipleArrayViewer;
import org.tigr.microarray.mev.PaperReferencesDialog;
import org.tigr.microarray.mev.SetDatabaseDialog;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.annotation.InvalidAnnMappingFileException;
import org.tigr.microarray.mev.file.FileLoadInfo;
import org.tigr.util.BrowserLauncher;
import org.tigr.util.Query;
import org.tigr.util.awt.ActionInfoEvent;
import org.tigr.util.awt.ActionInfoListener;
import org.tigr.util.awt.ImageScreen;
import org.tigr.util.awt.MessageDisplay;

public class Manager {
    private static Vector<Component> activeComponents;
    private JFrame frame;
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenuItem newMultipleArrayViewerItem;
    private JMenuItem newPreferencesItem;
    private JMenuItem loginItem;
    private JMenuItem quitItem;
    private JMenu preferencesMenu;
    private JRadioButtonMenuItem javaLFItem;
    private JRadioButtonMenuItem windowsLFItem;
    private JRadioButtonMenuItem motifLFItem;
    private JCheckBoxMenuItem toolTipsItem;
    private JCheckBoxMenuItem promptToSaveItem;
    private JCheckBoxMenuItem promptToGetOnlineItem;
    private JMenuItem selectURLLinkoutFile;
    private static JMenu windowMenu;
    private JMenu referencesMenu;
    private JMenuItem systemInfoItem;
    private JMenuItem acknolMenuItem;
    private JMenuItem papersMenuItem;
    private JMenuItem citationMenuItem;
    private JMenuItem aboutMenuItem;
    private ButtonGroup buttonGroup;
    private JMenu helpMenu;
    private JMenuItem bugReportMenuItem;
    private JMenuItem featureReqMenuItem;
    private JMenuItem documentMenuItem;
    private static EventListener eventListener;

    public Manager() {
        try {
            activeComponents = new Vector();
            eventListener = new EventListener();
            this.initializeFrame();
            this.initializeInput();
        }
        catch (Exception e) {
            System.out.println("Exception (Manager.const()): " + e);
            e.printStackTrace();
        }
    }

    public void initializeFrame() {
        this.frame = new JFrame("MultiExperiment Viewer");
        this.frame.addWindowListener(eventListener);
        this.initializeMenuBar(this.frame);
        this.frame.setSize(this.frame.getPreferredSize());
        String iconFile = "org/tigr/images/icon.png";
        URL iconURL = this.getClass().getClassLoader().getResource(iconFile);
        ImageIcon imgIcon = new ImageIcon(iconURL);
        if (imgIcon != null) {
            this.frame.setIconImage(imgIcon.getImage());
        }
        this.frame.setResizable(true);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public void initializeMenuBar(JFrame frame) {
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu("File");
        this.newMultipleArrayViewerItem = new JMenuItem("New Multiple Array Viewer");
        this.newMultipleArrayViewerItem.addActionListener(eventListener);
        this.newMultipleArrayViewerItem.setMnemonic(77);
        this.fileMenu.add(this.newMultipleArrayViewerItem);
        this.fileMenu.addSeparator();
        this.quitItem = new JMenuItem("Quit");
        this.quitItem.addActionListener(eventListener);
        this.quitItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.fileMenu.add(this.quitItem);
        this.menuBar.add(this.fileMenu);
        this.preferencesMenu = new JMenu("Preferences");
        this.buttonGroup = new ButtonGroup();
        this.javaLFItem = new JRadioButtonMenuItem("Metal L&F");
        this.javaLFItem.addActionListener(eventListener);
        this.preferencesMenu.add(this.javaLFItem);
        this.buttonGroup.add(this.javaLFItem);
        this.javaLFItem.setSelected(true);
        this.windowsLFItem = new JRadioButtonMenuItem("Windows L&F");
        this.windowsLFItem.addActionListener(eventListener);
        this.preferencesMenu.add(this.windowsLFItem);
        this.buttonGroup.add(this.windowsLFItem);
        this.motifLFItem = new JRadioButtonMenuItem("Motif L&F");
        this.motifLFItem.addActionListener(eventListener);
        this.preferencesMenu.add(this.motifLFItem);
        this.buttonGroup.add(this.motifLFItem);
        this.toolTipsItem = new JCheckBoxMenuItem("Show ToolTips");
        this.toolTipsItem.addActionListener(eventListener);
        this.preferencesMenu.add(this.toolTipsItem);
        this.toolTipsItem.setSelected(true);
        this.promptToSaveItem = new JCheckBoxMenuItem("Prompt to save analysis before closing");
        this.promptToSaveItem.addActionListener(eventListener);
        this.preferencesMenu.add(this.promptToSaveItem);
        this.promptToSaveItem.setSelected(new Boolean(TMEV.getSettingForOption("prompt-for-save")));
        this.promptToGetOnlineItem = new JCheckBoxMenuItem("Ask to get online");
        this.promptToGetOnlineItem.addActionListener(eventListener);
        this.preferencesMenu.add(this.promptToGetOnlineItem);
        this.promptToGetOnlineItem.setSelected(new Boolean(TMEV.getSettingForOption("prompt-to-get-online")));
        this.selectURLLinkoutFile = new JMenuItem("Select annotation linkout file...");
        this.selectURLLinkoutFile.addActionListener(eventListener);
        this.preferencesMenu.add(this.selectURLLinkoutFile);
        this.menuBar.add(this.preferencesMenu);
        windowMenu = new JMenu("Window");
        windowMenu.setEnabled(false);
        windowMenu.addActionListener(eventListener);
        this.menuBar.add(windowMenu);
        this.referencesMenu = new JMenu("About");
        this.acknolMenuItem = new JMenuItem("Credits");
        this.acknolMenuItem.addActionListener(eventListener);
        this.referencesMenu.add(this.acknolMenuItem);
        this.papersMenuItem = new JMenuItem("Papers / Publications");
        this.papersMenuItem.addActionListener(eventListener);
        this.referencesMenu.add(this.papersMenuItem);
        this.citationMenuItem = new JMenuItem("Referencing MeV...");
        this.citationMenuItem.addActionListener(eventListener);
        this.referencesMenu.add(this.citationMenuItem);
        this.referencesMenu.addSeparator();
        this.systemInfoItem = new JMenuItem("System Info");
        this.systemInfoItem.addActionListener(eventListener);
        this.referencesMenu.add(this.systemInfoItem);
        this.referencesMenu.addSeparator();
        this.aboutMenuItem = new JMenuItem("About MeV");
        this.aboutMenuItem.addActionListener(eventListener);
        this.referencesMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.referencesMenu);
        this.helpMenu = new JMenu("Help");
        this.documentMenuItem = new JMenuItem("Mev Manual");
        this.documentMenuItem.addActionListener(eventListener);
        this.bugReportMenuItem = new JMenuItem("Report Bug");
        this.bugReportMenuItem.addActionListener(eventListener);
        this.helpMenu.add(this.documentMenuItem);
        this.helpMenu.add(this.bugReportMenuItem);
        this.featureReqMenuItem = new JMenuItem("Request a Feature");
        this.featureReqMenuItem.addActionListener(eventListener);
        this.helpMenu.add(this.featureReqMenuItem);
        this.menuBar.add(this.helpMenu);
        frame.setJMenuBar(this.menuBar);
        this.menuBar.setPreferredSize(new Dimension(Math.min(Toolkit.getDefaultToolkit().getScreenSize().width - 2, 1550), this.menuBar.getFontMetrics(this.menuBar.getFont()).getHeight() + 5));
    }

    public boolean selectPreferencesFile() {
        File inputFile = null;
        JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
        chooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                if (f.getName().endsWith("Preferences")) {
                    return true;
                }
                if (f.getName().endsWith("preferences")) {
                    return true;
                }
                return f.getName().endsWith(".pref");
            }

            @Override
            public String getDescription() {
                return "Preference Files";
            }
        });
        chooser.setDialogTitle("Select Preferences File");
        chooser.setMultiSelectionEnabled(false);
        chooser.setCurrentDirectory(TMEV.getFile("preferences/"));
        if (chooser.showOpenDialog(this.frame) != 0) {
            System.out.println("No preference file selected");
            return false;
        }
        inputFile = chooser.getSelectedFile();
        if (TMEV.readPreferencesFile(inputFile)) {
            System.out.println("Successfully read preferences file - " + inputFile.getName());
            return true;
        }
        Manager.message(this.frame, "Error in preferences file: " + inputFile.getName());
        TMEV.quit();
        return false;
    }

    public static void addComponent(Component component) {
        activeComponents.addElement(component);
        Manager.updateWindowMenu();
    }

    public static void updateWindowMenu() {
        windowMenu.removeAll();
        windowMenu.setEnabled(activeComponents.size() > 0);
        for (int i = 0; i < activeComponents.size(); ++i) {
            Component component = activeComponents.elementAt(i);
            JMenuItem item = new JMenuItem(((MultipleArrayViewer)component).getFrame().getTitle());
            item.setActionCommand("window-cmd");
            item.addActionListener(eventListener);
            windowMenu.add(item);
        }
    }

    public static Component getLastComponent() {
        return activeComponents.lastElement();
    }

    public static Component getComponent(int position) {
        return activeComponents.elementAt(position);
    }

    public static void removeComponent(Component component) {
        activeComponents.removeElement(component);
        Manager.updateWindowMenu();
    }

    public void initializeInput() {
        try {
            String inputPreference = "Only File";
            if (inputPreference.equals("Database")) {
                this.databaseLogin();
                this.systemEnable(1001);
                this.systemEnable(1002);
            } else if (inputPreference.equals("File")) {
                this.databaseLogin();
                this.systemEnable(1001);
                this.systemEnable(1002);
            } else if (!inputPreference.equals("Only File")) {
                Manager.message(this.frame, "Error: Invalid Preferences File");
            }
        }
        catch (Exception e) {
            System.out.println("Exception (TMEV.initializeInput()): " + e);
        }
    }

    public static void createNewMultipleArrayViewer(int xOffset, int yOffset) {
        MultipleArrayViewer mav = new MultipleArrayViewer();
        Manager.addComponent(mav);
        mav.getFrame().setSize(1150, 700);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenSize.width - mav.getFrame().getSize().width) / 2 + xOffset;
        int y = (screenSize.height - mav.getFrame().getSize().height) / 2 + yOffset;
        mav.getFrame().setLocation(x, y);
        mav.getFrame().setVisible(true);
    }

    public static void createNewMultipleArrayViewer() {
        MultipleArrayViewer mav = new MultipleArrayViewer();
        Manager.addComponent(mav);
        mav.getFrame().setSize(1150, 700);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        mav.getFrame().setLocation((screenSize.width - mav.getFrame().getSize().width) / 2, (screenSize.height - mav.getFrame().getSize().height) / 2);
        mav.getFrame().setVisible(true);
    }

    public static void createNewMultipleArrayViewer(MultipleArrayData data, String clusterLabel) {
        MultipleArrayViewer mav = new MultipleArrayViewer(data);
        mav.getFrame().setSize(1150, 700);
        if (clusterLabel != null) {
            mav.getFrame().setTitle("Multiple Array Viewer, " + clusterLabel);
        }
        Manager.addComponent(mav);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        mav.getFrame().setLocation((screenSize.width - mav.getFrame().getSize().width) / 2, (screenSize.height - mav.getFrame().getSize().height) / 2);
        mav.getFrame().setVisible(true);
    }

    public static void createNewMultipleArrayViewer(MultipleArrayMenubar origMenubar, MultipleArrayData data, String clusterLabel) {
        MultipleArrayViewer mav = new MultipleArrayViewer(data, origMenubar);
        mav.getFrame().setSize(1150, 700);
        if (clusterLabel != null) {
            mav.getFrame().setTitle("Multiple Array Viewer, " + clusterLabel);
        }
        Manager.addComponent(mav);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        mav.getFrame().setLocation((screenSize.width - mav.getFrame().getSize().width) / 2, (screenSize.height - mav.getFrame().getSize().height) / 2);
        mav.getFrame().setVisible(true);
    }

    public static void createNewMultipleArrayViewer(FileLoadInfo fileInfo) {
        MultipleArrayViewer mav = new MultipleArrayViewer();
        Manager.addComponent(mav);
        mav.getFrame().setSize(1150, 700);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        mav.getFrame().setLocation((screenSize.width - mav.getFrame().getSize().width) / 2, (screenSize.height - mav.getFrame().getSize().height) / 2);
        mav.getFrame().setVisible(true);
        mav.loadData(fileInfo);
    }

    public static void displaySlideElementInfo(JFrame frame, MultipleArrayData data, int feature, int probe) {
        new InfoDisplay(frame, data, feature, probe);
    }

    public static void displaySlideElementInfo(JFrame frame, ISlideData slideData, ISlideDataElement element, int probe) {
        new InfoDisplay(frame, slideData, element, probe);
    }

    public void systemDisable(int state) {
        switch (state) {
            case 1000: {
                break;
            }
            case 1003: {
                break;
            }
            case 1001: {
                break;
            }
        }
        for (int i = 0; i < activeComponents.size(); ++i) {
            ((ArrayViewer)activeComponents.elementAt(i)).systemDisable(state);
        }
    }

    public void systemEnable(int state) {
        switch (state) {
            case 1000: {
                break;
            }
            case 1003: {
                break;
            }
            case 1001: {
                break;
            }
        }
        for (int i = 0; i < activeComponents.size(); ++i) {
            ((ArrayViewer)activeComponents.elementAt(i)).systemEnable(state);
        }
    }

    public void databaseLogin() {
        DatabaseLoginDialog dld = new DatabaseLoginDialog(this.frame);
        dld.addActionInfoListener(new ActionInfoListener(){

            public void actionInfoPerformed(ActionInfoEvent event) {
                Hashtable hash = event.getHashtable();
                Manager.this.databaseLoad((String)hash.get("username"), (String)hash.get("password"));
            }
        });
        dld.setVisible(true);
    }

    public void databaseLoad(String username, String password) {
        SetDatabaseDialog sdd;
        if ((TMEV.getConnection() != null || TMEV.connect(username, password)) && (sdd = new SetDatabaseDialog(this.frame)).showModal() == 0) {
            this.useDatabase(sdd.getDatabase());
        }
    }

    public void useDatabase(String database) {
        try {
            Query query = new Query("use " + database);
            query.executeUpdate(TMEV.getConnection());
            for (int i = 0; i < activeComponents.size(); ++i) {
                ((ArrayViewer)activeComponents.elementAt(i)).systemEnable(1002);
            }
        }
        catch (Exception e) {
            System.out.println("Exception (ColumnApplet.useDatabase()): " + e);
        }
    }

    public static void message(JFrame parent, String message) {
        System.out.println(message);
        MessageDisplay md = new MessageDisplay(parent, message);
        md.setVisible(true);
    }

    public static void message(JFrame parent, Exception e) {
        Manager.message(parent, e.toString());
    }

    public static void exception(JFrame parent, String exception) {
        System.out.println("EXCEPTION: " + exception);
        MessageDisplay md = new MessageDisplay(parent, exception);
        md.setVisible(true);
    }

    public static void exception(JFrame parent, Exception e) {
        Manager.exception(parent, e.toString());
    }

    private void handleItems(Object target) {
    }

    public void setLookAndFeel(String lookAndFeelStr) {
        try {
            UIManager.setLookAndFeel(lookAndFeelStr);
            SwingUtilities.updateComponentTreeUI(this.frame);
            for (int i = 0; i < activeComponents.size(); ++i) {
                SwingUtilities.updateComponentTreeUI(activeComponents.elementAt(i).getParent());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class EventListener
    implements ActionListener,
    WindowListener {
        private EventListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object source = event.getSource();
            Manager.this.handleItems(source);
            if (source == Manager.this.newMultipleArrayViewerItem) {
                Manager.createNewMultipleArrayViewer();
            } else if (source == Manager.this.loginItem) {
                Manager.this.databaseLogin();
            } else if (source == Manager.this.newPreferencesItem) {
                Manager.this.selectPreferencesFile();
            } else if (source == Manager.this.quitItem) {
                TMEV.quit();
            } else if (source == Manager.this.javaLFItem) {
                try {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                    SwingUtilities.updateComponentTreeUI(Manager.this.frame);
                    for (int i = 0; i < activeComponents.size(); ++i) {
                        SwingUtilities.updateComponentTreeUI(((Component)activeComponents.elementAt(i)).getParent());
                    }
                }
                catch (Exception e) {}
            } else if (source == Manager.this.windowsLFItem) {
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                    SwingUtilities.updateComponentTreeUI(Manager.this.frame);
                    for (int i = 0; i < activeComponents.size(); ++i) {
                        SwingUtilities.updateComponentTreeUI(((Component)activeComponents.elementAt(i)).getParent());
                    }
                }
                catch (Exception e) {}
            } else if (source == Manager.this.motifLFItem) {
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
                    SwingUtilities.updateComponentTreeUI(Manager.this.frame);
                    for (int i = 0; i < activeComponents.size(); ++i) {
                        SwingUtilities.updateComponentTreeUI(((Component)activeComponents.elementAt(i)).getParent());
                    }
                }
                catch (Exception e) {}
            } else if (source == Manager.this.toolTipsItem) {
                if (Manager.this.toolTipsItem.isSelected()) {
                    ToolTipManager.sharedInstance().setEnabled(true);
                } else {
                    ToolTipManager.sharedInstance().setEnabled(false);
                }
            } else if (source == Manager.this.promptToGetOnlineItem) {
                TMEV.storeProperty("prompt-to-get-online", new Boolean(Manager.this.promptToGetOnlineItem.isSelected()).toString());
                TMEV.getResourceManager().setAskToGetOnline(new Boolean(Manager.this.promptToGetOnlineItem.isSelected()));
            } else if (source == Manager.this.selectURLLinkoutFile) {
                JFileChooser chooser = new JFileChooser(System.getProperty(TMEV.getDataPath()));
                chooser.setDialogTitle("Select an annotation mapping file");
                chooser.setCurrentDirectory(new File(TMEV.getDataPath()));
                chooser.setMultiSelectionEnabled(false);
                if (chooser.showOpenDialog(Manager.this.frame) == 0) {
                    File urlsFile = chooser.getSelectedFile();
                    try {
                        TMEV.loadAnnotationsURLs(urlsFile);
                        TMEV.storeProperty("annotation-urls-mapping-file", urlsFile.getAbsolutePath());
                    }
                    catch (InvalidAnnMappingFileException iamfe) {
                        JOptionPane.showMessageDialog(Manager.this.frame, "MeV was unable to read the URL mappings from the file " + urlsFile.toString() + ". The MeV manual contains details about this type of file. ", "Error", 0);
                    }
                    catch (FileNotFoundException fnfe) {
                        JOptionPane.showMessageDialog(Manager.this.frame, "Could not find " + urlsFile + " file", "Error", 0);
                    }
                }
            } else if (source == Manager.this.promptToSaveItem) {
                TMEV.storeProperty("prompt-for-save", new Boolean(Manager.this.promptToSaveItem.isSelected()).toString());
            } else if (source == Manager.this.acknolMenuItem) {
                new AcknowlegementDialog((Frame)Manager.this.frame, AcknowlegementDialog.createAcknowlegementText());
            } else if (source == Manager.this.papersMenuItem) {
                new PaperReferencesDialog((Frame)Manager.this.frame, PaperReferencesDialog.createReferencesText());
            } else if (source == Manager.this.citationMenuItem) {
                new MevCitationDialog((Frame)Manager.this.frame, MevCitationDialog.createCitationText());
            } else if (source == Manager.this.aboutMenuItem) {
                ImageScreen is = new ImageScreen();
                is.showImageScreen();
            } else if (source == Manager.this.systemInfoItem) {
                int width = 640;
                int height = 550;
                InformationPanel infoPanel = new InformationPanel();
                JFrame frame = new JFrame("System Information");
                frame.getContentPane().add(infoPanel);
                frame.setSize(width, height);
                Dimension screenSize = frame.getToolkit().getScreenSize();
                frame.setLocation(screenSize.width / 2 - width / 2, screenSize.height / 2 - height / 2);
                frame.setResizable(false);
                frame.setVisible(true);
                infoPanel.Start();
            } else if (source == Manager.this.bugReportMenuItem) {
                try {
                    BrowserLauncher.openURL((String)"http://sourceforge.net/tracker/?atid=656691&group_id=110558&func=browse");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(Manager.this.frame, "Go to http://sourceforge.net/tracker/?atid=656691&group_id=110558&func=browse", "Input Error", 0);
                }
            } else if (source == Manager.this.featureReqMenuItem) {
                try {
                    BrowserLauncher.openURL((String)"http://sourceforge.net/tracker/?atid=656694&group_id=110558&func=browse");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(Manager.this.frame, "Go to http://sourceforge.net/tracker/?atid=656694&group_id=110558&func=browse", "Input Error", 0);
                }
            } else if (source == Manager.this.documentMenuItem) {
                try {
                    BrowserLauncher.openURL((String)"http://www.tm4.org/mev/documentation/manual");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(Manager.this.frame, "Go to http://www.tm4.org/mev/documentation/manual", "Input Error", 0);
                }
            }
            if (event.getActionCommand().equals("window-cmd")) {
                int compCount = windowMenu.getItemCount();
                JMenuItem item = (JMenuItem)event.getSource();
                for (int i = 0; i < compCount; ++i) {
                    if (item != windowMenu.getItem(i)) continue;
                    JComponent component = (JComponent)activeComponents.elementAt(i);
                    component.requestFocus();
                    component.setLocation(component.getLocation());
                    ((MultipleArrayViewer)component).getFrame().requestFocus();
                    break;
                }
            }
        }

        @Override
        public void windowClosing(WindowEvent event) {
            if (TMEV.activeSave) {
                JOptionPane.showMessageDialog(Manager.this.frame, "Analayis save is in progress. MeV will close when complete.", "Analysis Save in Progress", 1);
            }
            Manager.this.frame.dispose();
            while (TMEV.activeSave) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
            System.exit(0);
        }

        @Override
        public void windowOpened(WindowEvent event) {
        }

        @Override
        public void windowClosed(WindowEvent event) {
        }

        @Override
        public void windowIconified(WindowEvent event) {
        }

        @Override
        public void windowDeiconified(WindowEvent event) {
        }

        @Override
        public void windowActivated(WindowEvent event) {
        }

        @Override
        public void windowDeactivated(WindowEvent event) {
        }
    }
}

