/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.tigr.graph.GraphElement;
import org.tigr.graph.GraphLine;
import org.tigr.graph.GraphPoint;
import org.tigr.graph.GraphTick;
import org.tigr.graph.GraphViewer;
import org.tigr.microarray.mev.IRNASeqSlide;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.ISlideDataElement;
import org.tigr.microarray.mev.MultipleArrayData;
import org.tigr.microarray.mev.SpotInformationData;
import org.tigr.microarray.mev.annotation.AnnoAttributeObj;
import org.tigr.microarray.mev.annotation.InsufficientArgumentsException;
import org.tigr.microarray.mev.annotation.PublicURL;
import org.tigr.microarray.mev.annotation.URLNotFoundException;
import org.tigr.util.Xcon;
import org.tigr.util.awt.ActionInfoDialog;
import org.tigr.util.awt.GBA;

public class InfoDisplay
extends ActionInfoDialog {
    private static final long serialVersionUID = 1L;
    private int feature;
    private int probe;
    private MultipleArrayData data;
    private ISlideData slideData;
    private ISlideDataElement element;
    private int dataType;
    private int LINEAR = 0;
    private int LOG = 1;

    public InfoDisplay(JFrame parent, ISlideData slideData, ISlideDataElement element, int probe) {
        super(parent, false);
        this.probe = probe;
        this.dataType = slideData.getDataType();
        this.init(slideData, element);
    }

    public InfoDisplay(JFrame parent, MultipleArrayData data, int feature, int probe) {
        super(parent, false);
        this.data = data;
        this.feature = feature;
        this.probe = probe;
        this.dataType = data.getDataType();
        this.init(data.getFeature(feature), data.getSlideDataElement(feature, probe));
    }

    private void init(ISlideData slideData, ISlideDataElement element) {
        this.slideData = slideData;
        this.element = element;
        Font infoDisplayFont = new Font("Arial", 0, 10);
        JLabel spotImage = new JLabel(new ImageIcon(InfoDisplay.class.getResource("/org/tigr/images/spot.gif")));
        EventListener listener = new EventListener();
        JEditorPane infoDisplayTextPane = new JEditorPane();
        infoDisplayTextPane.setContentType("text/html");
        infoDisplayTextPane.setFont(infoDisplayFont);
        infoDisplayTextPane.setBackground(new Color(Integer.parseInt("FFFFCC", 16)));
        infoDisplayTextPane.setEditable(false);
        infoDisplayTextPane.setMargin(new Insets(10, 15, 10, 10));
        infoDisplayTextPane.setText(this.createMessage(element));
        infoDisplayTextPane.setCaretPosition(0);
        infoDisplayTextPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hle) {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(hle.getEventType())) {
                    try {
                        BrowserLauncher.openURL((String)hle.getURL().toString());
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            }
        });
        JButton viewGeneGraphButton = new JButton("Gene Graph");
        viewGeneGraphButton.setActionCommand("view-gene-graph");
        viewGeneGraphButton.addActionListener(listener);
        viewGeneGraphButton.setEnabled(false);
        if (this.data != null) {
            viewGeneGraphButton.setEnabled(true);
        }
        JButton setColorButton = new JButton("Set Gene Color");
        setColorButton.setActionCommand("set-color");
        setColorButton.addActionListener(listener);
        setColorButton.setEnabled(false);
        JButton closeButton = new JButton("Close Spot Information");
        closeButton.setActionCommand("close");
        closeButton.addActionListener(listener);
        this.contentPane.setLayout(new GridBagLayout());
        JScrollPane scrollPane = new JScrollPane(infoDisplayTextPane, 20, 30);
        scrollPane.getViewport().setBackground(Color.white);
        GBA gba = new GBA();
        gba.add(this.contentPane, (Component)scrollPane, 0, 0, 3, 2, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        gba.add(this.contentPane, (Component)viewGeneGraphButton, 0, 2, 1, 1, 0, 0, 0, 17, new Insets(5, 5, 5, 5), 0, 0);
        gba.add(this.contentPane, (Component)setColorButton, 2, 2, 1, 1, 0, 0, 0, 13, new Insets(5, 5, 5, 5), 0, 0);
        gba.add(this.contentPane, (Component)closeButton, 0, 3, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        gba.add(this.contentPane, (Component)spotImage, 2, 3, 1, 1, 0, 0, 0, 13, new Insets(5, 5, 5, 5), 0, 0);
        this.pack();
        this.setSize(600, 500);
        this.setResizable(true);
        this.setTitle("Spot Information");
        this.setLocation(300, 100);
        this.setVisible(true);
    }

    private String createMessage(ISlideDataElement element) {
        SpotInformationData spotData;
        int i;
        boolean stringLength = false;
        int trueRow = element.getRow(0);
        int trueColumn = element.getColumn(0);
        float cy3 = this.slideData.getCY3(this.probe);
        float cy5 = this.slideData.getCY5(this.probe);
        float ratio = cy5 / cy3;
        float logRatio = cy3 < 0.0f || cy5 < 0.0f ? Float.NaN : (float)(Math.log(ratio) / Math.log(2.0));
        String message = "<html><body bgcolor = \"#FFFFCC\"><basefont face = \"Arial\"><table cellpadding=4 valign=top><th colspan=2 align=left valign=center><font size=6>Location and Intensities</font></th>";
        if (this.dataType == 0) {
            message = message + "<tr><td><i>Row</i></td><td>" + trueRow + "</td></tr>" + "<tr><td><i>Column</i></td><td>" + trueColumn + "</td></tr>";
            message = message + "<tr><td>Cy3</td><td><b>" + cy3 + "</b></td></tr>" + "<tr><td><i>Cy5</i></td><td><b>" + cy5 + "</b></td></tr>";
            message = message + "<tr><td><i>Ratio</i></td><td>" + ratio + "</td></tr>" + "<tr><td><i>log2(Ratio)</i></td><td><b>" + logRatio + "</b></td></tr>";
        } else if (this.dataType == 2) {
            message = message + "<tr><td><i>File Index</i></td><td>+" + trueRow + "</td></tr>";
            message = message + "<tr><td><i>Affy Loading Mode</i></td><td>Absolute</td></tr>";
            message = message + "<tr><td><i>Intensity<i>/</td><td><b>" + cy5 + "</b></td></tr>";
        } else if (this.dataType == 3) {
            message = message + "<tr><td><i>File Index</i></td><td>" + trueRow + "</td></tr>";
            message = message + "<tr><td><i>Affy Loading Mode</i></td><td>Reference</td></tr>";
            message = message + "<tr><td><i>Sample Intensity</i></td><td><b>" + cy5 + "</b></td></tr>";
            message = message + "<tr><td><i>Ref. Intensity</i></td><td><b>" + cy3 + "</b></td></tr>";
            message = message + "<tr><td><i>Ratio (Sample/Ref.)</i></td><td>" + ratio + "</td></tr>" + "<tr><td><i>log2(Ratio)</i></td><td><b>" + logRatio + "</b></td></tr>";
        } else if (this.dataType == 4) {
            message = message + "<tr><td><i>File Index</i></td><td>" + trueRow + "</td></tr>";
            message = message + "<tr><td><i>Affy Loading Mode</i></td><td>Array Set Mean Int. as Ref.</td></tr>";
            message = message + "<tr><td><i>Sample Intensity</i></td><td><b>" + cy5 + "</b></td></tr>";
            message = message + "<tr><td><i>Array Set Mean Int.</i></td><td><b>" + cy3 + "</b></td></tr>";
            message = message + "<tr><td><i>Ratio (Sample/Mean)</i></td><td>" + ratio + "</td></tr>" + "<tr><td><i>log2(Ratio)</i></td><td><b>" + logRatio + "</b></td></tr>";
        } else if (this.dataType == 5) {
            message = message + "<tr><td><i>File Index</i></td><td>" + trueRow + "</td></tr>";
            message = message + "<tr><td><i>Affy Loading Mode</i></td><td>Spot Median as Ref.</td></tr>";
            message = message + "<tr><td><i>Sample Intensity</i></td><td><b>" + cy5 + "</b></td></tr>";
            message = message + "<tr><td><i>Spot Median Intensity</i></td><td><b>" + cy3 + "</b></td></tr>";
            message = message + "<tr><td><i>Ratio (Sample/Median)</i></td><td>" + ratio + "</td></tr>" + "<tr><td><i>log2(Ratio)</i></td><td><b>" + logRatio + "</b></td></tr>";
        } else if (this.dataType == 6) {
            message = message + "<tr><td><i>File Index</i></td><td>" + trueRow + "</td></tr>";
            message = message + "<tr><td><i>RPKM/FPKM<i></td><td><b>" + cy5 + "</b></td></tr>";
            message = message + "<tr><td><i>Count<i></td><td><b>" + ((IRNASeqSlide)this.slideData).getCount(this.probe) + "</b></td></tr>";
        } else {
            logRatio = cy5;
            message = message + "<tr><td><i>File Index</i></td><td>" + trueRow + "</td></tr>";
            message = message + "<tr><td><i>Value</i></td><td><b>" + logRatio + "</b></td></tr>";
        }
        Vector<String> keys = this.slideData.getSlideDataKeys();
        Hashtable expLabels = this.slideData.getSlideDataLabels();
        message = message + "<th colspan=2 align=left valign=center><font size=6>Sample Annotation</font></header></th/>";
        for (int i2 = 0; i2 < keys.size(); ++i2) {
            String key = keys.elementAt(i2);
            String value = (String)expLabels.get(key);
            if (value == null) {
                value = "";
            }
            message = message + "<tr valign=top><td><i>" + key + "</i></td><td>" + value + "</td></tr>";
        }
        String[] fieldNames = this.data.getFieldNames();
        message = message + "<th colspan=2 align=left valign=center><font size=6>Gene Annotation</font></th>";
        for (i = 0; i < fieldNames.length; ++i) {
            AnnoAttributeObj anno = this.data.getElementAnnotationObject(this.probe, fieldNames[i]);
            if (anno.getAttribCount() < 1 || anno.getAttributeAt(0).toString().equalsIgnoreCase("na")) {
                message = message + "<tr valign=top><td><i>" + fieldNames[i] + "</i></td><td>NA</td></tr>";
                continue;
            }
            message = message + "<tr valign=top><td><i>" + fieldNames[i] + "</i></td><td>";
            for (int j = 0; j < anno.getAttribCount(); ++j) {
                if (PublicURL.hasUrlForKey(anno.getAttribName())) {
                    try {
                        message = message + "<a href=\"" + PublicURL.getURL(anno.getAttribName(), new String[]{anno.getAttributeAt(j).toString()}) + "\">" + anno.getAttributeAt(j).toString() + "</a>";
                    }
                    catch (URLNotFoundException unfe) {
                        message = message + anno.getAttributeAt(j);
                    }
                    catch (InsufficientArgumentsException iae) {
                        message = message + anno.getAttributeAt(j);
                    }
                } else {
                    message = message + anno.getAttributeAt(j);
                }
                if (j >= anno.getAttribCount() - 1) continue;
                message = message + ", ";
            }
            message = message + "</td></tr>";
        }
        if (fieldNames != null && fieldNames.length > 0) {
            for (i = 0; i < fieldNames.length; ++i) {
                if (fieldNames[i].equals("Detection")) {
                    message = message + "<tr valign=top><td><i>" + fieldNames[i] + "</i></td><td>" + element.getDetection() + "</td></tr>";
                    continue;
                }
                if (!fieldNames[i].equals("P-value")) continue;
                message = message + "<tr valign=top><td><i>" + fieldNames[i] + "</i></td><td>" + element.getPvalue() + "</td></tr>";
            }
        }
        if ((spotData = this.slideData.getSpotInformationData()) != null) {
            String[] spotInfoLabels = spotData.getSpotInformationHeader();
            String[] info = spotData.getSpotInformationArray(this.probe);
            message = message + "<th colspan=2 align=left valign=center><font size=6>Spot Information</font></th>";
            for (int i3 = 0; i3 < spotInfoLabels.length; ++i3) {
                message = message + "<tr valign=top><td><i>" + spotInfoLabels[i3] + "</i></td><td>" + info[i3] + "</td></tr>";
            }
        }
        message = message + "</table>";
        message = message + "</basefont></body></html>";
        return message;
    }

    public void createGeneGraph() {
        GraphTick gt;
        double logCy5;
        double logCy3;
        float cy5;
        int i;
        GraphLine gl;
        int i2;
        ISlideData sde;
        ISlideData[] targets = new ISlideData[this.data.getFeaturesCount()];
        int columnsInExperiments = this.data.getFeature(0).getSlideMetaData().getColumns();
        for (int i3 = 0; i3 < targets.length; ++i3) {
            targets[i3] = this.data.getFeature(i3);
        }
        int minCy3 = 0;
        int maxCy3 = targets.length;
        int minCy5 = Integer.MAX_VALUE;
        int maxCy5 = Integer.MIN_VALUE;
        int workingRatio = 0;
        for (int i4 = 0; i4 < targets.length; ++i4) {
            sde = targets[i4];
            workingRatio = (int)sde.getRatio(this.probe, this.LOG);
            if (workingRatio < minCy5) {
                minCy5 = workingRatio;
            }
            if (workingRatio <= maxCy5) continue;
            maxCy5 = workingRatio;
        }
        int xGap = maxCy3 - minCy3;
        int yGap = ++maxCy5 - --minCy5;
        JFrame graphFrame = new JFrame("Sample vs. Log Ratio");
        GraphViewer graph = new GraphViewer(graphFrame, 0, 500, 0, 500, (double)minCy3, (double)maxCy3, (double)minCy5, (double)maxCy5, 100, 100, 100, 100, "Sample vs. Log Ratio", "Sample Name", "Log2 (Cy5 / Cy3)");
        graph.setXAxisValue(0.0);
        graph.setYAxisValue((double)minCy3);
        for (i2 = minCy3 + 1; i2 <= maxCy3; ++i2) {
            gl = new GraphLine((double)i2, (double)minCy5, (double)i2, (double)maxCy5, Color.yellow);
            graph.addGraphElement((GraphElement)gl);
        }
        for (i2 = minCy5; i2 <= maxCy5; ++i2) {
            if (i2 == 0) continue;
            gl = new GraphLine((double)minCy3, (double)i2, (double)maxCy3, (double)i2, Color.yellow);
            graph.addGraphElement((GraphElement)gl);
        }
        for (i = 0; i < targets.length - 1; ++i) {
            sde = targets[i];
            float cy3 = sde.getCY3(this.probe);
            cy5 = sde.getCY5(this.probe);
            logCy3 = i + 1;
            logCy5 = this.dataType == 1 ? (double)cy5 : Xcon.log2((double)((double)cy5 / (double)cy3));
            sde = targets[i + 1];
            float cy3b = sde.getCY3(this.probe);
            float cy5b = sde.getCY5(this.probe);
            double logCy3b = i + 2;
            double logCy5b = this.dataType == 1 ? (double)cy5b : Xcon.log2((double)((double)cy5b / (double)cy3b));
            if (Double.isNaN(logCy5) || Double.isNaN(logCy5b)) continue;
            gl = new GraphLine(logCy3, logCy5, logCy3b, logCy5b, Color.blue);
            graph.addGraphElement((GraphElement)gl);
        }
        for (i = 0; i < targets.length; ++i) {
            sde = targets[i];
            float cy3 = sde.getCY3(this.probe);
            cy5 = sde.getCY5(this.probe);
            logCy3 = i + 1;
            logCy5 = this.dataType == 1 ? (double)cy5 : Xcon.log2((double)((double)cy5 / (double)cy3));
            if (Double.isNaN(logCy5)) continue;
            GraphPoint gp = new GraphPoint(logCy3, logCy5, Color.blue, 3);
            graph.addGraphElement((GraphElement)gp);
        }
        for (i = minCy5; i <= maxCy5; ++i) {
            gt = i == 0 ? new GraphTick((double)i, 8, Color.black, 1, 0, "0", Color.black) : new GraphTick((double)i, 8, Color.black, 1, 0, "" + i, Color.black);
            graph.addGraphElement((GraphElement)gt);
        }
        for (i = minCy3 + 1; i <= maxCy3; ++i) {
            gt = new GraphTick((double)i, 8, Color.black, 0, 0, this.data.getSampleName(i - 1), Color.black);
            graph.addGraphElement((GraphElement)gt);
        }
        graphFrame.setSize(500, 500);
        graph.setVisible(true);
    }

    class EventListener
    implements ActionListener {
        EventListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command.equals("close")) {
                InfoDisplay.this.dispose();
            } else if (command.equals("view-gene-graph")) {
                InfoDisplay.this.setVisible(false);
                InfoDisplay.this.createGeneGraph();
                InfoDisplay.this.dispose();
            } else if (command.equals("set-color")) {
                // empty if block
            }
        }
    }
}

