/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ListOrderDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.microarray.mev.sampleannotation.IDFConstants;

public class IDFEditor
extends AlgorithmDialog {
    JTable table;
    DefaultViewerTableModel model;
    CellEditor cellEditor;
    int result = 0;
    JPopupMenu popup;
    JMenuItem delRowsPopItem;
    JMenuItem delRowsItem;
    JCheckBoxMenuItem enableReorderItem;
    JCheckBoxMenuItem enableReorderPopItem;
    boolean allowReordering = false;
    JFrame parent;

    public IDFEditor(JFrame parent, String title, boolean modal, boolean permitReorder, IData data) {
        super(parent, "IDF Editor", true);
        this.parent = parent;
        Listener listener = new Listener();
        this.allowReordering = permitReorder;
        this.model = new DefaultViewerTableModel(data);
        this.table = new JTable(this.model);
        this.table.setDefaultRenderer(String.class, new CellRenderer());
        this.table.setDefaultRenderer(JTextField.class, new CellRenderer());
        this.table.setDefaultRenderer(Object.class, new CellRenderer());
        this.table.setRowSelectionAllowed(true);
        this.table.setAutoResizeMode(4);
        this.table.setDefaultEditor(JTextField.class, new DefaultCellEditor(new JTextField()));
        this.table.setRowHeight(25);
        JScrollPane pane = new JScrollPane(this.table);
        pane.setColumnHeaderView(this.table.getTableHeader());
        this.table.setPreferredScrollableViewportSize(new Dimension(700, 350));
        ParameterPanel panel = new ParameterPanel("IDF Fields");
        panel.setLayout((LayoutManager)new GridBagLayout());
        panel.add((Component)pane, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        JMenuBar menuBar = this.createMenuBar(listener);
        this.setJMenuBar(menuBar);
        this.popup = this.createPopupMenu(listener);
        this.addContent((Component)panel);
        int w = this.getToolkit().getScreenSize().width;
        int dataWidth = 130 + 100 * (this.table.getColumnCount() - 1) - 50;
        if (w > 100) {
            w = (int)((double)w * 0.8);
            this.setSize(Math.min(w, dataWidth), 300);
        } else {
            this.setSize(700, 300);
        }
        this.table.addMouseListener(listener);
        this.setActionListeners(listener);
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public String[][] getLableData() {
        String[][] data = new String[this.table.getRowCount()][this.table.getColumnCount()];
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                data[i][j] = (String)this.model.getValueAt(i, j);
            }
        }
        return data;
    }

    public String[][] getLabelDataWithoutKeys() {
        String[][] data = new String[this.table.getRowCount()][this.table.getColumnCount() - 1];
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                data[i][j] = (String)this.model.getValueAt(i, j + 1);
            }
        }
        return data;
    }

    public String[] getLabelKeys() {
        String[] keys = new String[this.table.getRowCount()];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = (String)this.model.getValueAt(i, 0);
        }
        return keys;
    }

    private JMenuBar createMenuBar(Listener listener) {
        JMenuBar bar = new JMenuBar();
        JMenu editMenu = new JMenu("Edit");
        editMenu.setMnemonic('E');
        JMenuItem addRowItem = new JMenuItem("Add Missing IDF Fields");
        addRowItem.setActionCommand("add-row-command");
        addRowItem.addActionListener(listener);
        this.delRowsItem = new JMenuItem("Delete Selected Rows");
        this.delRowsItem.setActionCommand("del-rows-command");
        this.delRowsItem.addActionListener(listener);
        this.enableReorderItem = new JCheckBoxMenuItem("Enable Sample Reordering", false);
        this.enableReorderItem.setActionCommand("reorder-command");
        this.enableReorderItem.setEnabled(this.allowReordering);
        this.enableReorderItem.setToolTipText("forces samples to reorder to match table, hit info button");
        this.enableReorderItem.addActionListener(listener);
        editMenu.add(addRowItem);
        editMenu.add(this.delRowsItem);
        editMenu.add(new JSeparator());
        editMenu.add(this.enableReorderItem);
        bar.add(editMenu);
        return bar;
    }

    private JPopupMenu createPopupMenu(Listener listener) {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem addIDFFields = new JMenuItem("Add All IDF Fields");
        addIDFFields.setActionCommand("add-idf-fields-command");
        addIDFFields.addActionListener(listener);
        JMenuItem addRowPopItem = new JMenuItem("Add Missing IDF fields");
        addRowPopItem.setActionCommand("add-row-command");
        addRowPopItem.addActionListener(listener);
        this.delRowsPopItem = new JMenuItem("Delete Selected Rows");
        this.delRowsPopItem.setActionCommand("del-rows-command");
        this.delRowsPopItem.addActionListener(listener);
        this.enableReorderPopItem = new JCheckBoxMenuItem("Enable Sample Reordering", false);
        this.enableReorderPopItem.setActionCommand("reorder-command");
        this.enableReorderPopItem.setEnabled(this.allowReordering);
        this.enableReorderPopItem.setToolTipText("forces samples to reorder to match table, hit info button");
        this.enableReorderPopItem.addActionListener(listener);
        popup.add(addRowPopItem);
        popup.add(addIDFFields);
        popup.add(this.delRowsPopItem);
        popup.addSeparator();
        popup.add(this.enableReorderPopItem);
        return popup;
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String command = ae.getActionCommand();
            if (command.equals("add-row-command")) {
                IDFEditor.this.model.addNewRow();
            } else if (command.equals("del-rows-command")) {
                int[] selectedRows = IDFEditor.this.table.getSelectedRows();
                if (selectedRows.length < 1) {
                    return;
                }
                IDFEditor.this.model.deleteRows(selectedRows);
            } else if (IDFEditor.this.allowReordering && command.equals("reorder-command")) {
                if (ae.getSource() == IDFEditor.this.enableReorderItem) {
                    IDFEditor.this.enableReorderPopItem.setSelected(IDFEditor.this.enableReorderItem.isSelected());
                } else {
                    IDFEditor.this.enableReorderItem.setSelected(IDFEditor.this.enableReorderPopItem.isSelected());
                }
            } else if (command.equals("ok-command")) {
                if (IDFEditor.this.table.isEditing()) {
                    String value = ((JTextField)IDFEditor.this.table.getEditorComponent()).getText();
                    IDFEditor.this.table.setValueAt(value, IDFEditor.this.table.getEditingRow(), IDFEditor.this.table.getEditingColumn());
                }
                IDFEditor.this.result = 0;
                IDFEditor.this.dispose();
            } else if (command.equals("cancel-command")) {
                System.out.println("idfeditor cancel button clicked");
                IDFEditor.this.result = 2;
                IDFEditor.this.dispose();
            } else if (command.equals("info-command")) {
                HelpWindow.launchBrowser((Window)((Object)IDFEditor.this), (String)"Experiment Label Editor");
            }
        }

        @Override
        public void mousePressed(MouseEvent me) {
            if (me.isPopupTrigger()) {
                IDFEditor.this.popup.show(IDFEditor.this.table, me.getX(), me.getY());
                return;
            }
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            if (me.isPopupTrigger()) {
                IDFEditor.this.popup.show(IDFEditor.this.table, me.getX(), me.getY());
                return;
            }
            if (IDFEditor.this.table.getSelectedRowCount() > 0) {
                IDFEditor.this.delRowsItem.setEnabled(true);
                IDFEditor.this.delRowsPopItem.setEnabled(true);
            } else {
                IDFEditor.this.delRowsItem.setEnabled(false);
                IDFEditor.this.delRowsPopItem.setEnabled(false);
            }
        }
    }

    public class CellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JTextField field = new JTextField();
        String value;

        public CellEditor() {
            this.field.setBackground(new Color(222, 222, 222));
        }

        @Override
        public Object getCellEditorValue() {
            return this.field;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.value = this.field.getText();
            this.fireEditingStopped();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object obj, boolean selected, int row, int col) {
            this.field = (JTextField)obj;
            return (JTextField)obj;
        }
    }

    public class CellRenderer
    extends DefaultTableCellRenderer {
        JPanel colorPanel;
        JLabel label;
        JTextField textField = new JTextField();

        public CellRenderer() {
            this.textField.setOpaque(true);
            this.colorPanel = new JPanel();
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object obj, boolean param, boolean param3, int row, int col) {
            if (obj instanceof Color) {
                this.colorPanel.setBackground((Color)obj);
                return this.colorPanel;
            }
            if (obj instanceof JLabel) {
                this.label = (JLabel)obj;
                this.label.setOpaque(true);
                this.label.setFont(new Font("Arial", 0, 12));
                if (row == 0 || col == 0) {
                    this.label.setBackground(Color.lightGray);
                } else {
                    this.label.setBackground(new Color(225, 225, 225));
                }
                this.label.setForeground(Color.black);
                this.label.setHorizontalAlignment(0);
                if (IDFEditor.this.table.isRowSelected(row) && row != 0) {
                    this.label.setBackground(IDFEditor.this.table.getSelectionBackground());
                }
                return this.label;
            }
            if (obj instanceof JTextField) {
                this.textField = (JTextField)obj;
                if (row == 0) {
                    this.textField.setEditable(false);
                    this.textField.setBackground(Color.lightGray);
                } else if (col == 0) {
                    this.textField.setEditable(true);
                    this.textField.setBackground(new Color(255, 255, 155));
                } else {
                    this.textField.setEditable(true);
                    this.textField.setBackground(Color.white);
                }
                if (IDFEditor.this.table.isRowSelected(row) && row != 0) {
                    this.textField.setBackground(IDFEditor.this.table.getSelectionBackground());
                }
                return this.textField;
            }
            if (obj instanceof String) {
                this.textField.setText((String)obj);
                if (row == 0) {
                    this.textField.setEditable(false);
                    this.textField.setBackground(Color.lightGray);
                } else if (col == 0) {
                    this.textField.setEditable(true);
                    this.textField.setBackground(new Color(255, 255, 155));
                } else {
                    this.textField.setEditable(true);
                    this.textField.setBackground(Color.white);
                }
                if (IDFEditor.this.table.isRowSelected(row) && row != 0) {
                    this.textField.setBackground(IDFEditor.this.table.getSelectionBackground());
                }
                return this.textField;
            }
            this.colorPanel.setBackground(Color.white);
            return this.colorPanel;
        }
    }

    public class DefaultViewerTableModel
    extends AbstractTableModel
    implements Serializable {
        boolean[] numerical;
        Row[] rows;
        int colToSort = 0;
        boolean ascending = false;
        int rowCount;
        String currKey;
        String[] rowNames;
        String[][] dataObject;
        ArrayList<ArrayList> list = new ArrayList();
        String[] idfFields;
        int maxColumns = 0;
        JTextField valueObject;
        JLabel label;
        IData data;

        public DefaultViewerTableModel(IData data) {
            int i;
            this.data = data;
            Hashtable idfHash = this.data.getIDFObject().getIDFHash();
            Enumeration temp = idfHash.keys();
            this.rowCount = idfHash.keySet().size();
            this.rowNames = new String[this.rowCount];
            while (temp.hasMoreElements()) {
                String key = (String)temp.nextElement();
                ArrayList _temp = new ArrayList();
                _temp = (ArrayList)idfHash.get(key);
                _temp.add(0, key);
                if (_temp.size() > this.maxColumns) {
                    this.maxColumns = _temp.size();
                }
                this.list.add(_temp);
            }
            this.dataObject = new String[this.rowCount][this.maxColumns + 1];
            for (i = 0; i < this.rowCount; ++i) {
                ArrayList l = this.list.get(i);
                for (int j = 0; j < l.size(); ++j) {
                    this.dataObject[i][j] = (String)l.get(j);
                }
                l.clear();
            }
            this.rows = new Row[this.rowCount];
            for (i = 0; i < this.rows.length; ++i) {
                this.rows[i] = new Row();
                this.rows[i].index = i;
            }
            this.valueObject = new JTextField();
            this.valueObject.setOpaque(true);
            this.label = new JLabel();
            this.label.setOpaque(true);
        }

        public void initializeRows(int rowCount) {
            this.rows = new Row[rowCount];
            for (int i = 0; i < this.rows.length; ++i) {
                this.rows[i] = new Row();
                this.rows[i].index = i;
            }
        }

        public void setNumerical(int col, boolean numericalBool) {
            if (col > -1 && col < this.numerical.length) {
                this.numerical[col] = numericalBool;
            }
        }

        @Override
        public int getRowCount() {
            return this.rows.length;
        }

        @Override
        public Object getValueAt(int param, int param1) {
            return this.dataObject[param][param1];
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.dataObject[row][col] = (String)value;
            this.fireTableChanged(new TableModelEvent(this, row, row, col));
        }

        @Override
        public String getColumnName(int index) {
            return null;
        }

        private boolean isNumerical(int col) {
            return this.numerical[col];
        }

        public void sort(int col) {
            this.ascending = !this.ascending;
            this.colToSort = col;
            Arrays.sort(this.rows);
            this.fireTableDataChanged();
        }

        public int getRow(int tableRow) {
            return this.rows[tableRow].index;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col > 0;
        }

        public void addNewRow() {
            int i;
            int fieldCount = 0;
            boolean flag = false;
            ArrayList<String> rows_to_add = new ArrayList<String>();
            String[] keys = IDFEditor.this.getLabelKeys();
            Field[] fields = IDFConstants.class.getFields();
            for (int index1 = 0; index1 < fields.length; ++index1) {
                try {
                    String temp = (String)fields[index1].get(new IDFConstants());
                    flag = false;
                    for (int index2 = 0; index2 < keys.length; ++index2) {
                        if (!temp.equalsIgnoreCase(keys[index2])) continue;
                        flag = true;
                    }
                    if (flag) continue;
                    rows_to_add.add(temp);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (rows_to_add.isEmpty()) {
                JOptionPane.showMessageDialog(null, "Your file has all required IDF Fields", "Information", 1);
            } else {
                String text = "<html><body><b><center>The following missing fields will be added</center><b><br>";
                for (int num = 0; num < rows_to_add.size(); ++num) {
                    text = text + rows_to_add.get(num) + "<br>";
                }
                text = text + "<br><br></body></html>";
                JOptionPane.showMessageDialog(null, text, "Information", 1);
            }
            String[][] newData = new String[this.dataObject.length + rows_to_add.size()][this.maxColumns];
            for (i = 0; i < newData.length; ++i) {
                if (i < this.dataObject.length) {
                    newData[i] = this.dataObject[i];
                    continue;
                }
                newData[i][0] = (String)rows_to_add.get(fieldCount);
                ++fieldCount;
            }
            this.dataObject = newData;
            this.initializeRows(this.dataObject.length);
            for (i = 1; i < this.maxColumns; ++i) {
                this.dataObject[this.dataObject.length - 1][i] = "";
            }
            this.fireTableRowsInserted(this.dataObject.length - 1, this.dataObject.length - 1);
        }

        public void addNewRow(String[] newRow) {
            String[][] newData = new String[this.dataObject.length + 1][this.maxColumns];
            for (int i = 0; i < newData.length - 1; ++i) {
                newData[i] = this.dataObject[i];
            }
            this.dataObject = newData;
            this.initializeRows(this.dataObject.length);
            this.dataObject[this.dataObject.length - 1] = newRow;
            this.fireTableRowsInserted(this.dataObject.length - 1, this.dataObject.length - 1);
        }

        public void mergeRows(int[] rowsToMerge) {
            Vector keysToMerge = new Vector();
            for (int i = 0; i < rowsToMerge.length; ++i) {
                keysToMerge.addElement(this.dataObject[rowsToMerge[i]][0]);
            }
            JList keyOrderList = new JList(keysToMerge);
            keyOrderList.setSelectedIndex(0);
            ListOrderDialog dialog = new ListOrderDialog(IDFEditor.this.parent, keyOrderList, keysToMerge, "Sample Label Keys", " ");
            if (dialog.showModal() != 0) {
                return;
            }
            keysToMerge = dialog.getSortedVector();
            String[] newRow = new String[IDFEditor.this.table.getColumnCount()];
            for (int i = 0; i < newRow.length; ++i) {
                newRow[i] = (String)this.getMergedData(keysToMerge, i);
            }
            this.addNewRow(newRow);
        }

        public Object getMergedData(Vector keys, int col) {
            String mergedData = "";
            for (int i = 0; i < keys.size(); ++i) {
                mergedData = i == 0 ? mergedData + this.getDataForKey((String)keys.elementAt(i), col) : mergedData + "-" + this.getDataForKey((String)keys.elementAt(i), col);
            }
            return mergedData;
        }

        public Object getDataForKey(String key, int col) {
            for (int i = 0; i < this.dataObject.length; ++i) {
                if (!this.dataObject[i][0].equals(key)) continue;
                return this.dataObject[i][col];
            }
            return " ";
        }

        public void deleteRows(int[] selectedRows) {
            boolean[] delRows = new boolean[this.dataObject.length];
            int rowsToDelete = 0;
            for (int i = 0; i < selectedRows.length; ++i) {
                if (selectedRows[i] == 0) continue;
                delRows[selectedRows[i]] = true;
                ++rowsToDelete;
            }
            String[][] newData = new String[this.dataObject.length - rowsToDelete][];
            int newRowCnt = 0;
            for (int i = 0; i < this.dataObject.length; ++i) {
                if (delRows[i]) continue;
                newData[newRowCnt] = this.dataObject[i];
                ++newRowCnt;
            }
            this.initializeRows(newData.length);
            this.dataObject = newData;
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return this.maxColumns;
        }

        private class Row
        implements Comparable,
        Serializable {
            public int index;
            private String myString;
            private String otherString;

            private Row() {
            }

            public int compareTo(Object other) {
                if (DefaultViewerTableModel.this.ascending) {
                    return this.compareToOther(other);
                }
                return this.compareToOther(other) * -1;
            }

            public int compareToOther(Object other) {
                Row otherRow = (Row)other;
                Object myObject = DefaultViewerTableModel.this.getValueAt(this.index, DefaultViewerTableModel.this.colToSort);
                Object otherObject = DefaultViewerTableModel.this.getValueAt(otherRow.index, DefaultViewerTableModel.this.colToSort);
                if (myObject instanceof Comparable) {
                    if (DefaultViewerTableModel.this.isNumerical(DefaultViewerTableModel.this.colToSort) && myObject instanceof String) {
                        Float myFloat = new Float((String)myObject);
                        Float otherFloat = new Float((String)otherObject);
                        return myFloat.compareTo(otherFloat);
                    }
                    return ((Comparable)myObject).compareTo(otherObject);
                }
                if (myObject instanceof JLabel) {
                    this.myString = ((JLabel)myObject).getText();
                    this.otherString = ((JLabel)otherObject).getText();
                    return this.myString.compareTo(this.otherString);
                }
                return this.index - otherRow.index;
            }
        }
    }
}

