/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;

public class HistoryViewer
extends ViewerAdapter {
    private JTextArea content;
    private JPopupMenu menu;

    public HistoryViewer() {
        this.initContent();
        this.addHistory("Open Multiple Array Viewer");
        this.initMenu();
        this.content.addMouseListener(new HistoryListener());
    }

    public HistoryViewer(JTextArea content, JComponent header) {
        this.content = content;
        this.initMenu();
        content.addMouseListener(new HistoryListener());
    }

    private void initContent() {
        this.content = new JTextArea();
        this.content.setEditable(false);
        this.content.setMargin(new Insets(10, 10, 10, 10));
        this.content.setBackground(new Color(252, 255, 168));
    }

    private void initMenu() {
        this.menu = new JPopupMenu();
        JMenuItem saveItem = new JMenuItem("Save History to File", GUIFactory.getIcon((String)"save16.gif"));
        saveItem.setActionCommand("save");
        saveItem.addActionListener(new HistoryListener());
        this.menu.add(saveItem);
    }

    public void addHistory(String msg) {
        this.content.append(this.getDateStamp() + msg + "\n\n");
    }

    private String getDateStamp() {
        Date date = new Date(System.currentTimeMillis());
        DateFormat format = DateFormat.getDateTimeInstance();
        format.setTimeZone(TimeZone.getDefault());
        return format.format(date) + " -- ";
    }

    public JComponent getContentComponent() {
        return this.content;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.content.getText());
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        String text = (String)ois.readObject();
        this.initContent();
        this.content.append(text);
        this.addHistory("Load Analysis From File");
        this.initMenu();
        this.content.addMouseListener(new HistoryListener());
    }

    private void saveHistory() {
        JFileChooser chooser;
        String sep = System.getProperty("file.separator");
        String dataPath = TMEV.getDataPath();
        File fileLoc = TMEV.getFile("data/");
        if (dataPath != null && !(fileLoc = new File(dataPath)).exists()) {
            fileLoc = TMEV.getFile("data/");
        }
        if ((chooser = new JFileChooser(fileLoc)).showSaveDialog(this.content) == 0) {
            try {
                File file = chooser.getSelectedFile();
                PrintWriter bfr = new PrintWriter(new FileWriter(file));
                StringTokenizer stok = new StringTokenizer(this.content.getText(), "\n\n");
                while (stok.hasMoreTokens()) {
                    bfr.println(stok.nextToken());
                }
                bfr.flush();
                bfr.close();
            }
            catch (IOException ioe) {
                String msg = ioe.getMessage();
                JOptionPane.showMessageDialog(this.content, "An error occurred while saving history. \nMessage: " + msg, "Error Saving History", 2);
            }
        }
    }

    public class HistoryListener
    extends MouseAdapter
    implements ActionListener {
        @Override
        public void mousePressed(MouseEvent me) {
            if (me.isPopupTrigger()) {
                HistoryViewer.this.menu.show(HistoryViewer.this.content, me.getX(), me.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            if (me.isPopupTrigger()) {
                HistoryViewer.this.menu.show(HistoryViewer.this.content, me.getX(), me.getY());
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (ae.getActionCommand().equals("save")) {
                HistoryViewer.this.saveHistory();
            }
        }
    }
}

