/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;

public class GetSpeciesDialog
extends AlgorithmDialog {
    public static final String SPECIES_NAME_KEY = "speciesname";
    String result = "unknown";
    JCheckBox saveSpeciesName;
    JLabel speciesNameLabel;
    JTextField speciesNameTextField;

    public GetSpeciesDialog(JFrame frame, String currentName) {
        super(frame, "Change Species Name", true);
        Listener listener = new Listener();
        this.speciesNameLabel = new JLabel("Please provide a species name: ");
        this.speciesNameTextField = new JTextField(currentName, 10);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        JButton okButton = new JButton("Ok");
        okButton.setFocusPainted(true);
        okButton.setBorder(BorderFactory.createBevelBorder(0));
        okButton.setPreferredSize(new Dimension(60, 30));
        okButton.setActionCommand("yes");
        okButton.addActionListener(listener);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setFocusPainted(false);
        cancelButton.setBorder(BorderFactory.createBevelBorder(0));
        cancelButton.setPreferredSize(new Dimension(60, 30));
        cancelButton.setActionCommand("no");
        cancelButton.addActionListener(listener);
        buttonPanel.add((Component)okButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 20), 0, 0));
        buttonPanel.add((Component)cancelButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 0, 0), 0, 0));
        JPanel paramPanel = new JPanel(new GridBagLayout());
        paramPanel.setBackground(Color.white);
        paramPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        JLabel promptLabel = new JLabel("Gaggle needs to broadcast a species name for the selected data.");
        promptLabel.setHorizontalAlignment(0);
        this.saveSpeciesName = new JCheckBox("Save this species name for the session.", true);
        this.saveSpeciesName.setBackground(Color.white);
        this.saveSpeciesName.setFocusPainted(false);
        paramPanel.add((Component)promptLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(20, 0, 0, 0), 0, 0));
        paramPanel.add((Component)this.speciesNameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(20, 0, 0, 0), 0, 0));
        paramPanel.add((Component)this.speciesNameTextField, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(20, 0, 0, 0), 0, 0));
        paramPanel.add((Component)this.saveSpeciesName, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(20, 0, 0, 0), 0, 0));
        this.supplantButtonPanel(buttonPanel);
        this.addContent(paramPanel);
        this.setSize(480, 280);
    }

    public String showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public void disposeDialog() {
        this.dispose();
    }

    public boolean saveSpeciesName() {
        return this.saveSpeciesName.isSelected();
    }

    public static void main(String[] args) {
        GetSpeciesDialog dialog = new GetSpeciesDialog(new JFrame(), "previous species name");
        String result = dialog.showModal();
        System.out.println("result = " + result);
        System.out.println("save species name = " + dialog.saveSpeciesName());
        System.exit(0);
    }

    public class Listener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            String command = ae.getActionCommand();
            if (command.equals("yes")) {
                GetSpeciesDialog.this.result = GetSpeciesDialog.this.speciesNameTextField.getText();
            }
            GetSpeciesDialog.this.disposeDialog();
        }
    }
}

