/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.util.awt.GBA;

public class GenePixCutoffDialog
extends AlgorithmDialog {
    private float originalValue;
    private int result;
    private JTextField textField;
    private JCheckBox enableCheckBox;
    private JLabel percentageLabel;

    public GenePixCutoffDialog(JFrame parent, float percentage) {
        super(parent, "Set GenePix Flags Filter", true);
        Listener listener = new Listener();
        this.originalValue = percentage;
        GBA gba = new GBA();
        this.enableCheckBox = new JCheckBox("Enable GenePix Flags Filter", true);
        this.enableCheckBox.setActionCommand("enable-check-box-command");
        this.enableCheckBox.setOpaque(false);
        this.enableCheckBox.setFocusPainted(false);
        this.enableCheckBox.addActionListener(listener);
        this.percentageLabel = new JLabel("Above Percentage((samples with negative flags) /(total samples)) for each gene");
        this.percentageLabel.setHorizontalTextPosition(4);
        this.percentageLabel.setHorizontalAlignment(4);
        this.textField = new JTextField(10);
        this.textField.setText(String.valueOf(percentage));
        this.textField.selectAll();
        this.textField.addKeyListener(listener);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(Color.white);
        panel.setBorder(BorderFactory.createLineBorder(Color.black));
        gba.add((Container)panel, (Component)this.enableCheckBox, 0, 0, 2, 1, 0, 0, 3, 10, new Insets(25, 5, 0, 5), 0, 0);
        gba.add((Container)panel, (Component)this.percentageLabel, 0, 1, 1, 1, 1, 0, 1, 13, new Insets(10, 5, 35, 5), 0, 0);
        gba.add((Container)panel, (Component)this.textField, 1, 1, 1, 1, 1, 0, 0, 17, new Insets(10, 5, 35, 5), 0, 0);
        this.addContent(panel);
        this.setActionListeners(listener);
        this.addWindowListener(listener);
        this.pack();
        this.setResizable(false);
        this.textField.grabFocus();
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public boolean isCutoffFilterEnabled() {
        return this.enableCheckBox.isSelected();
    }

    public float getPercentageCutoff() {
        return Float.parseFloat(this.textField.getText());
    }

    public static void main(String[] args) {
        GenePixCutoffDialog dialog = new GenePixCutoffDialog(new JFrame(), 0.0f);
        dialog.showModal();
    }

    private class Listener
    extends WindowAdapter
    implements ActionListener,
    KeyListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command.equals("ok-command")) {
                try {
                    Float.parseFloat(GenePixCutoffDialog.this.textField.getText());
                    GenePixCutoffDialog.this.result = 0;
                }
                catch (Exception exception) {
                    GenePixCutoffDialog.this.result = 2;
                }
                GenePixCutoffDialog.this.dispose();
            } else if (command.equals("cancel-command")) {
                GenePixCutoffDialog.this.result = 2;
                GenePixCutoffDialog.this.dispose();
            } else if (command.equals("reset-command")) {
                GenePixCutoffDialog.this.enableCheckBox.setSelected(true);
                GenePixCutoffDialog.this.textField.setEnabled(true);
                GenePixCutoffDialog.this.percentageLabel.setEnabled(true);
                GenePixCutoffDialog.this.textField.setText(String.valueOf(GenePixCutoffDialog.this.originalValue));
                GenePixCutoffDialog.this.textField.selectAll();
                GenePixCutoffDialog.this.textField.grabFocus();
            } else if (command.equals("info-command")) {
                HelpWindow.launchBrowser((Window)((Object)GenePixCutoffDialog.this), (String)"Set Percentage Cutoff");
            } else if (command.equals("enable-check-box-command")) {
                boolean enabled = GenePixCutoffDialog.this.enableCheckBox.isSelected();
                GenePixCutoffDialog.this.percentageLabel.setEnabled(enabled);
                GenePixCutoffDialog.this.textField.setEnabled(enabled);
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            GenePixCutoffDialog.this.result = -1;
            GenePixCutoffDialog.this.dispose();
        }

        @Override
        public void keyPressed(KeyEvent event) {
            if (event.getKeyCode() == 10) {
                try {
                    Float.parseFloat(GenePixCutoffDialog.this.textField.getText());
                    GenePixCutoffDialog.this.result = 0;
                }
                catch (Exception exception) {
                    GenePixCutoffDialog.this.result = 2;
                }
                GenePixCutoffDialog.this.dispose();
            }
        }

        @Override
        public void keyReleased(KeyEvent event) {
        }

        @Override
        public void keyTyped(KeyEvent event) {
        }
    }
}

