/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class GeneAnnotationImportDialog
extends AlgorithmDialog {
    private JComboBox dataKeyBox;
    private JComboBox annFileKeyBox;
    private String[] dataAnnKeys;
    private String[] annFileKeys;
    private ColumnNamesPanel fieldSelectionPanel;
    private int result = 2;

    public GeneAnnotationImportDialog(JFrame frame, String[] dataAnnKeys, String[] annFileKeys) {
        super(frame, "Append Gene Annotation", true);
        this.dataAnnKeys = dataAnnKeys;
        this.annFileKeys = annFileKeys;
        JLabel dataKeyLabel = new JLabel("Gene Identifier (from current data):");
        this.dataKeyBox = new JComboBox<String>(dataAnnKeys);
        JLabel fileKeyLabel = new JLabel("Corresponding Gene Identifier from Input File:");
        this.annFileKeyBox = new JComboBox<String>(annFileKeys);
        String text = "<html><body>Note: The Gene identifiers from the loaded data and the input annoation<br>";
        text = text + "file should correspond to the same annoation type.   These identifiers<br>";
        text = text + "are used to map annotation in the file to the proper genes loaded in MeV.</html>";
        JLabel explanationLabel = new JLabel(text);
        this.fieldSelectionPanel = new ColumnNamesPanel(annFileKeys);
        ParameterPanel panel = new ParameterPanel("Annotation Key Selection");
        panel.setLayout((LayoutManager)new GridBagLayout());
        panel.add((Component)dataKeyLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(20, 10, 0, 10), 0, 0));
        panel.add((Component)this.dataKeyBox, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 10, 0, 10), 0, 0));
        panel.add((Component)fileKeyLabel, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(25, 10, 0, 10), 0, 0));
        panel.add((Component)this.annFileKeyBox, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 10, 20, 10), 0, 0));
        panel.add((Component)explanationLabel, (Object)new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 10, 20, 10), 0, 0));
        panel.add((Component)this.fieldSelectionPanel, (Object)new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 20, 0), 0, 0));
        this.setActionListeners((ActionListener)((Object)new Listener()));
        this.addContent((Component)panel);
        this.pack();
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public String getFileAnnotationKey() {
        return (String)this.annFileKeyBox.getSelectedItem();
    }

    public String getDataAnnotationKey() {
        return (String)this.dataKeyBox.getSelectedItem();
    }

    private void resetControls() {
        this.dataKeyBox.setSelectedIndex(0);
        this.annFileKeyBox.setSelectedIndex(0);
        this.fieldSelectionPanel.resetControls();
    }

    public String[] getSelectedAnnotationFields() {
        return this.fieldSelectionPanel.getSelectedColNames();
    }

    public static void main(String[] args) {
        String[] s1 = new String[3];
        String[] s2 = new String[5];
        s1[0] = "UID";
        s1[1] = "GB";
        s1[2] = "TC";
        s2[0] = "UID";
        s2[1] = "R";
        s2[2] = "C";
        s2[3] = "Tigr TC";
        s2[4] = "GenBank";
        GeneAnnotationImportDialog dialog = new GeneAnnotationImportDialog(new JFrame(), s1, s2);
        dialog.showModal();
        System.exit(0);
    }

    private class ColumnNamesPanel
    extends JPanel {
        JCheckBox[] columnNameBoxes;
        JButton selectAllButton;
        JButton clearAllButton;

        ColumnNamesPanel(String[] columnHeaders) {
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createTitledBorder("Select Annotation Fields to Append"));
            this.setBackground(Color.white);
            this.columnNameBoxes = new JCheckBox[columnHeaders.length];
            boolean selected = true;
            for (int i = 0; i < this.columnNameBoxes.length; ++i) {
                selected = !columnHeaders[i].equals("UID") && !columnHeaders[i].equals("R") && !columnHeaders[i].equals("C");
                this.columnNameBoxes[i] = new JCheckBox(columnHeaders[i], selected);
                this.columnNameBoxes[i].setOpaque(false);
                this.columnNameBoxes[i].setFocusPainted(false);
            }
            JPanel checkBoxPanel = this.createCheckBoxPanel();
            JScrollPane scroll = new JScrollPane(checkBoxPanel);
            scroll.setPreferredSize(new Dimension(450, 150));
            JButton selectAllButton = new JButton("Select All");
            JButton clearAllButton = new JButton("Clear All");
            selectAllButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    for (int i = 0; i < ColumnNamesPanel.this.columnNameBoxes.length; ++i) {
                        ColumnNamesPanel.this.columnNameBoxes[i].setSelected(true);
                    }
                }
            });
            clearAllButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    for (int i = 0; i < ColumnNamesPanel.this.columnNameBoxes.length; ++i) {
                        ColumnNamesPanel.this.columnNameBoxes[i].setSelected(false);
                    }
                }
            });
            this.add((Component)selectAllButton, new GridBagConstraints(0, 0, 1, 1, 50.0, 10.0, 17, 3, new Insets(5, 10, 5, 0), 0, 0));
            this.add((Component)scroll, new GridBagConstraints(0, 1, 2, 1, 100.0, 90.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        }

        private JPanel createCheckBoxPanel() {
            JPanel panel1 = new JPanel();
            panel1.setBackground(Color.white);
            panel1.setLayout(new GridBagLayout());
            for (int i = 0; i < this.columnNameBoxes.length; ++i) {
                panel1.add((Component)this.columnNameBoxes[i], new GridBagConstraints(0, i, 1, 1, 100.0, 0.0, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
            }
            return panel1;
        }

        public int[] getSelectedCols() {
            Vector<Integer> selColsVector = new Vector<Integer>();
            for (int i = 0; i < this.columnNameBoxes.length; ++i) {
                if (!this.columnNameBoxes[i].isSelected()) continue;
                selColsVector.add(new Integer(i + 1));
            }
            int[] selCols = new int[selColsVector.size()];
            for (int i = 0; i < selCols.length; ++i) {
                selCols[i] = (Integer)selColsVector.get(i);
            }
            return selCols;
        }

        public String[] getSelectedColNames() {
            Vector<String> selColNamesVector = new Vector<String>();
            for (int i = 0; i < this.columnNameBoxes.length; ++i) {
                if (!this.columnNameBoxes[i].isSelected()) continue;
                selColNamesVector.add(this.columnNameBoxes[i].getText());
            }
            String[] selColNames = new String[selColNamesVector.size()];
            for (int i = 0; i < selColNames.length; ++i) {
                selColNames[i] = (String)selColNamesVector.get(i);
            }
            return selColNames;
        }

        public void resetControls() {
            boolean selected = true;
            for (int i = 0; i < this.columnNameBoxes.length; ++i) {
                selected = !this.columnNameBoxes[i].getText().equals("UID") && !this.columnNameBoxes[i].getText().equals("R") && !this.columnNameBoxes[i].getText().equals("C");
                this.columnNameBoxes[i].setSelected(selected);
            }
        }
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("ok-command")) {
                if (GeneAnnotationImportDialog.this.getSelectedAnnotationFields().length < 1) {
                    JOptionPane.showMessageDialog((Component)((Object)GeneAnnotationImportDialog.this), "You must select at least one annotation field to import.", "Empty Annotation Field Selection", 0);
                    return;
                }
                GeneAnnotationImportDialog.this.result = 0;
                GeneAnnotationImportDialog.this.dispose();
            } else if (command.equals("cancel-command")) {
                GeneAnnotationImportDialog.this.result = 2;
                GeneAnnotationImportDialog.this.dispose();
            } else {
                if (command.equals("reset-command")) {
                    GeneAnnotationImportDialog.this.resetControls();
                    GeneAnnotationImportDialog.this.result = 2;
                    return;
                }
                if (command.equals("info-command")) {
                    HelpWindow.launchBrowser((Window)((Object)GeneAnnotationImportDialog.this), (String)"Gene Annotation Import");
                }
            }
            GeneAnnotationImportDialog.this.dispose();
        }

        public void windowClosing(WindowEvent e) {
            GeneAnnotationImportDialog.this.result = -1;
            GeneAnnotationImportDialog.this.dispose();
        }
    }
}

