/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.io.Serializable;

public class FoldFilter
implements Serializable {
    public static final long serialVersionUID = 100010201100001L;
    private float fold_change;
    private int[] group_membership;
    private String divider;
    private static int NUM_OF_GROUPS = 3;
    private static String BOTH = "both";
    private static String GREATER_THAN = ">";
    private static String LESS_THAN = "<";
    private static float INITAL_FOLD_CHANGE = 2.0f;

    public FoldFilter(String[] names) {
        this.group_membership = new int[names.length];
        for (int i = 0; i < names.length; ++i) {
            this.group_membership[i] = 0;
        }
        this.divider = BOTH;
        this.fold_change = INITAL_FOLD_CHANGE;
    }

    public void set_fold_change(float fold_change) {
        this.fold_change = fold_change;
    }

    public float get_fold_change() {
        return this.fold_change;
    }

    public int get_group_membership(int file_index) {
        return this.group_membership[file_index];
    }

    public String get_divider() {
        return this.divider;
    }

    public void set_group_membership(int group_index, int file_index) {
        this.group_membership[file_index] = group_index;
    }

    public void set_divider(String divider) {
        this.divider = divider;
    }

    public int get_num_members(int index) {
        int num_members = 0;
        for (int i = 0; i < this.group_membership.length; ++i) {
            if (this.get_group_membership(i) != index) continue;
            ++num_members;
        }
        return num_members;
    }

    public boolean keep_gene(float[] signals) {
        float[] mean = new float[3];
        mean[2] = 0.0f;
        mean[1] = 0.0f;
        mean[0] = 0.0f;
        for (int i = 0; i < signals.length; ++i) {
            int n = this.get_group_membership(i);
            mean[n] = mean[n] + signals[i];
        }
        mean[0] = mean[0] / (float)this.get_num_members(0);
        mean[1] = mean[1] / (float)this.get_num_members(1);
        if (this.divider.equals(GREATER_THAN)) {
            return mean[0] / mean[1] > this.fold_change;
        }
        if (this.divider.equals(LESS_THAN)) {
            return mean[1] / mean[0] > this.fold_change;
        }
        return mean[0] / mean[1] > this.fold_change || mean[1] / mean[0] > this.fold_change;
    }

    public String toString() {
        String out = "x";
        if (this.divider.equals(BOTH)) {
            out = "All genes with a fold change of greater than: " + this.fold_change;
        }
        if (this.divider.equals(GREATER_THAN)) {
            out = "Group A > Group B by " + this.fold_change + " fold.";
        }
        if (this.divider.equals(LESS_THAN)) {
            out = "Group B > Group A by " + this.fold_change + "fold.";
        }
        for (int i = 0; i < this.group_membership.length; ++i) {
            out = out + "\nsample: " + i + " is in group: " + this.get_group_membership(i);
        }
        return out;
    }
}

