/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.ISlideDataElement;
import org.tigr.microarray.mev.ISlideMetaData;
import org.tigr.microarray.mev.SpotInformationData;
import org.tigr.microarray.mev.sampleannotation.SampleAnnotation;
import org.tigr.midas.engine.IterativeLinReg;
import org.tigr.midas.engine.IterativeLogMean;
import org.tigr.midas.engine.RatioStats;
import org.tigr.midas.engine.TotInt;
import org.tigr.midas.util.ColumnWorker;
import org.tigr.util.math.LinearEquation;

public class FloatSlideData
implements ISlideData {
    private String name;
    private String filename;
    private float[] currentCY3;
    private float[] currentCY5;
    private float[] trueCY3;
    private float[] trueCY5;
    private static boolean isNonZero = true;
    private int normalizedState = 0;
    private int sortState = 0;
    private ISlideMetaData slideMetaData;
    private SpotInformationData spotInfoData;
    private boolean abbrName = false;
    private int dataType = 0;
    private char[] detection;
    private float[] pvalue;
    private int[] flags;
    private String sampleLabelKey = "Default Slide Name";
    private Hashtable sampleLabels;
    private Vector sampleLabelKeys;
    private SampleAnnotation sampAnn;
    private boolean isSampleAnnotationLoaded = false;
    private Vector[] flankingRegions;

    public FloatSlideData(Vector sampleLabelKeys, Hashtable sampleLabels, String filename, String name, boolean isNonZero, int normalizedState, int sortState, SpotInformationData spotInfoData, Integer dataType, ISlideMetaData ismd) throws IOException {
        this.sampleLabelKeys = sampleLabelKeys;
        this.sampleLabels = sampleLabels;
        this.filename = filename;
        this.name = name;
        this.setNonZero(isNonZero);
        this.normalizedState = normalizedState;
        this.sortState = sortState;
        this.spotInfoData = spotInfoData;
        this.dataType = dataType;
        this.slideMetaData = ismd;
    }

    public FloatSlideData(FloatSlideData fsd) {
        this.sampleLabelKeys = fsd.getSlideDataKeys();
        this.sampleLabels = fsd.getSlideDataLabels();
        this.filename = fsd.getFullSlideFileName();
        this.name = fsd.getSlideDataName();
        this.setNonZero(fsd.getIsNonZero());
        this.normalizedState = fsd.getNormalizedState();
        this.sortState = fsd.getSortState();
        this.spotInfoData = fsd.getSpotInformationData();
        this.dataType = fsd.getDataType();
        this.slideMetaData = fsd.getSlideMetaData();
        this.setCurrentCY3(fsd.getCurrentCY3());
        this.setCurrentCY5(fsd.getCurrentCY5());
        this.setTrueCY3(fsd.getTrueCY3());
        this.setTrueCY5(fsd.getTrueCY5());
        this.setDetection(fsd.getDetection());
        this.setPvalues(fsd.getPvalue());
        this.setGenePixFlags(fsd.getGenePixFlags());
        if (fsd.getSampleAnnotation() != null) {
            this.setSampleAnnotation(fsd.getSampleAnnotation());
        }
    }

    public FloatSlideData(ISlideMetaData slideMetaData, SampleAnnotation sampAnn) {
        this(slideMetaData, slideMetaData.getSize());
        this.sampAnn = sampAnn;
    }

    public FloatSlideData(ISlideMetaData slideMetaData, int size, SampleAnnotation sampAnn) {
        this.slideMetaData = slideMetaData;
        this.trueCY3 = new float[size];
        this.trueCY5 = new float[size];
        this.detection = new char[size];
        this.pvalue = new float[size];
        this.flags = new int[size];
        this.sampAnn = sampAnn;
    }

    public FloatSlideData(ISlideMetaData slideMetaData) {
        this(slideMetaData, slideMetaData.getSize());
        this.sampleLabelKeys = new Vector();
        this.sampleLabelKey = "Default Slide Name";
        this.sampleLabelKeys = new Vector();
        this.sampleLabels = new Hashtable();
    }

    public FloatSlideData(ISlideMetaData slideMetaData, int size) {
        this.slideMetaData = slideMetaData;
        this.trueCY3 = new float[size];
        this.trueCY5 = new float[size];
        this.detection = new char[size];
        this.pvalue = new float[size];
        this.flags = new int[size];
        this.sampleLabelKey = "Default Slide Name";
        this.sampleLabelKeys = new Vector();
        this.sampleLabels = new Hashtable();
    }

    public void setCurrentCY3(float[] f) {
        this.currentCY3 = f;
    }

    public void setCurrentCY5(float[] f) {
        this.currentCY5 = f;
    }

    public void setTrueCY3(float[] f) {
        this.trueCY3 = f;
    }

    public void setTrueCY5(float[] f) {
        this.trueCY5 = f;
    }

    public char[] getDetection() {
        return this.detection;
    }

    public float[] getCurrentCY3() {
        return this.currentCY3;
    }

    public float[] getCurrentCY5() {
        return this.currentCY5;
    }

    public float[] getTrueCY3() {
        return this.trueCY3;
    }

    public float[] getTrueCY5() {
        return this.trueCY5;
    }

    @Override
    public ISlideMetaData getSlideMetaData() {
        return this.slideMetaData;
    }

    public void setSlideMetaData(ISlideMetaData i) {
        this.slideMetaData = i;
    }

    @Override
    public void setDataType(int type) {
        this.dataType = type;
    }

    @Override
    public int getDataType() {
        return this.dataType;
    }

    @Override
    public void setSpotInformationData(String[] columnHeaders, String[][] spotInfoData) {
        this.spotInfoData = new SpotInformationData(columnHeaders, spotInfoData);
    }

    public void setSpotInformationData(SpotInformationData spotInfoData) {
        this.spotInfoData = spotInfoData;
    }

    @Override
    public SpotInformationData getSpotInformationData() {
        return this.spotInfoData;
    }

    @Override
    public int getSize() {
        return this.slideMetaData.getSize();
    }

    @Override
    public void setSlideDataLabels(Vector keys, Hashtable namesHash) {
        this.sampleLabelKeys = keys;
        this.sampleLabels = namesHash;
    }

    @Override
    public void setSlideDataName(String slideDataName) {
        this.name = slideDataName;
        if (this.isSampleAnnotationLoaded) {
            if (!this.getSampleAnnotation().getSampleAnnoHash().containsKey("Default Slide Name")) {
                this.getSampleAnnotation().setAnnotation("Default Slide Name", this.name);
            }
        } else {
            String key;
            this.sampleLabelKey = key = "Default Slide Name";
            this.sampleLabelKeys.addElement(key);
            this.sampleLabels.put(key, slideDataName);
        }
    }

    @Override
    public void toggleNameLength() {
        this.abbrName = !this.abbrName;
    }

    @Override
    public String getSlideDataName() {
        String name = "";
        name = this.isSampleAnnotationLoaded ? this.getSampleAnnotation().getAnnotation(this.sampleLabelKey) : (String)this.sampleLabels.get(this.sampleLabelKey);
        if (name == null) {
            return " ";
        }
        if (!this.abbrName) {
            return name;
        }
        if (name.length() < 26) {
            return name;
        }
        return name.substring(0, 25) + "...";
    }

    @Override
    public String getFullSlideDataName() {
        String name = "";
        name = this.isSampleAnnotationLoaded ? this.getSampleAnnotation().getAnnotation(this.sampleLabelKey) : (String)this.sampleLabels.get(this.sampleLabelKey);
        if (name == null) {
            return " ";
        }
        return name;
    }

    @Override
    public void setSlideFileName(String filename) {
        this.filename = filename;
    }

    @Override
    public String getSlideFileName() {
        if (!this.abbrName) {
            return this.filename;
        }
        if (this.filename.length() < 26) {
            return this.filename;
        }
        return this.filename.substring(0, 25) + "...";
    }

    public String getFullSlideFileName() {
        return this.filename;
    }

    @Override
    public void setIntensities(int index, float cy3, float cy5) {
        this.trueCY3[index] = cy3;
        this.trueCY5[index] = cy5;
    }

    public void setCurrentIntensities(int index, float cy3, float cy5) {
        if (this.currentCY3 != null && this.currentCY5 != null) {
            this.currentCY3[index] = cy3;
            this.currentCY5[index] = cy5;
        }
    }

    @Override
    public float getCY3(int index) {
        if (this.normalizedState == 0) {
            return this.trueCY3[index];
        }
        return this.currentCY3[index];
    }

    @Override
    public float getCY5(int index) {
        if (this.normalizedState == 0) {
            return this.trueCY5[index];
        }
        return this.currentCY5[index];
    }

    @Override
    public float getMaxRatio() {
        return this.getMaxRatio(0);
    }

    @Override
    public float getMinRatio() {
        return this.getMinRatio(0);
    }

    @Override
    public float getMaxRatio(int logState) {
        float maxRatio = Float.MIN_VALUE;
        int size = this.getSize();
        for (int i = 0; i < size; ++i) {
            float ratio = this.getRatio(i, logState);
            if (!(ratio > maxRatio)) continue;
            maxRatio = ratio;
        }
        return maxRatio;
    }

    @Override
    public float getMaxRatio(int index1, int index2, int logState) {
        float[] denumerator;
        float[] numerator;
        if (index1 == index2) {
            throw new IllegalArgumentException("The indices should not be equals.");
        }
        float maxRatio = Float.MIN_VALUE;
        if (index1 == 1) {
            numerator = this.trueCY5;
            denumerator = this.trueCY3;
        } else {
            numerator = this.trueCY3;
            denumerator = this.trueCY5;
        }
        int size = this.getSize();
        for (int i = 0; i < size; ++i) {
            float ratio = FloatSlideData.getRatio(numerator[i], denumerator[i], logState);
            if (!(ratio > maxRatio)) continue;
            maxRatio = ratio;
        }
        return maxRatio;
    }

    @Override
    public float getMinRatio(int logState) {
        int SIZE;
        float minRatio = Float.MAX_VALUE;
        int i = SIZE = this.getSize();
        while (--i >= 0) {
            float ratio = this.getRatio(i, logState);
            if (!(ratio < minRatio)) continue;
            minRatio = ratio;
        }
        return minRatio;
    }

    @Override
    public float getMinRatio(int index1, int index2, int logState) {
        float[] denumerator;
        float[] numerator;
        if (index1 == index2) {
            throw new IllegalArgumentException("The indices should not be equals.");
        }
        float minRatio = Float.MAX_VALUE;
        if (index1 == 1) {
            numerator = this.trueCY5;
            denumerator = this.trueCY3;
        } else {
            numerator = this.trueCY3;
            denumerator = this.trueCY5;
        }
        int size = this.getSize();
        for (int i = 0; i < size; ++i) {
            float ratio = FloatSlideData.getRatio(numerator[i], denumerator[i], logState);
            if (!(ratio < minRatio)) continue;
            minRatio = ratio;
        }
        return minRatio;
    }

    @Override
    public final float getRatio(int index, int logState) {
        if (this.normalizedState == 0) {
            if (this.dataType == 1 || this.dataType == 6) {
                return this.trueCY5[index];
            }
            return FloatSlideData.getRatio(this.trueCY5[index], this.trueCY3[index], logState);
        }
        if (this.dataType == 1 || this.dataType == 6) {
            return this.currentCY5[index];
        }
        return FloatSlideData.getRatio(this.currentCY5[index], this.currentCY3[index], logState);
    }

    @Override
    public void setNonZero(boolean value) {
        isNonZero = value;
    }

    public boolean getIsNonZero() {
        return isNonZero;
    }

    public static final float getRatio(float numerator, float denominator, int logState) {
        float ratio;
        if (denominator < 0.0f || numerator < 0.0f) {
            return numerator;
        }
        if (isNonZero) {
            if (denominator == 0.0f && numerator == 0.0f) {
                return Float.NaN;
            }
            ratio = numerator == 0.0f ? 1.0f / denominator : (denominator == 0.0f ? numerator : numerator / denominator);
        } else {
            if (denominator == 0.0f) {
                return Float.NaN;
            }
            if (numerator == 0.0f) {
                return Float.NaN;
            }
            ratio = numerator / denominator;
        }
        if (logState == 1) {
            ratio = (float)(Math.log(ratio) / Math.log(2.0));
        }
        return ratio;
    }

    @Override
    public float getMaxCY3() {
        if (this.normalizedState == 0) {
            return this.getMaxCY(this.trueCY3);
        }
        return this.getMaxCY(this.currentCY3);
    }

    @Override
    public float getMaxCY5() {
        if (this.normalizedState == 0) {
            return this.getMaxCY(this.trueCY5);
        }
        return this.getMaxCY(this.currentCY5);
    }

    private float getMaxCY(float[] CY) {
        int SIZE;
        float maxIntensity = 0.0f;
        int i = SIZE = this.getSize();
        while (--i >= 0) {
            if (!(CY[i] > maxIntensity)) continue;
            maxIntensity = CY[i];
        }
        return maxIntensity;
    }

    public float getMinCY3() {
        if (this.normalizedState == 0) {
            return this.getMinIntensity(this.trueCY3, true);
        }
        return this.getMinIntensity(this.currentCY3, true);
    }

    public float getMinCY5() {
        if (this.normalizedState == 0) {
            return this.getMinIntensity(this.trueCY5, true);
        }
        return this.getMinIntensity(this.currentCY5, true);
    }

    private float getMinIntensity(float[] CY, boolean acceptZeros) {
        int SIZE;
        float minIntensity = Float.MAX_VALUE;
        int i = SIZE = this.getSize();
        while (--i >= 0) {
            float intensity = CY[i];
            if (!acceptZeros) {
                if (!(intensity < minIntensity) || intensity == 0.0f) continue;
                minIntensity = intensity;
                continue;
            }
            if (!(intensity < minIntensity)) continue;
            minIntensity = intensity;
        }
        return minIntensity;
    }

    @Override
    public int getNormalizedState() {
        return this.normalizedState;
    }

    @Override
    public void setNormalizedState(int normalizedState) {
        this.normalizedState = normalizedState;
    }

    @Override
    public int getSortState() {
        return this.sortState;
    }

    public void setSortState(int sortState) {
        this.sortState = sortState;
    }

    public void setDetection(int index, String value) {
        this.detection[index] = value.charAt(0);
    }

    public void setDetection(char[] d) {
        this.detection = d;
    }

    @Override
    public String getDetection(int index) {
        return String.valueOf(this.detection[index]);
    }

    public void setPvalue(int index, float value) {
        this.pvalue[index] = value;
    }

    public float[] getPvalue() {
        return this.pvalue;
    }

    public void setPvalues(float[] p) {
        this.pvalue = p;
    }

    public void setGenePixFlags(int[] f) {
        this.flags = f;
    }

    public int[] getGenePixFlags() {
        return this.flags;
    }

    @Override
    public float getPvalue(int index) {
        return this.pvalue[index];
    }

    @Override
    public int getGenePixFlags(int index) {
        return this.flags[index];
    }

    public int setGenePixFlags(int index, int value) {
        this.flags[index] = value;
        return this.flags[index];
    }

    @Override
    public float getMaxIntensity(int intensityType) {
        switch (intensityType) {
            case 0: {
                return this.getMaxCY3();
            }
            case 1: {
                return this.getMaxCY5();
            }
        }
        return Float.NaN;
    }

    @Override
    public float getMinIntensity(int intensityType, boolean acceptZeros) {
        return this.getMinIntensity(this.getIntensities(intensityType), acceptZeros);
    }

    private float[] getIntensities(int type) {
        switch (type) {
            case 0: {
                return this.trueCY3;
            }
            case 1: {
                return this.trueCY5;
            }
        }
        return null;
    }

    @Override
    public float getMaxProduct(int index1, int index2) {
        float product = 0.0f;
        float maxProduct = 0.0f;
        float[] v_1 = this.getIntensities(index1);
        float[] v_2 = this.getIntensities(index2);
        int size = this.getSize();
        for (int i = 0; i < size; ++i) {
            product = v_1[i] * v_2[i];
            if (!(product > maxProduct)) continue;
            maxProduct = product;
        }
        return maxProduct;
    }

    @Override
    public float getMinProduct(int index1, int index2, boolean acceptZeros) {
        return this.getMinProduct(index1, index2, acceptZeros, 0);
    }

    @Override
    public float getMinProduct(int index1, int index2, boolean acceptZeros, int lowCutoff) {
        float product = 0.0f;
        float minProduct = Float.MAX_VALUE;
        float[] v_1 = this.getIntensities(index1);
        float[] v_2 = this.getIntensities(index2);
        int size = this.getSize();
        for (int i = 0; i < size; ++i) {
            product = v_1[i] * v_2[i];
            if (!(product >= (float)lowCutoff)) continue;
            if (!acceptZeros) {
                if (!(product < minProduct) || product == 0.0f) continue;
                minProduct = product;
                continue;
            }
            if (!(product < minProduct)) continue;
            minProduct = product;
        }
        return minProduct;
    }

    @Override
    public ISlideDataElement getSlideDataElement(int index) {
        ISlideDataElement sde = this.slideMetaData.toSlideDataElement(index);
        sde.setIntensity(0, this.getCY3(index));
        sde.setIntensity(1, this.getCY5(index));
        sde.setTrueIntensity(0, this.getCY3(index));
        sde.setTrueIntensity(1, this.getCY5(index));
        sde.setDetection(this.getDetection(index));
        try {
            sde.setPvalue(this.getPvalue(index));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return sde;
    }

    @Override
    public void addSlideDataElement(ISlideDataElement element) {
        this.throwNotImplemented("addSlideDataElement");
    }

    private void createDataCopy() {
        if (this.currentCY3 == null || this.currentCY5 == null) {
            this.currentCY3 = new float[this.trueCY3.length];
            this.currentCY5 = new float[this.trueCY5.length];
            System.arraycopy(this.trueCY3, 0, this.currentCY3, 0, this.currentCY3.length);
            System.arraycopy(this.trueCY5, 0, this.currentCY5, 0, this.currentCY5.length);
        }
    }

    public void createCurrentIntensityArrays() {
        if (this.currentCY3 == null || this.currentCY5 == null) {
            this.currentCY3 = new float[this.trueCY3.length];
            this.currentCY5 = new float[this.trueCY5.length];
            System.arraycopy(this.trueCY3, 0, this.currentCY3, 0, this.currentCY3.length);
            System.arraycopy(this.trueCY5, 0, this.currentCY5, 0, this.currentCY5.length);
        }
    }

    @Override
    public void applyNormalization(int normalizationMode, Properties props) {
        this.createDataCopy();
        switch (normalizationMode) {
            case 0: {
                this.applyNoNormalization();
                break;
            }
            case 1: {
                this.applyTotalIntensity();
                break;
            }
            case 2: {
                this.applyLeastSquares();
                break;
            }
            case 3: {
                this.applyLinearRegression(props);
                break;
            }
            case 4: {
                this.applyRatioStatistics(props);
                break;
            }
            case 5: {
                this.applyRatioStatistics(props);
                break;
            }
            case 6: {
                this.applyIterativeLog(props);
                break;
            }
            case 7: {
                this.applyLowess(10);
            }
        }
        this.setNormalizedState(normalizationMode);
    }

    @Override
    public void applyNormalizationList(int normalizationMode) {
        this.createDataCopy();
        switch (normalizationMode) {
            case 101: {
                this.applyTotalIntensity();
                break;
            }
            case 102: {
                this.applyLeastSquares();
                break;
            }
            case 103: {
                this.applyLinearRegression(new Properties());
                break;
            }
            case 104: {
                this.applyRatioStatistics(new Properties());
                break;
            }
            case 105: {
                this.applyRatioStatistics(new Properties());
                break;
            }
            case 106: {
                this.applyIterativeLog(new Properties());
                break;
            }
            case 107: {
                this.applyLowess(10);
            }
        }
        this.setNormalizedState(normalizationMode);
    }

    private void applyNoNormalization() {
        if (this.trueCY3 != null && this.trueCY5 != null) {
            System.arraycopy(this.trueCY3, 0, this.currentCY3, 0, this.trueCY3.length);
            System.arraycopy(this.trueCY5, 0, this.currentCY5, 0, this.trueCY5.length);
        }
    }

    public void applyTotalIntensity() {
        boolean[] goodValues = new boolean[this.getSize()];
        ColumnWorker cw = this.constructColumnWorker(goodValues);
        cw = new TotInt(cw, "Cy3", false).getFileTotIntColumnWorker();
        this.setNormalizedIntensities(cw, goodValues);
        this.normalizedState = 1;
    }

    public void applyLinearRegression(Properties properties) {
        boolean[] goodValues = new boolean[this.getSize()];
        ColumnWorker cw = this.constructColumnWorker(goodValues);
        try {
            String mode = (String)properties.get("mode");
            float sd = Float.parseFloat((String)properties.get("standard-deviation"));
            cw = new IterativeLinReg(cw, sd, mode, "Cy3").getIterLinRegColumnWorker();
            this.setNormalizedIntensities(cw, goodValues);
            this.normalizedState = 3;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(new JFrame(), "Error Performing Normalization: Data Unchanged", "Normalization Error : Aborted", 2);
            this.normalizedState = 0;
            e.printStackTrace();
        }
    }

    public void applyRatioStatistics(Properties properties) {
        boolean[] goodValues = new boolean[this.getSize()];
        ColumnWorker cw = this.constructColumnWorker(goodValues);
        try {
            int confInt = Integer.parseInt((String)properties.get("confidence-interval"));
            cw = new RatioStats(cw, false, confInt, "Cy3").getRatioStatsColumnWorker();
            this.setNormalizedIntensities(cw, goodValues);
            this.normalizedState = 3;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(new JFrame(), "Error Performing Normalization: Data Unchanged", "Normalization Error : Aborted", 2);
            this.normalizedState = 0;
            e.printStackTrace();
        }
    }

    public void applyIterativeLog(Properties properties) {
        boolean[] goodValues = new boolean[this.getSize()];
        ColumnWorker cw = this.constructColumnWorker(goodValues);
        try {
            float sd = Float.parseFloat((String)properties.get("standard-deviation"));
            cw = new IterativeLogMean(cw, sd, "Cy3").getIterLogMeanColumnWorker();
            this.setNormalizedIntensities(cw, goodValues);
            this.normalizedState = 6;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(new JFrame(), "Error Performing Normalization: Data Unchanged", "Normalization Error : Aborted", 2);
            this.normalizedState = 0;
        }
    }

    private ColumnWorker constructColumnWorker(boolean[] goodValues) {
        int n;
        int size = n = this.getSize();
        float[] cy3 = new float[n];
        float[] cy5 = new float[n];
        String[] metaCombo = new String[n];
        n = 0;
        for (int i = 0; i < size; ++i) {
            int metaRow = this.getSlideDataElement(i).getRow(1);
            int metaColumn = this.getSlideDataElement(i).getColumn(1);
            float CY3 = this.trueCY3[i];
            float CY5 = this.trueCY5[i];
            if (this.dataType == 1) {
                CY3 = 100000.0f;
                if ((CY5 = (float)(100000.0 * Math.pow(2.0, CY5))) == Float.POSITIVE_INFINITY || CY5 == Float.NEGATIVE_INFINITY) {
                    CY5 = 0.0f;
                    CY3 = 0.0f;
                }
            }
            if (CY3 == 0.0f || CY5 == 0.0f) continue;
            goodValues[i] = true;
            cy3[n] = CY3;
            cy5[n] = CY5;
            metaCombo[n] = Integer.toString(metaRow) + "_" + Integer.toString(metaColumn);
            ++n;
        }
        float[] goodCy3 = new float[n];
        float[] goodCy5 = new float[n];
        System.arraycopy(cy3, 0, goodCy3, 0, n);
        System.arraycopy(cy5, 0, goodCy5, 0, n);
        System.arraycopy(metaCombo, 0, metaCombo, 0, n);
        return new ColumnWorker(goodCy3, goodCy5, metaCombo);
    }

    private void setNormalizedIntensities(ColumnWorker cw, boolean[] goodIntensity) {
        float[] cy3 = cw.getColumnOneArray();
        float[] cy5 = cw.getColumnTwoArray();
        int goodIndex = 0;
        for (int i = 0; i < goodIntensity.length; ++i) {
            if (goodIntensity[i]) {
                if (this.dataType == 1) {
                    this.currentCY3[i] = 1.0f;
                    this.currentCY5[i] = (float)(Math.log(cy5[goodIndex] / cy3[goodIndex]) / Math.log(2.0));
                } else {
                    this.currentCY3[i] = cy3[goodIndex];
                    this.currentCY5[i] = cy5[goodIndex];
                }
                ++goodIndex;
                continue;
            }
            this.currentCY3[i] = this.trueCY3[i];
            this.currentCY5[i] = this.trueCY5[i];
        }
    }

    private final float applyTotalIntensity(float value, float totalCy3, float totalCy5) {
        if (value > 0.0f) {
            return value * totalCy3 / totalCy5;
        }
        return 0.0f;
    }

    private float getSumIntensity(int intensityType) {
        float totalIntensity = 0.0f;
        float[] intensities = this.getIntensities(intensityType);
        for (int i = 0; i < intensities.length; ++i) {
            totalIntensity += intensities[i];
        }
        return totalIntensity;
    }

    private float getSumNonZeroIntensity(int intensityType) {
        float totalIntensity = 0.0f;
        float[] intensities = this.getIntensities(intensityType);
        for (int i = 0; i < intensities.length; ++i) {
            if (!this.slideMetaData.hasNoZeros(i)) continue;
            totalIntensity += intensities[i];
        }
        return totalIntensity;
    }

    private void applyLeastSquares() {
        if (this.getNormalizedState() != 2) {
            LinearEquation linearEquation = this.getRegressionEquation(true);
            int size = this.getSize();
            for (int i = 0; i < size; ++i) {
                this.currentCY5[i] = this.applyLeastSquares(this.trueCY5[i], linearEquation);
            }
        }
    }

    private float applyLeastSquares(float value, LinearEquation linearEquation) {
        if (value > 0.0f) {
            return (float)(((double)value - linearEquation.getYIntercept()) * (1.0 / linearEquation.getSlope()));
        }
        return 0.0f;
    }

    private LinearEquation getRegressionEquation(boolean useTrueValues) {
        double x = 0.0;
        double y = 0.0;
        double sum = 0.0;
        double sumX = 0.0;
        double sumY = 0.0;
        double sumX2 = 0.0;
        double sumY2 = 0.0;
        double sumXY = 0.0;
        double weight = 1.0;
        double delta = 0.0;
        double a = 0.0;
        double b = 0.0;
        double variance = 1.0;
        double regressionCoefficient = 0.0;
        double sigmaA = 0.0;
        double sigmaB = 0.0;
        float[] cy3 = useTrueValues ? this.trueCY3 : this.currentCY3;
        float[] cy5 = useTrueValues ? this.trueCY5 : this.currentCY5;
        int size = this.getSize();
        for (int i = 0; i < size; ++i) {
            x = cy3[i];
            y = cy5[i];
            if (x == 0.0 || y == 0.0) continue;
            sum += weight;
            sumX += weight * x;
            sumY += weight * y;
            sumX2 += weight * x * x;
            sumY2 += weight * y * y;
            sumXY += weight * x * y;
        }
        delta = sum * sumX2 - sumX * sumX;
        a = (sumX2 * sumY - sumX * sumXY) / delta;
        b = (sumXY * sum - sumX * sumY) / delta;
        sigmaA = Math.sqrt(variance * sumX2 / delta);
        sigmaB = Math.sqrt(variance * sum / delta);
        regressionCoefficient = (sum * sumXY - sumX * sumY) / Math.sqrt(delta * (sum * sumY2) - sumY * sumY);
        LinearEquation linearEquation = new LinearEquation(b, a, regressionCoefficient);
        return linearEquation;
    }

    private void applyLowess(int bins) {
        this.throwNotImplemented("applyLowess");
    }

    private void throwNotImplemented(String methodName) {
        throw new RuntimeException("Method '" + methodName + "' is not supported");
    }

    public Vector getSlideDataKeys() {
        if (this.isSampleAnnotationLoaded) {
            return new Vector(this.getSampleAnnotation().getAnnotationKeys());
        }
        return this.sampleLabelKeys;
    }

    @Override
    public Hashtable getSlideDataLabels() {
        if (this.isSampleAnnotationLoaded) {
            return this.getSampleAnnotation().getSampleAnnoHash();
        }
        return this.sampleLabels;
    }

    @Override
    public void setDataLabelKey(String key) {
        this.sampleLabelKey = key;
    }

    @Override
    public String getSampleLabelKey() {
        return this.sampleLabelKey;
    }

    @Override
    public void addNewSampleLabel(String label, String value) {
        if (!this.isSampleAnnotationLoaded) {
            if (!this.sampleLabelKeys.contains(label)) {
                this.sampleLabelKeys.addElement(label);
            }
            this.sampleLabels.put(label, value);
        } else {
            SampleAnnotation ann = new SampleAnnotation();
            this.isSampleAnnotationLoaded = true;
            ann.setAnnotation("Default Slide Name", this.getSampleAnnotation().getAnnotation("Default Slide Name"));
            ann.setAnnotation(label, value);
            this.setSampleAnnotation(ann);
        }
    }

    @Override
    public void setFlankingRegions(Vector[] flankingRegions) {
        this.flankingRegions = flankingRegions;
    }

    @Override
    public int getNumFlankingRegions(int chromosomeIndex) {
        return this.flankingRegions[chromosomeIndex].size();
    }

    @Override
    public Vector[] getFlankingRegions() {
        return this.flankingRegions;
    }

    @Override
    public boolean isMissingData(int cloneIndex) {
        return Float.isNaN(this.getCY3(cloneIndex)) || Float.isNaN(this.getCY5(cloneIndex));
    }

    public void loadIntensities(DataInputStream dis) throws IOException {
        int i;
        this.currentCY3 = new float[dis.readInt()];
        for (i = 0; i < this.currentCY3.length; ++i) {
            this.currentCY3[i] = dis.readFloat();
        }
        this.currentCY5 = new float[dis.readInt()];
        for (i = 0; i < this.currentCY5.length; ++i) {
            this.currentCY5[i] = dis.readFloat();
        }
        this.trueCY3 = new float[dis.readInt()];
        for (i = 0; i < this.trueCY3.length; ++i) {
            this.trueCY3[i] = dis.readFloat();
        }
        this.trueCY5 = new float[dis.readInt()];
        for (i = 0; i < this.trueCY5.length; ++i) {
            this.trueCY5[i] = dis.readFloat();
        }
        this.detection = new char[dis.readInt()];
        for (i = 0; i < this.detection.length; ++i) {
            this.detection[i] = dis.readChar();
        }
    }

    public void writeIntensities(DataOutputStream dos) throws IOException {
        int i;
        if (this.currentCY3 != null) {
            dos.writeInt(this.currentCY3.length);
            for (i = 0; i < this.currentCY3.length; ++i) {
                dos.writeFloat(this.currentCY3[i]);
            }
        } else {
            dos.writeInt(0);
        }
        if (this.currentCY5 != null) {
            dos.writeInt(this.currentCY5.length);
            for (i = 0; i < this.currentCY5.length; ++i) {
                dos.writeFloat(this.currentCY5[i]);
            }
        } else {
            dos.writeInt(0);
        }
        dos.writeInt(this.trueCY3.length);
        for (i = 0; i < this.trueCY3.length; ++i) {
            dos.writeFloat(this.trueCY3[i]);
        }
        dos.writeInt(this.trueCY5.length);
        for (i = 0; i < this.trueCY5.length; ++i) {
            dos.writeFloat(this.trueCY5[i]);
        }
        dos.writeInt(this.detection.length);
        for (i = 0; i < this.detection.length; ++i) {
            dos.writeChar(this.detection[i]);
        }
    }

    @Override
    public SampleAnnotation getSampleAnnotation() {
        return this.sampAnn;
    }

    @Override
    public void setSampleAnnotation(SampleAnnotation sampAnn) {
        this.sampAnn = sampAnn;
    }

    @Override
    public boolean isSampleAnnotationLoaded() {
        return this.isSampleAnnotationLoaded;
    }

    @Override
    public void setSampleAnnotationLoaded(boolean isAnnLoaded) {
        this.isSampleAnnotationLoaded = isAnnLoaded;
    }
}

