/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ListOrderDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class ExperimentLabelEditor
extends AlgorithmDialog {
    JTable table;
    DefaultViewerTableModel model;
    CellEditor cellEditor;
    int result = 0;
    JPopupMenu popup;
    JMenuItem mergeRowsPopItem;
    JMenuItem mergeRowsItem;
    JMenuItem delRowsPopItem;
    JMenuItem delRowsItem;
    JCheckBoxMenuItem enableReorderItem;
    JCheckBoxMenuItem enableReorderPopItem;
    boolean allowReordering = false;
    JFrame parent;

    public ExperimentLabelEditor(JFrame parent, Vector keys, IData data, boolean permitReorder) {
        super(parent, "Sample Label Editor", true);
        this.parent = parent;
        Listener listener = new Listener();
        this.allowReordering = permitReorder;
        this.model = new DefaultViewerTableModel(keys, data);
        this.table = new JTable(this.model);
        this.table.setDefaultRenderer(String.class, new CellRenderer());
        this.table.setDefaultRenderer(JTextField.class, new CellRenderer());
        this.table.setDefaultRenderer(Object.class, new CellRenderer());
        this.table.setRowSelectionAllowed(true);
        this.table.setAutoResizeMode(0);
        this.table.getColumn("Label Key").setMinWidth(130);
        for (int i = 1; i < this.table.getColumnCount(); ++i) {
            this.table.getColumn(String.valueOf(i)).setMinWidth(100);
        }
        this.table.setDefaultEditor(JTextField.class, new DefaultCellEditor(new JTextField()));
        this.table.setRowHeight(25);
        JScrollPane pane = new JScrollPane(this.table);
        pane.setColumnHeaderView(this.table.getTableHeader());
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 150));
        ParameterPanel panel = new ParameterPanel("Sample Labels");
        panel.setLayout((LayoutManager)new GridBagLayout());
        panel.add((Component)pane, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        JMenuBar menuBar = this.createMenuBar(listener);
        this.setJMenuBar(menuBar);
        this.popup = this.createPopupMenu(listener);
        this.addContent((Component)panel);
        int w = this.getToolkit().getScreenSize().width;
        int dataWidth = 130 + 100 * (this.table.getColumnCount() - 1) - 50;
        if (w > 100) {
            w = (int)((double)w * 0.8);
            this.setSize(Math.min(w, dataWidth), 300);
        } else {
            this.setSize(700, 300);
        }
        this.table.addMouseListener(listener);
        this.setActionListeners(listener);
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public String getNewLabel() {
        return "TestLabel";
    }

    public String[] getLabelValues() {
        String[] labels = new String[10];
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = "Test Label " + String.valueOf(i);
        }
        return labels;
    }

    public String[][] getLableData() {
        String[][] data = new String[this.table.getRowCount()][this.table.getColumnCount()];
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                data[i][j] = (String)this.model.getValueAt(i, j);
            }
        }
        return data;
    }

    public String[][] getLabelDataWithoutKeys() {
        String[][] data = new String[this.table.getRowCount()][this.table.getColumnCount() - 1];
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                data[i][j] = (String)this.model.getValueAt(i, j + 1);
            }
        }
        return data;
    }

    public String[] getLabelKeys() {
        String[] keys = new String[this.table.getRowCount()];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = (String)this.model.getValueAt(i, 0);
        }
        return keys;
    }

    public String[] getExperimentNamesInOriginalOrder() {
        String[] expNames = new String[this.table.getColumnCount() - 1];
        for (int i = 0; i < expNames.length; ++i) {
            expNames[i] = (String)this.model.getValueAt(0, i + 1);
        }
        return expNames;
    }

    public String[] getExperimentNamesInTableOrder() {
        String[] expNames = new String[this.table.getColumnCount() - 1];
        for (int i = 0; i < expNames.length; ++i) {
            expNames[i] = (String)this.table.getValueAt(0, i + 1);
        }
        return expNames;
    }

    public int[] getNewOrderScheme() {
        String[] origOrder = this.getExperimentNamesInOriginalOrder();
        String[] newOrder = this.getExperimentNamesInTableOrder();
        int[] order = new int[origOrder.length];
        for (int i = 0; i < origOrder.length; ++i) {
            for (int j = 0; j < newOrder.length; ++j) {
                if (!origOrder[i].equals(newOrder[j])) continue;
                order[j] = i;
            }
        }
        return order;
    }

    public boolean isReorderedSelected() {
        return this.allowReordering && (this.enableReorderItem.isSelected() || this.enableReorderPopItem.isSelected());
    }

    private JMenuBar createMenuBar(Listener listener) {
        JMenuBar bar = new JMenuBar();
        JMenu editMenu = new JMenu("Edit");
        editMenu.setMnemonic('E');
        JMenuItem addRowItem = new JMenuItem("Add New Sample Label");
        addRowItem.setActionCommand("add-row-command");
        addRowItem.addActionListener(listener);
        this.mergeRowsItem = new JMenuItem("Merge Selected Rows");
        this.mergeRowsItem.setActionCommand("merge-rows-command");
        this.mergeRowsItem.addActionListener(listener);
        this.delRowsItem = new JMenuItem("Delete Selected Rows");
        this.delRowsItem.setActionCommand("del-rows-command");
        this.delRowsItem.addActionListener(listener);
        this.enableReorderItem = new JCheckBoxMenuItem("Enable Sample Reordering", false);
        this.enableReorderItem.setActionCommand("reorder-command");
        this.enableReorderItem.setEnabled(this.allowReordering);
        this.enableReorderItem.setToolTipText("forces samples to reorder to match table, hit info button");
        this.enableReorderItem.addActionListener(listener);
        editMenu.add(addRowItem);
        editMenu.add(this.mergeRowsItem);
        editMenu.add(this.delRowsItem);
        editMenu.add(new JSeparator());
        editMenu.add(this.enableReorderItem);
        bar.add(editMenu);
        return bar;
    }

    private JPopupMenu createPopupMenu(Listener listener) {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem addRowPopItem = new JMenuItem("Add New Sample Label");
        addRowPopItem.setActionCommand("add-row-command");
        addRowPopItem.addActionListener(listener);
        this.mergeRowsPopItem = new JMenuItem("Merge Selected Rows");
        this.mergeRowsPopItem.setActionCommand("merge-rows-command");
        this.mergeRowsPopItem.addActionListener(listener);
        this.delRowsPopItem = new JMenuItem("Delete Selected Rows");
        this.delRowsPopItem.setActionCommand("del-rows-command");
        this.delRowsPopItem.addActionListener(listener);
        this.enableReorderPopItem = new JCheckBoxMenuItem("Enable Sample Reordering", false);
        this.enableReorderPopItem.setActionCommand("reorder-command");
        this.enableReorderPopItem.setEnabled(this.allowReordering);
        this.enableReorderPopItem.setToolTipText("forces samples to reorder to match table, hit info button");
        this.enableReorderPopItem.addActionListener(listener);
        popup.add(addRowPopItem);
        popup.add(this.mergeRowsPopItem);
        popup.add(this.delRowsPopItem);
        popup.addSeparator();
        popup.add(this.enableReorderPopItem);
        return popup;
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String command = ae.getActionCommand();
            if (command.equals("add-row-command")) {
                ExperimentLabelEditor.this.model.addNewRow();
            } else if (command.equals("merge-rows-command")) {
                int[] selectedRows = ExperimentLabelEditor.this.table.getSelectedRows();
                if (selectedRows.length < 2) {
                    return;
                }
                ExperimentLabelEditor.this.model.mergeRows(selectedRows);
            } else if (command.equals("del-rows-command")) {
                int[] selectedRows = ExperimentLabelEditor.this.table.getSelectedRows();
                if (selectedRows.length < 1) {
                    return;
                }
                ExperimentLabelEditor.this.model.deleteRows(selectedRows);
            } else if (ExperimentLabelEditor.this.allowReordering && command.equals("reorder-command")) {
                if (ae.getSource() == ExperimentLabelEditor.this.enableReorderItem) {
                    ExperimentLabelEditor.this.enableReorderPopItem.setSelected(ExperimentLabelEditor.this.enableReorderItem.isSelected());
                } else {
                    ExperimentLabelEditor.this.enableReorderItem.setSelected(ExperimentLabelEditor.this.enableReorderPopItem.isSelected());
                }
            } else if (command.equals("ok-command")) {
                if (ExperimentLabelEditor.this.table.isEditing()) {
                    String value = ((JTextField)ExperimentLabelEditor.this.table.getEditorComponent()).getText();
                    ExperimentLabelEditor.this.table.setValueAt(value, ExperimentLabelEditor.this.table.getEditingRow(), ExperimentLabelEditor.this.table.getEditingColumn());
                }
                ExperimentLabelEditor.this.result = 0;
                ExperimentLabelEditor.this.dispose();
            } else if (command.equals("cancel-command")) {
                ExperimentLabelEditor.this.result = 2;
                ExperimentLabelEditor.this.dispose();
            } else if (command.equals("info-command")) {
                HelpWindow.launchBrowser((Window)((Object)ExperimentLabelEditor.this), (String)"Experiment Label Editor");
            }
        }

        @Override
        public void mousePressed(MouseEvent me) {
            if (me.isPopupTrigger()) {
                ExperimentLabelEditor.this.popup.show(ExperimentLabelEditor.this.table, me.getX(), me.getY());
                return;
            }
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            if (me.isPopupTrigger()) {
                ExperimentLabelEditor.this.popup.show(ExperimentLabelEditor.this.table, me.getX(), me.getY());
                return;
            }
            if (ExperimentLabelEditor.this.table.getSelectedRowCount() > 1) {
                ExperimentLabelEditor.this.mergeRowsItem.setEnabled(true);
                ExperimentLabelEditor.this.mergeRowsPopItem.setEnabled(true);
            } else {
                ExperimentLabelEditor.this.mergeRowsItem.setEnabled(false);
                ExperimentLabelEditor.this.mergeRowsPopItem.setEnabled(false);
            }
            if (ExperimentLabelEditor.this.table.getSelectedRowCount() > 0) {
                ExperimentLabelEditor.this.delRowsItem.setEnabled(true);
                ExperimentLabelEditor.this.delRowsPopItem.setEnabled(true);
            } else {
                ExperimentLabelEditor.this.delRowsItem.setEnabled(false);
                ExperimentLabelEditor.this.delRowsPopItem.setEnabled(false);
            }
        }
    }

    public class CellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JTextField field = new JTextField();
        String value;

        public CellEditor() {
            this.field.setBackground(new Color(222, 222, 222));
        }

        @Override
        public Object getCellEditorValue() {
            return this.field;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.value = this.field.getText();
            this.fireEditingStopped();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object obj, boolean selected, int row, int col) {
            this.field = (JTextField)obj;
            return (JTextField)obj;
        }
    }

    public class CellRenderer
    extends DefaultTableCellRenderer {
        JPanel colorPanel;
        JLabel label;
        JTextField textField = new JTextField();

        public CellRenderer() {
            this.textField.setOpaque(true);
            this.colorPanel = new JPanel();
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object obj, boolean param, boolean param3, int row, int col) {
            if (obj instanceof Color) {
                this.colorPanel.setBackground((Color)obj);
                return this.colorPanel;
            }
            if (obj instanceof JLabel) {
                this.label = (JLabel)obj;
                this.label.setOpaque(true);
                this.label.setFont(new Font("Arial", 0, 12));
                if (row == 0 || col == 0) {
                    this.label.setBackground(Color.lightGray);
                } else {
                    this.label.setBackground(new Color(225, 225, 225));
                }
                this.label.setForeground(Color.black);
                this.label.setHorizontalAlignment(0);
                if (ExperimentLabelEditor.this.table.isRowSelected(row) && row != 0) {
                    this.label.setBackground(ExperimentLabelEditor.this.table.getSelectionBackground());
                }
                return this.label;
            }
            if (obj instanceof JTextField) {
                this.textField = (JTextField)obj;
                if (row == 0) {
                    this.textField.setEditable(false);
                    this.textField.setBackground(Color.lightGray);
                } else if (col == 0) {
                    this.textField.setEditable(true);
                    this.textField.setBackground(new Color(255, 255, 155));
                } else {
                    this.textField.setEditable(true);
                    this.textField.setBackground(Color.white);
                }
                if (ExperimentLabelEditor.this.table.isRowSelected(row) && row != 0) {
                    this.textField.setBackground(ExperimentLabelEditor.this.table.getSelectionBackground());
                }
                return this.textField;
            }
            if (obj instanceof String) {
                this.textField.setText((String)obj);
                if (row == 0) {
                    this.textField.setEditable(false);
                    this.textField.setBackground(Color.lightGray);
                } else if (col == 0) {
                    this.textField.setEditable(true);
                    this.textField.setBackground(new Color(255, 255, 155));
                } else {
                    this.textField.setEditable(true);
                    this.textField.setBackground(Color.white);
                }
                if (ExperimentLabelEditor.this.table.isRowSelected(row) && row != 0) {
                    this.textField.setBackground(ExperimentLabelEditor.this.table.getSelectionBackground());
                }
                return this.textField;
            }
            this.colorPanel.setBackground(Color.white);
            return this.colorPanel;
        }
    }

    public class DefaultViewerTableModel
    extends AbstractTableModel
    implements Serializable {
        boolean[] numerical;
        Row[] rows;
        int colToSort = 0;
        boolean ascending = false;
        int columnCount;
        IData data;
        ISlideData slideData;
        String currKey;
        String[] columnNames;
        String[][] dataObject;
        Vector keys;
        JTextField valueObject;
        JLabel label;

        public DefaultViewerTableModel(Vector keys, IData data) {
            int i;
            this.data = data;
            this.keys = keys;
            this.columnCount = data.getFeaturesCount() + 1;
            this.columnNames = new String[this.columnCount];
            for (int i2 = 0; i2 < this.columnNames.length; ++i2) {
                this.columnNames[i2] = i2 == 0 ? "Label Key" : String.valueOf(i2);
            }
            int sampleCount = data.getFeaturesCount();
            int attrCount = keys.size();
            this.dataObject = new String[attrCount][sampleCount + 1];
            for (i = 0; i < sampleCount + 1; ++i) {
                String value = null;
                for (int j = 0; j < attrCount; ++j) {
                    String key = (String)keys.elementAt(j);
                    if (i == 0) {
                        this.dataObject[j][i] = key;
                        continue;
                    }
                    this.slideData = data.getFeature(i - 1);
                    value = (String)this.slideData.getSlideDataLabels().get(key);
                    this.dataObject[j][i] = value != null ? value : " ";
                }
            }
            this.rows = new Row[keys.size()];
            for (i = 0; i < this.rows.length; ++i) {
                this.rows[i] = new Row();
                this.rows[i].index = i;
            }
            this.valueObject = new JTextField();
            this.valueObject.setOpaque(true);
            this.label = new JLabel();
            this.label.setOpaque(true);
        }

        public void initializeRows(int rowCount) {
            this.rows = new Row[rowCount];
            for (int i = 0; i < this.rows.length; ++i) {
                this.rows[i] = new Row();
                this.rows[i].index = i;
            }
        }

        public void setNumerical(int col, boolean numericalBool) {
            if (col > -1 && col < this.numerical.length) {
                this.numerical[col] = numericalBool;
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnCount;
        }

        @Override
        public int getRowCount() {
            return this.rows.length;
        }

        @Override
        public Object getValueAt(int param, int param1) {
            return this.dataObject[param][param1];
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.dataObject[row][col] = (String)value;
            this.fireTableChanged(new TableModelEvent(this, row, row, col));
        }

        @Override
        public String getColumnName(int index) {
            return this.columnNames[index];
        }

        private boolean isNumerical(int col) {
            return this.numerical[col];
        }

        public void sort(int col) {
            this.ascending = !this.ascending;
            this.colToSort = col;
            Arrays.sort(this.rows);
            this.fireTableDataChanged();
        }

        public int getRow(int tableRow) {
            return this.rows[tableRow].index;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return row > 0;
        }

        public void addNewRow() {
            int i;
            String[][] newData = new String[this.dataObject.length + 1][this.columnCount];
            for (i = 0; i < newData.length - 1; ++i) {
                newData[i] = this.dataObject[i];
            }
            this.dataObject = newData;
            this.initializeRows(this.dataObject.length);
            for (i = 0; i < this.columnCount; ++i) {
                this.dataObject[this.dataObject.length - 1][i] = "";
            }
            this.fireTableRowsInserted(this.dataObject.length - 1, this.dataObject.length - 1);
        }

        public void addNewRow(String[] newRow) {
            String[][] newData = new String[this.dataObject.length + 1][this.columnCount];
            for (int i = 0; i < newData.length - 1; ++i) {
                newData[i] = this.dataObject[i];
            }
            this.dataObject = newData;
            this.initializeRows(this.dataObject.length);
            this.dataObject[this.dataObject.length - 1] = newRow;
            this.fireTableRowsInserted(this.dataObject.length - 1, this.dataObject.length - 1);
        }

        public void addNewRow(int[] newRow) {
            int count = 0;
            String[][] newData = new String[this.dataObject.length + newRow.length][this.columnCount];
            for (int i = 0; i < this.dataObject.length; ++i) {
                newData[i] = this.dataObject[i];
            }
            for (int j = this.dataObject.length; j < newData.length; ++j) {
                newData[j] = this.dataObject[newRow[count]];
                if (count >= newRow.length) continue;
                ++count;
            }
            this.dataObject = newData;
            this.initializeRows(this.dataObject.length);
            this.fireTableRowsInserted(this.dataObject.length, this.dataObject.length);
        }

        public void mergeRows(int[] rowsToMerge) {
            Vector keysToMerge = new Vector();
            for (int i = 0; i < rowsToMerge.length; ++i) {
                keysToMerge.addElement(this.dataObject[rowsToMerge[i]][0]);
            }
            JList keyOrderList = new JList(keysToMerge);
            keyOrderList.setSelectedIndex(0);
            ListOrderDialog dialog = new ListOrderDialog(ExperimentLabelEditor.this.parent, keyOrderList, keysToMerge, "Sample Label Keys", " ");
            if (dialog.showModal() != 0) {
                return;
            }
            keysToMerge = dialog.getSortedVector();
            String[] newRow = new String[ExperimentLabelEditor.this.table.getColumnCount()];
            for (int i = 0; i < newRow.length; ++i) {
                newRow[i] = (String)this.getMergedData(keysToMerge, i);
            }
            this.addNewRow(newRow);
        }

        public Object getMergedData(Vector keys, int col) {
            String mergedData = "";
            for (int i = 0; i < keys.size(); ++i) {
                mergedData = i == 0 ? mergedData + this.getDataForKey((String)keys.elementAt(i), col) : mergedData + "-" + this.getDataForKey((String)keys.elementAt(i), col);
            }
            return mergedData;
        }

        public Object getDataForKey(String key, int col) {
            for (int i = 0; i < this.dataObject.length; ++i) {
                if (!this.dataObject[i][0].equals(key)) continue;
                return this.dataObject[i][col];
            }
            return " ";
        }

        public void deleteRows(int[] selectedRows) {
            boolean[] delRows = new boolean[this.dataObject.length];
            int rowsToDelete = 0;
            for (int i = 0; i < selectedRows.length; ++i) {
                if (selectedRows[i] == 0) continue;
                delRows[selectedRows[i]] = true;
                ++rowsToDelete;
            }
            String[][] newData = new String[this.dataObject.length - rowsToDelete][];
            int newRowCnt = 0;
            for (int i = 0; i < this.dataObject.length; ++i) {
                if (delRows[i]) continue;
                newData[newRowCnt] = this.dataObject[i];
                ++newRowCnt;
            }
            this.initializeRows(newData.length);
            this.dataObject = newData;
            this.fireTableDataChanged();
        }

        private class Row
        implements Comparable,
        Serializable {
            public int index;
            private String myString;
            private String otherString;

            private Row() {
            }

            public int compareTo(Object other) {
                if (DefaultViewerTableModel.this.ascending) {
                    return this.compareToOther(other);
                }
                return this.compareToOther(other) * -1;
            }

            public int compareToOther(Object other) {
                Row otherRow = (Row)other;
                Object myObject = DefaultViewerTableModel.this.getValueAt(this.index, DefaultViewerTableModel.this.colToSort);
                Object otherObject = DefaultViewerTableModel.this.getValueAt(otherRow.index, DefaultViewerTableModel.this.colToSort);
                if (myObject instanceof Comparable) {
                    if (DefaultViewerTableModel.this.isNumerical(DefaultViewerTableModel.this.colToSort) && myObject instanceof String) {
                        Float myFloat = new Float((String)myObject);
                        Float otherFloat = new Float((String)otherObject);
                        return myFloat.compareTo(otherFloat);
                    }
                    return ((Comparable)myObject).compareTo(otherObject);
                }
                if (myObject instanceof JLabel) {
                    this.myString = ((JLabel)myObject).getText();
                    this.otherString = ((JLabel)otherObject).getText();
                    return this.myString.compareTo(this.otherString);
                }
                return this.index - otherRow.index;
            }
        }
    }
}

