/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.io.Serializable;

public class DetectionFilter
implements Serializable {
    public static final long serialVersionUID = 100010201110001L;
    private int[] num_required = new int[NUM_OF_GROUPS];
    private static int NUM_OF_GROUPS = 2;
    private boolean both;
    private int[] group_membership;

    public DetectionFilter(String[] names) {
        this.group_membership = new int[names.length];
        for (int i = 0; i < names.length; ++i) {
            this.group_membership[i] = 0;
        }
        this.set_num_required(0, 1);
        this.set_num_required(1, 1);
        this.both = false;
    }

    public int get_num_required(int group_index) {
        return this.num_required[group_index];
    }

    public int get_group_membership(int file_index) {
        return this.group_membership[file_index];
    }

    public boolean get_both() {
        return this.both;
    }

    public void set_num_required(int group_index, int required) {
        this.num_required[group_index] = required;
    }

    public void set_group_membership(int group_index, int file_index) {
        this.group_membership[file_index] = group_index;
    }

    public void set_both(boolean use_both) {
        this.both = use_both;
    }

    public boolean keep_gene(String[] detection_calls) {
        int[] present_calls = new int[]{0, 0};
        for (int i = 0; i < detection_calls.length; ++i) {
            if (!detection_calls[i].equalsIgnoreCase("P")) continue;
            int n = this.get_group_membership(i);
            present_calls[n] = present_calls[n] + 1;
        }
        if (this.get_both()) {
            return present_calls[0] >= this.get_num_required(0) && present_calls[1] >= this.get_num_required(1);
        }
        return present_calls[0] >= this.get_num_required(0) || present_calls[1] >= this.get_num_required(1);
    }

    public String toString() {
        String out = "Num Required Grp 1:" + this.get_num_required(0);
        out = out + "\nNum Required Grp 2:" + this.get_num_required(1);
        for (int i = 0; i < this.group_membership.length; ++i) {
            out = out + "\nsample: " + i + " is in group: " + this.get_group_membership(i);
        }
        return out;
    }
}

