/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import org.tigr.microarray.mev.SlideDataElement;
import org.tigr.microarray.mev.cgh.CGHDataObj.CGHClone;

public class CGHSlideDataElement
extends SlideDataElement {
    public static final int CLONE_ID = 0;
    public static final int CHR = 1;
    public static final int START = 2;
    public static final int END = 3;
    public static final int DESC = 4;

    public CGHSlideDataElement(String UID, int[] rows, int[] columns, float[] intensities, String[] values) {
        super(UID, rows, columns, intensities, values);
    }

    public CGHSlideDataElement(int[] rows, int[] cols, String[] extraFields, String uid, boolean isNull, boolean isNonZero) {
        super(rows, cols, extraFields, uid, isNull, isNonZero);
    }

    public String getCloneID() {
        return this.extraFields[0];
    }

    public String getChromosome() {
        return this.extraFields[1];
    }

    public int getProbeStart() {
        return Integer.parseInt(this.extraFields[2]);
    }

    public int getProbeEnd() {
        return Integer.parseInt(this.extraFields[3]);
    }

    public int getProbeLength() {
        return this.getProbeEnd() - this.getProbeStart();
    }

    public String getDesc() {
        return this.extraFields[4];
    }

    public CGHClone getClone(int species) {
        return new CGHClone(this.getCloneID().trim(), this.getChromosome(), this.getProbeStart(), this.getProbeEnd(), species);
    }
}

