/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.tigr.graph.GraphBar;
import org.tigr.graph.GraphElement;
import org.tigr.graph.GraphLine;
import org.tigr.graph.GraphPoint;
import org.tigr.graph.GraphTick;
import org.tigr.graph.GraphViewer;

public class BlockGraphViewer
extends GraphViewer {
    public int maxRows;
    public int maxColumns;
    public JPanel buttonPanel;
    public JButton button;
    public JButton allButton;
    public JButton noneButton;
    private boolean[] visibles;
    private Color[] colors = new Color[]{Color.black, Color.blue, Color.red, Color.yellow, Color.orange, Color.magenta, Color.cyan, Color.pink, Color.green, Color.gray, Color.lightGray, Color.darkGray};

    public BlockGraphViewer(JFrame frame, int maxRows, int maxColumns, int startx, int stopx, int starty, int stopy, double graphstartx, double graphstopx, double graphstarty, double graphstopy, int preXSpacing, int postXSpacing, int preYSpacing, int postYSpacing, String title, String xLabel, String yLabel) {
        super(frame, startx, stopx, starty, stopy, graphstartx, graphstopx, graphstarty, graphstopy, preXSpacing, postXSpacing, preYSpacing, postYSpacing, title, xLabel, yLabel);
        int i;
        this.maxRows = maxRows;
        this.maxColumns = maxColumns;
        this.generatePalette();
        this.visibles = new boolean[maxRows * maxColumns];
        for (i = 0; i < this.visibles.length; ++i) {
            this.visibles[i] = true;
        }
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridBagLayout());
        this.allButton = new JButton("All");
        this.allButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                for (int i = 0; i < BlockGraphViewer.this.visibles.length; ++i) {
                    ((BlockGraphViewer)BlockGraphViewer.this).visibles[i] = true;
                }
                BlockGraphViewer.this.repaint();
            }
        });
        this.gba.add((Container)this.buttonPanel, (Component)this.allButton, 0, 0, 1, 1, 1, 1, 1, 10);
        this.noneButton = new JButton("None");
        this.noneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                for (int i = 0; i < BlockGraphViewer.this.visibles.length; ++i) {
                    ((BlockGraphViewer)BlockGraphViewer.this).visibles[i] = false;
                }
                BlockGraphViewer.this.repaint();
            }
        });
        this.gba.add((Container)this.buttonPanel, (Component)this.noneButton, 1, 0, 1, 1, 1, 1, 1, 10);
        for (i = 0; i < maxRows; ++i) {
            for (int j = 0; j < maxColumns; ++j) {
                this.button = new JButton(j + 1 + ", " + (i + 1));
                final int location = maxColumns * i + j;
                if (i == 0 && j == 0) {
                    this.button.setForeground(Color.white);
                }
                this.button.setBackground(this.colors[location]);
                this.button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        ((BlockGraphViewer)BlockGraphViewer.this).visibles[location] = !BlockGraphViewer.this.visibles[location];
                        BlockGraphViewer.this.repaint();
                    }
                });
                this.gba.add((Container)this.buttonPanel, (Component)this.button, j, i + 1, 1, 1, 1, 1, 1, 10);
            }
        }
        frame.getContentPane().add(this.buttonPanel);
    }

    public void generatePalette() {
        int elements = this.maxColumns * this.maxRows;
        if (elements != 12) {
            int strata = 0;
            while (strata * strata * strata < elements) {
                ++strata;
            }
            this.colors = new Color[strata * strata * strata];
            for (int r = strata - 1; r >= 0; --r) {
                for (int g = strata - 1; g >= 0; --g) {
                    for (int b = strata - 1; b >= 0; --b) {
                        this.colors[r * strata * strata + g * strata + b] = new Color((int)((double)r * 255.0 / (double)(strata - 1)), (int)((double)g * 255.0 / (double)(strata - 1)), (int)((double)b * 255.0 / (double)(strata - 1)));
                    }
                }
            }
        }
    }

    public Color[] getColors() {
        return this.colors;
    }

    public boolean[] getVisibles() {
        return this.visibles;
    }

    public void drawGraph(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.drawSystem(g, 1100);
        for (int i = 0; i < this.graphElements.size(); ++i) {
            GraphElement e = (GraphElement)this.graphElements.elementAt(i);
            if (e instanceof GraphPoint) {
                for (int j = 0; j < this.visibles.length; ++j) {
                    if (!this.visibles[j] || ((GraphPoint)e).getColor() != this.colors[j]) continue;
                    this.drawPoint(g, (GraphPoint)e);
                }
                continue;
            }
            if (e instanceof GraphBar) {
                this.drawBar(g, (GraphBar)e);
                continue;
            }
            if (e instanceof GraphTick) {
                this.drawTick(g, (GraphTick)e);
                continue;
            }
            if (!(e instanceof GraphLine)) continue;
            this.drawLine(g, (GraphLine)e);
        }
        if (this.referenceLinesOn) {
            int x = this.getXOldEvent();
            int y = this.getYOldEvent();
            if (x <= this.convertX(this.graphstopx) && x >= this.convertX(this.graphstartx)) {
                g.setColor(Color.magenta);
                g.drawLine(x, this.convertY(this.graphstarty), x, this.convertY(this.graphstopy));
            }
            if (y >= this.convertY(this.graphstopy) && y <= this.convertY(this.graphstarty)) {
                g.setColor(Color.magenta);
                g.drawLine(this.convertX(this.graphstartx), y, this.convertX(this.graphstopx), y);
            }
        }
        this.drawXLabel(g, this.xLabel, Color.black);
        this.drawYLabel(g, this.yLabel, Color.black);
        this.drawTitle(g, this.title, Color.black);
    }
}

