/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Cursor;
import java.io.File;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.ISlideMetaData;
import org.tigr.microarray.mev.MultipleArrayViewer;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.util.swing.SlideDataLoader;
import org.tigr.microarray.util.swing.TAVFileFilter;
import org.tigr.util.swing.FileTransferDialog;
import org.tigr.util.swing.TXTFileFilter;

public abstract class ArrayViewer
extends JPanel {
    protected JFrame mainframe;
    protected boolean firstLoad = true;
    protected String currentDataPath;

    public ArrayViewer(JFrame mainframe) {
        this.mainframe = mainframe;
        String iconFile = "org/tigr/images/icon.png";
        URL iconURL = this.getClass().getClassLoader().getResource(iconFile);
        ImageIcon imgIcon = new ImageIcon(iconURL);
        if (imgIcon != null) {
            mainframe.setIconImage(imgIcon.getImage());
        }
    }

    public JFrame getFrame() {
        return this.mainframe;
    }

    public void setCursor(int cursor) {
        this.setCursor(Cursor.getPredefinedCursor(cursor));
    }

    private File selectFile() {
        return this.selectFile("Select a datafile to open", true);
    }

    private File selectFile(String title, boolean multiSelectionEnabled) {
        JFileChooser chooser = this.firstLoad ? new JFileChooser(TMEV.getFile("data/")) : new JFileChooser(this.currentDataPath);
        chooser.setDialogTitle(title);
        chooser.addChoosableFileFilter((FileFilter)new TXTFileFilter());
        chooser.addChoosableFileFilter(new TAVFileFilter());
        if (!multiSelectionEnabled) {
            chooser.setFileFilter(chooser.getAcceptAllFileFilter());
        }
        chooser.setMultiSelectionEnabled(multiSelectionEnabled);
        if (this.firstLoad) {
            chooser.setCurrentDirectory(new File("Data"));
        }
        if (chooser.showOpenDialog(this.getParent()) == 0) {
            File file = chooser.getSelectedFile();
            this.firstLoad = false;
            this.currentDataPath = file.getParent();
            if (this.currentDataPath == null) {
                this.currentDataPath = file.getPath();
            }
            return file;
        }
        return null;
    }

    public ISlideData loadSlideData(ISlideMetaData slideMetaData) throws Exception {
        File file = this.selectFile();
        if (file == null) {
            return null;
        }
        SlideDataLoader loader = this instanceof MultipleArrayViewer ? new SlideDataLoader(this.getFrame(), slideMetaData, file, false) : new SlideDataLoader(this.getFrame(), slideMetaData, file, true);
        if (loader.showModal() != 0) {
            return null;
        }
        return loader.getData(0);
    }

    public ISlideData[] loadDirectory(ISlideMetaData slideMetaData) throws Exception {
        String directory = this.firstLoad ? TMEV.getFile("data/").getPath() : this.currentDataPath;
        return this.loadSlideDataDirectory(directory, new FileFilter[]{new TAVFileFilter()}, slideMetaData);
    }

    private ISlideData[] loadSlideDataDirectory(String directory, FileFilter[] fileFilters, ISlideMetaData slideMetaData) throws Exception {
        SlideDataLoader loader;
        FileTransferDialog dialog = new FileTransferDialog(this.getFrame(), directory, fileFilters);
        if (dialog.showModal() != 0) {
            return null;
        }
        File[] files = dialog.getFiles();
        if (files.length < 1) {
            return null;
        }
        if (this.firstLoad) {
            this.firstLoad = false;
        }
        this.currentDataPath = files[0].getParent();
        if (this.currentDataPath == null) {
            this.currentDataPath = files[0].getPath();
        }
        if ((loader = this instanceof MultipleArrayViewer ? new SlideDataLoader(this.getFrame(), slideMetaData, files, false) : new SlideDataLoader(this.getFrame(), slideMetaData, files, true)).showModal() != 0) {
            return null;
        }
        return loader.getData();
    }

    public ISlideData[] loadStanfordFile(String title) throws Exception {
        File file = this.selectFile(title, false);
        if (file == null) {
            return null;
        }
        SlideDataLoader loader = new SlideDataLoader(this.getFrame(), null, file, false);
        if (loader.showModal(true) != 0) {
            return null;
        }
        return loader.getData();
    }

    public abstract void systemDisable(int var1);

    public abstract void systemEnable(int var1);
}

