/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.tigr.util.awt.GBA;

public class AcknowlegementDialog
extends JDialog
implements Printable {
    private String text;
    private JEditorPane ed;

    public AcknowlegementDialog(Frame parent) {
        this(parent, "");
    }

    public AcknowlegementDialog(Frame parent, String labelText) {
        super(parent, "Contribution Acknowledgement", false);
        EventListener listener = new EventListener();
        this.addWindowListener(listener);
        this.text = labelText;
        GBA gba = new GBA();
        Font font = new Font("serif", 0, 12);
        this.ed = new JEditorPane("text/html", labelText);
        this.ed.setEditable(false);
        this.ed.setMargin(new Insets(10, 10, 10, 10));
        this.ed.setBackground(new Color(234, 233, 191));
        this.ed.setCaretPosition(0);
        JScrollPane scrollPane = new JScrollPane(this.ed, 20, 31);
        JPanel referencesPanel = new JPanel(new GridBagLayout());
        referencesPanel.setBackground(new Color(234, 233, 191));
        gba.add((Container)referencesPanel, (Component)scrollPane, 0, 0, 1, 1, 1, 1, 1, 10);
        JButton printButton = new JButton("Print");
        printButton.setBorder(BorderFactory.createBevelBorder(0));
        printButton.setFocusPainted(false);
        printButton.setActionCommand("print-command");
        printButton.addActionListener(listener);
        JButton closeButton = new JButton("  Close  ");
        closeButton.setBorder(BorderFactory.createBevelBorder(0));
        closeButton.setFocusPainted(false);
        closeButton.setActionCommand("close-command");
        closeButton.addActionListener(listener);
        closeButton.setSize(120, 30);
        closeButton.setPreferredSize(new Dimension(120, 30));
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        gba.add((Container)buttonPanel, (Component)closeButton, 0, 0, 1, 1, 1, 1, 0, 10);
        this.getContentPane().setLayout(new GridBagLayout());
        gba.add(this.getContentPane(), (Component)referencesPanel, 0, 0, 1, 2, 1, 1, 1, 10);
        gba.add(this.getContentPane(), (Component)buttonPanel, 0, 2, 1, 1, 0, 0, 0, 10);
        this.setSize(750, 500);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
    }

    public static String createAcknowlegementText() {
        String html = "";
        try {
            String thisLine;
            InputStream is = AcknowlegementDialog.class.getResourceAsStream("/org/tigr/microarray/mev/acknowledgements.html");
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((thisLine = br.readLine()) != null) {
                html = html + thisLine;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return html;
    }

    public static void main(String[] args) {
        AcknowlegementDialog d = new AcknowlegementDialog(new Frame(), AcknowlegementDialog.createAcknowlegementText());
    }

    @Override
    public int print(Graphics g, PageFormat format, int page) throws PrinterException {
        if (page > 2) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.clip(new Rectangle2D.Double(0.0, 0.0, format.getImageableWidth(), format.getImageableHeight()));
        g2d.translate(format.getImageableX(), (double)(-page) * format.getImageableHeight());
        g2d.scale(1.0, 1.0);
        g2d.drawString("Test String", 0, 20);
        this.ed.paint(g);
        return 0;
    }

    private Book makeBook(PageFormat page, int numPages) {
        Book book = new Book();
        book.append(this, page, numPages);
        return book;
    }

    private class EventListener
    extends WindowAdapter
    implements ActionListener,
    KeyListener {
        private EventListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command.equals("close-command")) {
                AcknowlegementDialog.this.dispose();
            } else if (command.equals("print-command")) {
                PrinterJob pj = PrinterJob.getPrinterJob();
                pj.setPrintable(AcknowlegementDialog.this, pj.defaultPage());
                int numPages = AcknowlegementDialog.this.ed.getHeight();
                numPages = (int)((double)numPages / pj.defaultPage().getImageableY());
                pj.setPageable(AcknowlegementDialog.this.makeBook(pj.defaultPage(), numPages));
                if (pj.printDialog()) {
                    try {
                        pj.print();
                    }
                    catch (PrinterException pe) {
                        System.out.println(pe);
                    }
                }
            }
        }

        @Override
        public void windowClosing(WindowEvent we) {
            AcknowlegementDialog.this.dispose();
        }

        @Override
        public void keyPressed(KeyEvent event) {
            if (event.getKeyCode() == 10) {
                AcknowlegementDialog.this.dispose();
            }
        }

        @Override
        public void keyReleased(KeyEvent event) {
        }

        @Override
        public void keyTyped(KeyEvent event) {
        }
    }
}

