/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.file;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.tigr.microarray.file.FieldNotFoundException;
import org.tigr.microarray.mev.SpotInformationData;
import org.tigr.microarray.mev.file.agilent.ColumnMismatchException;
import org.tigr.microarray.mev.file.agilent.MeVerizer;

public class AgilentMevFileParser {
    public static final int INVALID_FILE = 0;
    public static final int MEV_FILE = 1;
    public static String mHeaderLine = "UID\tIA\tIB\tR\tC\tMR\tMC\tFlagA\tFlagB\tBGA\tBGB\tSDIA\tSDIB\tSDBGA\tSDBGB\tMedianA\tMedianB";
    public static String columnDefLine = "FeatureNum\tgDyeNormSignal\trDyeNormSignal\tRow\tCol\tMR\tMC\tgIsFeatNonUnifOL\trIsFeatNonUnifOL\tgBGMedianSignal\trBGMedianSignal\tgPixSDev\trPixSDev\tgBGPixSDev\trBGPixSDev\tgMedianSignal\trMedianSignal";
    public static String replacement = "1";
    public static final String UNIQUE_ID_STRING = "UID";
    private Vector columnHeaders;
    private Vector rawLines;
    private IntVector dataLinesMap;
    private boolean mevFileLoaded;

    public SpotInformationData getSpotInformation() {
        if (this.isMevFileLoaded()) {
            String[][] data = this.getDataMatrix();
            Vector headers = this.getColumnHeaders();
            if (headers.size() < 9) {
                return null;
            }
            int numberOfFields = headers.size() - 9;
            String[][] spotData = new String[data.length][numberOfFields];
            for (int i = 0; i < spotData.length; ++i) {
                for (int j = 0; j < spotData[i].length; ++j) {
                    spotData[i][j] = data[i][j + 9];
                }
            }
            String[] headerStrings = new String[headers.size() - 9];
            for (int i = 0; i < headerStrings.length; ++i) {
                headerStrings[i] = (String)headers.elementAt(i + 9);
            }
            return new SpotInformationData(headerStrings, spotData);
        }
        return null;
    }

    public static File selectFile(Component dialogParent) {
        return AgilentMevFileParser.selectFile(new File(System.getProperty("user.dir")), dialogParent);
    }

    public static File selectFile(File defaultDirectory, Component dialogParent) {
        JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
        chooser.setDialogTitle("Select an Agilent Oligo Feature Extraction file");
        chooser.setCurrentDirectory(defaultDirectory);
        chooser.setMultiSelectionEnabled(false);
        chooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                String extension = "";
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().endsWith(".txt");
            }

            @Override
            public String getDescription() {
                return "Agilent Oligo Feature Extraction Files (*.txt)";
            }
        });
        if (chooser.showOpenDialog(dialogParent) == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    public static int validate(File targetFile) {
        IntVector dataLinesMap = new IntVector();
        Vector<String> rawLines = new Vector<String>();
        Vector<String> columnHeaders = new Vector<String>();
        String currentLine = new String();
        BufferedReader reader = null;
        boolean readHeaders = false;
        boolean valid1 = false;
        boolean valid2 = true;
        boolean valid3 = false;
        boolean valid4 = true;
        String s = null;
        try {
            MeVerizer mv = new MeVerizer(mHeaderLine, columnDefLine);
            mv.parseExtract(targetFile, true, replacement);
            s = mv.getFileString();
        }
        catch (ColumnMismatchException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            reader = new BufferedReader(new StringReader(s));
            int lineCount = 0;
            while ((currentLine = reader.readLine()) != null) {
                rawLines.add(currentLine);
                if (!currentLine.startsWith("#")) {
                    if (!readHeaders) {
                        readHeaders = true;
                        StringTokenizer st = new StringTokenizer(currentLine, "\t");
                        while (st.hasMoreTokens()) {
                            String token = st.nextToken();
                            if (token.equals(UNIQUE_ID_STRING)) {
                                valid1 = true;
                            }
                            for (int i = 0; i < columnHeaders.size(); ++i) {
                                String headerValue = (String)columnHeaders.elementAt(i);
                                if (!token.equals(headerValue)) continue;
                                valid2 = false;
                                return 0;
                            }
                            columnHeaders.add(token);
                        }
                    } else {
                        dataLinesMap.add(lineCount);
                    }
                }
                ++lineCount;
            }
            if (dataLinesMap.size() > 0) {
                valid3 = true;
            }
        }
        catch (IOException ioe) {
            return 0;
        }
        if (valid1 && valid2 && valid3 && valid4) {
            return 1;
        }
        return 0;
    }

    public void loadFile(File targetFile) {
        this.dataLinesMap = new IntVector();
        this.rawLines = new Vector();
        this.columnHeaders = new Vector();
        String currentLine = new String();
        BufferedReader reader = null;
        boolean readHeaders = false;
        String s = null;
        try {
            MeVerizer mv = new MeVerizer(mHeaderLine, columnDefLine);
            mv.parseExtract(targetFile, true, replacement);
            s = mv.getFileString();
        }
        catch (ColumnMismatchException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            reader = new BufferedReader(new StringReader(s));
            int lineCount = 0;
            while ((currentLine = reader.readLine()) != null) {
                this.rawLines.add(currentLine);
                if (!currentLine.startsWith("#")) {
                    if (!readHeaders) {
                        readHeaders = true;
                        StringTokenizer st = new StringTokenizer(currentLine, "\t");
                        while (st.hasMoreTokens()) {
                            this.columnHeaders.add(st.nextToken());
                        }
                    } else {
                        this.dataLinesMap.add(lineCount);
                    }
                }
                ++lineCount;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.mevFileLoaded = false;
            return;
        }
        this.mevFileLoaded = true;
    }

    public boolean isMevFileLoaded() {
        return this.mevFileLoaded;
    }

    public Vector getColumnHeaders() {
        return this.columnHeaders;
    }

    public Vector getColumnAt(int targetColumn) {
        return this.getColumnAt(targetColumn, false);
    }

    public Vector getColumnAt(int targetColumn, boolean withHeaders) {
        Vector columnVector = new Vector(this.dataLinesMap.size() + (withHeaders ? 1 : 0));
        if (targetColumn >= this.columnHeaders.size() || targetColumn < 0) {
            throw new IndexOutOfBoundsException("Column Index out of bounds.");
        }
        if (withHeaders) {
            columnVector.add(this.columnHeaders.elementAt(targetColumn));
        }
        for (int i = 0; i < this.dataLinesMap.size(); ++i) {
            StringTokenizer st = new StringTokenizer(this.getElementAtIndex(i));
            for (int j = 0; j < targetColumn; ++j) {
                st.nextToken();
            }
            columnVector.add(st.nextToken());
        }
        return columnVector;
    }

    public Vector getColumnNamed(String columnName) throws FieldNotFoundException {
        return this.getColumnNamed(columnName, false);
    }

    public Vector getColumnNamed(String columnName, boolean withHeaders) throws FieldNotFoundException {
        Vector columnHeaders = this.getColumnHeaders();
        if (columnHeaders.contains(columnName)) {
            return this.getColumnAt(columnHeaders.indexOf(columnName), withHeaders);
        }
        throw new FieldNotFoundException("Field " + columnName + " not found.");
    }

    public String getLineAt(int rawTargetLine) {
        return (String)this.rawLines.elementAt(rawTargetLine);
    }

    public String getElementAtIndex(int index) {
        return this.getLineAt(this.dataLinesMap.intElementAt(index));
    }

    public String getElementAtRC(int row, int column) {
        return new String();
    }

    public String getElementById(String id) throws FieldNotFoundException {
        String element = null;
        try {
            element = this.getElementByField(UNIQUE_ID_STRING, id);
            return element;
        }
        catch (FieldNotFoundException fnfe) {
            throw new FieldNotFoundException("Unique Identifier field (UID) not found.");
        }
    }

    public String getElementByField(String fieldName, String value) throws FieldNotFoundException {
        Vector targetColumn = this.getColumnNamed(fieldName);
        if (targetColumn == null) {
            throw new FieldNotFoundException("Field " + fieldName + " not found.");
        }
        for (int i = 0; i < targetColumn.size(); ++i) {
            if (!((String)targetColumn.elementAt(i)).equals(value)) continue;
            return this.getElementAtIndex(i);
        }
        return null;
    }

    public Vector getElementsByField(String fieldName, String value) throws FieldNotFoundException {
        Vector targetColumn = this.getColumnNamed(fieldName);
        Vector<String> matchesVector = null;
        if (targetColumn == null) {
            throw new FieldNotFoundException("Field " + fieldName + " not found.");
        }
        for (int i = 0; i < targetColumn.size(); ++i) {
            if (!((String)targetColumn.elementAt(i)).equals(value)) continue;
            if (matchesVector == null) {
                matchesVector = new Vector<String>();
            }
            matchesVector.add(this.getElementAtIndex(i));
        }
        return matchesVector;
    }

    public String[][] getDataMatrix() {
        return this.getDataMatrix(false);
    }

    public String[][] getDataMatrix(boolean withHeaders) {
        int i;
        Vector columnHeaders = this.getColumnHeaders();
        int hc = withHeaders ? 1 : 0;
        String[][] matrix = new String[this.dataLinesMap.size() + hc][columnHeaders.size()];
        if (withHeaders) {
            for (i = 0; i < columnHeaders.size(); ++i) {
                matrix[0][i] = (String)columnHeaders.elementAt(i);
            }
        }
        for (i = hc; i < matrix.length; ++i) {
            String currentLine = this.getElementAtIndex(i - hc);
            StringTokenizer st = new StringTokenizer(currentLine, "\t");
            for (int j = 0; j < matrix[i].length; ++j) {
                matrix[i][j] = st.nextToken();
            }
        }
        return matrix;
    }

    private static class IntVector
    extends Vector {
        private IntVector() {
        }

        public void add(int element) {
            super.add(new Integer(element));
        }

        public int intElementAt(int index) {
            return (Integer)super.elementAt(index);
        }
    }
}

