/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.util;

import org.tigr.microarray.mev.cluster.gui.impl.util.IntComparator;

public class IntSorter {
    public static void sort(int[] a, IntComparator c) {
        int[] aux = IntSorter.cloneArray(a);
        IntSorter.mergeSort(aux, a, 0, a.length, c);
    }

    private static int[] cloneArray(int[] a) {
        int[] clone = new int[a.length];
        int i = a.length;
        while (--i >= 0) {
            clone[i] = a[i];
        }
        return clone;
    }

    private static void swap(int[] x, int a, int b) {
        int t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void mergeSort(int[] src, int[] dest, int low, int high, IntComparator c) {
        int length = high - low;
        if (length < 7) {
            for (int i = low; i < high; ++i) {
                for (int j = i; j > low && c.compare(dest[j - 1], dest[j]) > 0; --j) {
                    IntSorter.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int mid = (low + high) / 2;
        IntSorter.mergeSort(dest, src, low, mid, c);
        IntSorter.mergeSort(dest, src, mid, high, c);
        if (c.compare(src[mid - 1], src[mid]) <= 0) {
            System.arraycopy(src, low, dest, low, length);
            return;
        }
        int p = low;
        int q = mid;
        for (int i = low; i < high; ++i) {
            dest[i] = q >= high || p < mid && c.compare(src[p], src[q]) <= 0 ? src[p++] : src[q++];
        }
    }
}

