/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.usc;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.impl.usc.Reader;
import org.tigr.microarray.mev.cluster.gui.impl.usc.USCGUI;
import org.tigr.microarray.mev.cluster.gui.impl.usc.USCGene;
import org.tigr.microarray.mev.cluster.gui.impl.usc.USCHyb;
import org.tigr.microarray.mev.cluster.gui.impl.usc.USCHybSet;
import org.tigr.microarray.mev.r.ClassAssigner;

public class USCTrainFileLoader {
    private USCHybSet trainHybSet;
    private USCHybSet testHybSet;
    private double delta;
    private double rho;

    public USCTrainFileLoader(IData data, String[] hybLabels) {
        USCHyb hyb;
        String sHybName;
        int iIndex;
        int h;
        int[] sortedIndices = data.getSortedIndices(0);
        Vector<Integer> vInclude = new Vector<Integer>();
        Vector<Integer> vTest = new Vector<Integer>();
        for (int i = 0; i < hybLabels.length; ++i) {
            if (!hybLabels[i].equals(ClassAssigner.TEST_CLASS_STRING)) {
                vInclude.add(new Integer(i));
                continue;
            }
            vTest.add(new Integer(i));
        }
        int hybKount = vInclude.size();
        int testKount = vTest.size();
        USCHyb[] hybArray = new USCHyb[hybKount];
        USCHyb[] testArray = new USCHyb[testKount];
        double[][] ratios = USCGUI.castFloatToDoubleArray(this.transpose(data.getExperiment().getValues()));
        for (int i = 0; i < ratios.length; ++i) {
            for (int j = 0; j < ratios[i].length; ++j) {
                if (ratios[i][j] == Double.NaN) {
                    System.out.println("Nan");
                    continue;
                }
                if (ratios[i][j] != Double.NEGATIVE_INFINITY && ratios[i][j] != Double.POSITIVE_INFINITY) continue;
                System.out.println("Infinity");
            }
        }
        for (h = 0; h < hybKount; ++h) {
            Integer I = (Integer)vInclude.elementAt(h);
            iIndex = I;
            sHybName = data.getFullSampleName(iIndex);
            hybArray[h] = hyb = new USCHyb(h, hybLabels[iIndex], sHybName, ratios[iIndex]);
        }
        for (h = 0; h < testKount; ++h) {
            Integer I = (Integer)vTest.elementAt(h);
            iIndex = I;
            sHybName = data.getFullSampleName(iIndex);
            testArray[h] = hyb = new USCHyb(h, ClassAssigner.TEST_CLASS_STRING, sHybName, ratios[iIndex]);
        }
        this.trainHybSet = new USCHybSet(hybArray, this.createGeneList(data));
        this.testHybSet = new USCHybSet(testArray, this.createGeneList(data));
    }

    public USCTrainFileLoader(IData data) {
        int[] sortedIndices = data.getSortedIndices(0);
        int testKount = data.getFeaturesCount();
        USCHyb[] testArray = new USCHyb[testKount];
        float[][] tempRatios = data.getExperiment().getValues();
        double[][] ratios = USCGUI.castFloatToDoubleArray(this.transpose(tempRatios));
        for (int h = 0; h < ratios.length; ++h) {
            testArray[h] = new USCHyb(h, ClassAssigner.TEST_CLASS_STRING, data.getFullSampleName(h), ratios[h]);
        }
        this.testHybSet = new USCHybSet(testArray, this.createGeneList(data));
    }

    public USCTrainFileLoader(File f) throws IOException {
        int hybKount = 0;
        int geneKount = 0;
        String[] geneNames = null;
        String[] geneIndex = null;
        USCHyb[] hybs = null;
        Reader r = new Reader();
        r.readFile(f);
        Vector v = r.getVNullLine("MOTHRA");
        for (int i = 0; i < v.size(); ++i) {
            String s;
            int j;
            String line = (String)v.elementAt(i);
            StringTokenizer st = new StringTokenizer(line, "\t");
            int tokenKount = st.countTokens();
            if (i == 0) {
                hybKount = tokenKount - 2;
                hybs = new USCHyb[hybKount];
                geneKount = v.size() - 2;
                geneNames = new String[geneKount];
                geneIndex = new String[geneKount];
                for (j = 0; j < tokenKount; ++j) {
                    USCHyb hyb;
                    String hybName = st.nextToken();
                    if (j == 0) {
                        this.delta = this.parseDR(hybName);
                        continue;
                    }
                    if (j == 1) continue;
                    hybs[j - 2] = hyb = new USCHyb(j - 1, hybName, geneKount);
                }
                continue;
            }
            if (i == 1) {
                for (j = 0; j < tokenKount; ++j) {
                    s = st.nextToken();
                    if (j == 0) {
                        this.rho = this.parseDR(s);
                        continue;
                    }
                    if (j == 1) continue;
                    hybs[j - 2].setHybLabel(s);
                }
                continue;
            }
            for (j = 0; j < tokenKount; ++j) {
                s = st.nextToken();
                if (j == 0) {
                    geneNames[i - 2] = s;
                    continue;
                }
                if (j == 1) {
                    geneIndex[i - 2] = s;
                    continue;
                }
                Float FRatio = new Float(s);
                if (FRatio.isNaN()) {
                    hybs[j - 2].setRatio(i - 2, 0.0);
                    continue;
                }
                hybs[j - 2].setRatio(i - 2, FRatio.doubleValue());
            }
        }
        USCGene[] genes = new USCGene[geneNames.length];
        for (int i = 0; i < geneNames.length; ++i) {
            genes[i] = new USCGene((String)geneNames[i], null);
        }
        int[] geneIndices = this.intifyStringArray(geneIndex);
        this.trainHybSet = new USCHybSet(hybs, genes);
    }

    private USCGene[] createGeneList(IData data) {
        int numGenes = data.getFeaturesSize();
        USCGene[] genes = new USCGene[numGenes];
        for (int i = 0; i < numGenes; ++i) {
            USCGene gene;
            String geneName = data.getGeneName(i);
            String[] extraFields = data.getSlideDataElement(0, i).getExtraFields();
            genes[i] = gene = new USCGene(geneName, extraFields);
        }
        return genes;
    }

    private float[][] condenseRatios(float[][] ratios, int[] geneIndex) {
        float[][] toReturn = new float[geneIndex.length][ratios.length];
        for (int i = 0; i < geneIndex.length; ++i) {
            toReturn[i] = ratios[geneIndex[i]];
        }
        return toReturn;
    }

    private int[] intifyStringArray(String[] sInts) {
        int[] toReturn = new int[sInts.length];
        for (int i = 0; i < sInts.length; ++i) {
            toReturn[i] = new Integer(sInts[i]);
        }
        return toReturn;
    }

    private double parseDR(String sDR) {
        int iEqual = sDR.indexOf("=");
        Float F = new Float(sDR.substring(iEqual + 1));
        return F.doubleValue();
    }

    public USCTrainFileLoader(double[][] m) {
    }

    private float[][] transpose(float[][] m) {
        float[][] toReturn = new float[m[0].length][m.length];
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m[0].length; ++j) {
                toReturn[j][i] = m[i][j];
            }
        }
        return toReturn;
    }

    public static void main(String[] args) {
        double[][] m = new double[3][2];
        m[0][0] = 0.0;
        m[1][0] = 1.0;
        m[2][0] = 2.0;
        m[0][1] = 3.0;
        m[1][1] = 4.0;
        m[2][1] = 5.0;
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m[0].length; ++j) {
                System.out.println(i + "," + j + " = " + m[i][j]);
            }
        }
        USCTrainFileLoader loader = new USCTrainFileLoader(m);
    }

    public USCHybSet getTrainHybSet() {
        return this.trainHybSet;
    }

    public USCHybSet getTestHybSet() {
        return this.testHybSet;
    }

    public double getDelta() {
        return this.delta;
    }

    public double getRho() {
        return this.rho;
    }
}

