/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.usc;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.impl.usc.USCGene;
import org.tigr.microarray.mev.cluster.gui.impl.usc.USCResult;
import org.tigr.microarray.mev.cluster.gui.impl.usc.USCTextFileFilter;

public class USCSummaryViewer
extends JPanel
implements IViewer,
ActionListener {
    private JButton saveGeneList;
    private JButton anotherDeltaRho;
    private USCGene[] genes;
    private USCResult result;
    transient IFramework framework;
    private String[] hybNames;
    private String[] uniqueClasses;
    private String[] params;

    public USCSummaryViewer(String[] hybNames, USCResult resultP, String[] uniqueClasses, String[] params, USCGene[] genesP, IFramework frameworkP) {
        this(hybNames, resultP, uniqueClasses, params, genesP);
        this.framework = frameworkP;
    }

    public USCSummaryViewer(String[] hybNames, USCResult resultP, String[] uniqueClasses, String[] params, USCGene[] genesP) {
        this.hybNames = hybNames;
        this.uniqueClasses = uniqueClasses;
        this.params = params;
        this.result = resultP;
        this.genes = genesP;
        this.setLayout(new GridBagLayout());
        GridBagConstraints c1 = new GridBagConstraints();
        c1.fill = 2;
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new GridBagLayout());
        GridBagConstraints c2 = new GridBagConstraints();
        c2.fill = 2;
        c2.gridx = 0;
        c2.gridy = 0;
        leftPanel.add((Component)this.createParamPanel(this.result.getDelta(), this.result.getRho(), params, this.result.getNumGenesUsed()), c2);
        c2.gridx = 0;
        c2.gridy = 1;
        leftPanel.add((Component)this.createAssPanel(hybNames, this.result, uniqueClasses), c2);
        c1.gridx = 0;
        c1.gridy = 0;
        this.add((Component)leftPanel, c1);
        JPanel rightPanel = new JPanel();
        rightPanel.add(this.createGenePanel(this.genes));
        c1.gridx = 1;
        c1.gridy = 0;
        this.add((Component)rightPanel, c1);
    }

    private JPanel createParamPanel(double delta, double rho, String[] params, int numGenesUsed) {
        Border loweredBorder = BorderFactory.createLoweredBevelBorder();
        JPanel toReturn = new JPanel();
        Dimension d = new Dimension(410, 130);
        toReturn.setPreferredSize(d);
        toReturn.setMaximumSize(d);
        toReturn.setMinimumSize(d);
        Font font = new Font("Arial", 0, 12);
        toReturn.setBorder(BorderFactory.createTitledBorder(loweredBorder, "Parameters Used", 1, 0, font, Color.GRAY));
        BoxLayout bl = new BoxLayout(toReturn, 1);
        toReturn.setLayout(bl);
        String sDelta = new Float(delta).toString();
        String sRho = new Float(rho).toString();
        JLabel dLabel = new JLabel(new String("  Delta = " + sDelta + "  "));
        JLabel rLabel = new JLabel(new String("  Rho = " + sRho + "  "));
        JLabel binLabel = new JLabel("  # of Bins = " + params[0] + "  ");
        JLabel loLabel = new JLabel("  Correlation Low = " + params[1] + "  ");
        JLabel hiLabel = new JLabel("  Correlation High = " + params[2] + "  ");
        JLabel stepLabel = new JLabel("  Correlation Step = " + params[3] + "  ");
        toReturn.add(dLabel);
        toReturn.add(rLabel);
        toReturn.add(binLabel);
        toReturn.add(loLabel);
        toReturn.add(hiLabel);
        toReturn.add(stepLabel);
        return toReturn;
    }

    private JPanel createAssPanel(String[] testHybNames, USCResult resultP, String[] uniqueClasses) {
        Border loweredBorder = BorderFactory.createLoweredBevelBorder();
        StringBuffer sbAss = new StringBuffer();
        StringBuffer sbDScore = new StringBuffer();
        for (int h = 0; h < testHybNames.length; ++h) {
            int iClass = resultP.getAssignedClassIndex(h);
            String sAss = new String("  " + testHybNames[h] + " >>> " + uniqueClasses[iClass] + "  ");
            String dScore = Double.toString(resultP.getDiscScores()[h][iClass]);
            sbAss.append(this.formatLine(sAss, dScore));
            sbAss.append("\r\n");
        }
        JPanel toReturn = new JPanel();
        JTextArea assArea = new JTextArea(testHybNames.length, 15);
        assArea.setBackground(toReturn.getBackground());
        assArea.setText(sbAss.toString());
        JScrollPane jspAss = new JScrollPane(assArea);
        Dimension d = new Dimension(410, 385);
        jspAss.setPreferredSize(d);
        jspAss.setMaximumSize(d);
        jspAss.setMinimumSize(d);
        toReturn.setSize(410, 365);
        toReturn.add(jspAss);
        return toReturn;
    }

    private JPanel createGenePanel(USCGene[] genesP) {
        Border loweredBorder = BorderFactory.createLoweredBevelBorder();
        String genesUsed = new String(genesP.length + " Genes Used");
        JPanel toReturn = new JPanel();
        Font font = new Font("Arial", 0, 12);
        toReturn.setBorder(BorderFactory.createTitledBorder(loweredBorder, genesUsed, 1, 0, font, Color.GRAY));
        Dimension d = new Dimension(210, 525);
        toReturn.setPreferredSize(d);
        toReturn.setMaximumSize(d);
        toReturn.setMinimumSize(d);
        StringBuffer sbGenes = new StringBuffer();
        for (int i = 0; i < genesP.length; ++i) {
            sbGenes.append(genesP[i].getGeneName());
            sbGenes.append("\r\n");
        }
        JTextArea geneArea = new JTextArea(genesP.length, 15);
        geneArea.setBackground(toReturn.getBackground());
        geneArea.setText(sbGenes.toString());
        JScrollPane jsp = new JScrollPane(geneArea);
        jsp.setPreferredSize(new Dimension(190, 430));
        jsp.setHorizontalScrollBarPolicy(30);
        jsp.setVerticalScrollBarPolicy(20);
        toReturn.add(jsp);
        this.saveGeneList = new JButton("Save GeneList");
        Dimension dButton = new Dimension(200, 30);
        this.saveGeneList.setPreferredSize(dButton);
        this.saveGeneList.setMaximumSize(dButton);
        this.saveGeneList.setMinimumSize(dButton);
        this.saveGeneList.addActionListener(this);
        toReturn.add(this.saveGeneList);
        return toReturn;
    }

    private void onAnotherDeltaRho() {
        System.out.println("onAnotherDeltaRho()");
    }

    private void onSaveGeneList() {
        String currentPath = TMEV.getDataPath();
        USCTextFileFilter textFilter = new USCTextFileFilter();
        JFileChooser chooser = new JFileChooser(currentPath);
        chooser.addChoosableFileFilter(textFilter);
        if (chooser.showSaveDialog(this) == 0) {
            File saveFile;
            if (chooser.getFileFilter() == textFilter) {
                String path = chooser.getSelectedFile().getPath();
                if (path.toLowerCase().endsWith("txt")) {
                    saveFile = new File(path);
                } else {
                    String subPath;
                    int period = path.lastIndexOf(".");
                    if (period != -1) {
                        System.out.println("period  = -1");
                        subPath = path.substring(0, period);
                    } else {
                        subPath = path;
                    }
                    String newPath = subPath + ".txt";
                    saveFile = new File(newPath);
                }
            } else {
                saveFile = chooser.getSelectedFile();
            }
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.genes.length; ++i) {
                USCGene gene = this.genes[i];
                sb.append(gene.getGeneName());
                for (int e = 0; e < gene.getExtraFieldSize(); ++e) {
                    sb.append("\t");
                    sb.append(gene.getExtraField(e));
                }
                sb.append("\r\n");
            }
            this.writeFile(saveFile, sb.toString());
        } else {
            System.out.println("User cancelled Gene List Save");
        }
    }

    private void writeFile(File f, String s) {
        try {
            FileWriter fw = new FileWriter(f);
            fw.write(s);
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.saveGeneList) {
            this.onSaveGeneList();
        } else if (e.getSource() == this.anotherDeltaRho) {
            this.onAnotherDeltaRho();
        }
    }

    private String formatLine(String assLine, String dScore) {
        int width = 70;
        int assKount = assLine.length();
        int dKount = dScore.length();
        int diff = width - assKount - dKount;
        StringBuffer sb = new StringBuffer(assLine);
        for (int i = 0; i < diff; ++i) {
            sb.append("-");
        }
        sb.append(dScore);
        return sb.toString();
    }

    public JComponent getContentComponent() {
        return this;
    }

    public JComponent getHeaderComponent() {
        return null;
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    public void onSelected(IFramework framework) {
        this.framework = framework;
    }

    public void onDataChanged(IData data) {
    }

    public void onMenuChanged(IDisplayMenu menu) {
    }

    public void onDeselected() {
    }

    public void onClosed() {
    }

    public BufferedImage getImage() {
        return null;
    }

    public int[][] getClusters() {
        return null;
    }

    public Experiment getExperiment() {
        return null;
    }

    public int getViewerType() {
        return 0;
    }

    public void setExperiment(Experiment e) {
    }

    public int getExperimentID() {
        return 0;
    }

    public void setExperimentID(int id) {
    }

    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.hybNames, this.result, this.uniqueClasses, this.params, this.genes});
    }
}

