/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.usc;

import java.io.Serializable;
import org.tigr.microarray.mev.cluster.gui.impl.usc.USCOrder;

public class USCResult
implements Serializable {
    private int iDeltaBin;
    private int iRhoBin;
    private double delta;
    private double rho;
    private double[][] discScores;
    private int numGenesUsed;
    private USCOrder[] order;

    public USCResult(double[][] discScores, int numGenes, double delta, double rho, USCOrder[] order) {
        this.discScores = discScores;
        this.numGenesUsed = numGenes;
        this.delta = delta;
        this.rho = rho;
        this.order = order;
    }

    public USCResult() {
    }

    public USCOrder[] getOrder() {
        return this.order;
    }

    public void setDiscScores(double[][] discScores) {
        this.discScores = discScores;
    }

    public double[][] getDiscScores() {
        return this.discScores;
    }

    public int getAssignedClassIndex(int hybIndex) {
        double fMin = 9.9999999E7;
        int iMin = 0;
        for (int i = 0; i < this.discScores[hybIndex].length; ++i) {
            if (!(this.discScores[hybIndex][i] < fMin)) continue;
            fMin = this.discScores[hybIndex][i];
            iMin = i;
        }
        return iMin;
    }

    public int getNumGenesUsed() {
        return this.numGenesUsed;
    }

    public double getDelta() {
        return this.delta;
    }

    public double getRho() {
        return this.rho;
    }

    public int getIDeltaBin() {
        return this.iDeltaBin;
    }

    public void setIDeltaBin(int deltaBin) {
        this.iDeltaBin = deltaBin;
    }

    public int getIRhoBin() {
        return this.iRhoBin;
    }

    public void setIRhoBin(int rhoBin) {
        this.iRhoBin = rhoBin;
    }

    public void setDelta(double delta) {
        this.delta = delta;
    }

    public void setNumGenesUsed(int numGenesUsed) {
        this.numGenesUsed = numGenesUsed;
    }

    public void setRho(double rho) {
        this.rho = rho;
    }

    public void setOrder(USCOrder[] u) {
        this.order = u;
    }
}

