/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.usc;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.microarray.mev.cluster.gui.impl.usc.SpringUtilities;

public class USCInitDialog
extends AlgorithmDialog {
    static int TRAIN_THEN_CLASSIFY = 0;
    static int CLASSIFY_FROM_FILE = 1;
    private int result;
    private JButton hideAdvance;
    private JButton showAdvance;
    private JRadioButton trainPlusClassify;
    private JRadioButton classifyFromFile;
    private JRadioButton cv;
    private JRadioButton loocv;
    private JSpinner fold;
    private JSpinner delta;
    private JSpinner numBins;
    private JTextField corrLo;
    private JTextField corrHi;
    private JTextField corrStep;
    private JSpinner numClass;
    private Dimension dSpin;
    private Dimension dLabel;
    private Dimension dField;
    private Vector vClassField;
    private Vector vLabel;
    private Hashtable htField;
    private Hashtable htLabel;
    private JPanel centerPanel;
    private JPanel requiredPanel;
    private JPanel numClassPanel;
    private JPanel classFieldPanel;
    private JPanel classLabelPanel;
    private JPanel advPanel;
    private JPanel defaultPanel;
    private JPanel borderPanel;
    private JPanel buttonPanel;

    public USCInitDialog(Frame parent) {
        super(new JFrame(), "USC:Uncorrelated Shrunken Centroid Classification", true);
        this.setResizable(true);
        this.setSize(550, 450);
        Dimension dButton = new Dimension(140, 20);
        Dimension dField = new Dimension(20, 20);
        Dimension dSpin = new Dimension(100, 20);
        AdvListener al = new AdvListener();
        this.trainPlusClassify = new JRadioButton("Train then Classify");
        this.trainPlusClassify.setSelected(true);
        this.classifyFromFile = new JRadioButton("Classify from file");
        this.classifyFromFile.setSelected(false);
        ButtonGroup selectionGroup = new ButtonGroup();
        selectionGroup.add(this.trainPlusClassify);
        selectionGroup.add(this.classifyFromFile);
        JPanel radioPanel = new JPanel();
        radioPanel.add(this.trainPlusClassify);
        radioPanel.add(this.classifyFromFile);
        radioPanel.setBorder(BorderFactory.createTitledBorder("Analysis Mode"));
        SpinnerNumberModel classModel = new SpinnerNumberModel(2, 1, 100, 1);
        this.numClass = new JSpinner(classModel);
        this.numClass.setMaximumSize(dSpin);
        this.numClass.addChangeListener(new SpinListener());
        JLabel classLabel = new JLabel("# of Classes");
        classLabel.setLabelFor(this.numClass);
        this.numClassPanel = new JPanel();
        this.numClassPanel.setLayout(new SpringLayout());
        this.numClassPanel.setSize(new Dimension(300, 300));
        this.numClassPanel.add(classLabel);
        this.numClassPanel.add(this.numClass);
        SpringUtilities.makeCompactGrid(this.numClassPanel, 2, 1, 0, 0, 0, 0);
        this.classLabelPanel = new JPanel();
        BoxLayout labelBoxLayout = new BoxLayout(this.classLabelPanel, 1);
        this.classLabelPanel.setLayout(labelBoxLayout);
        this.classFieldPanel = new JPanel();
        BoxLayout fieldBoxLayout = new BoxLayout(this.classFieldPanel, 1);
        this.classFieldPanel.setLayout(fieldBoxLayout);
        this.vLabel = new Vector();
        this.vClassField = new Vector();
        this.initClassFields(2);
        this.requiredPanel = new JPanel(new SpringLayout());
        this.requiredPanel.add(this.numClassPanel);
        this.requiredPanel.add(this.classLabelPanel);
        this.requiredPanel.add(this.classFieldPanel);
        SpringUtilities.makeCompactGrid(this.requiredPanel, 1, 3, 20, 0, 20, 0);
        this.centerPanel = new JPanel(new SpringLayout());
        this.centerPanel.setBackground(Color.BLACK);
        this.centerPanel.add(radioPanel);
        this.centerPanel.add(this.requiredPanel);
        SpringUtilities.makeCompactGrid(this.centerPanel, 2, 1, 0, 0, 0, 0);
        this.showAdvance = new JButton("Advanced Options");
        this.showAdvance.setMaximumSize(dButton);
        this.showAdvance.addActionListener(al);
        this.defaultPanel = new JPanel();
        this.defaultPanel.add(this.showAdvance);
        this.hideAdvance = new JButton("Hide Advanced");
        this.hideAdvance.setMaximumSize(dButton);
        this.hideAdvance.addActionListener(al);
        this.buttonPanel = new JPanel();
        this.buttonPanel.add(this.hideAdvance);
        this.cv = new JRadioButton("Standard");
        this.cv.setSelected(true);
        this.loocv = new JRadioButton("LOOCV");
        this.loocv.setSelected(false);
        ButtonGroup xValidationGroup = new ButtonGroup();
        xValidationGroup.add(this.cv);
        xValidationGroup.add(this.loocv);
        JPanel paramSub = new JPanel();
        paramSub.setBorder(BorderFactory.createTitledBorder("X Validation Algorithm"));
        paramSub.setLayout(new BoxLayout(paramSub, 1));
        paramSub.add(this.cv);
        paramSub.add(this.loocv);
        SpinnerNumberModel foldModel = new SpinnerNumberModel(5, 1, 50, 1);
        SpinnerNumberModel binModel = new SpinnerNumberModel(50, 1, 200, 1);
        SpinnerNumberModel deltaModel = new SpinnerNumberModel(20, 1, 200, 1);
        this.fold = new JSpinner(foldModel);
        this.fold.setMaximumSize(dSpin);
        this.numBins = new JSpinner(binModel);
        this.numBins.setMaximumSize(dSpin);
        this.delta = new JSpinner(deltaModel);
        this.delta.setMaximumSize(dSpin);
        this.corrLo = new JTextField("0");
        this.corrLo.setMaximumSize(dSpin);
        this.corrHi = new JTextField("1.0");
        this.corrHi.setMaximumSize(dSpin);
        this.corrStep = new JTextField("0.1");
        this.corrStep.setMaximumSize(dSpin);
        JLabel foldLabel = new JLabel("Numbaaaaer of Folds");
        JLabel binLabel = new JLabel("# of Bins");
        JLabel deltaLabel = new JLabel("Delta High");
        JLabel corrLoLabel = new JLabel("Corr Low");
        JLabel corrHiLabel = new JLabel("Corr High");
        JLabel corrStepLabel = new JLabel("Corr Step");
        foldLabel.setLabelFor(this.fold);
        corrLoLabel.setLabelFor(this.corrLo);
        corrHiLabel.setLabelFor(this.corrHi);
        corrStepLabel.setLabelFor(this.corrStep);
        JPanel fieldPanel = new JPanel();
        fieldPanel.setLayout(new SpringLayout());
        fieldPanel.setBorder(BorderFactory.createTitledBorder("Validation Parameters"));
        fieldPanel.add(foldLabel);
        fieldPanel.add(this.fold);
        fieldPanel.add(binLabel);
        fieldPanel.add(this.numBins);
        fieldPanel.add(deltaLabel);
        fieldPanel.add(this.delta);
        fieldPanel.add(corrLoLabel);
        fieldPanel.add(this.corrLo);
        fieldPanel.add(corrHiLabel);
        fieldPanel.add(this.corrHi);
        fieldPanel.add(corrStepLabel);
        fieldPanel.add(this.corrStep);
        SpringUtilities.makeCompactGrid(fieldPanel, 6, 2, 0, 0, 5, 0);
        this.advPanel = new JPanel();
        this.advPanel.setLayout(new SpringLayout());
        this.advPanel.add(this.hideAdvance);
        this.advPanel.add(paramSub);
        this.advPanel.add(fieldPanel);
        SpringUtilities.makeCompactGrid(this.advPanel, 3, 1, 155, 0, 155, 0);
        Listener listener = new Listener();
        super.addWindowListener(listener);
        super.setActionListeners(listener);
        this.borderPanel = new JPanel();
        this.borderPanel.setLayout(new SpringLayout());
        this.borderPanel.add(this.centerPanel);
        this.borderPanel.add(this.defaultPanel);
        SpringUtilities.makeCompactGrid(this.borderPanel, 2, 1, 0, 0, 0, 0);
        this.addContent(this.borderPanel);
    }

    private void classList() {
        SpinnerNumberModel model = (SpinnerNumberModel)this.numClass.getModel();
        int i = model.getNumber().intValue();
        if (i < this.vClassField.size()) {
            this.removeClassFields(this.vClassField.size() - i);
        } else if (i > this.vClassField.size()) {
            this.addClassFields(i - this.vClassField.size());
        }
    }

    private void initClassFields(int numToAdd) {
        int iField = this.vClassField.size();
        for (int i = 0; i < numToAdd; ++i) {
            JLabel label = new JLabel("Class " + (iField + 1 + i) + " Label:");
            label.setMaximumSize(this.dField);
            label.setMinimumSize(this.dField);
            label.setPreferredSize(this.dField);
            JTextField field = new JTextField("");
            field.setMaximumSize(this.dField);
            field.setMinimumSize(this.dField);
            field.setPreferredSize(this.dField);
            label.setLabelFor(field);
            this.classFieldPanel.add(field);
            this.vClassField.add(field);
        }
        this.getRootPane().revalidate();
    }

    private void addClassFields(int numToAdd) {
        int iField = this.vClassField.size();
        for (int i = 0; i < numToAdd; ++i) {
            JLabel label = new JLabel("Class " + (iField + 1 + i) + " Label:");
            label.setMaximumSize(this.dField);
            label.setMinimumSize(this.dField);
            label.setPreferredSize(this.dField);
            JTextField field = new JTextField("");
            field.setMaximumSize(this.dField);
            field.setMinimumSize(this.dField);
            field.setPreferredSize(this.dField);
            label.setLabelFor(field);
            this.classFieldPanel.add(field);
            this.vClassField.add(field);
        }
        this.requiredPanel.repaint();
        this.getRootPane().revalidate();
    }

    private void removeClassFields(int numToRemove) {
        System.out.println("removeClassFields() called");
        for (int i = 0; i < numToRemove; ++i) {
            int iField = this.vClassField.size() - (i + 1);
            JTextField field = (JTextField)this.vClassField.elementAt(iField);
            this.classFieldPanel.remove(field);
            this.vClassField.remove(iField);
        }
        this.requiredPanel.repaint();
        this.getRootPane().revalidate();
    }

    private void onShowAdvanced() {
        this.borderPanel.remove(this.defaultPanel);
        this.borderPanel.add(this.advPanel);
        this.getRootPane().revalidate();
        this.pack();
    }

    private void onHideAdvanced() {
        this.getFold();
        this.borderPanel.remove(this.advPanel);
        this.borderPanel.add(this.defaultPanel);
        this.getRootPane().revalidate();
        this.pack();
    }

    public int getSelectedAction() {
        if (this.trainPlusClassify.isSelected()) {
            return TRAIN_THEN_CLASSIFY;
        }
        return CLASSIFY_FROM_FILE;
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public void error(String message) {
        JOptionPane.showMessageDialog(this, message, "Input Error", 0);
    }

    public static void main(String[] args) {
        System.out.println("invoked by main");
        USCInitDialog uid = new USCInitDialog(new JFrame("Test"));
        uid.showModal();
    }

    public int getNumClasses() {
        SpinnerNumberModel model = (SpinnerNumberModel)this.numClass.getModel();
        Number N = model.getNumber();
        return N.intValue();
    }

    public double getCorrLo() {
        String sCorr = this.corrLo.getText();
        Double DCorr = new Double(sCorr);
        return DCorr;
    }

    public double getCorrHi() {
        String sCorr = this.corrHi.getText();
        Double DCorr = new Double(sCorr);
        return DCorr;
    }

    public double getCorrStep() {
        String sCorr = this.corrStep.getText();
        Double DCorr = new Double(sCorr);
        return DCorr;
    }

    public int getFold() {
        SpinnerNumberModel model = (SpinnerNumberModel)this.fold.getModel();
        Number N = model.getNumber();
        return N.intValue();
    }

    public int getNumBins() {
        SpinnerNumberModel model = (SpinnerNumberModel)this.numBins.getModel();
        Number N = model.getNumber();
        return N.intValue();
    }

    public int getDeltaHi() {
        SpinnerNumberModel model = (SpinnerNumberModel)this.delta.getModel();
        Number N = model.getNumber();
        return N.intValue();
    }

    public boolean doLoocv() {
        return this.loocv.isSelected();
    }

    private class Listener
    extends DialogListener
    implements ItemListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("ok-command")) {
                USCInitDialog.this.result = 0;
                USCInitDialog.this.dispose();
            } else if (command.equals("cancel-command")) {
                USCInitDialog.this.result = 2;
                USCInitDialog.this.dispose();
            } else {
                if (command.equals("reset-command")) {
                    USCInitDialog.this.result = 2;
                    return;
                }
                if (command.equals("info-command")) {
                    HelpWindow.launchBrowser(USCInitDialog.this, "USC Initialization Dialog");
                }
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            USCInitDialog.this.result = -1;
            USCInitDialog.this.dispose();
        }
    }

    private class SpinListener
    implements ChangeListener {
        private SpinListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            USCInitDialog.this.classList();
        }
    }

    private class AdvListener
    implements ActionListener {
        private AdvListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            System.out.println(source.toString());
            if (source == USCInitDialog.this.showAdvance) {
                USCInitDialog.this.onShowAdvanced();
            } else if (source == USCInitDialog.this.hideAdvance) {
                USCInitDialog.this.onHideAdvanced();
            }
        }
    }
}

