/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.usc;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;
import org.tigr.microarray.mev.cluster.gui.impl.usc.USCGene;
import org.tigr.microarray.mev.cluster.gui.impl.usc.USCHyb;
import org.tigr.microarray.mev.cluster.gui.impl.usc.USCTrainFileLoader;

public class USCHybSet {
    private int hybKount;
    private int numClasses;
    private int foldKount;
    private int hybPerFold;
    private int hybRemain;
    private int[] iPermuted;
    private float s0;
    private float[] sis;
    private float[] geneCentroids;
    private float[][] classCentroids;
    private float[] classMks;
    private String[] uniqueClasses;
    private USCHyb[] hybs;
    private USCHyb[][] testArray;
    private USCHyb[][] trainArray;
    private USCGene[] genes;

    public USCHybSet(USCHyb[] hybArray, USCGene[] geneListP) {
        this.hybs = hybArray;
        this.hybKount = hybArray.length;
        this.genes = geneListP;
        this.uniqueClasses = this.findUniqueClasses(this);
        this.numClasses = this.uniqueClasses.length;
        this.assignClassIndices();
        this.iPermuted = this.randomize(this.hybKount);
    }

    private void assignClassIndices() {
        block0: for (int h = 0; h < this.hybs.length; ++h) {
            String sLabel = this.hybs[h].getHybLabel();
            for (int c = 0; c < this.uniqueClasses.length; ++c) {
                if (!sLabel.equals(this.uniqueClasses[c])) continue;
                this.hybs[h].setUniqueLabelIndex(c);
                continue block0;
            }
        }
    }

    public void permute(int foldKountP) {
        this.foldKount = foldKountP;
        this.hybPerFold = this.hybKount / this.foldKount;
        this.hybRemain = this.hybKount % this.foldKount;
        this.createTestArrays();
    }

    private void createTestArrays() {
        this.testArray = new USCHyb[this.foldKount][];
        this.trainArray = new USCHyb[this.foldKount][];
        if (this.foldKount == 1) {
            this.testArray[0] = new USCHyb[0];
            this.trainArray[0] = this.hybs;
        } else {
            for (int i = 0; i < this.foldKount; ++i) {
                int iStart = i * this.hybPerFold;
                if (i == this.foldKount - 1) {
                    this.testArray[i] = new USCHyb[this.hybPerFold + this.hybRemain];
                    this.trainArray[i] = new USCHyb[this.hybKount - (this.hybPerFold + this.hybRemain)];
                } else {
                    this.testArray[i] = new USCHyb[this.hybPerFold];
                    this.trainArray[i] = new USCHyb[this.hybKount - this.hybPerFold];
                }
                for (int j = 0; j < this.testArray[i].length; ++j) {
                    this.testArray[i][j] = this.getHyb(this.iPermuted[iStart + j]);
                }
                int index = 0;
                for (int j = 0; j < this.hybKount; ++j) {
                    boolean add = true;
                    for (int k = 0; k < this.testArray[i].length; ++k) {
                        if (this.getHyb(j).getIndexInFullSet() != this.testArray[i][k].getIndexInFullSet()) continue;
                        add = false;
                        break;
                    }
                    if (!add) continue;
                    this.trainArray[i][index] = this.getHyb(j);
                    ++index;
                }
            }
        }
    }

    public int[] randomize(int hybKount) {
        Vector<Integer> vIndices = new Vector<Integer>();
        int[] toReturn = new int[hybKount];
        Random r = new Random();
        for (int i = 0; i < toReturn.length; ++i) {
            int iTry = -1;
            while (!this.isNew(iTry, vIndices)) {
                iTry = r.nextInt(hybKount);
            }
            vIndices.add(new Integer(iTry));
            toReturn[i] = iTry;
        }
        return toReturn;
    }

    private boolean isNew(int iTry, Vector v) {
        if (iTry == -1) {
            return false;
        }
        boolean toReturn = true;
        for (int i = 0; i < v.size(); ++i) {
            Integer I = (Integer)v.elementAt(i);
            if (iTry != I) continue;
            toReturn = false;
            break;
        }
        return toReturn;
    }

    private String[] findUniqueClasses(USCHybSet hybSet) {
        int i;
        Vector<String> vUniqueLabel = new Vector<String>();
        for (i = 0; i < hybSet.getHybs().length; ++i) {
            String sLabel = hybSet.getHyb(i).getHybLabel();
            boolean labelFound = false;
            for (int j = 0; j < vUniqueLabel.size(); ++j) {
                String jLabel = (String)vUniqueLabel.elementAt(j);
                if (!sLabel.equals(jLabel)) continue;
                labelFound = true;
                break;
            }
            if (labelFound) continue;
            vUniqueLabel.add(sLabel);
        }
        String[] toReturn = new String[vUniqueLabel.size()];
        for (i = 0; i < vUniqueLabel.size(); ++i) {
            toReturn[i] = (String)vUniqueLabel.elementAt(i);
        }
        return toReturn;
    }

    public int getHybKount() {
        return this.hybKount;
    }

    public USCHyb[] getHybs() {
        return this.hybs;
    }

    public USCHyb getHyb(int index) {
        return this.hybs[index];
    }

    public USCGene[] getGenes() {
        return this.genes;
    }

    public USCGene getGene(int iGene) {
        return this.genes[iGene];
    }

    public int getNumClasses() {
        return this.numClasses;
    }

    public int getNumGenes() {
        return this.getHyb(0).getNumGenes();
    }

    public void setS0(float s0P) {
        this.s0 = s0P;
    }

    public float getS0() {
        return this.s0;
    }

    public void setSis(float[] sisP) {
        this.sis = sisP;
    }

    public void setSi(float siP, int geneIndex) {
        this.sis[geneIndex] = siP;
    }

    public float getSi(int geneIndex) {
        return this.sis[geneIndex];
    }

    public float[] getSis() {
        return this.sis;
    }

    public void setGeneCentroids(float[] geneCentroidsP) {
        this.geneCentroids = geneCentroidsP;
    }

    public void setGeneCentroid(float geneCentroid, int geneIndex) {
        this.geneCentroids[geneIndex] = geneCentroid;
    }

    public float getGeneCentroid(int geneIndex) {
        return this.geneCentroids[geneIndex];
    }

    public float[] getGeneCentroids() {
        return this.geneCentroids;
    }

    public void setClassCentroids(float[] classCentroidsP, int geneIndex) {
        this.classCentroids[geneIndex] = classCentroidsP;
    }

    public float[][] getClassCentroids() {
        return this.classCentroids;
    }

    public float getClassCentroid(int classIndex, int geneIndex) {
        return this.classCentroids[geneIndex][classIndex];
    }

    public void setClassMks(float[] classMksP) {
        this.classMks = classMksP;
    }

    public float[] getClassMks() {
        return this.classMks;
    }

    public float getClassMk(int classIndex) {
        return this.classMks[classIndex];
    }

    public String[] getUniqueClasses() {
        return this.uniqueClasses;
    }

    public String getUniqueClass(int classIndex) {
        return this.uniqueClasses[classIndex];
    }

    public USCHyb[] getHybsInClass(int classIndex) {
        Vector<USCHyb> v = new Vector<USCHyb>();
        String classLabel = this.uniqueClasses[classIndex];
        for (int i = 0; i < this.hybKount; ++i) {
            USCHyb hyb = this.hybs[i];
            if (!hyb.getHybLabel().equalsIgnoreCase(classLabel)) continue;
            v.add(hyb);
        }
        USCHyb[] toReturn = new USCHyb[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            USCHyb hyb;
            toReturn[i] = hyb = (USCHyb)v.elementAt(i);
        }
        return toReturn;
    }

    public int getNumHybsInClass(int classIndex) {
        Vector<USCHyb> v = new Vector<USCHyb>();
        String classLabel = this.uniqueClasses[classIndex];
        for (int i = 0; i < this.hybKount; ++i) {
            USCHyb hyb = this.hybs[i];
            if (!hyb.getHybLabel().equalsIgnoreCase(classLabel)) continue;
            v.add(hyb);
        }
        return v.size();
    }

    public double[][] getRatioMatrix() {
        double[][] toReturn = new double[this.hybs.length][];
        for (int i = 0; i < this.hybs.length; ++i) {
            USCHyb hyb = this.hybs[i];
            toReturn[i] = hyb.getRatios();
        }
        return toReturn;
    }

    public USCHyb[] getTestArray(int foldIndex) {
        return this.testArray[foldIndex];
    }

    public USCHyb[] getTrainArray(int foldIndex) {
        return this.trainArray[foldIndex];
    }

    public static void main(String[] args) {
        System.out.println("Invoked by main");
        File f = new File("C:" + File.separator + "Dev" + File.separator + "MeV" + File.separator + "files" + File.separator + "human" + File.separator + "NewTrainFormat.txt");
        try {
            USCTrainFileLoader loader = new USCTrainFileLoader(f);
            USCHybSet hs = loader.getTrainHybSet();
            hs.permute(5);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

