/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.usc;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.impl.usc.USCAssignLabel;
import org.tigr.microarray.mev.cluster.gui.impl.usc.USCClassDialog;
import org.tigr.microarray.mev.cluster.gui.impl.usc.USCConfirmDelta;
import org.tigr.microarray.mev.cluster.gui.impl.usc.USCCrossValidation;
import org.tigr.microarray.mev.cluster.gui.impl.usc.USCDeltaDialog;
import org.tigr.microarray.mev.cluster.gui.impl.usc.USCDeltaRhoResult;
import org.tigr.microarray.mev.cluster.gui.impl.usc.USCExperimentClusterViewer;
import org.tigr.microarray.mev.cluster.gui.impl.usc.USCFileDialog;
import org.tigr.microarray.mev.cluster.gui.impl.usc.USCFoldResult;
import org.tigr.microarray.mev.cluster.gui.impl.usc.USCGene;
import org.tigr.microarray.mev.cluster.gui.impl.usc.USCHyb;
import org.tigr.microarray.mev.cluster.gui.impl.usc.USCHybSet;
import org.tigr.microarray.mev.cluster.gui.impl.usc.USCOrder;
import org.tigr.microarray.mev.cluster.gui.impl.usc.USCOrderSorter;
import org.tigr.microarray.mev.cluster.gui.impl.usc.USCResult;
import org.tigr.microarray.mev.cluster.gui.impl.usc.USCRow;
import org.tigr.microarray.mev.cluster.gui.impl.usc.USCSummaryViewer;
import org.tigr.microarray.mev.cluster.gui.impl.usc.USCTextFileFilter;
import org.tigr.microarray.mev.cluster.gui.impl.usc.USCTrainFileLoader;
import org.tigr.util.FloatMatrix;

public class USCGUI
implements IClusterGUI {
    public static final int START_ROW = 1;
    public static final int START_COLUMN = 1;
    public static final int NUMBER_REPLICATES = 1;
    public static final String ERROR_OPTION = "0";
    public static final String NULL_REPLACER = "MOTHRA";
    public static final String END_LINE = "\r\n";
    public static final String TAB = "\t";
    private Hashtable htNameIndex;
    private int numClasses;
    private int fold;
    private int numBins;
    private int delta;
    private int xValKount;
    private double corrLo;
    private double corrHi;
    private double corrStep;
    private boolean doLoocv;
    private String[] uniqueClassArray;
    private String[] userLabelArray;
    private String[] hybNames;
    private String[] params;
    private String dataPath;
    private USCResult finalResult;
    private USCFoldResult[] foldResults;
    private USCDeltaRhoResult[][][] xResult;

    public DefaultMutableTreeNode execute(IFramework framework) throws AlgorithmException {
        this.dataPath = TMEV.getDataPath();
        DefaultMutableTreeNode returnNode = new DefaultMutableTreeNode("USC Result");
        IData data = framework.getData();
        USCClassDialog classDialog = new USCClassDialog(framework.getFrame());
        if (classDialog.showModal() != 0) {
            return null;
        }
        this.numClasses = classDialog.getNumClasses();
        this.numBins = classDialog.getNumBins();
        this.delta = classDialog.getDeltaMax();
        this.fold = classDialog.getFolds();
        this.corrLo = classDialog.getCorrLo();
        this.corrHi = classDialog.getCorrHi();
        this.corrStep = classDialog.getCorrStep();
        this.userLabelArray = classDialog.getClassLabels();
        this.xValKount = classDialog.getXValRuns();
        this.params = new String[4];
        this.params[0] = Integer.toString(this.numBins);
        this.params[1] = Double.toString(this.corrLo);
        this.params[2] = Double.toString(this.corrHi);
        this.params[3] = Double.toString(this.corrStep);
        this.hybNames = new String[data.getFeaturesCount()];
        for (int i = 0; i < this.hybNames.length; ++i) {
            this.hybNames[i] = data.getFullSampleName(i);
        }
        if (classDialog.getAnalysisOption() == USCClassDialog.TRAIN_THEN_CLASSIFY) {
            return this.trainThenClassify(data, framework);
        }
        return this.classifyFromFile(data, framework);
    }

    private DefaultMutableTreeNode trainThenClassify(IData data, IFramework framework) {
        USCAssignLabel assLabel = new USCAssignLabel(this.hybNames, this.userLabelArray);
        if (assLabel.showModal() == 0) {
            String[] userEnteredLabels = assLabel.getHybLabels();
            USCTrainFileLoader loader = new USCTrainFileLoader(data, userEnteredLabels);
            USCHybSet trainSet = loader.getTrainHybSet();
            USCHybSet testSet = loader.getTestHybSet();
            this.htNameIndex = this.hashNameIndex(data);
            this.uniqueClassArray = trainSet.getUniqueClasses();
            this.fold = this.validateFold(this.fold, trainSet);
            trainSet.permute(this.fold);
            USCCrossValidation xVal = new USCCrossValidation(this.numBins, this.delta, this.corrLo, this.corrHi, this.corrStep, this.fold, this.xValKount);
            this.xResult = xVal.crossValidate(trainSet, framework.getFrame());
            USCDeltaDialog deltaDialog = this.fold == 1 ? new USCDeltaDialog(this.xResult, true) : new USCDeltaDialog(this.xResult, false);
            if (deltaDialog.showModal() == 0) {
                USCRow row = deltaDialog.getSelectedRow();
                double fDelta = row.getFDelta();
                double fRho = row.getFRho();
                int iRho = (int)(fRho * 10.0);
                JFrame jf = new JFrame();
                JPanel panel = new JPanel();
                JProgressBar bar = new JProgressBar(0, trainSet.getNumGenes());
                JProgressBar rhoBar = new JProgressBar(0, 6);
                panel.add(bar);
                jf.getContentPane().add(panel);
                jf.setSize(150, 100);
                jf.setVisible(false);
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                jf.setLocation((screenSize.width - 200) / 2, (screenSize.height - 100) / 2);
                USCHyb[] trainArray = trainSet.getHybs();
                USCHyb[] testArray = testSet.getHybs();
                this.finalResult = xVal.testTest(trainArray, testArray, fDelta, fRho, trainSet.getNumGenes(), trainSet.getNumClasses(), this.uniqueClassArray, bar, iRho);
                jf.dispose();
                DefaultMutableTreeNode returnNode = new DefaultMutableTreeNode("USC");
                if (this.finalResult.getNumGenesUsed() <= 0) {
                    LeafInfo li = new LeafInfo("No results returned");
                    returnNode.add(new DefaultMutableTreeNode(li));
                } else {
                    USCOrder[] order = this.finalResult.getOrder();
                    if (deltaDialog.saveTraining()) {
                        this.saveTraining(trainSet.getHybs(), row, order, data, framework.getFrame(), trainSet.getGenes());
                    }
                    Experiment newExp = this.createNewExperiment(data.getExperiment(), this.finalResult.getNumGenesUsed(), order);
                    String[] testHybNames = new String[testArray.length];
                    for (int h = 0; h < testArray.length; ++h) {
                        testHybNames[h] = testArray[h].getHybName();
                    }
                    USCSummaryViewer summaryViewer = new USCSummaryViewer(testHybNames, this.finalResult, this.uniqueClassArray, this.params, this.getGenes(testSet.getGenes(), this.finalResult), framework);
                    LeafInfo summaryLeaf = new LeafInfo("Summary", (IViewer)summaryViewer);
                    returnNode.add(new DefaultMutableTreeNode(summaryLeaf));
                    returnNode.add(new DefaultMutableTreeNode(this.createFullCluster(data, newExp, this.finalResult)));
                    for (int c = 0; c < this.numClasses; ++c) {
                        LeafInfo li = this.createClassCluster(c, newExp, this.finalResult, trainSet, testSet);
                        returnNode.add(new DefaultMutableTreeNode(li));
                    }
                }
                return returnNode;
            }
            return null;
        }
        return null;
    }

    private DefaultMutableTreeNode classifyFromFile(IData data, IFramework framework) {
        framework.getFrame().setCursor(Cursor.getPredefinedCursor(3));
        USCFileDialog trainFileDialog = new USCFileDialog(framework.getFrame());
        int iTfd = trainFileDialog.showModal();
        if (iTfd != 0) {
            return null;
        }
        USCTrainFileLoader loader = null;
        try {
            loader = new USCTrainFileLoader(trainFileDialog.getSelectedFile());
        }
        catch (IOException e) {
            this.error("The File doesn't appear to be a Results File");
            e.printStackTrace();
            return null;
        }
        USCHybSet trainSet = loader.getTrainHybSet();
        this.htNameIndex = this.hashNameIndex(data);
        this.uniqueClassArray = trainSet.getUniqueClasses();
        double fDelta = loader.getDelta();
        double fRho = loader.getRho();
        USCConfirmDelta confirmDelta = new USCConfirmDelta(framework.getFrame(), fDelta, fRho);
        int iCd = confirmDelta.showModal();
        if (iCd != 0) {
            return null;
        }
        fDelta = confirmDelta.getDelta();
        fRho = confirmDelta.getRho();
        int iRho = (int)(fRho * 10.0);
        USCTrainFileLoader testLoader = new USCTrainFileLoader(data);
        USCHybSet testSet = testLoader.getTestHybSet();
        USCHyb[] trainArray = trainSet.getHybs();
        USCHyb[] testArray = testSet.getHybs();
        this.numClasses = trainSet.getNumClasses();
        JFrame jf = new JFrame();
        JPanel panel = new JPanel();
        JProgressBar bar = new JProgressBar(0, trainSet.getNumGenes());
        panel.add(bar);
        jf.getContentPane().add(panel);
        jf.setSize(250, 100);
        jf.show();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        jf.setLocation((screenSize.width - 200) / 2, (screenSize.height - 100) / 2);
        USCCrossValidation xVal = new USCCrossValidation(this.numBins, this.delta, this.corrLo, this.corrHi, this.corrStep, this.fold, this.xValKount);
        this.finalResult = xVal.testTest(trainArray, testArray, fDelta, fRho, trainSet.getNumGenes(), trainSet.getNumClasses(), trainSet.getUniqueClasses(), bar, iRho);
        jf.dispose();
        USCOrder[] order = this.finalResult.getOrder();
        Experiment newExp = this.createNewExperiment(data.getExperiment(), this.finalResult.getNumGenesUsed(), order);
        DefaultMutableTreeNode returnNode = new DefaultMutableTreeNode("USC");
        USCSummaryViewer summaryViewer = new USCSummaryViewer(this.hybNames, this.finalResult, this.uniqueClassArray, this.params, this.getGenes(testSet.getGenes(), this.finalResult), framework);
        LeafInfo summaryLeaf = new LeafInfo("Summary", (IViewer)summaryViewer);
        returnNode.add(new DefaultMutableTreeNode(summaryLeaf));
        returnNode.add(new DefaultMutableTreeNode(this.createFullCluster(data, newExp, this.finalResult)));
        for (int c = 0; c < this.numClasses; ++c) {
            LeafInfo li = this.createClassClusterForTrainFile(c, newExp, this.finalResult, trainSet, testSet);
            returnNode.add(new DefaultMutableTreeNode(li));
        }
        framework.getFrame().setCursor(Cursor.getPredefinedCursor(0));
        return returnNode;
    }

    static double[][] castFloatToDoubleArray(float[][] floatMatrix) {
        double[][] toReturn = new double[floatMatrix.length][floatMatrix[0].length];
        for (int i = 0; i < floatMatrix.length; ++i) {
            for (int j = 0; j < floatMatrix[i].length; ++j) {
                toReturn[i][j] = floatMatrix[i][j];
            }
        }
        return toReturn;
    }

    private Experiment createNewExperiment(Experiment exp, int numGenesUsed, USCOrder[] order) {
        float[][] fullMatrix = exp.getValues();
        int[] fullRowMap = exp.getRowMappingArrayCopy();
        int[] fullColumns = exp.getColumnIndicesCopy();
        float[][] newMatrix = new float[numGenesUsed][];
        int[] newRowMap = new int[numGenesUsed];
        int iKount = 0;
        for (int i = 0; i < order.length; ++i) {
            if (!order[i].use()) continue;
            int iGene = order[iKount].getIOriginal();
            newMatrix[iKount] = fullMatrix[iGene];
            newRowMap[iKount] = fullRowMap[iGene];
            ++iKount;
        }
        FloatMatrix fm = new FloatMatrix((float[][])newMatrix);
        Experiment toReturn = new Experiment(fm, fullColumns, newRowMap);
        return toReturn;
    }

    private LeafInfo createFullCluster(IData data, Experiment exp, USCResult result) {
        int[][] clusters = new int[1][data.getFeaturesCount()];
        for (int i = 0; i < data.getFeaturesCount(); ++i) {
            clusters[0][i] = i;
        }
        USCExperimentClusterViewer viewer = new USCExperimentClusterViewer(exp, clusters);
        LeafInfo toReturn = new LeafInfo("All Loaded Hybs - Genes Used", (IViewer)viewer, (Object)new Integer(0));
        return toReturn;
    }

    private LeafInfo createClassClusterForTrainFile(int c, Experiment exp, USCResult result, USCHybSet trainSet, USCHybSet testSet) {
        double[][] scores = result.getDiscScores();
        USCHyb[] classHybs = trainSet.getHybsInClass(c);
        Vector<Integer> vHybIndex = new Vector<Integer>();
        for (int h = 0; h < scores.length; ++h) {
            USCHyb hyb = testSet.getHyb(h);
            int iMin = result.getAssignedClassIndex(h);
            if (iMin != c) continue;
            vHybIndex.add(new Integer(this.lookupIndex(hyb.getHybName())));
        }
        int[][] clusters = new int[1][vHybIndex.size()];
        for (int h = 0; h < vHybIndex.size(); ++h) {
            Integer I = (Integer)vHybIndex.elementAt(h);
            clusters[0][h] = I;
        }
        USCExperimentClusterViewer viewer = new USCExperimentClusterViewer(exp, clusters);
        String sNode = new String("Classified As: " + trainSet.getUniqueClass(c));
        LeafInfo toReturn = new LeafInfo(sNode, (IViewer)viewer, (Object)new Integer(0));
        return toReturn;
    }

    private LeafInfo createClassCluster(int c, Experiment exp, USCResult result, USCHybSet trainSet, USCHybSet testSet) {
        int h;
        double[][] scores = result.getDiscScores();
        USCHyb[] classHybs = trainSet.getHybsInClass(c);
        Vector<Integer> vHybIndex = new Vector<Integer>();
        for (int h2 = 0; h2 < scores.length; ++h2) {
            USCHyb hyb = testSet.getHyb(h2);
            int iMin = result.getAssignedClassIndex(h2);
            if (iMin != c) continue;
            vHybIndex.add(new Integer(this.lookupIndex(hyb.getHybName())));
        }
        int[][] clusters = new int[1][classHybs.length + vHybIndex.size()];
        for (h = 0; h < classHybs.length; ++h) {
            clusters[0][h] = this.lookupIndex(classHybs[h].getHybName());
        }
        for (h = 0; h < vHybIndex.size(); ++h) {
            Integer I = (Integer)vHybIndex.elementAt(h);
            clusters[0][classHybs.length + h] = I;
        }
        USCExperimentClusterViewer viewer = new USCExperimentClusterViewer(exp, clusters);
        String sNode = new String("Classified As: " + trainSet.getUniqueClass(c));
        LeafInfo toReturn = new LeafInfo(sNode, (IViewer)viewer, (Object)new Integer(0));
        return toReturn;
    }

    private Hashtable hashNameIndex(IData data) {
        Hashtable<String, Integer> ht = new Hashtable<String, Integer>();
        int iHyb = data.getFeaturesCount();
        for (int i = 0; i < iHyb; ++i) {
            ht.put(data.getFullSampleName(i), new Integer(i));
        }
        return ht;
    }

    private void saveTraining(USCHyb[] trainArray, USCRow row, USCOrder[] order, IData data, Frame frame, USCGene[] genes) {
        StringBuffer sb;
        File saveFile;
        String dataPath = "/" + TMEV.getDataPath();
        if (dataPath == null) {
            dataPath = "";
        }
        Arrays.sort(order, new USCOrderSorter());
        JFileChooser chooser = new JFileChooser(dataPath);
        USCTextFileFilter textFilter = new USCTextFileFilter();
        chooser.addChoosableFileFilter(textFilter);
        int returnVal = chooser.showSaveDialog(frame);
        if (returnVal == 0) {
            int h;
            if (chooser.getFileFilter() == textFilter) {
                String path = chooser.getSelectedFile().getPath();
                if (path.toLowerCase().endsWith("txt")) {
                    saveFile = new File(path);
                } else {
                    String subPath;
                    int period = path.lastIndexOf(".");
                    if (period != -1) {
                        System.out.println("period  = -1");
                        subPath = path.substring(0, period);
                    } else {
                        subPath = path;
                    }
                    String newPath = subPath + ".txt";
                    saveFile = new File(newPath);
                }
            } else {
                saveFile = chooser.getSelectedFile();
            }
            sb = new StringBuffer();
            sb.append("Delta=");
            sb.append(row.getDelta());
            sb.append(TAB);
            sb.append("BLANK");
            for (h = 0; h < trainArray.length; ++h) {
                USCHyb hyb = trainArray[h];
                sb.append(TAB);
                sb.append(hyb.getHybName());
            }
            sb.append(END_LINE);
            sb.append("Rho=");
            sb.append(row.getRho());
            sb.append(TAB);
            sb.append("BLANK");
            for (h = 0; h < trainArray.length; ++h) {
                USCHyb hyb = trainArray[h];
                sb.append(TAB);
                sb.append(hyb.getHybLabel());
            }
            sb.append(END_LINE);
            for (int o = 0; o < order.length; ++o) {
                int iOrig = order[o].getIOriginal();
                sb.append(data.getGeneName(iOrig));
                sb.append(TAB);
                sb.append(data.getUniqueId(iOrig));
                for (int h2 = 0; h2 < trainArray.length; ++h2) {
                    USCHyb hyb = trainArray[h2];
                    sb.append(TAB);
                    sb.append(hyb.getRatio(iOrig));
                }
                sb.append(END_LINE);
            }
        } else {
            System.out.println("User Cancelled Saving Training File");
            return;
        }
        this.writeFile(saveFile, sb.toString());
        this.updateDataPath(saveFile.getAbsolutePath());
    }

    private void updateDataPath(String dataPath) {
        if (dataPath == null) {
            return;
        }
        String renderedSep = "/";
        String renderedPath = new String();
        String sep = System.getProperty("file.separator");
        String lineSep = System.getProperty("line.separator");
        StringTokenizer stok = new StringTokenizer(dataPath, sep);
        this.dataPath = new String();
        while (stok.hasMoreTokens() && stok.countTokens() > 1) {
            String str = stok.nextToken();
            renderedPath = renderedPath + str + renderedSep;
            this.dataPath = this.dataPath + str + sep;
        }
        TMEV.setDataPath((String)renderedPath);
        TMEV.setDataPath((String)this.dataPath);
    }

    private USCGene[] getGenes(USCGene[] fullGenes, USCResult result) {
        USCOrder[] order = result.getOrder();
        int usedKount = 0;
        for (int i = 0; i < order.length; ++i) {
            if (!order[i].use()) continue;
            ++usedKount;
        }
        USCGene[] returnGenes = new USCGene[usedKount];
        int iGene = 0;
        for (int i = 0; i < order.length; ++i) {
            if (!order[i].use()) continue;
            returnGenes[iGene] = fullGenes[order[i].getIOriginal()];
            ++iGene;
        }
        return returnGenes;
    }

    private int lookupIndex(String hybName) {
        Integer I = (Integer)this.htNameIndex.get(hybName);
        return I;
    }

    private int validateFold(int iFold, USCHybSet hybSet) {
        int toReturn = iFold;
        for (int i = 0; i < this.numClasses; ++i) {
            int hybKount = hybSet.getNumHybsInClass(i);
            if (hybKount >= toReturn) continue;
            toReturn = hybKount;
        }
        return toReturn;
    }

    private void writeFile(File f, String s) {
        try {
            FileWriter fw = new FileWriter(f);
            fw.write(s);
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.error(e.getMessage());
        }
    }

    private int findParamValue(Hashtable ht, String sKey) {
        int toReturn = 0;
        JTextField field = (JTextField)ht.get(sKey);
        Integer I = new Integer(field.getText());
        toReturn = I;
        return toReturn;
    }

    public void error(String message) {
        JOptionPane.showMessageDialog(new JFrame(), message, "Input Error", 0);
    }
}

