/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.usc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ToolTipManager;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.microarray.mev.cluster.gui.impl.usc.USCDeltaRhoResult;
import org.tigr.microarray.mev.cluster.gui.impl.usc.USCFoldResult;
import org.tigr.microarray.mev.cluster.gui.impl.usc.USCHyb;
import org.tigr.microarray.mev.cluster.gui.impl.usc.USCResult;
import org.tigr.microarray.mev.cluster.gui.impl.usc.USCRow;
import org.tigr.microarray.mev.cluster.gui.impl.usc.USCXValResult;
import org.tigr.microarray.mev.r.TableSorter;

public class USCDeltaDialog
extends AlgorithmDialog {
    private USCFoldResult[] foldResults;
    private USCXValResult xValResults;
    private USCDeltaRhoResult[][][] xResult;
    private int buttonPushed;
    private JPanel mainPanel;
    private JCheckBox saveBox;
    private Vector vRow;
    private JTable jt;

    public USCDeltaDialog(USCXValResult results, boolean foldIsOne) {
        super(new JFrame(), "Choose your parameters", true);
        this.setSize(600, 400);
        this.xValResults = results;
        this.createGUI(this.xValResults, foldIsOne);
        Listener listener = new Listener();
        super.addWindowListener(listener);
        super.setActionListeners(listener);
    }

    public USCDeltaDialog(USCDeltaRhoResult[][][] xResultP, boolean foldIsOne) {
        super(new JFrame(), "Choose your parameters", true);
        this.setSize(600, 400);
        this.xResult = xResultP;
        this.createGUI(this.xResult, foldIsOne);
        Listener listener = new Listener();
        super.addWindowListener(listener);
        super.setActionListeners(listener);
    }

    private void createGUI(USCXValResult results, boolean foldIsOne) {
        this.mainPanel = new JPanel(new BorderLayout());
        JPanel radioPanel = this.createRadioPanel(results, foldIsOne);
        this.mainPanel.add((Component)radioPanel, "Center");
        this.mainPanel.add((Component)this.createSavePanel(), "South");
        this.addContent(this.mainPanel);
    }

    private void createGUI(USCDeltaRhoResult[][][] xResult, boolean foldIsOne) {
        this.mainPanel = new JPanel(new BorderLayout());
        JPanel radioPanel = this.createRadioPanel(xResult, foldIsOne);
        this.mainPanel.add((Component)radioPanel, "Center");
        this.mainPanel.add((Component)this.createSavePanel(), "South");
        this.addContent(this.mainPanel);
    }

    private JPanel createRadioPanel(USCDeltaRhoResult[][][] results, boolean foldIsOne) {
        int i;
        TableColumn column;
        USCRow row;
        int i2;
        Object[][] table;
        String[] toolTips;
        Object[] header;
        JPanel toReturn = new JPanel();
        this.vRow = this.createRows(results);
        if (foldIsOne) {
            header = new String[]{"", "Avg#Genes", "Delta", "Rho"};
            toolTips = new String[]{"Choose the Delta/Rho combination to use", "Average # of Genes Used to classify over all CrossValidation folds", "Amount of Shrinkage applied to Class Centroids", "Lower Threshold of Gene Correlation"};
            table = new Object[this.vRow.size()][4];
            for (i2 = 0; i2 < this.vRow.size(); ++i2) {
                row = (USCRow)this.vRow.elementAt(i2);
                table[i2][0] = row.getButton();
                table[i2][1] = row.getNumGenes();
                table[i2][2] = row.getDelta();
                table[i2][3] = row.getRho();
            }
        } else {
            header = new String[]{"", "#Mistakes", "Avg#Genes", "Delta", "Rho"};
            toolTips = new String[]{"Choose the Delta/Rho combination to use", "Total # of Mistaken Class Assignments", "Average # of Genes Used to classify over all CrossValidation folds", "Amount of Shrinkage applied to Class Centroids", "Lower Threshold of Gene Correlation"};
            table = new Object[this.vRow.size()][5];
            for (i2 = 0; i2 < this.vRow.size(); ++i2) {
                row = (USCRow)this.vRow.elementAt(i2);
                table[i2][0] = row.getButton();
                table[i2][1] = row.getNumErrors();
                table[i2][2] = row.getNumGenes();
                table[i2][3] = row.getDelta();
                table[i2][4] = row.getRho();
            }
        }
        DefaultTableModel dm = new DefaultTableModel();
        dm.setDataVector(table, header);
        TableSorter sorter = new TableSorter((TableModel)dm);
        this.jt = new JTable((TableModel)sorter){

            @Override
            public void tableChanged(TableModelEvent e) {
                super.tableChanged(e);
                this.repaint();
            }
        };
        sorter.setTableHeader(this.jt.getTableHeader());
        if (foldIsOne) {
            this.jt.setPreferredScrollableViewportSize(new Dimension(245, 240));
            this.jt.setAutoResizeMode(0);
            column = null;
            for (i = 0; i < table[0].length; ++i) {
                column = this.jt.getColumnModel().getColumn(i);
                if (i == 0) {
                    column.setPreferredWidth(20);
                    column.setMinWidth(20);
                    continue;
                }
                if (i == 1 || i == 2) {
                    column.setPreferredWidth(75);
                    column.setMinWidth(75);
                    continue;
                }
                if (i != 3) continue;
                column.setPreferredWidth(55);
                column.setMinWidth(55);
            }
        } else {
            this.jt.setPreferredScrollableViewportSize(new Dimension(280, 240));
            this.jt.setAutoResizeMode(0);
            column = null;
            for (i = 0; i < table[0].length; ++i) {
                column = this.jt.getColumnModel().getColumn(i);
                if (i == 0) {
                    column.setPreferredWidth(20);
                    column.setMinWidth(20);
                    continue;
                }
                if (i == 1) {
                    column.setPreferredWidth(75);
                    column.setMinWidth(75);
                    continue;
                }
                if (i == 2) {
                    column.setPreferredWidth(75);
                    column.setMinWidth(75);
                    continue;
                }
                if (i == 3 || i == 4) {
                    column.setPreferredWidth(55);
                    column.setMinWidth(55);
                    continue;
                }
                column.setPreferredWidth(50);
                column.setMinWidth(50);
            }
        }
        this.jt.getColumn("").setCellRenderer(new RadioButtonRenderer());
        this.jt.getColumn("").setCellEditor(new RadioButtonEditor(new JCheckBox()));
        ColumnHeaderToolTips tips = new ColumnHeaderToolTips();
        for (int t = 0; t < toolTips.length; ++t) {
            TableColumn col = this.jt.getColumnModel().getColumn(t);
            tips.setToolTip(col, toolTips[t]);
        }
        JTableHeader head = this.jt.getTableHeader();
        head.addMouseMotionListener(tips);
        ToolTipManager.sharedInstance().setInitialDelay(0);
        ButtonGroup group1 = new ButtonGroup();
        for (int i3 = 0; i3 < this.vRow.size(); ++i3) {
            group1.add((JRadioButton)dm.getValueAt(i3, 0));
        }
        JScrollPane jsp = new JScrollPane(this.jt);
        toReturn.add(jsp);
        return toReturn;
    }

    private JPanel createRadioPanel(USCXValResult results, boolean foldIsOne) {
        int i;
        TableColumn column;
        USCRow row;
        int i2;
        Object[][] table;
        String[] toolTips;
        Object[] header;
        JPanel toReturn = new JPanel();
        this.vRow = this.createRows(results);
        if (foldIsOne) {
            header = new String[]{"", "Avg#Genes", "Delta", "Rho"};
            toolTips = new String[]{"Choose the Delta/Rho combination to use", "Average # of Genes Used to classify over all CrossValidation folds", "Amount of Shrinkage applied to Class Centroids", "Lower Threshold of Gene Correlation"};
            table = new Object[this.vRow.size()][4];
            for (i2 = 0; i2 < this.vRow.size(); ++i2) {
                row = (USCRow)this.vRow.elementAt(i2);
                table[i2][0] = row.getButton();
                table[i2][1] = row.getNumGenes();
                table[i2][2] = row.getDelta();
                table[i2][3] = row.getRho();
            }
        } else {
            header = new String[]{"", "#Mistakes", "Avg#Genes", "Delta", "Rho"};
            toolTips = new String[]{"Choose the Delta/Rho combination to use", "Total # of Mistaken Class Assignments", "Average # of Genes Used to classify over all CrossValidation folds", "Amount of Shrinkage applied to Class Centroids", "Lower Threshold of Gene Correlation"};
            table = new Object[this.vRow.size()][5];
            for (i2 = 0; i2 < this.vRow.size(); ++i2) {
                row = (USCRow)this.vRow.elementAt(i2);
                table[i2][0] = row.getButton();
                table[i2][1] = row.getNumErrors();
                table[i2][2] = row.getNumGenes();
                table[i2][3] = row.getDelta();
                table[i2][4] = row.getRho();
            }
        }
        DefaultTableModel dm = new DefaultTableModel();
        dm.setDataVector(table, header);
        TableSorter sorter = new TableSorter((TableModel)dm);
        this.jt = new JTable((TableModel)sorter){

            @Override
            public void tableChanged(TableModelEvent e) {
                super.tableChanged(e);
                this.repaint();
            }
        };
        sorter.setTableHeader(this.jt.getTableHeader());
        if (foldIsOne) {
            this.jt.setPreferredScrollableViewportSize(new Dimension(245, 240));
            this.jt.setAutoResizeMode(0);
            column = null;
            for (i = 0; i < table[0].length; ++i) {
                column = this.jt.getColumnModel().getColumn(i);
                if (i == 0) {
                    column.setPreferredWidth(20);
                    column.setMinWidth(20);
                    continue;
                }
                if (i == 1 || i == 2) {
                    column.setPreferredWidth(75);
                    column.setMinWidth(75);
                    continue;
                }
                if (i != 3) continue;
                column.setPreferredWidth(55);
                column.setMinWidth(55);
            }
        } else {
            this.jt.setPreferredScrollableViewportSize(new Dimension(280, 240));
            this.jt.setAutoResizeMode(0);
            column = null;
            for (i = 0; i < table[0].length; ++i) {
                column = this.jt.getColumnModel().getColumn(i);
                if (i == 0) {
                    column.setPreferredWidth(20);
                    column.setMinWidth(20);
                    continue;
                }
                if (i == 1) {
                    column.setPreferredWidth(75);
                    column.setMinWidth(75);
                    continue;
                }
                if (i == 2) {
                    column.setPreferredWidth(75);
                    column.setMinWidth(75);
                    continue;
                }
                if (i == 3 || i == 4) {
                    column.setPreferredWidth(55);
                    column.setMinWidth(55);
                    continue;
                }
                column.setPreferredWidth(50);
                column.setMinWidth(50);
            }
        }
        this.jt.getColumn("").setCellRenderer(new RadioButtonRenderer());
        this.jt.getColumn("").setCellEditor(new RadioButtonEditor(new JCheckBox()));
        ColumnHeaderToolTips tips = new ColumnHeaderToolTips();
        for (int t = 0; t < toolTips.length; ++t) {
            TableColumn col = this.jt.getColumnModel().getColumn(t);
            tips.setToolTip(col, toolTips[t]);
        }
        JTableHeader head = this.jt.getTableHeader();
        head.addMouseMotionListener(tips);
        ToolTipManager.sharedInstance().setInitialDelay(0);
        ButtonGroup group1 = new ButtonGroup();
        for (int i3 = 0; i3 < this.vRow.size(); ++i3) {
            group1.add((JRadioButton)dm.getValueAt(i3, 0));
        }
        JScrollPane jsp = new JScrollPane(this.jt);
        toReturn.add(jsp);
        return toReturn;
    }

    private JPanel createSavePanel() {
        JPanel toReturn = new JPanel();
        this.saveBox = new JCheckBox("Save Training Results");
        this.saveBox.setSelected(true);
        toReturn.add(this.saveBox);
        return toReturn;
    }

    private Vector createRows(USCDeltaRhoResult[][][] results) {
        Vector<USCRow> vReturn = new Vector<USCRow>();
        ButtonGroup bg = new ButtonGroup();
        int resultKount = results[0].length;
        for (int r = 0; r < results[0][0].length; ++r) {
            int iCorrect = 0;
            int iMistake = 0;
            int iNumGenes = 0;
            int iResults = 0;
            double delta = 0.0;
            double rho = 0.0;
            for (int f = 0; f < results[0].length; ++f) {
                for (int m = 0; m < results.length; ++m) {
                    USCDeltaRhoResult dr = results[m][f][r];
                    if (dr.isNull()) continue;
                    iMistake += dr.getMistake();
                    iCorrect += dr.getCorrect();
                    iNumGenes += dr.getNumGene();
                    ++iResults;
                    delta = dr.getDelta();
                    rho = dr.getRho();
                }
            }
            DecimalFormat df = new DecimalFormat("###.#");
            double mistakeAvg = (double)iMistake / (double)iResults;
            double numGenesAvg = (double)iNumGenes / (double)iResults;
            String sMistake = df.format(mistakeAvg);
            String sNumGenes = df.format(numGenesAvg);
            String sDelta = df.format(delta);
            String sRho = df.format(rho);
            USCRow row = new USCRow(sMistake, sNumGenes, sDelta, sRho);
            bg.add(row.getButton());
            vReturn.add(row);
        }
        if (vReturn.size() > 0 && vReturn.get(0) != null) {
            ((USCRow)vReturn.get(0)).getButton().setSelected(true);
        }
        return vReturn;
    }

    private Vector createRows(USCXValResult xValResults) {
        Vector<USCRow> vReturn = new Vector<USCRow>();
        ButtonGroup bg = new ButtonGroup();
        int resultKount = xValResults.getFoldResult(0)[0].getResultKount();
        for (int r = 0; r < resultKount; ++r) {
            int iCorrect = 0;
            int iMistake = 0;
            int iTotalCalls = 0;
            int iTotalNumGenes = 0;
            int iGenesDenom = 0;
            boolean hasResult = false;
            double delta = 0.0;
            double rho = 0.0;
            for (int x = 0; x < xValResults.getXValKount(); ++x) {
                USCFoldResult[] foldResultArray = xValResults.getFoldResult(x);
                for (int f = 0; f < foldResultArray.length; ++f) {
                    USCFoldResult foldResult = foldResultArray[f];
                    if (!foldResult.hasResult(r)) continue;
                    if (!hasResult) {
                        hasResult = true;
                    }
                    USCResult result = foldResult.getResult(r);
                    delta = result.getDelta();
                    rho = result.getRho();
                    iTotalNumGenes += result.getNumGenesUsed();
                    ++iGenesDenom;
                    double[][] dScores = result.getDiscScores();
                    USCHyb[] testArray = foldResult.getTestArray();
                    for (int h = 0; h < dScores.length; ++h) {
                        double dMin = 9.9999999E7;
                        int iMin = 0;
                        for (int c = 0; c < dScores[h].length; ++c) {
                            if (!(dScores[h][c] < dMin)) continue;
                            dMin = dScores[h][c];
                            iMin = c;
                        }
                        if (testArray[h].getUniqueLabelIndex() == iMin) {
                            ++iCorrect;
                            ++iTotalCalls;
                            continue;
                        }
                        ++iMistake;
                        ++iTotalCalls;
                    }
                }
            }
            double fNumGenes = iGenesDenom > 0 ? (double)iTotalNumGenes / (double)iGenesDenom : 0.0;
            if (!hasResult) continue;
            USCRow row = new USCRow(iMistake, iTotalCalls, fNumGenes, delta, rho);
            bg.add(row.getButton());
            vReturn.add(row);
            if (vReturn.size() != 1) continue;
            row.getButton().setSelected(true);
        }
        return vReturn;
    }

    public void error(String message) {
        JOptionPane.showMessageDialog(this, message, "Input Error", 0);
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.buttonPushed;
    }

    public USCRow getSelectedRow() {
        USCRow toReturn = null;
        boolean selectedIndex = false;
        for (int i = 0; i < this.jt.getRowCount(); ++i) {
            TableModel dm = this.jt.getModel();
            JRadioButton rButton = (JRadioButton)dm.getValueAt(i, 0);
            if (!rButton.isSelected()) continue;
            for (int r = 0; r < this.vRow.size(); ++r) {
                USCRow row = (USCRow)this.vRow.elementAt(r);
                if (rButton != row.getButton()) continue;
                toReturn = row;
            }
            break;
        }
        return toReturn;
    }

    public boolean saveTraining() {
        return this.saveBox.isSelected();
    }

    private class ColumnHeaderToolTips
    extends MouseMotionAdapter {
        TableColumn curCol;
        Map tips = new HashMap();

        private ColumnHeaderToolTips() {
        }

        public void setToolTip(TableColumn col, String tooltip) {
            if (tooltip == null) {
                this.tips.remove(col);
            } else {
                this.tips.put(col, tooltip);
            }
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
            TableColumn col = null;
            JTableHeader header = (JTableHeader)evt.getSource();
            JTable table = header.getTable();
            TableColumnModel colModel = table.getColumnModel();
            int vColIndex = colModel.getColumnIndexAtX(evt.getX());
            if (vColIndex >= 0) {
                col = colModel.getColumn(vColIndex);
            }
            if (col != this.curCol) {
                header.setToolTipText((String)this.tips.get(col));
                this.curCol = col;
            }
        }
    }

    private class Listener
    extends DialogListener
    implements ItemListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("ok-command")) {
                USCDeltaDialog.this.buttonPushed = 0;
                USCDeltaDialog.this.dispose();
            } else if (command.equals("cancel-command")) {
                USCDeltaDialog.this.buttonPushed = 2;
                USCDeltaDialog.this.dispose();
            } else {
                if (command.equals("reset-command")) {
                    USCDeltaDialog.this.buttonPushed = 2;
                    return;
                }
                if (command.equals("info-command")) {
                    HelpWindow.launchBrowser(USCDeltaDialog.this, "USC Delta Dialog");
                }
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            USCDeltaDialog.this.buttonPushed = -1;
            USCDeltaDialog.this.dispose();
        }
    }

    private class RadioButtonEditor
    extends DefaultCellEditor
    implements ItemListener {
        private JRadioButton button;

        public RadioButtonEditor(JCheckBox checkBox) {
            super(checkBox);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                return null;
            }
            this.button = (JRadioButton)value;
            this.button.addItemListener(this);
            return (Component)value;
        }

        @Override
        public Object getCellEditorValue() {
            this.button.removeItemListener(this);
            return this.button;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            super.fireEditingStopped();
        }
    }

    private class RadioButtonRenderer
    implements TableCellRenderer {
        private RadioButtonRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return null;
            }
            return (Component)value;
        }
    }
}

