/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.usc;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class USCConfirmDelta
extends AlgorithmDialog {
    private int result = 0;
    private double delta;
    private double rho;
    private JSpinner deltaSpinner;
    private JSpinner rhoSpinner;

    public USCConfirmDelta(Frame frame, double sDelta, double sRho) {
        super((JFrame)frame, "Confirm Delta & Rho", true);
        this.setSize(250, 200);
        this.delta = sDelta;
        this.rho = sRho;
        Listener listener = new Listener();
        super.addWindowListener(listener);
        super.setActionListeners(listener);
        this.createGUI();
    }

    private void createGUI() {
        JPanel mainPanel = new JPanel();
        JPanel labelPanel = new JPanel();
        JLabel instructionLabel = new JLabel("Change Delta and Rho if you wish");
        labelPanel.add(instructionLabel);
        JLabel deltaLabel = new JLabel("Delta:");
        JLabel rhoLabel = new JLabel("Rho:");
        JPanel spinnerLabelPanel = new JPanel();
        BoxLayout spinnerLabelBoxLayout = new BoxLayout(spinnerLabelPanel, 1);
        spinnerLabelPanel.setLayout(spinnerLabelBoxLayout);
        spinnerLabelPanel.add(deltaLabel);
        spinnerLabelPanel.add(rhoLabel);
        JPanel spinnerPanel = new JPanel();
        BoxLayout spinnerBoxLayout = new BoxLayout(spinnerPanel, 1);
        spinnerPanel.setLayout(spinnerBoxLayout);
        SpinnerNumberModel deltaModel = new SpinnerNumberModel(this.delta, 0.0, 50.0, 0.1);
        SpinnerNumberModel rhoModel = new SpinnerNumberModel(this.rho, 0.0, 1.0, 0.1);
        this.deltaSpinner = new JSpinner(deltaModel);
        this.rhoSpinner = new JSpinner(rhoModel);
        spinnerPanel.add(this.deltaSpinner);
        spinnerPanel.add(this.rhoSpinner);
        JPanel centerPanel = new JPanel();
        centerPanel.add(spinnerLabelPanel);
        centerPanel.add(spinnerPanel);
        mainPanel.add((Component)labelPanel, "North");
        mainPanel.add((Component)centerPanel, "Center");
        this.addContent(mainPanel);
    }

    public double getDelta() {
        SpinnerNumberModel model = (SpinnerNumberModel)this.deltaSpinner.getModel();
        return model.getNumber().doubleValue();
    }

    public double getRho() {
        SpinnerNumberModel model = (SpinnerNumberModel)this.rhoSpinner.getModel();
        return model.getNumber().doubleValue();
    }

    public static void main(String[] Args) {
        USCConfirmDelta ucd = new USCConfirmDelta((Frame)new JFrame(), 0.8, 0.8);
        int iTest = ucd.showModal();
        if (iTest == 0) {
            System.out.println("OK_OPTION\tdelta=" + ucd.getDelta());
        } else {
            System.out.println("Not OK_OPTION");
        }
    }

    public void error(String message) {
        JOptionPane.showMessageDialog(this, message, "Input Error", 0);
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    private class Listener
    extends DialogListener
    implements ItemListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("ok-command")) {
                USCConfirmDelta.this.result = 0;
                USCConfirmDelta.this.dispose();
            } else if (command.equals("cancel-command")) {
                USCConfirmDelta.this.result = 2;
                USCConfirmDelta.this.dispose();
            } else {
                if (command.equals("reset-command")) {
                    USCConfirmDelta.this.result = 2;
                    return;
                }
                if (command.equals("info-command")) {
                    HelpWindow.launchBrowser(USCConfirmDelta.this, "USC Confirm Dialog");
                }
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            USCConfirmDelta.this.result = -1;
            USCConfirmDelta.this.dispose();
        }
    }
}

