/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.usc;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.microarray.mev.cluster.gui.impl.usc.SpringUtilities;
import org.tigr.microarray.mev.r.ClassAssigner;

public class USCClassDialog
extends AlgorithmDialog {
    static int TRAIN_THEN_CLASSIFY = 0;
    static int CLASSIFY_FROM_FILE = 1;
    private int result;
    private JPanel mainPanel;
    private JPanel radioPanel;
    private JPanel labelPanel;
    private JPanel fieldPanel;
    private JPanel textPanel;
    private JPanel paramPanel;
    private JRadioButton trainClassify;
    private JRadioButton fileClassify;
    private JSpinner numClasses;
    private Vector vField;
    private Vector vLabel;
    private JCheckBox advActive;
    private JSpinner numFolds;
    private JSpinner numBins;
    private JSpinner deltaMax;
    private JSpinner numXVal;
    private JTextField corrLo;
    private JTextField corrHi;
    private JTextField corrStep;
    private Dimension dField;
    private Dimension dLabel;
    private JLabel numLabel;
    private JLabel foldLabel;
    private JLabel xValLabel;
    private JLabel binLabel;
    private JLabel deltaLabel;
    private JLabel loLabel;
    private JLabel hiLabel;
    private JLabel stepLabel;

    public USCClassDialog(Frame parent) {
        super((JFrame)parent, "USC: Uncorrelated Shrunken Centroid", true);
        this.setSize(350, 525);
        this.dLabel = new Dimension(55, 20);
        this.dField = new Dimension(140, 20);
        Dimension dSpin = new Dimension(45, 20);
        Dimension dButton = new Dimension(140, 20);
        this.mainPanel = new JPanel();
        SpinListener sl = new SpinListener();
        ButtonListener bl = new ButtonListener();
        Listener listener = new Listener();
        super.addWindowListener(listener);
        super.setActionListeners(listener);
        this.createRadioPanel(bl, dSpin);
        this.createLabelPanel(sl, 2);
        this.createParamPanel(bl, dSpin);
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)this.radioPanel, "West");
        this.mainPanel.add((Component)this.paramPanel, "East");
        this.mainPanel.add((Component)this.labelPanel, "North");
        JScrollPane scrollPane = new JScrollPane(this.mainPanel);
        this.addContent(scrollPane);
    }

    public static void main(String[] args) {
        System.out.println("invoked by main()");
        USCClassDialog d = new USCClassDialog(new JFrame());
        d.showModal();
    }

    private void createRadioPanel(ButtonListener bl, Dimension dSpin) {
        this.radioPanel = new JPanel();
        BoxLayout box = new BoxLayout(this.radioPanel, 1);
        this.radioPanel.setLayout(box);
        this.radioPanel.setBorder(BorderFactory.createTitledBorder("Analysis Mode"));
        this.trainClassify = new JRadioButton("Train & Classify");
        this.trainClassify.setSelected(true);
        this.trainClassify.addItemListener(bl);
        this.fileClassify = new JRadioButton("Classify from File");
        this.fileClassify.setSelected(false);
        this.fileClassify.addItemListener(bl);
        ButtonGroup group = new ButtonGroup();
        group.add(this.trainClassify);
        group.add(this.fileClassify);
        this.radioPanel.add(Box.createVerticalGlue());
        this.radioPanel.add(this.trainClassify);
        this.radioPanel.add(this.fileClassify);
        this.radioPanel.add(Box.createVerticalGlue());
    }

    private void createLabelPanel(SpinListener sl, int kount) {
        this.vField = new Vector();
        this.vLabel = new Vector();
        this.labelPanel = new JPanel(new BorderLayout());
        this.labelPanel.setBorder(BorderFactory.createTitledBorder("Enter all Class Labels"));
        this.fieldPanel = new JPanel();
        BoxLayout fieldBoxLayout = new BoxLayout(this.fieldPanel, 1);
        this.fieldPanel.setLayout(fieldBoxLayout);
        this.textPanel = new JPanel();
        BoxLayout textBoxLayout = new BoxLayout(this.textPanel, 1);
        this.textPanel.setLayout(textBoxLayout);
        JPanel centerPanel = new JPanel();
        centerPanel.add(this.textPanel);
        centerPanel.add(this.fieldPanel);
        for (int i = 0; i < kount; ++i) {
            JLabel label = new JLabel("Label " + (i + 1));
            label.setMaximumSize(this.dLabel);
            label.setMinimumSize(this.dLabel);
            label.setPreferredSize(this.dLabel);
            JTextField field = new JTextField();
            field.setMaximumSize(this.dField);
            field.setMinimumSize(this.dField);
            field.setPreferredSize(this.dField);
            this.textPanel.add(label);
            this.fieldPanel.add(field);
            this.vLabel.add(label);
            this.vField.add(field);
        }
        JPanel spinPanel = new JPanel();
        SpinnerNumberModel model = new SpinnerNumberModel(kount, 2, 50, 1);
        this.numClasses = new JSpinner(model);
        this.numClasses.setMaximumSize(this.dLabel);
        this.numLabel = new JLabel("# of Classes");
        spinPanel.add(this.numLabel);
        spinPanel.add(this.numClasses);
        this.numClasses.addChangeListener(sl);
        this.labelPanel.add((Component)spinPanel, "North");
        this.labelPanel.add((Component)centerPanel, "Center");
    }

    private void createParamPanel(ButtonListener cl, Dimension d) {
        this.paramPanel = new JPanel(new SpringLayout());
        this.paramPanel.setBorder(BorderFactory.createTitledBorder("Advanced Parameters"));
        this.advActive = new JCheckBox("Advanced");
        this.advActive.addItemListener(cl);
        JLabel advLabel = new JLabel(" ");
        SpinnerNumberModel numClassModel = (SpinnerNumberModel)this.numClasses.getModel();
        int numClasses = numClassModel.getNumber().intValue();
        int defaultFold = 3;
        int defaultXVal = 5;
        SpinnerNumberModel foldModel = new SpinnerNumberModel(defaultFold, 1, 100, 1);
        this.numFolds = new JSpinner(foldModel);
        this.numFolds.setMaximumSize(d);
        this.numFolds.setMinimumSize(d);
        this.numFolds.setPreferredSize(d);
        this.foldLabel = new JLabel("# Folds");
        SpinnerNumberModel xValModel = new SpinnerNumberModel(defaultXVal, 1, 100, 1);
        this.numXVal = new JSpinner(xValModel);
        this.numXVal.setMaximumSize(d);
        this.numXVal.setMinimumSize(d);
        this.numXVal.setPreferredSize(d);
        this.xValLabel = new JLabel("# CV runs");
        SpinnerNumberModel numBinsModel = new SpinnerNumberModel(20, 1, 500, 1);
        this.numBins = new JSpinner(numBinsModel);
        this.numBins.setMaximumSize(d);
        this.numBins.setMinimumSize(d);
        this.numBins.setPreferredSize(d);
        this.binLabel = new JLabel("# Bins");
        SpinnerNumberModel deltaMaxModel = new SpinnerNumberModel(10, 1, 500, 1);
        this.deltaMax = new JSpinner(deltaMaxModel);
        this.deltaMax.setMaximumSize(d);
        this.deltaMax.setMinimumSize(d);
        this.deltaMax.setPreferredSize(d);
        this.deltaLabel = new JLabel("Max Delta");
        this.corrLo = new JTextField("0.5");
        this.corrLo.setMaximumSize(d);
        this.corrLo.setMinimumSize(d);
        this.corrLo.setPreferredSize(d);
        this.loLabel = new JLabel("Corr Low");
        this.corrHi = new JTextField("1.0");
        this.corrHi.setMaximumSize(d);
        this.corrHi.setMinimumSize(d);
        this.corrHi.setPreferredSize(d);
        this.hiLabel = new JLabel("Corr High");
        this.corrStep = new JTextField("0.1");
        this.corrStep.setMaximumSize(d);
        this.corrStep.setMinimumSize(d);
        this.corrStep.setPreferredSize(d);
        this.stepLabel = new JLabel("Corr Step");
        this.advActive.setAlignmentX(0.5f);
        this.numFolds.setAlignmentX(0.5f);
        this.numXVal.setAlignmentX(0.5f);
        this.numBins.setAlignmentX(0.5f);
        this.deltaMax.setAlignmentX(0.5f);
        this.corrLo.setAlignmentX(0.5f);
        this.corrHi.setAlignmentX(0.5f);
        this.corrStep.setAlignmentX(0.5f);
        this.foldLabel.setForeground(Color.gray);
        this.binLabel.setForeground(Color.gray);
        this.xValLabel.setForeground(Color.gray);
        this.deltaLabel.setForeground(Color.gray);
        this.loLabel.setForeground(Color.gray);
        this.hiLabel.setForeground(Color.gray);
        this.stepLabel.setForeground(Color.gray);
        this.paramPanel.add(advLabel);
        this.paramPanel.add(this.advActive);
        this.paramPanel.add(this.foldLabel);
        this.paramPanel.add(this.numFolds);
        this.paramPanel.add(this.xValLabel);
        this.paramPanel.add(this.numXVal);
        this.paramPanel.add(this.binLabel);
        this.paramPanel.add(this.numBins);
        this.paramPanel.add(this.deltaLabel);
        this.paramPanel.add(this.deltaMax);
        this.paramPanel.add(this.loLabel);
        this.paramPanel.add(this.corrLo);
        this.paramPanel.add(this.hiLabel);
        this.paramPanel.add(this.corrHi);
        this.paramPanel.add(this.stepLabel);
        this.paramPanel.add(this.corrStep);
        SpringUtilities.makeCompactGrid(this.paramPanel, 8, 2, 0, 0, 10, 0);
        this.setParamEnabled(false);
    }

    private void setParamEnabled(boolean isEnabled) {
        if (isEnabled) {
            this.foldLabel.setForeground(Color.BLACK);
            this.xValLabel.setForeground(Color.BLACK);
            this.binLabel.setForeground(Color.BLACK);
            this.deltaLabel.setForeground(Color.BLACK);
            this.loLabel.setForeground(Color.BLACK);
            this.hiLabel.setForeground(Color.BLACK);
            this.stepLabel.setForeground(Color.BLACK);
        } else {
            this.foldLabel.setForeground(Color.GRAY);
            this.xValLabel.setForeground(Color.GRAY);
            this.binLabel.setForeground(Color.GRAY);
            this.deltaLabel.setForeground(Color.GRAY);
            this.loLabel.setForeground(Color.GRAY);
            this.hiLabel.setForeground(Color.GRAY);
            this.stepLabel.setForeground(Color.GRAY);
        }
        this.corrHi.setEnabled(isEnabled);
        this.corrLo.setEnabled(isEnabled);
        this.corrStep.setEnabled(isEnabled);
        this.numBins.setEnabled(isEnabled);
        this.deltaMax.setEnabled(isEnabled);
        this.numFolds.setEnabled(isEnabled);
        this.numXVal.setEnabled(isEnabled);
    }

    private void setAdvEnabled(boolean isEnabled) {
        if (isEnabled) {
            this.advActive.setEnabled(true);
            if (this.advActive.isSelected()) {
                this.setParamEnabled(true);
            } else {
                this.setParamEnabled(false);
            }
        } else {
            this.advActive.setEnabled(false);
            this.setParamEnabled(false);
        }
    }

    private void setLabelEnabled(boolean isEnabled) {
        this.numClasses.setEnabled(isEnabled);
        if (isEnabled) {
            this.numLabel.setForeground(Color.BLACK);
        } else {
            this.numLabel.setForeground(Color.GRAY);
        }
        for (int i = 0; i < this.vField.size(); ++i) {
            JTextField field = (JTextField)this.vField.elementAt(i);
            field.setEnabled(isEnabled);
            JLabel label = (JLabel)this.vLabel.elementAt(i);
            if (isEnabled) {
                label.setForeground(Color.BLACK);
                continue;
            }
            label.setForeground(Color.GRAY);
        }
    }

    private void numClassesChanged() {
        SpinnerNumberModel model = (SpinnerNumberModel)this.numClasses.getModel();
        int i = model.getNumber().intValue();
        if (i > this.vField.size()) {
            this.addFields(i - this.vField.size());
        } else if (i < this.vField.size()) {
            this.removeFields(this.vField.size() - i);
        }
    }

    private void addFields(int numToAdd) {
        int currentNum = this.vField.size();
        for (int i = 0; i < numToAdd; ++i) {
            int nextIndex = currentNum + i;
            JTextField field = new JTextField();
            field.setMaximumSize(this.dField);
            field.setMinimumSize(this.dField);
            field.setPreferredSize(this.dField);
            this.fieldPanel.add(field);
            JLabel label = new JLabel("Label " + (nextIndex + 1));
            label.setMaximumSize(this.dLabel);
            label.setMinimumSize(this.dLabel);
            label.setPreferredSize(this.dLabel);
            this.textPanel.add(label);
            this.vField.add(field);
            this.vLabel.add(label);
        }
        this.getRootPane().revalidate();
    }

    private void removeFields(int numToRemove) {
        int currentNum = this.vField.size();
        for (int i = 0; i < numToRemove; ++i) {
            JTextField field = (JTextField)this.vField.elementAt(currentNum - 1);
            JLabel label = (JLabel)this.vLabel.elementAt(currentNum - 1);
            this.fieldPanel.remove(field);
            this.textPanel.remove(label);
            this.vField.remove(field);
            this.vLabel.remove(label);
        }
        this.getRootPane().revalidate();
    }

    private boolean validateLabels() {
        boolean toReturn = true;
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < this.vField.size(); ++i) {
            JTextField field = (JTextField)this.vField.elementAt(i);
            if (field.getText() == null || field.getText().equals("")) {
                this.error("Please make sure every class has a valid Label");
                toReturn = false;
                break;
            }
            for (int j = 0; j < v.size(); ++j) {
                String s = (String)v.elementAt(j);
                if (!s.equalsIgnoreCase(field.getText())) continue;
                this.error("There is more than 1 class with the label - " + s);
                toReturn = false;
                break;
            }
            v.add(field.getText());
        }
        return toReturn;
    }

    public void error(String message) {
        JOptionPane.showMessageDialog(this, message, "Input Error", 0);
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public int getAnalysisOption() {
        if (this.trainClassify.isSelected()) {
            return TRAIN_THEN_CLASSIFY;
        }
        return CLASSIFY_FROM_FILE;
    }

    public int getNumClasses() {
        SpinnerNumberModel model = (SpinnerNumberModel)this.numClasses.getModel();
        return model.getNumber().intValue();
    }

    public int getFolds() {
        SpinnerNumberModel model = (SpinnerNumberModel)this.numFolds.getModel();
        return model.getNumber().intValue();
    }

    public int getXValRuns() {
        SpinnerNumberModel model = (SpinnerNumberModel)this.numXVal.getModel();
        return model.getNumber().intValue();
    }

    public int getNumBins() {
        SpinnerNumberModel model = (SpinnerNumberModel)this.numBins.getModel();
        return model.getNumber().intValue();
    }

    public int getDeltaMax() {
        SpinnerNumberModel model = (SpinnerNumberModel)this.deltaMax.getModel();
        return model.getNumber().intValue();
    }

    public double getCorrLo() {
        Double D = new Double(this.corrLo.getText());
        return D;
    }

    public double getCorrHi() {
        Double D = new Double(this.corrHi.getText());
        return D;
    }

    public double getCorrStep() {
        Double D = new Double(this.corrStep.getText());
        return D;
    }

    public String[] getClassLabels() {
        String[] toReturn = new String[this.vField.size() + 1];
        for (int i = 0; i < this.vField.size(); ++i) {
            JTextField field = (JTextField)this.vField.elementAt(i);
            toReturn[i] = field.getText();
        }
        toReturn[this.vField.size()] = ClassAssigner.TEST_CLASS_STRING;
        return toReturn;
    }

    private class Listener
    extends DialogListener
    implements ItemListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("ok-command")) {
                if (USCClassDialog.this.trainClassify.isSelected()) {
                    if (USCClassDialog.this.validateLabels()) {
                        USCClassDialog.this.result = 0;
                        USCClassDialog.this.dispose();
                    }
                } else {
                    USCClassDialog.this.result = 0;
                    USCClassDialog.this.dispose();
                }
            } else if (command.equals("cancel-command")) {
                USCClassDialog.this.result = 2;
                USCClassDialog.this.dispose();
            } else {
                if (command.equals("reset-command")) {
                    USCClassDialog.this.result = 2;
                    return;
                }
                if (command.equals("info-command")) {
                    HelpWindow.launchBrowser(USCClassDialog.this, "USC Initialization Dialog");
                }
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            USCClassDialog.this.result = -1;
            USCClassDialog.this.dispose();
        }
    }

    private class ButtonListener
    implements ItemListener {
        private ButtonListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == USCClassDialog.this.advActive) {
                if (e.getStateChange() == 2) {
                    USCClassDialog.this.setParamEnabled(false);
                } else if (e.getStateChange() == 1) {
                    USCClassDialog.this.setParamEnabled(true);
                }
            } else if (e.getSource() == USCClassDialog.this.trainClassify) {
                if (e.getStateChange() == 1) {
                    USCClassDialog.this.setLabelEnabled(true);
                    USCClassDialog.this.setAdvEnabled(true);
                }
            } else if (e.getSource() == USCClassDialog.this.fileClassify && e.getStateChange() == 1) {
                USCClassDialog.this.setLabelEnabled(false);
                USCClassDialog.this.setAdvEnabled(false);
            }
        }
    }

    private class SpinListener
    implements ChangeListener {
        private SpinListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            USCClassDialog.this.numClassesChanged();
        }
    }
}

