/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.usc;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.microarray.mev.r.ClassAssigner;

public class USCAssignLabel
extends AlgorithmDialog {
    private int result;
    private String[] userLabelArray;
    private JPanel mainPanel;
    private JButton loadButton;
    private JButton saveButton;
    private ClassAssigner ca;

    public USCAssignLabel(String[] hybArray, String[] labelArray) {
        super(new JFrame(), "USCAssignLabel", true);
        this.userLabelArray = labelArray;
        this.setSize(555, 600);
        this.initGUI(hybArray, labelArray);
        Listener l = new Listener();
        super.addWindowListener(l);
        super.setActionListeners(l);
    }

    private void initGUI(String[] hybs, String[] labels) {
        Dimension dLabel = new Dimension(350, 20);
        Dimension dCombo = new Dimension(150, 20);
        int iHyb = hybs.length;
        int iLabel = labels.length;
        JPanel selectionPanel = new JPanel(new SpringLayout());
        selectionPanel.setBorder(BorderFactory.createTitledBorder("Assign Labels"));
        this.ca = new ClassAssigner(hybs, labels, true, 3);
        this.mainPanel = new JPanel();
        this.mainPanel.add((Component)this.ca.getScrollPane(), "North");
        this.mainPanel.add((Component)this.createButtonPanel(), "South");
        this.addContent(this.mainPanel);
    }

    private JPanel createButtonPanel() {
        JPanel toReturn = new JPanel();
        toReturn.setLayout(new BoxLayout(toReturn, 0));
        Dimension dButton = new Dimension(150, 20);
        String title = "Assignments Files";
        Border greyLine = BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1);
        Font font11 = new Font("Arial", 0, 11);
        TitledBorder border = BorderFactory.createTitledBorder(greyLine, title, 4, 2, font11);
        toReturn.setBorder(border);
        this.loadButton = new JButton("Load Assignments");
        this.loadButton.setPreferredSize(dButton);
        this.saveButton = new JButton("Save Assignments");
        this.saveButton.setPreferredSize(dButton);
        AdvListener al = new AdvListener();
        this.loadButton.addActionListener(al);
        this.saveButton.addActionListener(al);
        toReturn.add(Box.createHorizontalGlue());
        toReturn.add(this.saveButton);
        toReturn.add(Box.createRigidArea(new Dimension(50, 20)));
        toReturn.add(this.loadButton);
        toReturn.add(Box.createHorizontalGlue());
        return toReturn;
    }

    private void error(String message) {
        JOptionPane.showMessageDialog(this, message, "Input Error", 0);
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public static void main(String[] args) {
        System.out.println("invoked by main()");
        String[] hybs = new String[]{"011101_16011521000000_S01_A01.txt", "011101_16011521000001_S01_A01.txt", "011101_16011521000002_S01_A01.txt", "011101_16011521000003_S01_A01.txt", "011101_16011521000004_S01_A01.txt", "011101_16011521000005_S01_A01.txt", "011101_16011521000006_S01_A01.txt", "011101_16011521000007_S01_A01.txt", "011101_16011521000008_S01_A01.txt", "011101_16011521000009_S01_A01.txt", "011101_16011521000010_S01_A01.txt"};
        String[] labels = new String[]{"tumor", "normal", "flu"};
        USCAssignLabel d = new USCAssignLabel(hybs, labels);
        d.showModal();
        System.exit(0);
    }

    public String[] getHybLabels() {
        String[] toReturn = new String[this.ca.getVComboBox().size()];
        for (int i = 0; i < this.ca.getVComboBox().size(); ++i) {
            toReturn[i] = this.ca.getSelectedString(i);
        }
        return toReturn;
    }

    private class Listener
    extends DialogListener
    implements ItemListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("ok-command")) {
                if (USCAssignLabel.this.ca.verifyLabeling()) {
                    USCAssignLabel.this.result = 0;
                    USCAssignLabel.this.dispose();
                }
            } else if (command.equals("cancel-command")) {
                USCAssignLabel.this.result = 2;
                USCAssignLabel.this.dispose();
            } else {
                if (command.equals("reset-command")) {
                    USCAssignLabel.this.result = 2;
                    return;
                }
                if (command.equals("info-command")) {
                    HelpWindow.launchBrowser(USCAssignLabel.this, "USC Assign Label Dialog");
                }
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            USCAssignLabel.this.result = -1;
            USCAssignLabel.this.dispose();
        }
    }

    private class AdvListener
    implements ActionListener {
        private AdvListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == USCAssignLabel.this.loadButton) {
                USCAssignLabel.this.ca.onLoadAssignments();
            } else if (source == USCAssignLabel.this.saveButton) {
                USCAssignLabel.this.ca.onSaveAssignments();
            }
        }
    }
}

