/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ttest;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.clusterUtil.Cluster;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterList;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterSelector;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.HCLSigOnlyPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.util.StringSplitter;

public class TtestInitDialog
extends AlgorithmDialog {
    GroupExperimentsPanel gPanel;
    OneClassPanel oPanel;
    TwoClassPairedMainPanel tcpmPanel;
    PValuePanel pPanel;
    SignificancePanel sPanel;
    HCLSigOnlyPanel hclOpsPanel;
    Vector<String> exptNames;
    JTabbedPane chooseDesignPane;
    JTabbedPane betweenSubsTab;
    JTabbedPane oneClassTab;
    JTextField oneClassClusterMean;
    DfCalcPanel dPanel;
    boolean lotsOfSamples = false;
    String lotsOfSamplesWarningText = "                                                Note: You can assign large numbers of samples quickly by using a saved text file.";
    public static final int GROUP_A = 1;
    public static final int GROUP_B = 2;
    public static final int NEITHER_GROUP = 3;
    public static final int JUST_ALPHA = 4;
    public static final int STD_BONFERRONI = 5;
    public static final int ADJ_BONFERRONI = 6;
    public static final int BETWEEN_SUBJECTS = 7;
    public static final int ONE_CLASS = 8;
    public static final int MAX_T = 9;
    public static final int MIN_P = 10;
    public static final int PAIRED = 11;
    public static final int FALSE_NUM = 12;
    public static final int FALSE_PROP = 13;
    public static final int CLUSTER_SELECTION = 14;
    public static final int ONE_CLASS_CLUSTER_SELECTION = 15;
    boolean okPressed = false;
    boolean permParamOkPressed = false;
    protected int userNumCombs = 0;
    protected boolean allCombsUsed = false;
    protected int allPossCombs;
    protected Color LABEL_COLOR = UIManager.getColor("Label.foreground");
    protected ClusterSelector clusterSelector;
    protected ClusterSelector oneClassSelector;
    protected ClusterRepository repository;
    boolean tooMany = false;
    int count;
    final int fileLoadMin = 20;

    public TtestInitDialog(JFrame parentFrame, boolean modality, Vector exptNames, ClusterRepository repository, String[] annotationLabels) {
        super(parentFrame, "TTEST: T-test", modality);
        this.exptNames = exptNames;
        this.repository = repository;
        this.setBounds(0, 0, 800, 850);
        this.setDefaultCloseOperation(2);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        JPanel pane = new JPanel();
        pane.setLayout(gridbag);
        if (exptNames.size() > 20) {
            this.lotsOfSamples = true;
        }
        this.chooseDesignPane = new JTabbedPane();
        this.sPanel = new SignificancePanel();
        this.pPanel = new PValuePanel();
        this.gPanel = new GroupExperimentsPanel(exptNames);
        this.count = 0;
        while (this.count < this.gPanel.groupARadioButtons.length) {
            this.gPanel.groupARadioButtons[this.count].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TtestInitDialog.this.pPanel.tDistButton.setSelected(true);
                    TtestInitDialog.this.sPanel.justAlphaButton.setSelected(true);
                    TtestInitDialog.this.sPanel.maxTButton.setSelected(false);
                    TtestInitDialog.this.sPanel.maxTButton.setEnabled(false);
                    TtestInitDialog.this.sPanel.minPButton.setSelected(false);
                    TtestInitDialog.this.sPanel.minPButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.randomGroupsButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.allCombsButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.timesField.setEnabled(false);
                    TtestInitDialog.this.pPanel.numCombsLabel.setText("                                                                            ");
                }
            });
            ++this.count;
        }
        this.count = 0;
        while (this.count < this.gPanel.groupBRadioButtons.length) {
            this.gPanel.groupBRadioButtons[this.count].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TtestInitDialog.this.pPanel.tDistButton.setSelected(true);
                    TtestInitDialog.this.sPanel.justAlphaButton.setSelected(true);
                    TtestInitDialog.this.sPanel.maxTButton.setSelected(false);
                    TtestInitDialog.this.sPanel.maxTButton.setEnabled(false);
                    TtestInitDialog.this.sPanel.minPButton.setSelected(false);
                    TtestInitDialog.this.sPanel.minPButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.randomGroupsButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.allCombsButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.timesField.setEnabled(false);
                    TtestInitDialog.this.pPanel.numCombsLabel.setText("                                                                            ");
                }
            });
            ++this.count;
        }
        this.count = 0;
        while (this.count < this.gPanel.neitherGroupRadioButtons.length) {
            this.gPanel.neitherGroupRadioButtons[this.count].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TtestInitDialog.this.pPanel.tDistButton.setSelected(true);
                    TtestInitDialog.this.sPanel.justAlphaButton.setSelected(true);
                    TtestInitDialog.this.sPanel.maxTButton.setSelected(false);
                    TtestInitDialog.this.sPanel.maxTButton.setEnabled(false);
                    TtestInitDialog.this.sPanel.minPButton.setSelected(false);
                    TtestInitDialog.this.sPanel.minPButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.randomGroupsButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.allCombsButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.timesField.setEnabled(false);
                    TtestInitDialog.this.pPanel.numCombsLabel.setText("                                                                            ");
                }
            });
            ++this.count;
        }
        this.count = 0;
        this.oPanel = new OneClassPanel();
        for (int i = 0; i < this.oPanel.includeExpts.length; ++i) {
            this.oPanel.includeExpts[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TtestInitDialog.this.pPanel.tDistButton.setSelected(true);
                    TtestInitDialog.this.sPanel.justAlphaButton.setSelected(true);
                    TtestInitDialog.this.sPanel.maxTButton.setSelected(false);
                    TtestInitDialog.this.sPanel.maxTButton.setEnabled(false);
                    TtestInitDialog.this.sPanel.minPButton.setSelected(false);
                    TtestInitDialog.this.sPanel.minPButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.randomGroupsButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.allCombsButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.timesField.setEnabled(false);
                    TtestInitDialog.this.pPanel.numCombsLabel.setText("                                                                            ");
                }
            });
        }
        JLabel meanLabel = new JLabel("Enter the mean value to be tested against: ");
        JPanel oneClassPanel = new JPanel();
        oneClassPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        this.oneClassClusterMean = new JTextField("0", 7);
        this.oneClassClusterMean.setSize(15, this.oneClassClusterMean.getHeight());
        this.oneClassSelector = new ClusterSelector(repository, 1);
        oneClassPanel.add((Component)meanLabel, c);
        c.gridx = 1;
        oneClassPanel.add((Component)this.oneClassClusterMean, c);
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.anchor = 20;
        oneClassPanel.add((Component)this.oneClassSelector, c);
        this.oneClassTab = new JTabbedPane();
        this.oneClassTab.add("Button Selection", this.oPanel);
        this.oneClassTab.add("Cluster Selection", oneClassPanel);
        this.oneClassTab.setSelectedIndex(1);
        if (repository == null || repository.isEmpty()) {
            this.oneClassTab.setSelectedIndex(0);
        }
        this.oneClassTab.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TtestInitDialog.this.pPanel.tDistButton.setSelected(true);
                TtestInitDialog.this.sPanel.justAlphaButton.setSelected(true);
                TtestInitDialog.this.sPanel.maxTButton.setSelected(false);
                TtestInitDialog.this.sPanel.maxTButton.setEnabled(false);
                TtestInitDialog.this.sPanel.minPButton.setSelected(false);
                TtestInitDialog.this.sPanel.minPButton.setEnabled(false);
                TtestInitDialog.this.pPanel.allCombsButton.setEnabled(false);
                TtestInitDialog.this.pPanel.randomGroupsButton.setEnabled(false);
                TtestInitDialog.this.pPanel.numCombsLabel.setForeground(Color.black);
                TtestInitDialog.this.pPanel.numCombsLabel.setText("");
                TtestInitDialog.this.pPanel.timesField.setEnabled(false);
                if (TtestInitDialog.this.getTestDesign() == 8) {
                    TtestInitDialog.this.pPanel.numCombsLabel.setForeground(Color.black);
                    TtestInitDialog.this.pPanel.numCombsLabel.setText("");
                }
            }
        });
        this.chooseDesignPane.add("One Class", this.oneClassTab);
        this.betweenSubsTab = new JTabbedPane();
        this.betweenSubsTab.add("Button Selection", this.gPanel);
        this.clusterSelector = new ClusterSelector(repository, 2);
        this.betweenSubsTab.add("Cluster Selection", (Component)this.clusterSelector);
        this.betweenSubsTab.setSelectedIndex(1);
        if (repository == null || repository.isEmpty()) {
            this.betweenSubsTab.setSelectedIndex(0);
        }
        this.betweenSubsTab.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TtestInitDialog.this.pPanel.tDistButton.setSelected(true);
                TtestInitDialog.this.sPanel.justAlphaButton.setSelected(true);
                TtestInitDialog.this.sPanel.maxTButton.setSelected(false);
                TtestInitDialog.this.sPanel.maxTButton.setEnabled(false);
                TtestInitDialog.this.sPanel.minPButton.setSelected(false);
                TtestInitDialog.this.sPanel.minPButton.setEnabled(false);
                TtestInitDialog.this.pPanel.allCombsButton.setEnabled(false);
                TtestInitDialog.this.pPanel.randomGroupsButton.setEnabled(false);
                TtestInitDialog.this.pPanel.numCombsLabel.setForeground(Color.black);
                TtestInitDialog.this.pPanel.numCombsLabel.setText("");
                TtestInitDialog.this.pPanel.timesField.setEnabled(false);
                if (TtestInitDialog.this.getTestDesign() == 8) {
                    TtestInitDialog.this.pPanel.numCombsLabel.setForeground(Color.black);
                    TtestInitDialog.this.pPanel.numCombsLabel.setText("");
                }
            }
        });
        this.chooseDesignPane.add("Between subjects", this.betweenSubsTab);
        this.tcpmPanel = new TwoClassPairedMainPanel();
        this.chooseDesignPane.add("Paired", this.tcpmPanel);
        this.pPanel.tDistButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TtestInitDialog.this.sPanel.justAlphaButton.setSelected(true);
                TtestInitDialog.this.sPanel.maxTButton.setSelected(false);
                TtestInitDialog.this.sPanel.maxTButton.setEnabled(false);
                TtestInitDialog.this.sPanel.minPButton.setSelected(false);
                TtestInitDialog.this.sPanel.minPButton.setEnabled(false);
                TtestInitDialog.this.sPanel.falseNumButton.setEnabled(false);
                TtestInitDialog.this.sPanel.falsePropButton.setEnabled(false);
                TtestInitDialog.this.sPanel.calcFDRPVals.setEnabled(false);
                TtestInitDialog.this.sPanel.fastFDRButton.setEnabled(false);
                TtestInitDialog.this.sPanel.slowFDRButton.setEnabled(false);
                TtestInitDialog.this.sPanel.falseNumField.setEnabled(false);
                TtestInitDialog.this.sPanel.falsePropField.setEnabled(false);
            }
        });
        this.pPanel.permutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (evt.getSource() == TtestInitDialog.this.pPanel.permutButton) {
                    TtestInitDialog.this.sPanel.maxTButton.setEnabled(true);
                    TtestInitDialog.this.sPanel.falseNumButton.setEnabled(true);
                    TtestInitDialog.this.sPanel.falsePropButton.setEnabled(true);
                    TtestInitDialog.this.sPanel.fastFDRButton.setEnabled(true);
                    TtestInitDialog.this.sPanel.falseNumField.setEnabled(true);
                    TtestInitDialog.this.sPanel.falsePropField.setEnabled(true);
                    if (TtestInitDialog.this.getTestDesign() == 7 || TtestInitDialog.this.getTestDesign() == 14) {
                        int[] grpAssignments = TtestInitDialog.this.getGroupAssignments();
                        if (TtestInitDialog.this.getTestDesign() == 14) {
                            grpAssignments = TtestInitDialog.this.getClusterGroupAssignments();
                        }
                        int grpACounter = 0;
                        int grpBCounter = 0;
                        for (int i = 0; i < grpAssignments.length; ++i) {
                            if (grpAssignments[i] == 1) {
                                ++grpACounter;
                                continue;
                            }
                            if (grpAssignments[i] != 2) continue;
                            ++grpBCounter;
                        }
                        if (grpACounter < 2 || grpBCounter < 2) {
                            TtestInitDialog.this.pPanel.numCombsLabel.setForeground(Color.red);
                            TtestInitDialog.this.pPanel.numCombsLabel.setText("Error! Group A and Group B must each contain more than one sample");
                        } else {
                            int numCombs = 0;
                            TtestInitDialog.this.pPanel.numCombsLabel.setForeground(Color.black);
                            TtestInitDialog.this.pPanel.numCombsLabel.setText("There are too many unique permutations                                  ");
                            TtestInitDialog.this.pPanel.allCombsButton.setEnabled(false);
                            TtestInitDialog.this.pPanel.randomGroupsButton.setEnabled(true);
                            TtestInitDialog.this.pPanel.randomGroupsButton.setSelected(true);
                            TtestInitDialog.this.pPanel.timesField.setEnabled(true);
                            TtestInitDialog.this.pPanel.timesField.setBackground(Color.white);
                            TtestInitDialog.this.pPanel.timesField.setText("100");
                            if (grpACounter + grpBCounter <= 20) {
                                numCombs = TtestInitDialog.this.getNumCombs(grpACounter + grpBCounter, grpACounter);
                                TtestInitDialog.this.pPanel.numCombsLabel.setForeground(Color.black);
                                TtestInitDialog.this.pPanel.numCombsLabel.setText("There are " + numCombs + " unique permutations                                ");
                                TtestInitDialog.this.allPossCombs = numCombs;
                                TtestInitDialog.this.pPanel.allCombsButton.setEnabled(true);
                                TtestInitDialog.this.pPanel.randomGroupsButton.setEnabled(true);
                            }
                        }
                    } else if (TtestInitDialog.this.getTestDesign() == 8 || TtestInitDialog.this.getTestDesign() == 15) {
                        TtestInitDialog.this.pPanel.numCombsLabel.setForeground(Color.black);
                        int validNum = TtestInitDialog.this.getNumValidOneClassExpts();
                        if (validNum <= 1) {
                            TtestInitDialog.this.pPanel.numCombsLabel.setForeground(Color.red);
                            TtestInitDialog.this.pPanel.numCombsLabel.setText("Error! Choose at least two samples");
                            TtestInitDialog.this.pPanel.randomGroupsButton.setEnabled(false);
                            TtestInitDialog.this.pPanel.timesField.setBackground(Color.gray);
                            TtestInitDialog.this.pPanel.timesField.setEnabled(false);
                        } else if (validNum <= 29) {
                            TtestInitDialog.this.pPanel.numCombsLabel.setText("There are " + (int)Math.pow(2.0, validNum) + " possible combinations                    ");
                            TtestInitDialog.this.pPanel.randomGroupsButton.setEnabled(true);
                            TtestInitDialog.this.pPanel.allCombsButton.setEnabled(true);
                            TtestInitDialog.this.pPanel.timesField.setBackground(Color.white);
                            TtestInitDialog.this.pPanel.timesField.setEnabled(true);
                        } else {
                            TtestInitDialog.this.pPanel.numCombsLabel.setText("There are too many unique combinations                                       ");
                            TtestInitDialog.this.pPanel.timesField.setBackground(Color.white);
                            TtestInitDialog.this.pPanel.timesField.setEnabled(true);
                            TtestInitDialog.this.pPanel.randomGroupsButton.setEnabled(true);
                            TtestInitDialog.this.pPanel.randomGroupsButton.setSelected(true);
                        }
                    } else if (TtestInitDialog.this.getTestDesign() == 11) {
                        if (TtestInitDialog.this.tcpmPanel.tcpPanel.pairedListModel.size() < 2) {
                            JOptionPane.showMessageDialog(null, "Need at least two pairs of samples!", "Error", 0);
                        } else if (TtestInitDialog.this.tcpmPanel.tcpPanel.pairedListModel.size() <= 29) {
                            TtestInitDialog.this.pPanel.numCombsLabel.setText("There are " + (int)Math.pow(2.0, TtestInitDialog.this.tcpmPanel.tcpPanel.pairedListModel.size()) + " possible combinations                    ");
                            TtestInitDialog.this.pPanel.randomGroupsButton.setEnabled(true);
                            TtestInitDialog.this.pPanel.allCombsButton.setEnabled(true);
                            TtestInitDialog.this.pPanel.timesField.setBackground(Color.white);
                            TtestInitDialog.this.pPanel.timesField.setEnabled(true);
                        } else {
                            TtestInitDialog.this.pPanel.numCombsLabel.setText("There are too many unique combinations                                       ");
                            TtestInitDialog.this.pPanel.timesField.setBackground(Color.white);
                            TtestInitDialog.this.pPanel.timesField.setEnabled(true);
                            TtestInitDialog.this.pPanel.randomGroupsButton.setEnabled(true);
                            TtestInitDialog.this.pPanel.randomGroupsButton.setSelected(true);
                        }
                    }
                }
            }
        });
        this.chooseDesignPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TtestInitDialog.this.pPanel.tDistButton.setSelected(true);
                TtestInitDialog.this.sPanel.justAlphaButton.setSelected(true);
                TtestInitDialog.this.sPanel.maxTButton.setSelected(false);
                TtestInitDialog.this.sPanel.maxTButton.setEnabled(false);
                TtestInitDialog.this.sPanel.minPButton.setSelected(false);
                TtestInitDialog.this.sPanel.minPButton.setEnabled(false);
                TtestInitDialog.this.pPanel.allCombsButton.setEnabled(false);
                TtestInitDialog.this.pPanel.randomGroupsButton.setEnabled(false);
                TtestInitDialog.this.pPanel.numCombsLabel.setForeground(Color.black);
                TtestInitDialog.this.pPanel.numCombsLabel.setText("");
                TtestInitDialog.this.pPanel.timesField.setEnabled(false);
                if (TtestInitDialog.this.getTestDesign() == 8) {
                    TtestInitDialog.this.pPanel.numCombsLabel.setForeground(Color.black);
                    TtestInitDialog.this.pPanel.numCombsLabel.setText("");
                }
            }
        });
        JTabbedPane bigTabbedPane = new JTabbedPane();
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 100);
        gridbag.setConstraints(this.chooseDesignPane, constraints);
        pane.add(this.chooseDesignPane);
        this.dPanel = new DfCalcPanel();
        bigTabbedPane.add("Variance Assumption", this.dPanel);
        bigTabbedPane.add("P-Value Parameters", this.pPanel);
        bigTabbedPane.add("P-Value/ False Discovery Corrections", this.sPanel);
        this.hclOpsPanel = new HCLSigOnlyPanel();
        bigTabbedPane.add("Hierarchical Clustering", this.hclOpsPanel);
        constraints.gridy = 1;
        constraints.weighty = 0.0;
        pane.add((Component)bigTabbedPane, constraints);
        this.addContent(pane);
        EventListener listener = new EventListener();
        this.setActionListeners(listener);
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return 0;
    }

    @Override
    public void setVisible(boolean visible) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        super.setVisible(visible);
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    protected long factorial(int n) {
        if (n == 1 || n == 0) {
            return 1L;
        }
        return this.factorial(n - 1) * (long)n;
    }

    protected int getNumCombs(int n, int k) {
        return Math.round(this.factorial(n) / (this.factorial(k) * this.factorial(n - k)));
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public boolean isDrawTrees() {
        return this.hclOpsPanel.isHCLSelected();
    }

    public boolean drawSigTreesOnly() {
        return this.hclOpsPanel.drawSigTreesOnly();
    }

    public int getTestDesign() {
        int design = -1;
        if (this.chooseDesignPane.getSelectedIndex() == 0) {
            design = this.oneClassTab.getSelectedIndex() == 0 ? 8 : 15;
        } else if (this.chooseDesignPane.getSelectedIndex() == 1) {
            design = this.betweenSubsTab.getSelectedIndex() == 0 ? 7 : 14;
        } else if (this.chooseDesignPane.getSelectedIndex() == 2) {
            design = 11;
        }
        return design;
    }

    public int[] getGroupAssignments() {
        int[] groupAssignments = new int[this.exptNames.size()];
        for (int i = 0; i < this.exptNames.size(); ++i) {
            groupAssignments[i] = this.gPanel.groupARadioButtons[i].isSelected() ? 1 : (this.gPanel.groupBRadioButtons[i].isSelected() ? 2 : 3);
        }
        return groupAssignments;
    }

    public int[] getClusterGroupAssignments() {
        int[] groupAssignments = new int[this.exptNames.size()];
        ArrayList groupAsamps = this.clusterSelector.getGroupSamples("Group 1");
        ArrayList groupBsamps = this.clusterSelector.getGroupSamples("Group 2");
        int toWhich = 0;
        boolean chosen = false;
        for (int i = 0; i < this.exptNames.size(); ++i) {
            boolean doubleAssigned = false;
            groupAssignments[i] = 3;
            if (groupAsamps.contains(i)) {
                groupAssignments[i] = 1;
                doubleAssigned = true;
            }
            if (!groupBsamps.contains(i)) continue;
            groupAssignments[i] = 2;
            if (!doubleAssigned) continue;
            if (!chosen) {
                Object[] optionst = new Object[]{"GROUP 1", "GROUP 2", "NEITHER", "CANCEL"};
                int option = JOptionPane.showOptionDialog(null, "The clusters you have chosen have overlapping samples. \n Which group should these samples be added to?", "Multiple Ownership Error", 1, 3, null, optionst, optionst[0]);
                if (option == 0) {
                    groupAssignments[i] = 1;
                }
                if (option == 1) {
                    groupAssignments[i] = 2;
                }
                if (option == 2) {
                    groupAssignments[i] = 3;
                }
                if (option == 3) {
                    return null;
                }
                toWhich = groupAssignments[i];
                chosen = true;
                continue;
            }
            groupAssignments[i] = toWhich;
        }
        return groupAssignments;
    }

    public boolean isPermut() {
        return this.pPanel.permutButton.isSelected();
    }

    public int getUserNumCombs() {
        String s1 = this.pPanel.timesField.getText();
        int num = 0;
        if (!this.useAllCombs()) {
            num = Integer.parseInt(s1);
        } else if (this.getTestDesign() == 7) {
            num = this.allPossCombs;
        } else if (this.getTestDesign() == 8) {
            num = (int)Math.pow(2.0, this.getNumValidOneClassExpts());
        } else if (this.getTestDesign() == 11) {
            num = (int)Math.pow(2.0, this.tcpmPanel.tcpPanel.pairedListModel.size());
        }
        return num;
    }

    public double getAlphaValue() {
        String s1 = this.pPanel.alphaInputField.getText();
        return Double.parseDouble(s1);
    }

    public int[] getOneClassAssignments() {
        int[] oneClassAssignments = new int[this.oPanel.includeExpts.length];
        for (int i = 0; i < oneClassAssignments.length; ++i) {
            oneClassAssignments[i] = this.oPanel.includeExpts[i].isSelected() ? 1 : 0;
        }
        return oneClassAssignments;
    }

    public int[] getOneClassClusterAssignments() {
        ArrayList groupAsamps = this.oneClassSelector.getGroupSamples("Group 1");
        int[] groupAssignments = new int[this.exptNames.size()];
        for (int i = 0; i < this.exptNames.size(); ++i) {
            groupAssignments[i] = 3;
            if (!groupAsamps.contains(i)) continue;
            groupAssignments[i] = 1;
        }
        return groupAssignments;
    }

    public int getNumValidOneClassExpts() {
        int validNum = 0;
        int[] oca = this.getOneClassAssignments();
        for (int i = 0; i < oca.length; ++i) {
            if (oca[i] != 1) continue;
            ++validNum;
        }
        return validNum;
    }

    public double getOneClassMean() {
        return Double.parseDouble(this.oPanel.meanField.getText());
    }

    public double getOneClassClusterMean() {
        return Double.parseDouble(this.oneClassClusterMean.getText());
    }

    public int getFalseNum() {
        return Integer.parseInt(this.sPanel.falseNumField.getText());
    }

    public double getFalseProp() {
        return Double.parseDouble(this.sPanel.falsePropField.getText());
    }

    public boolean validateAlpha(String alpha) {
        float a;
        try {
            a = Float.parseFloat(alpha);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "Alpha value is not a valid input value.", "Input Error", 2);
            this.pPanel.alphaInputField.requestFocus();
            this.pPanel.alphaInputField.selectAll();
            return false;
        }
        if (a <= 0.0f || a >= 1.0f) {
            JOptionPane.showMessageDialog(this, "Alpha value must be > 0 and < 1.0", "Input Error", 2);
            this.pPanel.alphaInputField.requestFocus();
            this.pPanel.alphaInputField.selectAll();
            return false;
        }
        return true;
    }

    public boolean validateFalseNum() {
        int a;
        try {
            String falseNum = this.sPanel.falseNumField.getText();
            a = Integer.parseInt(falseNum);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "False number must be an integer >= 0", "Input Error", 2);
            this.sPanel.falseNumField.requestFocus();
            this.sPanel.falseNumField.selectAll();
            return false;
        }
        if (a < 0) {
            JOptionPane.showMessageDialog(this, "False number must be an integer >= 0", "Input Error", 2);
            this.sPanel.falseNumField.requestFocus();
            this.sPanel.falseNumField.selectAll();
            return false;
        }
        return true;
    }

    public boolean validateFalseProp() {
        float a;
        try {
            String falseProp = this.sPanel.falsePropField.getText();
            a = Float.parseFloat(falseProp);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "False proportion must be between 0 and 1", "Input Error", 2);
            this.sPanel.falsePropField.requestFocus();
            this.sPanel.falsePropField.selectAll();
            return false;
        }
        if (a <= 0.0f || a > 1.0f) {
            JOptionPane.showMessageDialog(this, "False proportion must be between 0 and 1", "Input Error", 2);
            this.sPanel.falsePropField.requestFocus();
            this.sPanel.falsePropField.selectAll();
            return false;
        }
        return true;
    }

    public boolean validatePermutations(String n) {
        int i;
        try {
            i = Integer.parseInt(n);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "Number of Permutations is not a valid input value.", "Input Error", 2);
            this.pPanel.timesField.requestFocus();
            this.pPanel.timesField.selectAll();
            return false;
        }
        if (i <= 0) {
            JOptionPane.showMessageDialog(this, "Number of Permutations must be > 0", "Input Error", 2);
            this.pPanel.timesField.requestFocus();
            this.pPanel.timesField.selectAll();
            return false;
        }
        return true;
    }

    public Vector getPairedAExpts() {
        return this.tcpmPanel.tcpPanel.pairedAExpts;
    }

    public Vector getPairedBExpts() {
        return this.tcpmPanel.tcpPanel.pairedBExpts;
    }

    public int getSignificanceMethod() {
        if (this.sPanel.justAlphaButton.isSelected()) {
            return 4;
        }
        if (this.sPanel.stdBonfButton.isSelected()) {
            return 5;
        }
        if (this.sPanel.adjBonfButton.isSelected()) {
            return 6;
        }
        if (this.sPanel.maxTButton.isSelected()) {
            return 9;
        }
        if (this.sPanel.minPButton.isSelected()) {
            return 10;
        }
        if (this.sPanel.falseNumButton.isSelected()) {
            return 12;
        }
        if (this.sPanel.falsePropButton.isSelected()) {
            return 13;
        }
        return -1;
    }

    public Cluster getSelectedClusterA() {
        return this.clusterSelector.getSelectedCluster();
    }

    public boolean calculateFDRPVals() {
        return this.sPanel.calcFDRPVals.isSelected();
    }

    public boolean doFastFDRApprox() {
        return this.sPanel.fastFDRButton.isSelected();
    }

    public boolean useWelchDf() {
        return this.dPanel.welchButton.isSelected();
    }

    public boolean useAllCombs() {
        return this.pPanel.allCombsButton.isSelected();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Test");
        Vector<String> dummyVect = new Vector<String>();
        for (int i = 0; i < 24; ++i) {
            dummyVect.add("Expt " + i);
        }
        ClusterList[] cl = new ClusterList[1];
        ClusterRepository cr = new ClusterRepository(0);
        TtestInitDialog dialog = new TtestInitDialog(frame, true, dummyVect, null, new String[]{"sample 1", "sample 2"});
        if (dialog.showModal() != 0) {
            System.exit(0);
        }
        System.out.println("===============================");
    }

    public class EventListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            String command = ae.getActionCommand();
            if (command.equals("ok-command")) {
                String iter;
                String alpha;
                if (TtestInitDialog.this.getTestDesign() == 14 || TtestInitDialog.this.getTestDesign() == 15) {
                    if (TtestInitDialog.this.repository == null || TtestInitDialog.this.repository.isEmpty()) {
                        JOptionPane.showMessageDialog(new JPanel(), "Sample cluster repository is empty", "Error", 2);
                        return;
                    }
                    alpha = TtestInitDialog.this.pPanel.alphaInputField.getText();
                    if (TtestInitDialog.this.pPanel.permutButton.isSelected() && TtestInitDialog.this.pPanel.randomGroupsButton.isSelected() && !TtestInitDialog.this.validatePermutations(iter = TtestInitDialog.this.pPanel.timesField.getText())) {
                        TtestInitDialog.this.okPressed = false;
                        return;
                    }
                    if (!TtestInitDialog.this.validateAlpha(alpha)) {
                        TtestInitDialog.this.okPressed = false;
                        return;
                    }
                    if (TtestInitDialog.this.sPanel.falseNumButton.isSelected() && !TtestInitDialog.this.validateFalseNum()) {
                        TtestInitDialog.this.okPressed = false;
                        return;
                    }
                    if (TtestInitDialog.this.sPanel.falsePropButton.isSelected() && !TtestInitDialog.this.validateFalseProp()) {
                        TtestInitDialog.this.okPressed = false;
                        return;
                    }
                    TtestInitDialog.this.okPressed = true;
                    TtestInitDialog.this.dispose();
                }
                if (TtestInitDialog.this.getTestDesign() == 15) {
                    String iter2;
                    try {
                        Float.parseFloat(TtestInitDialog.this.oneClassClusterMean.getText());
                    }
                    catch (NumberFormatException nfe) {
                        JOptionPane.showMessageDialog(TtestInitDialog.this.oPanel, "Invalid value entered for mean", "Error", 2);
                        TtestInitDialog.this.okPressed = false;
                        return;
                    }
                    if (TtestInitDialog.this.repository == null) {
                        JOptionPane.showMessageDialog(new JPanel(), "Sample cluster repository is empty", "Error", 2);
                        return;
                    }
                    alpha = TtestInitDialog.this.pPanel.alphaInputField.getText();
                    if (TtestInitDialog.this.pPanel.permutButton.isSelected() && TtestInitDialog.this.pPanel.randomGroupsButton.isSelected() && !TtestInitDialog.this.validatePermutations(iter2 = TtestInitDialog.this.pPanel.timesField.getText())) {
                        TtestInitDialog.this.okPressed = false;
                        return;
                    }
                    if (!TtestInitDialog.this.validateAlpha(alpha)) {
                        TtestInitDialog.this.okPressed = false;
                        return;
                    }
                    if (TtestInitDialog.this.sPanel.falseNumButton.isSelected() && !TtestInitDialog.this.validateFalseNum()) {
                        TtestInitDialog.this.okPressed = false;
                        return;
                    }
                    if (TtestInitDialog.this.sPanel.falsePropButton.isSelected() && !TtestInitDialog.this.validateFalseProp()) {
                        TtestInitDialog.this.okPressed = false;
                        return;
                    }
                    TtestInitDialog.this.okPressed = true;
                    TtestInitDialog.this.dispose();
                }
                if (TtestInitDialog.this.getTestDesign() == 7) {
                    int[] grpAssignments = TtestInitDialog.this.getGroupAssignments();
                    int grpACounter = 0;
                    int grpBCounter = 0;
                    for (int i = 0; i < grpAssignments.length; ++i) {
                        if (grpAssignments[i] == 1) {
                            ++grpACounter;
                            continue;
                        }
                        if (grpAssignments[i] != 2) continue;
                        ++grpBCounter;
                    }
                    if (grpACounter < 2 || grpBCounter < 2) {
                        JOptionPane.showMessageDialog(TtestInitDialog.this.gPanel, "Group A and Group B must each contain more than one sample", "Error", 2);
                    } else {
                        String iter3;
                        String alpha2 = TtestInitDialog.this.pPanel.alphaInputField.getText();
                        if (TtestInitDialog.this.pPanel.permutButton.isSelected() && TtestInitDialog.this.pPanel.randomGroupsButton.isSelected() && !TtestInitDialog.this.validatePermutations(iter3 = TtestInitDialog.this.pPanel.timesField.getText())) {
                            TtestInitDialog.this.okPressed = false;
                            return;
                        }
                        if (!TtestInitDialog.this.validateAlpha(alpha2)) {
                            TtestInitDialog.this.okPressed = false;
                            return;
                        }
                        if (TtestInitDialog.this.sPanel.falseNumButton.isSelected() && !TtestInitDialog.this.validateFalseNum()) {
                            TtestInitDialog.this.okPressed = false;
                            return;
                        }
                        if (TtestInitDialog.this.sPanel.falsePropButton.isSelected() && !TtestInitDialog.this.validateFalseProp()) {
                            TtestInitDialog.this.okPressed = false;
                            return;
                        }
                        TtestInitDialog.this.okPressed = true;
                        TtestInitDialog.this.hide();
                        TtestInitDialog.this.dispose();
                    }
                } else if (TtestInitDialog.this.getTestDesign() == 8) {
                    try {
                        float mean = Float.parseFloat(TtestInitDialog.this.oPanel.meanField.getText());
                    }
                    catch (NumberFormatException nfe) {
                        JOptionPane.showMessageDialog(TtestInitDialog.this.oPanel, "Invalid value entered for mean", "Error", 2);
                        TtestInitDialog.this.okPressed = false;
                        return;
                    }
                    if (TtestInitDialog.this.getNumValidOneClassExpts() < 2) {
                        JOptionPane.showMessageDialog(TtestInitDialog.this.oPanel, "Select at least two samples", "Error", 2);
                        TtestInitDialog.this.okPressed = false;
                        return;
                    }
                    String alpha3 = TtestInitDialog.this.pPanel.alphaInputField.getText();
                    if (TtestInitDialog.this.pPanel.permutButton.isSelected() && TtestInitDialog.this.pPanel.randomGroupsButton.isSelected() && !TtestInitDialog.this.validatePermutations(iter = TtestInitDialog.this.pPanel.timesField.getText())) {
                        TtestInitDialog.this.okPressed = false;
                        return;
                    }
                    if (!TtestInitDialog.this.validateAlpha(alpha3)) {
                        TtestInitDialog.this.okPressed = false;
                        return;
                    }
                    if (TtestInitDialog.this.sPanel.falseNumButton.isSelected() && !TtestInitDialog.this.validateFalseNum()) {
                        TtestInitDialog.this.okPressed = false;
                        return;
                    }
                    if (TtestInitDialog.this.sPanel.falsePropButton.isSelected() && !TtestInitDialog.this.validateFalseProp()) {
                        TtestInitDialog.this.okPressed = false;
                        return;
                    }
                    TtestInitDialog.this.okPressed = true;
                    TtestInitDialog.this.hide();
                    TtestInitDialog.this.dispose();
                } else if (TtestInitDialog.this.getTestDesign() == 11) {
                    if (TtestInitDialog.this.tcpmPanel.tcpPanel.pairedListModel.size() < 2) {
                        JOptionPane.showMessageDialog(null, "Need at least two pairs of samples!", "Error", 0);
                    } else {
                        if (TtestInitDialog.this.tcpmPanel.tcpPanel.pairedListModel.size() <= 29) {
                            int numCombs = TtestInitDialog.this.getUserNumCombs();
                            int numUniquePerms = (int)Math.pow(2.0, TtestInitDialog.this.tcpmPanel.tcpPanel.pairedListModel.size());
                        }
                        String alpha4 = TtestInitDialog.this.pPanel.alphaInputField.getText();
                        if (TtestInitDialog.this.pPanel.permutButton.isSelected() && TtestInitDialog.this.pPanel.randomGroupsButton.isSelected() && !TtestInitDialog.this.validatePermutations(iter = TtestInitDialog.this.pPanel.timesField.getText())) {
                            TtestInitDialog.this.okPressed = false;
                            return;
                        }
                        if (!TtestInitDialog.this.validateAlpha(alpha4)) {
                            TtestInitDialog.this.okPressed = false;
                            return;
                        }
                        if (TtestInitDialog.this.sPanel.falseNumButton.isSelected() && !TtestInitDialog.this.validateFalseNum()) {
                            TtestInitDialog.this.okPressed = false;
                            return;
                        }
                        if (TtestInitDialog.this.sPanel.falsePropButton.isSelected() && !TtestInitDialog.this.validateFalseProp()) {
                            TtestInitDialog.this.okPressed = false;
                            return;
                        }
                        TtestInitDialog.this.okPressed = true;
                        UIManager.put("TabbedPane.selected", Color.lightGray);
                        TtestInitDialog.this.dispose();
                    }
                }
            } else if (command.equals("reset-command")) {
                if (TtestInitDialog.this.getTestDesign() == 7) {
                    TtestInitDialog.this.gPanel.reset();
                } else if (TtestInitDialog.this.getTestDesign() == 8) {
                    TtestInitDialog.this.oPanel.reset();
                } else if (TtestInitDialog.this.getTestDesign() == 11) {
                    TtestInitDialog.this.tcpmPanel.tcpPanel.reset();
                }
                TtestInitDialog.this.pPanel.tDistButton.setSelected(true);
                TtestInitDialog.this.pPanel.randomGroupsButton.setEnabled(false);
                TtestInitDialog.this.pPanel.allCombsButton.setEnabled(false);
                TtestInitDialog.this.pPanel.timesField.setEnabled(false);
                TtestInitDialog.this.pPanel.timesField.setBackground(Color.white);
                TtestInitDialog.this.pPanel.timesField.setText("100");
                TtestInitDialog.this.pPanel.numCombsLabel.setText("                                                                            ");
                TtestInitDialog.this.pPanel.alphaInputField.setText("0.01");
                TtestInitDialog.this.sPanel.justAlphaButton.setSelected(true);
                TtestInitDialog.this.sPanel.falseNumField.setText("10");
                TtestInitDialog.this.sPanel.falsePropField.setText("0.05");
                TtestInitDialog.this.hclOpsPanel.setHCLSelected(false);
                TtestInitDialog.this.dPanel.reset();
            } else if (command.equals("cancel-command")) {
                TtestInitDialog.this.okPressed = false;
                TtestInitDialog.this.setVisible(false);
                TtestInitDialog.this.dispose();
            } else if (command.equals("info-command")) {
                HelpWindow.launchBrowser(TtestInitDialog.this, "TTEST Initialization Dialog");
            }
        }
    }

    class DfCalcPanel
    extends JPanel {
        JRadioButton welchButton;
        JRadioButton eqVarButton;

        DfCalcPanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(), "Variance assumption (for between subjects t-test only)"));
            this.setBackground(Color.white);
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(gridbag);
            this.welchButton = new JRadioButton("Welch approximation (unequal group variances)", true);
            this.welchButton.setBackground(Color.white);
            this.eqVarButton = new JRadioButton("Assume equal group variances", false);
            this.eqVarButton.setBackground(Color.white);
            ButtonGroup group = new ButtonGroup();
            group.add(this.welchButton);
            group.add(this.eqVarButton);
            TtestInitDialog.this.buildConstraints(constraints, 0, 0, 1, 1, 50, 100);
            gridbag.setConstraints(this.welchButton, constraints);
            this.add(this.welchButton);
            TtestInitDialog.this.buildConstraints(constraints, 1, 0, 1, 1, 50, 0);
            gridbag.setConstraints(this.eqVarButton, constraints);
            this.add(this.eqVarButton);
        }

        public void reset() {
            this.welchButton.setSelected(true);
        }
    }

    class OkCancelPanel
    extends JPanel {
        JButton okButton;
        JButton cancelButton;
        JCheckBox drawTreesBox;

        OkCancelPanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(), "General"));
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(gridbag);
            this.drawTreesBox = new JCheckBox("Draw hierarchical trees", false);
            TtestInitDialog.this.buildConstraints(constraints, 0, 0, 2, 1, 100, 50);
            gridbag.setConstraints(this.drawTreesBox, constraints);
            this.add(this.drawTreesBox);
            this.okButton = new JButton("OK");
            TtestInitDialog.this.buildConstraints(constraints, 0, 1, 1, 1, 50, 50);
            gridbag.setConstraints(this.okButton, constraints);
            this.add(this.okButton);
            this.cancelButton = new JButton("Cancel");
            TtestInitDialog.this.buildConstraints(constraints, 1, 1, 1, 1, 50, 0);
            gridbag.setConstraints(this.cancelButton, constraints);
            this.add(this.cancelButton);
        }
    }

    class SignificancePanel
    extends JPanel {
        JRadioButton minPButton;
        JRadioButton maxTButton;
        JRadioButton justAlphaButton;
        JRadioButton stdBonfButton;
        JRadioButton adjBonfButton;
        JRadioButton falseNumButton;
        JRadioButton falsePropButton;
        JRadioButton fastFDRButton;
        JRadioButton slowFDRButton;
        JTextField falseNumField;
        JTextField falsePropField;
        JCheckBox calcFDRPVals;

        SignificancePanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(1), "p-value / false discovery corrections", 0, 0, new Font("Dialog", 1, 12), Color.black));
            this.setBackground(Color.white);
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(gridbag);
            ButtonGroup sigGroup = new ButtonGroup();
            this.justAlphaButton = new JRadioButton("just alpha (no correction)", true);
            this.justAlphaButton.setFocusPainted(false);
            this.justAlphaButton.setForeground(UIManager.getColor("Label.foreground"));
            this.justAlphaButton.setBackground(Color.white);
            sigGroup.add(this.justAlphaButton);
            this.stdBonfButton = new JRadioButton("standard Bonferroni correction", false);
            this.stdBonfButton.setFocusPainted(false);
            this.stdBonfButton.setForeground(UIManager.getColor("Label.foreground"));
            this.stdBonfButton.setBackground(Color.white);
            sigGroup.add(this.stdBonfButton);
            this.adjBonfButton = new JRadioButton("adjusted Bonferroni correction", false);
            this.adjBonfButton.setFocusPainted(false);
            this.adjBonfButton.setForeground(UIManager.getColor("Label.foreground"));
            this.adjBonfButton.setBackground(Color.white);
            sigGroup.add(this.adjBonfButton);
            this.minPButton = new JRadioButton("minP", false);
            this.minPButton.setEnabled(false);
            this.minPButton.setFocusPainted(false);
            this.minPButton.setForeground(UIManager.getColor("Label.foreground"));
            this.minPButton.setBackground(Color.white);
            sigGroup.add(this.minPButton);
            this.maxTButton = new JRadioButton("maxT", false);
            this.maxTButton.setEnabled(false);
            this.maxTButton.setFocusPainted(false);
            this.maxTButton.setForeground(UIManager.getColor("Label.foreground"));
            this.maxTButton.setBackground(Color.white);
            sigGroup.add(this.maxTButton);
            this.falseNumButton = new JRadioButton("EITHER, The number of false significant genes should not exceed", false);
            this.falseNumButton.setEnabled(false);
            this.falseNumButton.setFocusPainted(false);
            this.falseNumButton.setForeground(UIManager.getColor("Label.foreground"));
            this.falseNumButton.setBackground(Color.white);
            sigGroup.add(this.falseNumButton);
            this.falsePropButton = new JRadioButton("OR, The proportion of false significant genes should not exceed", false);
            this.falsePropButton.setEnabled(false);
            this.falsePropButton.setFocusPainted(false);
            this.falsePropButton.setForeground(UIManager.getColor("Label.foreground"));
            this.falsePropButton.setBackground(Color.white);
            sigGroup.add(this.falsePropButton);
            this.falseNumField = new JTextField(10);
            this.falseNumField.setText("10");
            this.falseNumField.setMinimumSize(new Dimension(100, 20));
            this.falseNumField.setEnabled(false);
            this.falsePropField = new JTextField(10);
            this.falsePropField.setText("0.05");
            this.falsePropField.setMinimumSize(new Dimension(100, 20));
            this.falsePropField.setEnabled(false);
            this.calcFDRPVals = new JCheckBox("Calculate adjusted p values for false discovery control", false);
            this.calcFDRPVals.setEnabled(false);
            this.calcFDRPVals.setBackground(Color.white);
            TtestInitDialog.this.buildConstraints(constraints, 0, 0, 1, 1, 33, 33);
            gridbag.setConstraints(this.justAlphaButton, constraints);
            this.add(this.justAlphaButton);
            TtestInitDialog.this.buildConstraints(constraints, 1, 0, 1, 1, 33, 0);
            gridbag.setConstraints(this.stdBonfButton, constraints);
            this.add(this.stdBonfButton);
            TtestInitDialog.this.buildConstraints(constraints, 2, 0, 1, 1, 34, 0);
            gridbag.setConstraints(this.adjBonfButton, constraints);
            this.add(this.adjBonfButton);
            JPanel westfallYoungPanel = new JPanel();
            westfallYoungPanel.setBackground(Color.white);
            westfallYoungPanel.setBorder(new EtchedBorder());
            GridBagLayout grid2 = new GridBagLayout();
            westfallYoungPanel.setLayout(grid2);
            JLabel stepDownLabel = new JLabel("Step-down Westfall and Young methods (for permutations only): ");
            TtestInitDialog.this.buildConstraints(constraints, 0, 0, 1, 1, 34, 100);
            grid2.setConstraints(stepDownLabel, constraints);
            westfallYoungPanel.add(stepDownLabel);
            TtestInitDialog.this.buildConstraints(constraints, 1, 0, 1, 1, 33, 0);
            grid2.setConstraints(this.minPButton, constraints);
            westfallYoungPanel.add(this.minPButton);
            TtestInitDialog.this.buildConstraints(constraints, 2, 0, 1, 1, 33, 0);
            grid2.setConstraints(this.maxTButton, constraints);
            westfallYoungPanel.add(this.maxTButton);
            TtestInitDialog.this.buildConstraints(constraints, 0, 1, 3, 1, 100, 33);
            gridbag.setConstraints(westfallYoungPanel, constraints);
            this.add(westfallYoungPanel);
            ButtonGroup fastOrSlow = new ButtonGroup();
            this.fastFDRButton = new JRadioButton("Fast approximation (but possibly conservative)", true);
            this.fastFDRButton.setSelected(true);
            this.fastFDRButton.setEnabled(false);
            this.fastFDRButton.setBackground(Color.white);
            fastOrSlow.add(this.fastFDRButton);
            this.slowFDRButton = new JRadioButton("Complete computation (possibly slow)");
            this.slowFDRButton.setEnabled(false);
            this.slowFDRButton.setBackground(Color.white);
            fastOrSlow.add(this.slowFDRButton);
            JPanel FDRPanel = new JPanel();
            FDRPanel.setBackground(Color.white);
            FDRPanel.setBorder(new TitledBorder(new EtchedBorder(1), "False discovery control (permutations only)", 0, 0, new Font("Dialog", 1, 12), Color.black));
            GridBagLayout grid3 = new GridBagLayout();
            FDRPanel.setLayout(grid3);
            JLabel FDRLabel = new JLabel("With confidence of [1 - alpha] : ");
            constraints.anchor = 17;
            TtestInitDialog.this.buildConstraints(constraints, 0, 0, 2, 1, 100, 20);
            grid3.setConstraints(FDRLabel, constraints);
            FDRPanel.add(FDRLabel);
            constraints.anchor = 10;
            TtestInitDialog.this.buildConstraints(constraints, 0, 1, 1, 1, 50, 20);
            constraints.anchor = 13;
            grid3.setConstraints(this.falseNumButton, constraints);
            FDRPanel.add(this.falseNumButton);
            TtestInitDialog.this.buildConstraints(constraints, 1, 1, 1, 1, 50, 0);
            constraints.anchor = 17;
            grid3.setConstraints(this.falseNumField, constraints);
            FDRPanel.add(this.falseNumField);
            TtestInitDialog.this.buildConstraints(constraints, 0, 2, 1, 1, 50, 20);
            constraints.anchor = 13;
            grid3.setConstraints(this.falsePropButton, constraints);
            FDRPanel.add(this.falsePropButton);
            TtestInitDialog.this.buildConstraints(constraints, 1, 2, 1, 1, 50, 0);
            constraints.anchor = 17;
            grid3.setConstraints(this.falsePropField, constraints);
            FDRPanel.add(this.falsePropField);
            constraints.anchor = 10;
            TtestInitDialog.this.buildConstraints(constraints, 0, 3, 1, 1, 50, 20);
            grid3.setConstraints(this.fastFDRButton, constraints);
            FDRPanel.add(this.fastFDRButton);
            TtestInitDialog.this.buildConstraints(constraints, 1, 3, 1, 1, 50, 0);
            grid3.setConstraints(this.slowFDRButton, constraints);
            FDRPanel.add(this.slowFDRButton);
            TtestInitDialog.this.buildConstraints(constraints, 0, 4, 2, 1, 100, 20);
            grid3.setConstraints(this.calcFDRPVals, constraints);
            FDRPanel.add(this.calcFDRPVals);
            TtestInitDialog.this.buildConstraints(constraints, 0, 2, 3, 1, 100, 34);
            constraints.fill = 2;
            gridbag.setConstraints(FDRPanel, constraints);
            this.add(FDRPanel);
            constraints.fill = 0;
        }
    }

    class PValuePanel
    extends JPanel {
        JRadioButton tDistButton;
        JRadioButton permutButton;
        JRadioButton randomGroupsButton;
        JRadioButton allCombsButton;
        JLabel numCombsLabel;
        JTextField timesField;
        JTextField alphaInputField;

        PValuePanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(1), "P-Value Parameters", 0, 0, new Font("Dialog", 1, 12), Color.black));
            this.setBackground(Color.white);
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.anchor = 17;
            this.setLayout(gridbag);
            ButtonGroup chooseP = new ButtonGroup();
            this.tDistButton = new JRadioButton("p-values based on t-distribution", true);
            this.tDistButton.setFocusPainted(false);
            this.tDistButton.setForeground(UIManager.getColor("Label.foreground"));
            this.tDistButton.setBackground(Color.white);
            chooseP.add(this.tDistButton);
            this.permutButton = new JRadioButton("p-values based on permutation:  ", false);
            this.permutButton.setFocusPainted(false);
            this.permutButton.setForeground(UIManager.getColor("Label.foreground"));
            this.permutButton.setBackground(Color.white);
            chooseP.add(this.permutButton);
            this.numCombsLabel = new JLabel("                                       ");
            this.numCombsLabel.setOpaque(false);
            JPanel panel1 = new JPanel();
            panel1.setBackground(Color.white);
            GridBagLayout grid1 = new GridBagLayout();
            panel1.setLayout(grid1);
            TtestInitDialog.this.buildConstraints(constraints, 0, 0, 1, 1, 30, 50);
            grid1.setConstraints(this.tDistButton, constraints);
            panel1.add(this.tDistButton);
            TtestInitDialog.this.buildConstraints(constraints, 0, 1, 1, 1, 30, 50);
            constraints.anchor = 17;
            grid1.setConstraints(this.permutButton, constraints);
            panel1.add(this.permutButton);
            TtestInitDialog.this.buildConstraints(constraints, 1, 1, 1, 1, 70, 0);
            constraints.ipadx = 50;
            constraints.anchor = 17;
            grid1.setConstraints(this.numCombsLabel, constraints);
            panel1.add(this.numCombsLabel);
            constraints.ipadx = 100;
            TtestInitDialog.this.buildConstraints(constraints, 0, 0, 1, 1, 100, 20);
            constraints.anchor = 17;
            gridbag.setConstraints(panel1, constraints);
            this.add(panel1);
            constraints.fill = 0;
            constraints.anchor = 13;
            constraints.ipadx = 0;
            constraints.ipady = 0;
            JPanel panel2 = new JPanel();
            panel2.setBackground(Color.white);
            GridBagLayout grid2 = new GridBagLayout();
            panel2.setLayout(grid2);
            panel2.setBorder(new EtchedBorder());
            this.randomGroupsButton = new JRadioButton("Randomly group samples ", true);
            this.randomGroupsButton.setFocusPainted(false);
            this.randomGroupsButton.setForeground(UIManager.getColor("Label.foreground"));
            this.randomGroupsButton.setBackground(Color.white);
            this.randomGroupsButton.setEnabled(false);
            this.allCombsButton = new JRadioButton("Use all permutations                 ", false);
            this.allCombsButton.setFocusPainted(false);
            this.allCombsButton.setForeground(UIManager.getColor("Label.foreground"));
            this.allCombsButton.setBackground(Color.white);
            this.allCombsButton.setEnabled(false);
            ButtonGroup chooseAllOrRandom = new ButtonGroup();
            TtestInitDialog.this.buildConstraints(constraints, 0, 0, 1, 1, 60, 50);
            grid2.setConstraints(this.randomGroupsButton, constraints);
            panel2.add(this.randomGroupsButton);
            this.timesField = new JTextField("100", 7);
            this.timesField.setEnabled(false);
            this.timesField.setMinimumSize(new Dimension(100, 20));
            TtestInitDialog.this.buildConstraints(constraints, 1, 0, 1, 1, 20, 0);
            constraints.anchor = 17;
            grid2.setConstraints(this.timesField, constraints);
            panel2.add(this.timesField);
            JLabel timesLabel = new JLabel("times");
            timesLabel.setOpaque(false);
            TtestInitDialog.this.buildConstraints(constraints, 2, 0, 1, 1, 20, 0);
            grid2.setConstraints(timesLabel, constraints);
            panel2.add(timesLabel);
            TtestInitDialog.this.buildConstraints(constraints, 0, 1, 1, 1, 60, 0);
            constraints.anchor = 13;
            grid2.setConstraints(this.allCombsButton, constraints);
            panel2.add(this.allCombsButton);
            chooseAllOrRandom.add(this.randomGroupsButton);
            chooseAllOrRandom.add(this.allCombsButton);
            this.allCombsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (evt.getSource() == PValuePanel.this.allCombsButton) {
                        PValuePanel.this.timesField.setText("");
                        PValuePanel.this.timesField.setBackground(Color.gray);
                        PValuePanel.this.timesField.setEnabled(false);
                    }
                }
            });
            this.randomGroupsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (evt.getSource() == PValuePanel.this.randomGroupsButton) {
                        PValuePanel.this.timesField.setText("100");
                        PValuePanel.this.timesField.setBackground(Color.white);
                        PValuePanel.this.timesField.setEnabled(true);
                    }
                }
            });
            this.tDistButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (evt.getSource() == PValuePanel.this.tDistButton) {
                        PValuePanel.this.randomGroupsButton.setEnabled(false);
                        PValuePanel.this.allCombsButton.setEnabled(false);
                        PValuePanel.this.timesField.setEnabled(false);
                        PValuePanel.this.numCombsLabel.setText("                                                                            ");
                    }
                }
            });
            TtestInitDialog.this.buildConstraints(constraints, 0, 1, 1, 1, 100, 60);
            constraints.anchor = 11;
            constraints.fill = 3;
            gridbag.setConstraints(panel2, constraints);
            this.add(panel2);
            constraints.fill = 0;
            JPanel panel3 = new JPanel();
            panel3.setBackground(Color.white);
            GridBagLayout grid3 = new GridBagLayout();
            panel3.setLayout(grid3);
            JLabel alphaLabel = new JLabel("Overall alpha (critical p-value):                   ");
            alphaLabel.setOpaque(false);
            TtestInitDialog.this.buildConstraints(constraints, 0, 0, 1, 1, 75, 100);
            constraints.anchor = 17;
            grid3.setConstraints(alphaLabel, constraints);
            panel3.add(alphaLabel);
            this.alphaInputField = new JTextField("0.01", 7);
            this.alphaInputField.setMinimumSize(new Dimension(100, 20));
            TtestInitDialog.this.buildConstraints(constraints, 1, 0, 1, 1, 25, 0);
            constraints.anchor = 17;
            grid3.setConstraints(this.alphaInputField, constraints);
            panel3.add(this.alphaInputField);
            TtestInitDialog.this.buildConstraints(constraints, 0, 2, 1, 1, 0, 20);
            gridbag.setConstraints(panel3, constraints);
            this.add(panel3);
        }
    }

    class GroupExperimentsPanel
    extends JPanel {
        JLabel[] expLabels;
        JLabel lotsOfSamplesWarningLabel;
        int numPanels = 0;
        JRadioButton[] groupARadioButtons;
        JRadioButton[] groupBRadioButtons;
        JRadioButton[] neitherGroupRadioButtons;

        GroupExperimentsPanel(Vector exptNames) {
            int i;
            this.setBorder(new TitledBorder(new EtchedBorder(1), "Group Assignments", 0, 0, new Font("Dialog", 1, 12), Color.black));
            this.setBackground(Color.white);
            this.numPanels = exptNames.size() / 512 + 1;
            this.expLabels = new JLabel[exptNames.size()];
            this.groupARadioButtons = new JRadioButton[exptNames.size()];
            this.groupBRadioButtons = new JRadioButton[exptNames.size()];
            this.neitherGroupRadioButtons = new JRadioButton[exptNames.size()];
            ButtonGroup[] chooseGroup = new ButtonGroup[exptNames.size()];
            GridBagLayout gridbag = new GridBagLayout();
            GridBagLayout gridbag2 = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(gridbag2);
            JPanel[] panels = new JPanel[this.numPanels];
            int currPanel = 0;
            for (i = 0; i < panels.length; ++i) {
                panels[i] = new JPanel(gridbag);
            }
            for (i = 0; i < exptNames.size(); ++i) {
                currPanel = i / 512;
                String s1 = (String)exptNames.get(i);
                this.expLabels[i] = new JLabel(s1);
                this.expLabels[i].setForeground(Color.black);
                chooseGroup[i] = new ButtonGroup();
                this.groupARadioButtons[i] = new JRadioButton("Group A", true);
                chooseGroup[i].add(this.groupARadioButtons[i]);
                this.groupBRadioButtons[i] = new JRadioButton("Group B", false);
                chooseGroup[i].add(this.groupBRadioButtons[i]);
                this.neitherGroupRadioButtons[i] = new JRadioButton("Neither group", false);
                chooseGroup[i].add(this.neitherGroupRadioButtons[i]);
                TtestInitDialog.this.buildConstraints(constraints, 0, i % 512, 1, 1, 25, 100);
                gridbag.setConstraints(this.expLabels[i], constraints);
                panels[currPanel].add(this.expLabels[i]);
                TtestInitDialog.this.buildConstraints(constraints, 1, i % 512, 1, 1, 25, 100);
                gridbag.setConstraints(this.groupARadioButtons[i], constraints);
                panels[currPanel].add(this.groupARadioButtons[i]);
                TtestInitDialog.this.buildConstraints(constraints, 2, i % 512, 1, 1, 25, 100);
                gridbag.setConstraints(this.groupBRadioButtons[i], constraints);
                panels[currPanel].add(this.groupBRadioButtons[i]);
                TtestInitDialog.this.buildConstraints(constraints, 3, i % 512, 1, 1, 25, 100);
                gridbag.setConstraints(this.neitherGroupRadioButtons[i], constraints);
                panels[currPanel].add(this.neitherGroupRadioButtons[i]);
            }
            JPanel bigPanel = new JPanel(new GridBagLayout());
            for (int i2 = 0; i2 < this.numPanels; ++i2) {
                bigPanel.add((Component)panels[i2], new GridBagConstraints(0, i2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
            JScrollPane scroll = new JScrollPane(bigPanel);
            scroll.setHorizontalScrollBarPolicy(32);
            scroll.setVerticalScrollBarPolicy(22);
            scroll.setBorder(BorderFactory.createLineBorder(Color.black, 2));
            scroll.getHorizontalScrollBar().setUnitIncrement(20);
            scroll.getVerticalScrollBar().setUnitIncrement(20);
            TtestInitDialog.this.buildConstraints(constraints, 0, 0, 1, 1, 100, 90);
            constraints.fill = 1;
            gridbag2.setConstraints(scroll, constraints);
            this.add(scroll);
            JLabel label1 = new JLabel("                                                Note: Group A and Group B  MUST each contain more than one sample.");
            TtestInitDialog.this.buildConstraints(constraints, 0, 1, 1, 1, 0, 5);
            constraints.anchor = 13;
            gridbag2.setConstraints(label1, constraints);
            this.add(label1);
            if (TtestInitDialog.this.lotsOfSamples) {
                this.lotsOfSamplesWarningLabel = new JLabel(TtestInitDialog.this.lotsOfSamplesWarningText);
                this.add((Component)this.lotsOfSamplesWarningLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
            JPanel panel2 = new JPanel();
            panel2.setBackground(Color.white);
            GridBagLayout gridbag3 = new GridBagLayout();
            panel2.setLayout(gridbag3);
            JButton saveButton = new JButton(" Save grouping ");
            saveButton.setBorder(BorderFactory.createBevelBorder(0, Color.gray, new Color(185, 185, 185), Color.darkGray, Color.darkGray));
            saveButton.setFocusPainted(false);
            saveButton.setPreferredSize(new Dimension(100, 30));
            JButton loadButton = new JButton(" Load grouping ");
            loadButton.setBorder(BorderFactory.createBevelBorder(0, Color.gray, new Color(185, 185, 185), Color.darkGray, Color.darkGray));
            loadButton.setFocusPainted(false);
            loadButton.setPreferredSize(new Dimension(100, 30));
            JButton resetButton = new JButton(" Reset ");
            resetButton.setBorder(BorderFactory.createBevelBorder(0, Color.gray, new Color(185, 185, 185), Color.darkGray, Color.darkGray));
            resetButton.setFocusPainted(false);
            resetButton.setPreferredSize(new Dimension(55, 30));
            final int finNum = exptNames.size();
            resetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    for (int i = 0; i < finNum; ++i) {
                        GroupExperimentsPanel.this.groupARadioButtons[i].setSelected(true);
                    }
                    TtestInitDialog.this.pPanel.tDistButton.setSelected(true);
                    TtestInitDialog.this.sPanel.justAlphaButton.setSelected(true);
                    TtestInitDialog.this.sPanel.maxTButton.setSelected(false);
                    TtestInitDialog.this.sPanel.maxTButton.setEnabled(false);
                    TtestInitDialog.this.sPanel.minPButton.setSelected(false);
                    TtestInitDialog.this.sPanel.minPButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.randomGroupsButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.allCombsButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.timesField.setEnabled(false);
                    TtestInitDialog.this.pPanel.numCombsLabel.setText("                                                                            ");
                }
            });
            JFileChooser fc = new JFileChooser(TMEV.getDataPath());
            saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    GroupExperimentsPanel.this.saveAssignments();
                }
            });
            loadButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    GroupExperimentsPanel.this.loadAssignments();
                }
            });
            constraints.anchor = 10;
            constraints.fill = 0;
            constraints.insets = new Insets(0, 5, 0, 5);
            TtestInitDialog.this.buildConstraints(constraints, 0, 1, 1, 1, 33, 100);
            gridbag3.setConstraints(saveButton, constraints);
            panel2.add(saveButton);
            TtestInitDialog.this.buildConstraints(constraints, 1, 1, 1, 1, 33, 0);
            gridbag3.setConstraints(loadButton, constraints);
            panel2.add(loadButton);
            TtestInitDialog.this.buildConstraints(constraints, 2, 1, 1, 1, 34, 0);
            gridbag3.setConstraints(resetButton, constraints);
            panel2.add(resetButton);
            TtestInitDialog.this.buildConstraints(constraints, 0, 3, 1, 1, 0, 5);
            constraints.anchor = 10;
            gridbag2.setConstraints(panel2, constraints);
            this.add(panel2);
        }

        private void saveAssignments() {
            JFileChooser fileChooser = new JFileChooser(TMEV.getDataPath());
            if (fileChooser.showSaveDialog(this) == 0) {
                File file = fileChooser.getSelectedFile();
                try {
                    PrintWriter pw = new PrintWriter(new FileWriter(file));
                    Date currDate = new Date(System.currentTimeMillis());
                    String dateString = currDate.toString();
                    String userName = System.getProperty("user.name");
                    pw.println("# Assignment File");
                    pw.println("# User: " + userName + " Save Date: " + dateString);
                    pw.println("#");
                    pw.print("Module:\t");
                    pw.println("TTEST-Between Subjects");
                    pw.print("Group 1 Label:\t");
                    pw.println("1");
                    pw.print("Group 2 Label:\t");
                    pw.println("2");
                    pw.println("#");
                    pw.println("Sample Index\tSample Name\tGroup Assignment");
                    int[] groupAssgn = TtestInitDialog.this.getGroupAssignments();
                    for (int sample = 0; sample < TtestInitDialog.this.exptNames.size(); ++sample) {
                        pw.print(String.valueOf(sample + 1) + "\t");
                        pw.print(TtestInitDialog.this.exptNames.get(sample) + "\t");
                        if (groupAssgn[sample] != 3) {
                            pw.println(groupAssgn[sample]);
                            continue;
                        }
                        pw.println("Exclude");
                    }
                    pw.flush();
                    pw.close();
                }
                catch (FileNotFoundException fnfe) {
                    fnfe.printStackTrace();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }

        private void loadAssignments() {
            JFileChooser fileChooser = new JFileChooser(TMEV.getDataPath());
            if (fileChooser.showOpenDialog(this) == 0) {
                File file = fileChooser.getSelectedFile();
                try {
                    String line;
                    BufferedReader br = new BufferedReader(new FileReader(file));
                    Vector<String> data = new Vector<String>();
                    while ((line = br.readLine()) != null) {
                        data.add(line.trim());
                    }
                    br.close();
                    Vector<String> groupNames = new Vector<String>();
                    Vector<Integer> sampleIndices = new Vector<Integer>();
                    Vector<String> sampleNames = new Vector<String>();
                    Vector<String> groupAssignments = new Vector<String>();
                    for (int row = 0; row < data.size(); ++row) {
                        line = (String)data.get(row);
                        if (line.startsWith("#") || line.startsWith("SampleIndex")) continue;
                        String[] lineArray = line.split("\t");
                        if (lineArray[0].startsWith("Module:")) {
                            if (lineArray[1].equals("TTEST-Between Subjects")) continue;
                            Object[] optionst = new Object[]{"Continue", "Cancel"};
                            if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different module, " + lineArray[1] + ". \n Would you like MeV to try to load it anyway?", "File type warning", 1, 3, null, optionst, optionst[0]) == 0) continue;
                            return;
                        }
                        if (lineArray[0].startsWith("Group ") && lineArray[0].endsWith("Label:")) {
                            groupNames.add(lineArray[1]);
                            continue;
                        }
                        try {
                            Integer.parseInt(lineArray[0]);
                        }
                        catch (NumberFormatException nfe) {
                            continue;
                        }
                        sampleIndices.add(new Integer(lineArray[0]));
                        sampleNames.add(lineArray[1]);
                        groupAssignments.add(lineArray[2]);
                    }
                    if (TtestInitDialog.this.exptNames.size() != sampleNames.size()) {
                        System.out.println(TtestInitDialog.this.exptNames.size() + "  " + sampleNames.size());
                        System.out.println(TtestInitDialog.this.exptNames.size() + " s length " + sampleNames.size());
                        JOptionPane.showMessageDialog(this, "<html>Error -- number of samples designated in assignment file (" + String.valueOf(sampleNames.size()) + ")<br>" + "does not match the number of samples loaded in MeV (" + TtestInitDialog.this.exptNames.size() + ").<br>" + "Assignments are not set.</html>", "File Compatibility Error", 0);
                        return;
                    }
                    Vector<String> currSampleVector = new Vector<String>();
                    for (int i = 0; i < TtestInitDialog.this.exptNames.size(); ++i) {
                        currSampleVector.add(TtestInitDialog.this.exptNames.get(i));
                    }
                    int fileSampleIndex = 0;
                    int groupIndex = 0;
                    for (int sample = 0; sample < TtestInitDialog.this.exptNames.size(); ++sample) {
                        boolean doIndex = false;
                        for (int i = 0; i < TtestInitDialog.this.exptNames.size(); ++i) {
                            if (i == sample || !TtestInitDialog.this.exptNames.get(i).equals(TtestInitDialog.this.exptNames.get(sample))) continue;
                            doIndex = true;
                        }
                        fileSampleIndex = sampleNames.indexOf(TtestInitDialog.this.exptNames.get(sample));
                        if (fileSampleIndex == -1) {
                            doIndex = true;
                        }
                        if (doIndex) {
                            this.setStateBasedOnIndex(groupAssignments, groupNames);
                            break;
                        }
                        String groupName = (String)groupAssignments.get(fileSampleIndex);
                        groupIndex = groupNames.indexOf(groupName);
                        try {
                            if (groupIndex == 0) {
                                this.groupARadioButtons[sample].setSelected(true);
                            }
                            if (groupIndex == 1) {
                                this.groupBRadioButtons[sample].setSelected(true);
                            }
                            if (groupIndex != 2 && groupIndex != -1) continue;
                            this.neitherGroupRadioButtons[sample].setSelected(true);
                            continue;
                        }
                        catch (Exception e) {
                            this.neitherGroupRadioButtons[sample].setSelected(true);
                        }
                    }
                    this.repaint();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this, "<html>The file format cannot be read.</html>", "File Compatibility Error", 0);
                }
            }
        }

        private void setStateBasedOnIndex(Vector<String> groupAssignments, Vector<String> groupNames) {
            Object[] optionst = new Object[]{"Continue", "Cancel"};
            if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different sample annotation or has duplicate annotation. \n Would you like MeV to try to load it by index order?", "File type warning", 1, 3, null, optionst, optionst[0]) == 1) {
                return;
            }
            for (int sample = 0; sample < TtestInitDialog.this.exptNames.size(); ++sample) {
                try {
                    if (groupNames.indexOf(groupAssignments.get(sample)) == 0) {
                        this.groupARadioButtons[sample].setSelected(true);
                    }
                    if (groupNames.indexOf(groupAssignments.get(sample)) == 1) {
                        this.groupBRadioButtons[sample].setSelected(true);
                    }
                    if (groupNames.indexOf(groupAssignments.get(sample)) != 2 && groupNames.indexOf(groupAssignments.get(sample)) != -1) continue;
                    this.neitherGroupRadioButtons[sample].setSelected(true);
                    continue;
                }
                catch (Exception e) {
                    this.neitherGroupRadioButtons[sample].setSelected(true);
                }
            }
        }

        public void reset() {
            int finNum = TtestInitDialog.this.exptNames.size();
            for (int i = 0; i < finNum; ++i) {
                this.groupARadioButtons[i].setSelected(true);
            }
        }
    }

    class OneClassPanel
    extends JPanel {
        JTextField meanField;
        JCheckBox[] includeExpts;
        int numPanels = 0;
        JButton saveButton;
        JButton loadButton;
        JButton resetButton;
        JLabel lotsOfSamplesWarningLabel;

        OneClassPanel() {
            int i;
            this.setBackground(Color.white);
            JLabel meanLabel = new JLabel("Enter the mean value to be tested against: ");
            this.meanField = new JTextField("0", 7);
            this.includeExpts = new JCheckBox[TtestInitDialog.this.exptNames.size()];
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(gridbag);
            this.numPanels = TtestInitDialog.this.exptNames.size() / 512 + 1;
            JPanel[] panels = new JPanel[this.numPanels];
            int currPanel = 0;
            for (i = 0; i < panels.length; ++i) {
                panels[i] = new JPanel(gridbag);
            }
            for (i = 0; i < TtestInitDialog.this.exptNames.size(); ++i) {
                currPanel = i / 512;
                this.includeExpts[i] = new JCheckBox(TtestInitDialog.this.exptNames.get(i), true);
                TtestInitDialog.this.buildConstraints(constraints, 0, i % 512, 1, 1, 100, 100);
                gridbag.setConstraints(this.includeExpts[i], constraints);
                panels[currPanel].add(this.includeExpts[i]);
            }
            JPanel bigPanel = new JPanel(new GridBagLayout());
            for (int i2 = 0; i2 < this.numPanels; ++i2) {
                bigPanel.add((Component)panels[i2], new GridBagConstraints(0, i2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
            JScrollPane scroll = new JScrollPane(bigPanel);
            scroll.setVerticalScrollBarPolicy(22);
            scroll.getVerticalScrollBar().setUnitIncrement(20);
            JPanel enterMeanPanel = new JPanel();
            GridBagLayout grid2 = new GridBagLayout();
            enterMeanPanel.setLayout(grid2);
            constraints.fill = 0;
            TtestInitDialog.this.buildConstraints(constraints, 0, 0, 1, 1, 50, 100);
            constraints.anchor = 13;
            grid2.setConstraints(meanLabel, constraints);
            enterMeanPanel.add(meanLabel);
            TtestInitDialog.this.buildConstraints(constraints, 1, 0, 1, 1, 50, 0);
            constraints.anchor = 17;
            grid2.setConstraints(this.meanField, constraints);
            enterMeanPanel.add(this.meanField);
            JScrollPane scroll2 = new JScrollPane(enterMeanPanel);
            scroll2.getHorizontalScrollBar().setUnitIncrement(20);
            scroll2.getVerticalScrollBar().setUnitIncrement(20);
            JSplitPane split = new JSplitPane(1, scroll, scroll2);
            split.setOneTouchExpandable(true);
            split.setDividerLocation(150);
            constraints.fill = 1;
            TtestInitDialog.this.buildConstraints(constraints, 0, 0, 1, 1, 100, 80);
            gridbag.setConstraints(split, constraints);
            this.add(split);
            constraints.fill = 0;
            constraints.anchor = 10;
            if (TtestInitDialog.this.lotsOfSamples) {
                this.lotsOfSamplesWarningLabel = new JLabel(TtestInitDialog.this.lotsOfSamplesWarningText);
                this.add((Component)this.lotsOfSamplesWarningLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
            JPanel lsrPanel = new JPanel();
            this.loadButton = new JButton("Load settings");
            this.saveButton = new JButton("Save settings");
            this.resetButton = new JButton("Reset");
            this.resetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    for (int i = 0; i < OneClassPanel.this.includeExpts.length; ++i) {
                        OneClassPanel.this.includeExpts[i].setSelected(true);
                    }
                    TtestInitDialog.this.pPanel.tDistButton.setSelected(true);
                    TtestInitDialog.this.sPanel.justAlphaButton.setSelected(true);
                    TtestInitDialog.this.sPanel.maxTButton.setSelected(false);
                    TtestInitDialog.this.sPanel.maxTButton.setEnabled(false);
                    TtestInitDialog.this.sPanel.minPButton.setSelected(false);
                    TtestInitDialog.this.sPanel.minPButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.randomGroupsButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.allCombsButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.timesField.setEnabled(false);
                    TtestInitDialog.this.pPanel.numCombsLabel.setText("                                                                            ");
                }
            });
            JFileChooser fc = new JFileChooser(TMEV.getDataPath());
            this.saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    OneClassPanel.this.saveAssignments();
                }
            });
            this.loadButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    OneClassPanel.this.loadAssignments();
                }
            });
            GridBagLayout grid3 = new GridBagLayout();
            lsrPanel.setLayout(grid3);
            TtestInitDialog.this.buildConstraints(constraints, 0, 1, 1, 1, 33, 100);
            grid3.setConstraints(this.saveButton, constraints);
            lsrPanel.add(this.saveButton);
            TtestInitDialog.this.buildConstraints(constraints, 1, 1, 1, 1, 33, 0);
            grid3.setConstraints(this.loadButton, constraints);
            lsrPanel.add(this.loadButton);
            TtestInitDialog.this.buildConstraints(constraints, 2, 1, 1, 1, 33, 0);
            grid3.setConstraints(this.resetButton, constraints);
            lsrPanel.add(this.resetButton);
            TtestInitDialog.this.buildConstraints(constraints, 0, 2, 1, 1, 0, 20);
            gridbag.setConstraints(lsrPanel, constraints);
            this.add(lsrPanel);
        }

        private void saveAssignments() {
            JFileChooser fileChooser = new JFileChooser(TMEV.getDataPath());
            if (fileChooser.showSaveDialog(this) == 0) {
                File file = fileChooser.getSelectedFile();
                try {
                    PrintWriter pw = new PrintWriter(new FileWriter(file));
                    Date currDate = new Date(System.currentTimeMillis());
                    String dateString = currDate.toString();
                    String userName = System.getProperty("user.name");
                    pw.println("# Assignment File");
                    pw.println("# User: " + userName + " Save Date: " + dateString);
                    pw.println("#");
                    pw.print("Module:\t");
                    pw.println("TTEST: One Class");
                    pw.print("Group 1 Label:\t");
                    pw.println("Include");
                    pw.println("#");
                    pw.println("Sample Index\tSample Name\tGroup Assignment");
                    for (int sample = 0; sample < TtestInitDialog.this.exptNames.size(); ++sample) {
                        pw.print(String.valueOf(sample + 1) + "\t");
                        pw.print(TtestInitDialog.this.exptNames.get(sample) + "\t");
                        if (this.includeExpts[sample].isSelected()) {
                            pw.println("Include");
                            continue;
                        }
                        pw.println("Exclude");
                    }
                    pw.flush();
                    pw.close();
                }
                catch (FileNotFoundException fnfe) {
                    fnfe.printStackTrace();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }

        private void loadAssignments() {
            JFileChooser fileChooser = new JFileChooser(TMEV.getDataPath());
            if (fileChooser.showOpenDialog(this) == 0) {
                File file = fileChooser.getSelectedFile();
                try {
                    String line;
                    BufferedReader br = new BufferedReader(new FileReader(file));
                    Vector<String> data = new Vector<String>();
                    while ((line = br.readLine()) != null) {
                        data.add(line.trim());
                    }
                    br.close();
                    Vector<String> groupNames = new Vector<String>();
                    Vector<Integer> sampleIndices = new Vector<Integer>();
                    Vector<String> sampleNames = new Vector<String>();
                    Vector<String> groupAssignments = new Vector<String>();
                    for (int row = 0; row < data.size(); ++row) {
                        line = (String)data.get(row);
                        if (line.startsWith("#") || line.startsWith("SampleIndex")) continue;
                        String[] lineArray = line.split("\t");
                        if (lineArray[0].startsWith("Module:")) {
                            if (lineArray[1].equals("TTEST: One Class")) continue;
                            Object[] optionst = new Object[]{"Continue", "Cancel"};
                            if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different module, " + lineArray[1] + ". \n Would you like MeV to try to load it anyway?", "File type warning", 1, 3, null, optionst, optionst[0]) == 0) continue;
                            return;
                        }
                        if (lineArray[0].startsWith("Group ") && lineArray[0].endsWith("Label:")) {
                            groupNames.add(lineArray[1]);
                            continue;
                        }
                        try {
                            Integer.parseInt(lineArray[0]);
                        }
                        catch (NumberFormatException nfe) {
                            continue;
                        }
                        sampleIndices.add(new Integer(lineArray[0]));
                        sampleNames.add(lineArray[1]);
                        groupAssignments.add(lineArray[2]);
                    }
                    if (TtestInitDialog.this.exptNames.size() != sampleNames.size()) {
                        System.out.println(TtestInitDialog.this.exptNames.size() + "  " + sampleNames.size());
                        System.out.println(TtestInitDialog.this.exptNames.size() + " s length " + sampleNames.size());
                        JOptionPane.showMessageDialog(this, "<html>Error -- number of samples designated in assignment file (" + String.valueOf(sampleNames.size()) + ")<br>" + "does not match the number of samples loaded in MeV (" + TtestInitDialog.this.exptNames.size() + ").<br>" + "Assignments are not set.</html>", "File Compatibility Error", 0);
                        return;
                    }
                    Vector<String> currSampleVector = new Vector<String>();
                    for (int i = 0; i < TtestInitDialog.this.exptNames.size(); ++i) {
                        currSampleVector.add(TtestInitDialog.this.exptNames.get(i));
                    }
                    int fileSampleIndex = 0;
                    int groupIndex = 0;
                    for (int sample = 0; sample < TtestInitDialog.this.exptNames.size(); ++sample) {
                        boolean doIndex = false;
                        for (int i = 0; i < TtestInitDialog.this.exptNames.size(); ++i) {
                            if (i == sample || !TtestInitDialog.this.exptNames.get(i).equals(TtestInitDialog.this.exptNames.get(sample))) continue;
                            doIndex = true;
                        }
                        fileSampleIndex = sampleNames.indexOf(TtestInitDialog.this.exptNames.get(sample));
                        if (fileSampleIndex == -1) {
                            doIndex = true;
                        }
                        if (doIndex) {
                            this.setStateBasedOnIndex(groupAssignments, groupNames);
                            break;
                        }
                        String groupName = (String)groupAssignments.get(fileSampleIndex);
                        groupIndex = groupNames.indexOf(groupName);
                        try {
                            if (groupIndex == 0) {
                                this.includeExpts[sample].setSelected(true);
                            }
                            if (groupIndex != 1 && groupIndex != -1) continue;
                            this.includeExpts[sample].setSelected(false);
                            continue;
                        }
                        catch (Exception e) {
                            this.includeExpts[sample].setSelected(false);
                        }
                    }
                    this.repaint();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, "<html>The file format cannot be read.</html>", "File Compatibility Error", 0);
                }
            }
        }

        private void setStateBasedOnIndex(Vector<String> groupAssignments, Vector<String> groupNames) {
            Object[] optionst = new Object[]{"Continue", "Cancel"};
            if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different sample annotation or has duplicate annotation. \n Would you like MeV to try to load it by index order?", "File type warning", 1, 3, null, optionst, optionst[0]) == 1) {
                return;
            }
            for (int sample = 0; sample < TtestInitDialog.this.exptNames.size(); ++sample) {
                try {
                    if (groupNames.indexOf(groupAssignments.get(sample)) == 0) {
                        this.includeExpts[sample].setSelected(true);
                    }
                    if (groupNames.indexOf(groupAssignments.get(sample)) != 1 && groupNames.indexOf(groupAssignments.get(sample)) != -1) continue;
                    this.includeExpts[sample].setSelected(false);
                    continue;
                }
                catch (Exception e) {
                    this.includeExpts[sample].setSelected(false);
                }
            }
        }

        public void reset() {
            for (int i = 0; i < this.includeExpts.length; ++i) {
                this.includeExpts[i].setSelected(true);
            }
            this.meanField.setText("0");
        }
    }

    class TwoClassPairedPanel
    extends JPanel {
        ExperimentButton[] exptButtons;
        GridBagConstraints constraints;
        GridBagLayout gridbag;
        JTextField currentATextField;
        JTextField currentBTextField;
        JButton removeCurrentAButton;
        JButton removeCurrentBButton;
        JButton loadABPairButton;
        JButton removeABPairButton;
        PairedExperimentsPanel pairPanel;
        JList pairedExptsList;
        DefaultListModel pairedListModel;
        boolean currentAFilled = false;
        boolean currentBFilled = false;
        int currentAExpt = -1;
        int currentBExpt = -1;
        int numPanels = 0;
        Vector pairedAExpts = new Vector();
        Vector pairedBExpts = new Vector();

        public TwoClassPairedPanel() {
            this.constraints = new GridBagConstraints();
            this.gridbag = new GridBagLayout();
            this.setLayout(this.gridbag);
            this.pairedListModel = new DefaultListModel();
            this.pairedExptsList = new JList(this.pairedListModel);
            this.numPanels = TtestInitDialog.this.exptNames.size() / 512 + 1;
            JPanel[] panels = new JPanel[this.numPanels];
            int currPanel = 0;
            for (int i = 0; i < panels.length; ++i) {
                panels[i] = new JPanel(this.gridbag);
            }
            this.exptButtons = new ExperimentButton[TtestInitDialog.this.exptNames.size()];
            int maxWidth = 0;
            int maxNameLength = 0;
            for (int i = 0; i < TtestInitDialog.this.exptNames.size(); ++i) {
                String s;
                int currentNameLength;
                this.exptButtons[i] = new ExperimentButton(i);
                currPanel = i / 512;
                if (this.exptButtons[i].getPreferredSize().getWidth() > (double)maxWidth) {
                    maxWidth = (int)Math.ceil(this.exptButtons[i].getPreferredSize().getWidth());
                }
                if ((currentNameLength = (s = TtestInitDialog.this.exptNames.get(i)).length()) > maxNameLength) {
                    maxNameLength = currentNameLength;
                }
                TtestInitDialog.this.buildConstraints(this.constraints, 0, i % 512, 1, 1, 100, 100);
                this.gridbag.setConstraints(this.exptButtons[i], this.constraints);
                panels[currPanel].add(this.exptButtons[i]);
            }
            this.currentATextField = new JTextField("", maxNameLength + 2);
            this.currentBTextField = new JTextField("", maxNameLength + 2);
            this.currentATextField.setBackground(Color.white);
            this.currentBTextField.setBackground(Color.white);
            this.currentATextField.setEditable(false);
            this.currentBTextField.setEditable(false);
            JPanel bigPanel = new JPanel(new GridBagLayout());
            for (int i = 0; i < this.numPanels; ++i) {
                bigPanel.add((Component)panels[i], new GridBagConstraints(0, i, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
            JScrollPane scroll = new JScrollPane(bigPanel);
            scroll.setHorizontalScrollBarPolicy(32);
            scroll.setVerticalScrollBarPolicy(22);
            scroll.getHorizontalScrollBar().setUnitIncrement(20);
            scroll.getVerticalScrollBar().setUnitIncrement(20);
            TtestInitDialog.this.buildConstraints(this.constraints, 0, 0, 1, 1, 40, 100);
            this.constraints.fill = 1;
            this.gridbag.setConstraints(scroll, this.constraints);
            this.add(scroll);
            this.constraints.fill = 0;
            JPanel currentSelectionPanel = new JPanel();
            GridBagLayout grid2 = new GridBagLayout();
            currentSelectionPanel.setLayout(grid2);
            this.removeCurrentAButton = new JButton("< Remove A");
            this.removeCurrentBButton = new JButton("< Remove B");
            this.loadABPairButton = new JButton("   Load Pair >>   ");
            this.removeABPairButton = new JButton("<< Remove Pair");
            this.removeCurrentAButton.setEnabled(false);
            this.removeCurrentBButton.setEnabled(false);
            this.loadABPairButton.setEnabled(false);
            this.removeABPairButton.setEnabled(false);
            this.removeCurrentAButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TwoClassPairedPanel.this.exptButtons[TwoClassPairedPanel.this.currentAExpt].setEnabled(true);
                    TwoClassPairedPanel.this.currentAExpt = -1;
                    TwoClassPairedPanel.this.currentATextField.setText("");
                    TwoClassPairedPanel.this.currentAFilled = false;
                    TwoClassPairedPanel.this.removeCurrentAButton.setEnabled(false);
                    TwoClassPairedPanel.this.loadABPairButton.setEnabled(false);
                }
            });
            this.removeCurrentBButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TwoClassPairedPanel.this.exptButtons[TwoClassPairedPanel.this.currentBExpt].setEnabled(true);
                    TwoClassPairedPanel.this.currentBExpt = -1;
                    TwoClassPairedPanel.this.currentBTextField.setText("");
                    TwoClassPairedPanel.this.currentBFilled = false;
                    TwoClassPairedPanel.this.removeCurrentBButton.setEnabled(false);
                    TwoClassPairedPanel.this.loadABPairButton.setEnabled(false);
                }
            });
            this.loadABPairButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String currentPair = "A: " + TtestInitDialog.this.exptNames.get(TwoClassPairedPanel.this.currentAExpt) + " - B: " + TtestInitDialog.this.exptNames.get(TwoClassPairedPanel.this.currentBExpt);
                    TwoClassPairedPanel.this.pairedListModel.addElement(currentPair);
                    TwoClassPairedPanel.this.pairedAExpts.add(new Integer(TwoClassPairedPanel.this.currentAExpt));
                    TwoClassPairedPanel.this.pairedBExpts.add(new Integer(TwoClassPairedPanel.this.currentBExpt));
                    TwoClassPairedPanel.this.currentAExpt = -1;
                    TwoClassPairedPanel.this.currentBExpt = -1;
                    TwoClassPairedPanel.this.currentATextField.setText("");
                    TwoClassPairedPanel.this.currentBTextField.setText("");
                    TwoClassPairedPanel.this.currentAFilled = false;
                    TwoClassPairedPanel.this.currentBFilled = false;
                    TwoClassPairedPanel.this.removeCurrentAButton.setEnabled(false);
                    TwoClassPairedPanel.this.removeCurrentBButton.setEnabled(false);
                    TwoClassPairedPanel.this.loadABPairButton.setEnabled(false);
                    TwoClassPairedPanel.this.removeABPairButton.setEnabled(true);
                    TwoClassPairedPanel.this.pairedExptsList.setSelectedIndex(TwoClassPairedPanel.this.pairedListModel.size() - 1);
                    TtestInitDialog.this.pPanel.tDistButton.setSelected(true);
                    TtestInitDialog.this.sPanel.justAlphaButton.setSelected(true);
                    TtestInitDialog.this.sPanel.maxTButton.setSelected(false);
                    TtestInitDialog.this.sPanel.maxTButton.setEnabled(false);
                    TtestInitDialog.this.sPanel.minPButton.setSelected(false);
                    TtestInitDialog.this.sPanel.minPButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.randomGroupsButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.allCombsButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.timesField.setEnabled(false);
                    TtestInitDialog.this.pPanel.numCombsLabel.setText("                                                                            ");
                }
            });
            this.removeABPairButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    int index = TwoClassPairedPanel.this.pairedExptsList.getSelectedIndex();
                    TwoClassPairedPanel.this.pairedListModel.removeElementAt(index);
                    int removedAIndex = (Integer)TwoClassPairedPanel.this.pairedAExpts.remove(index);
                    int removedBIndex = (Integer)TwoClassPairedPanel.this.pairedBExpts.remove(index);
                    TwoClassPairedPanel.this.exptButtons[removedAIndex].setEnabled(true);
                    TwoClassPairedPanel.this.exptButtons[removedBIndex].setEnabled(true);
                    if (TwoClassPairedPanel.this.pairedListModel.isEmpty()) {
                        TwoClassPairedPanel.this.removeABPairButton.setEnabled(false);
                    } else {
                        TwoClassPairedPanel.this.pairedExptsList.setSelectedIndex(TwoClassPairedPanel.this.pairedListModel.size() - 1);
                    }
                    TtestInitDialog.this.pPanel.tDistButton.setSelected(true);
                    TtestInitDialog.this.sPanel.justAlphaButton.setSelected(true);
                    TtestInitDialog.this.sPanel.maxTButton.setSelected(false);
                    TtestInitDialog.this.sPanel.maxTButton.setEnabled(false);
                    TtestInitDialog.this.sPanel.minPButton.setSelected(false);
                    TtestInitDialog.this.sPanel.minPButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.randomGroupsButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.allCombsButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.timesField.setEnabled(false);
                    TtestInitDialog.this.pPanel.numCombsLabel.setText("                                                                            ");
                }
            });
            JScrollPane currentAScroll = new JScrollPane(this.currentATextField);
            currentAScroll.setMinimumSize(new Dimension(90, 50));
            JScrollPane currentBScroll = new JScrollPane(this.currentBTextField);
            currentBScroll.setMinimumSize(new Dimension(90, 50));
            currentAScroll.setHorizontalScrollBarPolicy(32);
            currentAScroll.setVerticalScrollBarPolicy(21);
            currentBScroll.setHorizontalScrollBarPolicy(32);
            currentBScroll.setVerticalScrollBarPolicy(21);
            currentAScroll.getHorizontalScrollBar().setUnitIncrement(20);
            currentAScroll.getVerticalScrollBar().setUnitIncrement(20);
            currentBScroll.getHorizontalScrollBar().setUnitIncrement(20);
            currentBScroll.getVerticalScrollBar().setUnitIncrement(20);
            TtestInitDialog.this.buildConstraints(this.constraints, 0, 0, 1, 1, 20, 50);
            grid2.setConstraints(this.removeCurrentAButton, this.constraints);
            currentSelectionPanel.add(this.removeCurrentAButton);
            JLabel aLabel = new JLabel(" Current A: ");
            TtestInitDialog.this.buildConstraints(this.constraints, 1, 0, 1, 1, 20, 0);
            grid2.setConstraints(aLabel, this.constraints);
            currentSelectionPanel.add(aLabel);
            TtestInitDialog.this.buildConstraints(this.constraints, 2, 0, 1, 1, 60, 0);
            this.constraints.fill = 1;
            grid2.setConstraints(currentAScroll, this.constraints);
            currentSelectionPanel.add(currentAScroll);
            this.constraints.fill = 0;
            TtestInitDialog.this.buildConstraints(this.constraints, 0, 1, 1, 1, 20, 50);
            grid2.setConstraints(this.removeCurrentBButton, this.constraints);
            currentSelectionPanel.add(this.removeCurrentBButton);
            JLabel bLabel = new JLabel("Current B: ");
            TtestInitDialog.this.buildConstraints(this.constraints, 1, 1, 1, 1, 20, 0);
            grid2.setConstraints(bLabel, this.constraints);
            currentSelectionPanel.add(bLabel);
            TtestInitDialog.this.buildConstraints(this.constraints, 2, 1, 1, 1, 60, 0);
            this.constraints.fill = 1;
            grid2.setConstraints(currentBScroll, this.constraints);
            currentSelectionPanel.add(currentBScroll);
            this.constraints.fill = 0;
            TtestInitDialog.this.buildConstraints(this.constraints, 1, 0, 1, 1, 10, 0);
            this.gridbag.setConstraints(currentSelectionPanel, this.constraints);
            this.add(currentSelectionPanel);
            this.constraints.fill = 0;
            JPanel pairButtonsPanel = new JPanel();
            GridBagLayout grid3 = new GridBagLayout();
            pairButtonsPanel.setLayout(grid3);
            TtestInitDialog.this.buildConstraints(this.constraints, 0, 0, 1, 1, 100, 50);
            grid3.setConstraints(this.loadABPairButton, this.constraints);
            pairButtonsPanel.add(this.loadABPairButton);
            TtestInitDialog.this.buildConstraints(this.constraints, 0, 1, 1, 1, 0, 50);
            grid3.setConstraints(this.removeABPairButton, this.constraints);
            pairButtonsPanel.add(this.removeABPairButton);
            TtestInitDialog.this.buildConstraints(this.constraints, 2, 0, 1, 1, 5, 0);
            this.gridbag.setConstraints(pairButtonsPanel, this.constraints);
            this.add(pairButtonsPanel);
            TtestInitDialog.this.buildConstraints(this.constraints, 3, 0, 1, 1, 45, 0);
            this.constraints.fill = 1;
            JScrollPane pairScroll = new JScrollPane(this.pairedExptsList);
            pairScroll.setBorder(new TitledBorder("Paired Samples"));
            this.gridbag.setConstraints(pairScroll, this.constraints);
            this.add(pairScroll);
        }

        public void reset() {
            for (int i = 0; i < this.exptButtons.length; ++i) {
                this.exptButtons[i].setEnabled(true);
                this.currentATextField.setText("");
                this.currentBTextField.setText("");
                this.removeCurrentAButton.setEnabled(false);
                this.removeCurrentBButton.setEnabled(false);
                this.loadABPairButton.setEnabled(false);
                this.removeABPairButton.setEnabled(false);
                this.pairedListModel.clear();
                this.currentAFilled = false;
                this.currentBFilled = false;
                this.currentAExpt = -1;
                this.currentBExpt = -1;
                this.pairedAExpts.clear();
                this.pairedBExpts.clear();
            }
        }

        class PairedExperimentsPanel
        extends JPanel {
        }

        class ExperimentButton
        extends JButton {
            String s;
            int index;

            public ExperimentButton(int i) {
                this.index = i;
                this.s = TtestInitDialog.this.exptNames.get(i);
                this.setText(this.s);
                this.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        if (TwoClassPairedPanel.this.currentAFilled && TwoClassPairedPanel.this.currentBFilled) {
                            JOptionPane.showMessageDialog(null, "Clear at least one current field first!", "Error", 0);
                        } else if (!TwoClassPairedPanel.this.currentAFilled) {
                            TwoClassPairedPanel.this.currentAExpt = ExperimentButton.this.index;
                            TwoClassPairedPanel.this.currentATextField.setText(ExperimentButton.this.s);
                            TwoClassPairedPanel.this.currentAFilled = true;
                            ExperimentButton.this.setEnabled(false);
                            TwoClassPairedPanel.this.removeCurrentAButton.setEnabled(true);
                        } else if (!TwoClassPairedPanel.this.currentBFilled) {
                            TwoClassPairedPanel.this.currentBExpt = ExperimentButton.this.index;
                            TwoClassPairedPanel.this.currentBTextField.setText(ExperimentButton.this.s);
                            TwoClassPairedPanel.this.currentBFilled = true;
                            ExperimentButton.this.setEnabled(false);
                            TwoClassPairedPanel.this.removeCurrentBButton.setEnabled(true);
                        }
                        if (TwoClassPairedPanel.this.currentAFilled && TwoClassPairedPanel.this.currentBFilled) {
                            TwoClassPairedPanel.this.loadABPairButton.setEnabled(true);
                        } else {
                            TwoClassPairedPanel.this.loadABPairButton.setEnabled(false);
                        }
                    }
                });
            }
        }
    }

    class TwoClassPairedMainPanel
    extends JPanel {
        TwoClassPairedPanel tcpPanel;
        JButton saveButton;
        JButton resetButton;
        JButton loadButton;
        GridBagConstraints constraints;
        GridBagLayout gridbag;
        JLabel lotsOfSamplesWarningLabel;

        public TwoClassPairedMainPanel() {
            this.tcpPanel = new TwoClassPairedPanel();
            JPanel bottomPanel = new JPanel();
            bottomPanel.setBackground(Color.white);
            this.constraints = new GridBagConstraints();
            this.gridbag = new GridBagLayout();
            this.setLayout(this.gridbag);
            TtestInitDialog.this.buildConstraints(this.constraints, 0, 0, 1, 1, 100, 90);
            this.constraints.fill = 1;
            this.gridbag.setConstraints(this.tcpPanel, this.constraints);
            this.add(this.tcpPanel);
            if (TtestInitDialog.this.lotsOfSamples) {
                this.lotsOfSamplesWarningLabel = new JLabel(TtestInitDialog.this.lotsOfSamplesWarningText);
                this.lotsOfSamplesWarningLabel.setBackground(Color.gray);
                this.add((Component)this.lotsOfSamplesWarningLabel, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
            GridBagLayout grid1 = new GridBagLayout();
            bottomPanel.setLayout(grid1);
            this.saveButton = new JButton("Save pairings");
            final JFileChooser fc = new JFileChooser(TMEV.getDataPath());
            this.saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    int returnVal = fc.showSaveDialog(TwoClassPairedMainPanel.this);
                    if (returnVal == 0) {
                        File file = fc.getSelectedFile();
                        try {
                            PrintWriter out = new PrintWriter(new FileOutputStream(file));
                            for (int i = 0; i < TwoClassPairedMainPanel.this.tcpPanel.pairedAExpts.size(); ++i) {
                                int currentA = (Integer)TwoClassPairedMainPanel.this.tcpPanel.pairedAExpts.get(i);
                                int currentB = (Integer)TwoClassPairedMainPanel.this.tcpPanel.pairedBExpts.get(i);
                                out.print(currentA);
                                out.print("\t");
                                out.print(currentB);
                                out.print("\t");
                                out.println();
                            }
                            out.flush();
                            out.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
            });
            this.constraints.fill = 0;
            TtestInitDialog.this.buildConstraints(this.constraints, 0, 1, 1, 1, 33, 100);
            grid1.setConstraints(this.saveButton, this.constraints);
            bottomPanel.add(this.saveButton);
            this.loadButton = new JButton("Load pairings");
            this.loadButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    int returnVal = fc.showOpenDialog(TwoClassPairedMainPanel.this);
                    if (returnVal == 0) {
                        TwoClassPairedMainPanel.this.tcpPanel.reset();
                        try {
                            String currentLine;
                            FileReader file = new FileReader(fc.getSelectedFile());
                            BufferedReader buff = new BufferedReader(file);
                            while ((currentLine = buff.readLine()) != null) {
                                StringSplitter st = new StringSplitter('\t');
                                st.init(currentLine);
                                for (int i = 0; i < 2; ++i) {
                                    String s = st.nextToken();
                                    if (i == 0) {
                                        TwoClassPairedMainPanel.this.tcpPanel.pairedAExpts.add(new Integer(s));
                                        continue;
                                    }
                                    if (i != 1) continue;
                                    TwoClassPairedMainPanel.this.tcpPanel.pairedBExpts.add(new Integer(s));
                                }
                            }
                            buff.close();
                            for (int i = 0; i < TwoClassPairedMainPanel.this.tcpPanel.pairedAExpts.size(); ++i) {
                                int currA = (Integer)TwoClassPairedMainPanel.this.tcpPanel.pairedAExpts.get(i);
                                int currB = (Integer)TwoClassPairedMainPanel.this.tcpPanel.pairedBExpts.get(i);
                                String currPair = "A: " + TtestInitDialog.this.exptNames.get(currA) + " - B: " + TtestInitDialog.this.exptNames.get(currB);
                                TwoClassPairedMainPanel.this.tcpPanel.exptButtons[currA].setEnabled(false);
                                TwoClassPairedMainPanel.this.tcpPanel.exptButtons[currB].setEnabled(false);
                                TwoClassPairedMainPanel.this.tcpPanel.pairedListModel.addElement(currPair);
                            }
                            if (TwoClassPairedMainPanel.this.tcpPanel.pairedAExpts.size() > 0) {
                                TwoClassPairedMainPanel.this.tcpPanel.removeABPairButton.setEnabled(true);
                                TwoClassPairedMainPanel.this.tcpPanel.pairedExptsList.setSelectedIndex(TwoClassPairedMainPanel.this.tcpPanel.pairedListModel.size() - 1);
                            }
                            TtestInitDialog.this.pPanel.tDistButton.setSelected(true);
                            TtestInitDialog.this.sPanel.justAlphaButton.setSelected(true);
                            TtestInitDialog.this.sPanel.maxTButton.setSelected(false);
                            TtestInitDialog.this.sPanel.maxTButton.setEnabled(false);
                            TtestInitDialog.this.sPanel.minPButton.setSelected(false);
                            TtestInitDialog.this.sPanel.minPButton.setEnabled(false);
                            TtestInitDialog.this.pPanel.randomGroupsButton.setEnabled(false);
                            TtestInitDialog.this.pPanel.allCombsButton.setEnabled(false);
                            TtestInitDialog.this.pPanel.timesField.setEnabled(false);
                            TtestInitDialog.this.pPanel.numCombsLabel.setText("                                                                            ");
                        }
                        catch (Exception exc) {
                            JOptionPane.showMessageDialog(TwoClassPairedMainPanel.this.tcpPanel, "Incompatible file!", "Error", 2);
                        }
                    }
                }
            });
            TtestInitDialog.this.buildConstraints(this.constraints, 1, 1, 1, 1, 33, 100);
            grid1.setConstraints(this.loadButton, this.constraints);
            bottomPanel.add(this.loadButton);
            this.resetButton = new JButton("Reset");
            this.resetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TwoClassPairedMainPanel.this.tcpPanel.reset();
                    TtestInitDialog.this.pPanel.tDistButton.setSelected(true);
                    TtestInitDialog.this.sPanel.justAlphaButton.setSelected(true);
                    TtestInitDialog.this.sPanel.maxTButton.setSelected(false);
                    TtestInitDialog.this.sPanel.maxTButton.setEnabled(false);
                    TtestInitDialog.this.sPanel.minPButton.setSelected(false);
                    TtestInitDialog.this.sPanel.minPButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.randomGroupsButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.allCombsButton.setEnabled(false);
                    TtestInitDialog.this.pPanel.timesField.setEnabled(false);
                    TtestInitDialog.this.pPanel.numCombsLabel.setText("                                                                            ");
                }
            });
            TtestInitDialog.this.buildConstraints(this.constraints, 2, 1, 1, 1, 34, 100);
            grid1.setConstraints(this.resetButton, this.constraints);
            bottomPanel.add(this.resetButton);
            TtestInitDialog.this.buildConstraints(this.constraints, 0, 2, 1, 1, 0, 10);
            this.gridbag.setConstraints(bottomPanel, this.constraints);
            this.add(bottomPanel);
        }
    }
}

