/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ttest;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.ClusterWrapper;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLGUI;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ttest.TTestClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ttest.TTestResults;
import org.tigr.microarray.mev.cluster.gui.impl.ttest.TTestVolcanoPlotViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ttest.TtestCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ttest.TtestCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ttest.TtestExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ttest.TtestInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.ttest.TtestInitDialog;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.util.FloatMatrix;

public class TtestGUI
implements IClusterGUI,
IScriptGUI {
    protected Algorithm algorithm;
    protected Progress progress;
    protected Experiment experiment;
    protected int[][] clusters;
    protected FloatMatrix means;
    protected FloatMatrix variances;
    protected String[] auxTitles;
    protected Object[][] auxData;
    protected Vector<Float> tValues;
    protected Vector<Float> rawPValues;
    protected Vector<Float> adjPValues;
    protected Vector<Float> qValues;
    protected Vector<Float> dfValues;
    protected Vector<Float> meansA;
    protected Vector<Float> meansB;
    protected Vector<Float> sdA;
    protected Vector<Float> sdB;
    protected Vector<Float> oneClassMeans;
    protected Vector<Float> oneClassSDs;
    protected Vector pairedGroupAExpts;
    protected Vector pairedGroupBExpts;
    protected IData data;
    protected Vector<String> exptNamesVector;
    protected int[] groupAssignments;
    public int tTestDesign;
    public int falseNum;
    protected double oneClassMean;
    protected double falseProp;
    protected boolean isPermutations;
    protected boolean useWelchDf;
    protected boolean drawSigTreesOnly;
    protected boolean doFastFDRApprox;
    protected boolean calculateAdjFDRPVals;
    protected boolean[] isSig;
    protected double[] diffMeansBA;
    protected double[] negLog10PValues;
    public static JFrame TtestFrame;
    protected TTestResults ttestResult;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework framework) throws AlgorithmException {
        boolean isPermut;
        this.experiment = framework.getData().getExperiment();
        this.exptNamesVector = new Vector();
        this.data = framework.getData();
        int number_of_samples = this.experiment.getNumberOfSamples();
        int number_of_genes = this.experiment.getNumberOfGenes();
        for (int i = 0; i < number_of_samples; ++i) {
            this.exptNamesVector.add(framework.getData().getSampleName(this.experiment.getSampleIndex(i)));
        }
        TtestInitDialog ttDialog = new TtestInitDialog((JFrame)framework.getFrame(), true, this.exptNamesVector, framework.getClusterRepository(1), framework.getData().getAllFilledAnnotationFields());
        ttDialog.setVisible(true);
        if (!ttDialog.isOkPressed()) {
            return null;
        }
        double alpha = 0.01;
        try {
            alpha = ttDialog.getAlphaValue();
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(framework.getFrame(), "Invalid alpha value!", "Error", 0);
            return null;
        }
        this.tTestDesign = ttDialog.getTestDesign();
        this.oneClassMean = 0.0;
        if (this.tTestDesign == 8) {
            this.groupAssignments = ttDialog.getOneClassAssignments();
            this.oneClassMean = ttDialog.getOneClassMean();
        } else if (this.tTestDesign == 7) {
            this.groupAssignments = ttDialog.getGroupAssignments();
        } else if (this.tTestDesign == 11) {
            this.pairedGroupAExpts = ttDialog.getPairedAExpts();
            this.pairedGroupBExpts = ttDialog.getPairedBExpts();
        } else if (this.tTestDesign == 14) {
            this.groupAssignments = ttDialog.getClusterGroupAssignments();
            if (this.groupAssignments == null) {
                return null;
            }
            this.tTestDesign = 7;
        } else if (this.tTestDesign == 15) {
            this.groupAssignments = ttDialog.getOneClassClusterAssignments();
            this.oneClassMean = ttDialog.getOneClassClusterMean();
            if (this.groupAssignments == null) {
                return null;
            }
            this.tTestDesign = 8;
        }
        int significanceMethod = ttDialog.getSignificanceMethod();
        if (significanceMethod == 12) {
            this.falseNum = ttDialog.getFalseNum();
            this.calculateAdjFDRPVals = ttDialog.calculateFDRPVals();
            this.doFastFDRApprox = ttDialog.doFastFDRApprox();
        }
        if (significanceMethod == 13) {
            this.falseProp = ttDialog.getFalseProp();
            this.calculateAdjFDRPVals = ttDialog.calculateFDRPVals();
            this.doFastFDRApprox = ttDialog.doFastFDRApprox();
        }
        boolean isHierarchicalTree = ttDialog.isDrawTrees();
        this.drawSigTreesOnly = true;
        if (isHierarchicalTree) {
            this.drawSigTreesOnly = ttDialog.drawSigTreesOnly();
        }
        this.isPermutations = isPermut = ttDialog.isPermut();
        int numCombs = ttDialog.getUserNumCombs();
        boolean useAllCombs = ttDialog.useAllCombs();
        this.useWelchDf = ttDialog.useWelchDf();
        int hcl_method = 0;
        boolean hcl_samples = false;
        boolean hcl_genes = false;
        IDistanceMenu menu = framework.getDistanceMenu();
        int function = menu.getDistanceFunction();
        if (function == 0) {
            function = 1;
        }
        int hcl_function = 4;
        boolean hcl_absolute = false;
        if (isHierarchicalTree) {
            HCLInitDialog hcl_dialog = new HCLInitDialog(framework.getFrame(), menu.getFunctionName(function), menu.isAbsoluteDistance(), true);
            if (hcl_dialog.showModal() != 0) {
                return null;
            }
            hcl_method = hcl_dialog.getMethod();
            hcl_samples = hcl_dialog.isClusterExperiments();
            hcl_genes = hcl_dialog.isClusterGenes();
            hcl_function = hcl_dialog.getDistanceMetric();
            hcl_absolute = hcl_dialog.getAbsoluteSelection();
        }
        Listener listener = new Listener();
        try {
            double currentP;
            int i;
            int i2;
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("TTEST");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            int genes = this.experiment.getNumberOfGenes();
            this.progress = new Progress(framework.getFrame(), "Finding significant genes", listener);
            this.progress.show();
            AlgorithmData data = new AlgorithmData();
            data.addMatrix("experiment", this.experiment.getMatrix());
            data.addParam("distance-factor", String.valueOf(1.0f));
            data.addParam("distance-absolute", String.valueOf(menu.isAbsoluteDistance()));
            data.addParam("distance-function", String.valueOf(function));
            data.addParam("tTestDesign", String.valueOf(this.tTestDesign));
            if (this.tTestDesign == 8 || this.tTestDesign == 7) {
                data.addIntArray("group-assignments", this.groupAssignments);
            }
            if (this.tTestDesign == 8) {
                data.addParam("oneClassMean", String.valueOf(this.oneClassMean));
            }
            if (this.tTestDesign == 11) {
                FloatMatrix pairedAExptsMatrix = new FloatMatrix(this.pairedGroupAExpts.size(), 1);
                FloatMatrix pairedBExptsMatrix = new FloatMatrix(this.pairedGroupBExpts.size(), 1);
                for (int i3 = 0; i3 < this.pairedGroupAExpts.size(); ++i3) {
                    pairedAExptsMatrix.A[i3][0] = ((Integer)this.pairedGroupAExpts.get(i3)).floatValue();
                    pairedBExptsMatrix.A[i3][0] = ((Integer)this.pairedGroupBExpts.get(i3)).floatValue();
                }
                data.addMatrix("pairedAExptsMatrix", pairedAExptsMatrix);
                data.addMatrix("pairedBExptsMatrix", pairedBExptsMatrix);
            }
            data.addParam("alpha", String.valueOf(alpha));
            data.addParam("significance-method", String.valueOf(significanceMethod));
            if (significanceMethod == 12) {
                data.addParam("falseNum", String.valueOf(this.falseNum));
                data.addParam("calculateAdjFDRPVals", String.valueOf(this.calculateAdjFDRPVals));
                data.addParam("useFastFDRApprox", String.valueOf(this.doFastFDRApprox));
            }
            if (significanceMethod == 13) {
                data.addParam("falseProp", String.valueOf((float)this.falseProp));
                data.addParam("calculateAdjFDRPVals", String.valueOf(this.calculateAdjFDRPVals));
                data.addParam("useFastFDRApprox", String.valueOf(this.doFastFDRApprox));
            }
            data.addParam("is-permut", String.valueOf(isPermut));
            data.addParam("num-combs", String.valueOf(numCombs));
            data.addParam("use-all-combs", String.valueOf(useAllCombs));
            data.addParam("useWelchDf", String.valueOf(this.useWelchDf));
            if (isHierarchicalTree) {
                data.addParam("hierarchical-tree", String.valueOf(true));
                data.addParam("draw-sig-trees-only", String.valueOf(this.drawSigTreesOnly));
                data.addParam("method-linkage", String.valueOf(hcl_method));
                data.addParam("calculate-genes", String.valueOf(hcl_genes));
                data.addParam("calculate-experiments", String.valueOf(hcl_samples));
                data.addParam("hcl-distance-function", String.valueOf(hcl_function));
                data.addParam("hcl-distance-absolute", String.valueOf(hcl_absolute));
            }
            long start = System.currentTimeMillis();
            AlgorithmData result = this.algorithm.execute(data);
            long time = System.currentTimeMillis() - start;
            Cluster result_cluster = result.getCluster("cluster");
            NodeList nodeList = result_cluster.getNodeList();
            AlgorithmParameters resultMap = result.getParams();
            int k = 2;
            this.clusters = new int[k][];
            for (int i4 = 0; i4 < k; ++i4) {
                this.clusters[i4] = nodeList.getNode(i4).getFeaturesIndexes();
            }
            this.means = result.getMatrix("clusters_means");
            this.variances = result.getMatrix("clusters_variances");
            FloatMatrix qValuesMatrix = result.getMatrix("qValues");
            FloatMatrix rawPValuesMatrix = result.getMatrix("rawPValues");
            FloatMatrix adjPValuesMatrix = result.getMatrix("adjPValues");
            FloatMatrix tValuesMatrix = result.getMatrix("tValues");
            FloatMatrix dfMatrix = result.getMatrix("dfValues");
            FloatMatrix meansAMatrix = result.getMatrix("meansAMatrix");
            FloatMatrix meansBMatrix = result.getMatrix("meansBMatrix");
            FloatMatrix sdAMatrix = result.getMatrix("sdAMatrix");
            FloatMatrix sdBMatrix = result.getMatrix("sdBMatrix");
            FloatMatrix isSigMatrix = result.getMatrix("isSigMatrix");
            FloatMatrix oneClassMeansMatrix = result.getMatrix("oneClassMeansMatrix");
            FloatMatrix oneClassSDsMatrix = result.getMatrix("oneClassSDsMatrix");
            this.ttestResult = new TTestResults();
            this.ttestResult.setTTestDesign(this.tTestDesign);
            this.ttestResult.setQValuesMatrix(result.getMatrix("qValues"));
            this.ttestResult.setRawPValuesMatrix(result.getMatrix("rawPValues"));
            this.ttestResult.setAdjPValuesMatrix(result.getMatrix("adjPValues"));
            this.ttestResult.setTValuesMatrix(result.getMatrix("tValues"));
            this.ttestResult.setDfMatrix(result.getMatrix("dfValues"));
            this.ttestResult.setMeansAMatrix(result.getMatrix("meansAMatrix"));
            this.ttestResult.setMeansBMatrix(result.getMatrix("meansBMatrix"));
            this.ttestResult.setSdAMatrix(result.getMatrix("sdAMatrix"));
            this.ttestResult.setSdBMatrix(result.getMatrix("sdBMatrix"));
            this.ttestResult.setOneClassMeansMatrix(result.getMatrix("oneClassMeansMatrix"));
            this.ttestResult.setOneClassSDsMatrix(result.getMatrix("oneClassSDsMatrix"));
            this.rawPValues = new Vector();
            this.adjPValues = new Vector();
            this.qValues = new Vector();
            this.tValues = new Vector();
            this.dfValues = new Vector();
            this.meansA = new Vector();
            this.meansB = new Vector();
            this.sdA = new Vector();
            this.sdB = new Vector();
            this.oneClassMeans = new Vector();
            this.oneClassSDs = new Vector();
            for (i2 = 0; i2 < rawPValuesMatrix.getRowDimension(); ++i2) {
                this.rawPValues.add(new Float(rawPValuesMatrix.A[i2][0]));
                this.adjPValues.add(new Float(adjPValuesMatrix.A[i2][0]));
                this.qValues.add(new Float(qValuesMatrix.A[i2][0]));
            }
            for (i2 = 0; i2 < tValuesMatrix.getRowDimension(); ++i2) {
                this.tValues.add(new Float(tValuesMatrix.A[i2][0]));
            }
            for (i2 = 0; i2 < dfMatrix.getRowDimension(); ++i2) {
                this.dfValues.add(new Float(dfMatrix.A[i2][0]));
            }
            if (this.tTestDesign == 8) {
                for (i2 = 0; i2 < oneClassMeansMatrix.getRowDimension(); ++i2) {
                    this.oneClassMeans.add(new Float(oneClassMeansMatrix.A[i2][0]));
                }
                for (i2 = 0; i2 < oneClassSDsMatrix.getRowDimension(); ++i2) {
                    this.oneClassSDs.add(new Float(oneClassSDsMatrix.A[i2][0]));
                }
            }
            if (this.tTestDesign == 7 || this.tTestDesign == 11) {
                for (i2 = 0; i2 < meansAMatrix.getRowDimension(); ++i2) {
                    this.meansA.add(new Float(meansAMatrix.A[i2][0]));
                    this.meansB.add(new Float(meansBMatrix.A[i2][0]));
                    this.sdA.add(new Float(sdAMatrix.A[i2][0]));
                    this.sdB.add(new Float(sdBMatrix.A[i2][0]));
                }
                this.isSig = new boolean[isSigMatrix.getRowDimension()];
                for (i2 = 0; i2 < this.isSig.length; ++i2) {
                    this.isSig[i2] = isSigMatrix.A[i2][0] == 1.0f;
                }
                this.diffMeansBA = new double[isSigMatrix.getRowDimension()];
                for (i2 = 0; i2 < this.diffMeansBA.length; ++i2) {
                    this.diffMeansBA[i2] = (double)meansBMatrix.A[i2][0] - (double)meansAMatrix.A[i2][0];
                }
                this.negLog10PValues = new double[isSigMatrix.getRowDimension()];
                double log10BaseE = Math.log(10.0);
                for (i = 0; i < this.negLog10PValues.length; ++i) {
                    currentP = adjPValuesMatrix.A[i][0];
                    this.negLog10PValues[i] = -1.0 * (Math.log(currentP) / log10BaseE);
                }
            }
            if (this.tTestDesign == 8) {
                int i5;
                this.isSig = new boolean[isSigMatrix.getRowDimension()];
                for (i5 = 0; i5 < this.isSig.length; ++i5) {
                    this.isSig[i5] = isSigMatrix.A[i5][0] == 1.0f;
                }
                this.diffMeansBA = new double[isSigMatrix.getRowDimension()];
                for (i5 = 0; i5 < this.diffMeansBA.length; ++i5) {
                    this.diffMeansBA[i5] = (double)oneClassMeansMatrix.A[i5][0] - this.oneClassMean;
                }
                this.negLog10PValues = new double[isSigMatrix.getRowDimension()];
                double log10BaseE = Math.log(10.0);
                for (i = 0; i < this.negLog10PValues.length; ++i) {
                    currentP = adjPValuesMatrix.A[i][0];
                    this.negLog10PValues[i] = -1.0 * (Math.log(currentP) / log10BaseE);
                }
            }
            this.ttestResult.setIsSig(this.isSig);
            this.ttestResult.setDiffMeansBA(this.diffMeansBA);
            this.ttestResult.setNegLog10PValues(this.negLog10PValues);
            this.ttestResult.setCalculateAdjFDRPVals(this.calculateAdjFDRPVals);
            this.ttestResult.setSignificanceMethod(significanceMethod);
            GeneralInfo info = new GeneralInfo();
            info.time = time;
            info.alpha = alpha;
            info.sigMethod = this.getSigMethod(significanceMethod);
            info.pValueBasedOn = this.getPValueBasedOn(isPermut);
            if (isPermut) {
                info.useAllCombs = useAllCombs;
                info.numCombs = numCombs;
            }
            info.function = menu.getFunctionName(function);
            info.hcl = isHierarchicalTree;
            info.hcl_genes = hcl_genes;
            info.hcl_samples = hcl_samples;
            info.hcl_method = hcl_method;
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(result_cluster, info);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    public AlgorithmData getScriptParameters(IFramework framework) {
        this.experiment = framework.getData().getExperiment();
        this.exptNamesVector = new Vector();
        this.data = framework.getData();
        int number_of_samples = this.experiment.getNumberOfSamples();
        int number_of_genes = this.experiment.getNumberOfGenes();
        for (int i = 0; i < number_of_samples; ++i) {
            this.exptNamesVector.add(framework.getData().getSampleName(this.experiment.getSampleIndex(i)));
        }
        TtestInitDialog ttDialog = new TtestInitDialog((JFrame)framework.getFrame(), true, this.exptNamesVector, framework.getClusterRepository(1), framework.getData().getAllFilledAnnotationFields());
        ttDialog.setVisible(true);
        if (!ttDialog.isOkPressed()) {
            return null;
        }
        double alpha = 0.01;
        try {
            alpha = ttDialog.getAlphaValue();
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(framework.getFrame(), "Invalid alpha value!", "Error", 0);
            return null;
        }
        this.tTestDesign = ttDialog.getTestDesign();
        this.oneClassMean = 0.0;
        if (this.tTestDesign == 8) {
            this.groupAssignments = ttDialog.getOneClassAssignments();
            this.oneClassMean = ttDialog.getOneClassMean();
        } else if (this.tTestDesign == 7) {
            this.groupAssignments = ttDialog.getGroupAssignments();
        } else if (this.tTestDesign == 11) {
            this.pairedGroupAExpts = ttDialog.getPairedAExpts();
            this.pairedGroupBExpts = ttDialog.getPairedBExpts();
        } else if (this.tTestDesign == 14) {
            this.groupAssignments = ttDialog.getClusterGroupAssignments();
            if (this.groupAssignments == null) {
                return null;
            }
            this.tTestDesign = 7;
        } else if (this.tTestDesign == 15) {
            this.groupAssignments = ttDialog.getOneClassClusterAssignments();
            this.oneClassMean = ttDialog.getOneClassClusterMean();
            if (this.groupAssignments == null) {
                return null;
            }
            this.tTestDesign = 8;
        }
        int significanceMethod = ttDialog.getSignificanceMethod();
        if (significanceMethod == 12) {
            this.falseNum = ttDialog.getFalseNum();
            this.calculateAdjFDRPVals = ttDialog.calculateFDRPVals();
            this.doFastFDRApprox = ttDialog.doFastFDRApprox();
        }
        if (significanceMethod == 13) {
            this.falseProp = ttDialog.getFalseProp();
            this.calculateAdjFDRPVals = ttDialog.calculateFDRPVals();
            this.doFastFDRApprox = ttDialog.doFastFDRApprox();
        }
        boolean isHierarchicalTree = ttDialog.isDrawTrees();
        this.drawSigTreesOnly = true;
        if (isHierarchicalTree) {
            this.drawSigTreesOnly = ttDialog.drawSigTreesOnly();
        }
        boolean isPermut = ttDialog.isPermut();
        this.useWelchDf = ttDialog.useWelchDf();
        this.isPermutations = isPermut;
        int numCombs = ttDialog.getUserNumCombs();
        boolean useAllCombs = ttDialog.useAllCombs();
        IDistanceMenu menu = framework.getDistanceMenu();
        int function = menu.getDistanceFunction();
        if (function == 0) {
            function = 1;
        }
        int hcl_method = 0;
        boolean hcl_samples = false;
        boolean hcl_genes = false;
        int hcl_function = 4;
        boolean hcl_absolute = false;
        if (isHierarchicalTree) {
            HCLInitDialog hcl_dialog = new HCLInitDialog(framework.getFrame(), menu.getFunctionName(function), menu.isAbsoluteDistance(), true);
            if (hcl_dialog.showModal() != 0) {
                return null;
            }
            hcl_method = hcl_dialog.getMethod();
            hcl_samples = hcl_dialog.isClusterExperiments();
            hcl_genes = hcl_dialog.isClusterGenes();
            hcl_function = hcl_dialog.getDistanceMetric();
            hcl_absolute = hcl_dialog.getAbsoluteSelection();
        }
        int genes = this.experiment.getNumberOfGenes();
        AlgorithmData data = new AlgorithmData();
        data.addParam("distance-factor", String.valueOf(1.0f));
        data.addParam("distance-absolute", String.valueOf(menu.isAbsoluteDistance()));
        data.addParam("distance-function", String.valueOf(function));
        data.addParam("tTestDesign", String.valueOf(this.tTestDesign));
        if (this.tTestDesign == 8 || this.tTestDesign == 7) {
            data.addIntArray("group-assignments", this.groupAssignments);
        }
        if (this.tTestDesign == 8) {
            data.addParam("oneClassMean", String.valueOf(this.oneClassMean));
        }
        if (this.tTestDesign == 11) {
            FloatMatrix pairedAExptsMatrix = new FloatMatrix(this.pairedGroupAExpts.size(), 1);
            FloatMatrix pairedBExptsMatrix = new FloatMatrix(this.pairedGroupBExpts.size(), 1);
            for (int i = 0; i < this.pairedGroupAExpts.size(); ++i) {
                pairedAExptsMatrix.A[i][0] = ((Integer)this.pairedGroupAExpts.get(i)).floatValue();
                pairedBExptsMatrix.A[i][0] = ((Integer)this.pairedGroupBExpts.get(i)).floatValue();
            }
            data.addMatrix("pairedAExptsMatrix", pairedAExptsMatrix);
            data.addMatrix("pairedBExptsMatrix", pairedBExptsMatrix);
        }
        data.addParam("alpha", String.valueOf(alpha));
        data.addParam("significance-method", String.valueOf(significanceMethod));
        if (significanceMethod == 12) {
            data.addParam("falseNum", String.valueOf(this.falseNum));
            data.addParam("calculateAdjFDRPVals", String.valueOf(this.calculateAdjFDRPVals));
            data.addParam("useFastFDRApprox", String.valueOf(this.doFastFDRApprox));
        }
        if (significanceMethod == 13) {
            data.addParam("falseProp", String.valueOf((float)this.falseProp));
            data.addParam("calculateAdjFDRPVals", String.valueOf(this.calculateAdjFDRPVals));
            data.addParam("useFastFDRApprox", String.valueOf(this.doFastFDRApprox));
        }
        data.addParam("is-permut", String.valueOf(isPermut));
        data.addParam("num-combs", String.valueOf(numCombs));
        data.addParam("use-all-combs", String.valueOf(useAllCombs));
        data.addParam("useWelchDf", String.valueOf(this.useWelchDf));
        if (isHierarchicalTree) {
            data.addParam("hierarchical-tree", String.valueOf(true));
            data.addParam("draw-sig-trees-only", String.valueOf(this.drawSigTreesOnly));
            data.addParam("method-linkage", String.valueOf(hcl_method));
            data.addParam("calculate-genes", String.valueOf(hcl_genes));
            data.addParam("calculate-experiments", String.valueOf(hcl_samples));
            data.addParam("hcl-distance-function", String.valueOf(hcl_function));
            data.addParam("hcl-distance-absolute", String.valueOf(hcl_absolute));
        }
        data.addParam("name", "TTEST");
        data.addParam("alg-type", "cluster-genes");
        data.addParam("output-class", "partition-output");
        String[] outputNodes = new String[]{"Significant Genes", "Non-significant Genes"};
        data.addStringArray("output-nodes", outputNodes);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode executeScript(IFramework framework, AlgorithmData algData, Experiment experiment) throws AlgorithmException {
        Listener listener = new Listener();
        try {
            int i;
            double currentP;
            int i2;
            int i3;
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("TTEST");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            this.experiment = experiment;
            this.data = framework.getData();
            this.groupAssignments = algData.getIntArray("group-assignments");
            this.isPermutations = algData.getParams().getBoolean("is-permut");
            this.useWelchDf = algData.getParams().getBoolean("useWelchDf");
            this.drawSigTreesOnly = algData.getParams().getBoolean("draw-sig-trees-only");
            this.exptNamesVector = new Vector();
            int number_of_samples = experiment.getNumberOfSamples();
            for (int i4 = 0; i4 < number_of_samples; ++i4) {
                this.exptNamesVector.add(this.data.getSampleName(i4));
            }
            int significanceMethod = algData.getParams().getInt("significance-method");
            algData.addMatrix("experiment", experiment.getMatrix());
            this.tTestDesign = algData.getParams().getInt("tTestDesign");
            if (significanceMethod == 12) {
                this.falseNum = algData.getParams().getInt("falseNum");
                System.out.println("executeScript: fasleNum = " + this.falseNum);
            } else if (significanceMethod == 13) {
                this.falseProp = algData.getParams().getFloat("falseProp");
                System.out.println("executeScript: falseProp = " + this.falseProp);
            }
            int genes = experiment.getNumberOfGenes();
            if (this.tTestDesign == 11) {
                FloatMatrix pairedAExptsMatrix = algData.getMatrix("pairedAExptsMatrix");
                FloatMatrix pairedBExptsMatrix = algData.getMatrix("pairedBExptsMatrix");
                this.pairedGroupAExpts = new Vector();
                this.pairedGroupBExpts = new Vector();
                for (int i5 = 0; i5 < pairedAExptsMatrix.A.length; ++i5) {
                    this.pairedGroupAExpts.add(new Integer((int)pairedAExptsMatrix.A[i5][0]));
                    this.pairedGroupBExpts.add(new Integer((int)pairedBExptsMatrix.A[i5][0]));
                }
            }
            this.progress = new Progress(framework.getFrame(), "Finding significant genes", listener);
            this.progress.show();
            long start = System.currentTimeMillis();
            AlgorithmData result = this.algorithm.execute(algData);
            long time = System.currentTimeMillis() - start;
            Cluster result_cluster = result.getCluster("cluster");
            NodeList nodeList = result_cluster.getNodeList();
            AlgorithmParameters resultMap = result.getParams();
            int k = 2;
            this.clusters = new int[k][];
            for (int i6 = 0; i6 < k; ++i6) {
                this.clusters[i6] = nodeList.getNode(i6).getFeaturesIndexes();
            }
            TTestResults ttestResult = new TTestResults();
            FloatMatrix rawPValuesMatrix = result.getMatrix("rawPValues");
            FloatMatrix adjPValuesMatrix = result.getMatrix("adjPValues");
            FloatMatrix qValuesMatrix = result.getMatrix("qValues");
            FloatMatrix tValuesMatrix = result.getMatrix("tValues");
            FloatMatrix dfMatrix = result.getMatrix("dfValues");
            FloatMatrix meansAMatrix = result.getMatrix("meansAMatrix");
            FloatMatrix meansBMatrix = result.getMatrix("meansBMatrix");
            FloatMatrix sdAMatrix = result.getMatrix("sdAMatrix");
            FloatMatrix sdBMatrix = result.getMatrix("sdBMatrix");
            FloatMatrix isSigMatrix = result.getMatrix("isSigMatrix");
            FloatMatrix oneClassMeansMatrix = result.getMatrix("oneClassMeansMatrix");
            FloatMatrix oneClassSDsMatrix = result.getMatrix("oneClassSDsMatrix");
            ttestResult.setTTestDesign(this.tTestDesign);
            ttestResult.setRawPValuesMatrix(result.getMatrix("rawPValues"));
            ttestResult.setAdjPValuesMatrix(result.getMatrix("adjPValues"));
            ttestResult.setQValuesMatrix(result.getMatrix("qValues"));
            ttestResult.setTValuesMatrix(result.getMatrix("tValues"));
            ttestResult.setDfMatrix(result.getMatrix("dfValues"));
            ttestResult.setMeansAMatrix(result.getMatrix("meansAMatrix"));
            ttestResult.setMeansBMatrix(result.getMatrix("meansBMatrix"));
            ttestResult.setSdAMatrix(result.getMatrix("sdAMatrix"));
            ttestResult.setSdBMatrix(result.getMatrix("sdBMatrix"));
            ttestResult.setOneClassMeansMatrix(result.getMatrix("oneClassMeansMatrix"));
            ttestResult.setOneClassSDsMatrix(result.getMatrix("oneClassSDsMatrix"));
            this.rawPValues = new Vector();
            this.adjPValues = new Vector();
            this.qValues = new Vector();
            this.tValues = new Vector();
            this.dfValues = new Vector();
            this.meansA = new Vector();
            this.meansB = new Vector();
            this.sdA = new Vector();
            this.sdB = new Vector();
            this.oneClassMeans = new Vector();
            this.oneClassSDs = new Vector();
            for (i3 = 0; i3 < rawPValuesMatrix.getRowDimension(); ++i3) {
                this.rawPValues.add(new Float(rawPValuesMatrix.A[i3][0]));
                this.adjPValues.add(new Float(adjPValuesMatrix.A[i3][0]));
                this.qValues.add(new Float(qValuesMatrix.A[i3][0]));
            }
            for (i3 = 0; i3 < tValuesMatrix.getRowDimension(); ++i3) {
                this.tValues.add(new Float(tValuesMatrix.A[i3][0]));
            }
            for (i3 = 0; i3 < dfMatrix.getRowDimension(); ++i3) {
                this.dfValues.add(new Float(dfMatrix.A[i3][0]));
            }
            if (this.tTestDesign == 8) {
                for (i3 = 0; i3 < oneClassMeansMatrix.getRowDimension(); ++i3) {
                    this.oneClassMeans.add(new Float(oneClassMeansMatrix.A[i3][0]));
                }
                for (i3 = 0; i3 < oneClassSDsMatrix.getRowDimension(); ++i3) {
                    this.oneClassSDs.add(new Float(oneClassSDsMatrix.A[i3][0]));
                }
            }
            if (this.tTestDesign == 7 || this.tTestDesign == 11) {
                for (i3 = 0; i3 < meansAMatrix.getRowDimension(); ++i3) {
                    this.meansA.add(new Float(meansAMatrix.A[i3][0]));
                    this.meansB.add(new Float(meansBMatrix.A[i3][0]));
                    this.sdA.add(new Float(sdAMatrix.A[i3][0]));
                    this.sdB.add(new Float(sdBMatrix.A[i3][0]));
                }
                this.isSig = new boolean[isSigMatrix.getRowDimension()];
                for (i3 = 0; i3 < this.isSig.length; ++i3) {
                    this.isSig[i3] = isSigMatrix.A[i3][0] == 1.0f;
                }
                this.diffMeansBA = new double[isSigMatrix.getRowDimension()];
                for (i3 = 0; i3 < this.diffMeansBA.length; ++i3) {
                    this.diffMeansBA[i3] = (double)meansBMatrix.A[i3][0] - (double)meansAMatrix.A[i3][0];
                }
                this.negLog10PValues = new double[isSigMatrix.getRowDimension()];
                double log10BaseE = Math.log(10.0);
                for (i2 = 0; i2 < this.negLog10PValues.length; ++i2) {
                    currentP = adjPValuesMatrix.A[i2][0];
                    this.negLog10PValues[i2] = -1.0 * (Math.log(currentP) / log10BaseE);
                }
            }
            if (this.tTestDesign == 8) {
                int i7;
                this.isSig = new boolean[isSigMatrix.getRowDimension()];
                for (i7 = 0; i7 < this.isSig.length; ++i7) {
                    this.isSig[i7] = isSigMatrix.A[i7][0] == 1.0f;
                }
                this.diffMeansBA = new double[isSigMatrix.getRowDimension()];
                for (i7 = 0; i7 < this.diffMeansBA.length; ++i7) {
                    this.diffMeansBA[i7] = (double)oneClassMeansMatrix.A[i7][0] - this.oneClassMean;
                }
                this.negLog10PValues = new double[isSigMatrix.getRowDimension()];
                double log10BaseE = Math.log(10.0);
                for (i2 = 0; i2 < this.negLog10PValues.length; ++i2) {
                    currentP = adjPValuesMatrix.A[i2][0];
                    this.negLog10PValues[i2] = -1.0 * (Math.log(currentP) / log10BaseE);
                }
            }
            ttestResult.setIsSig(this.isSig);
            ttestResult.setDiffMeansBA(this.diffMeansBA);
            ttestResult.setNegLog10PValues(this.negLog10PValues);
            ttestResult.setCalculateAdjFDRPVals(this.calculateAdjFDRPVals);
            ttestResult.setSignificanceMethod(significanceMethod);
            GeneralInfo info = new GeneralInfo();
            info.time = time;
            AlgorithmParameters params = algData.getParams();
            info.alpha = params.getFloat("alpha");
            info.sigMethod = this.getSigMethod(params.getInt("significance-method"));
            boolean isPermut = params.getBoolean("is-permut");
            info.pValueBasedOn = this.getPValueBasedOn(isPermut);
            if (isPermut) {
                info.useAllCombs = params.getBoolean("use-all-combs");
                info.numCombs = params.getInt("num-combs");
            }
            info.function = framework.getDistanceMenu().getFunctionName(params.getInt("distance-function"));
            info.hcl = params.getBoolean("hierarchical-tree");
            if (info.hcl) {
                info.hcl_genes = params.getBoolean("calculate-genes");
                info.hcl_samples = params.getBoolean("calculate-experiments");
                info.hcl_method = params.getInt("method-linkage");
            }
            Vector<String> titlesVector = new Vector<String>();
            if (this.tTestDesign == 7 || this.tTestDesign == 11) {
                titlesVector.add("GroupA mean");
                titlesVector.add("GroupA std.dev.");
                titlesVector.add("GroupB mean");
                titlesVector.add("GroupB std.dev.");
                titlesVector.add("Absolute t value");
            } else if (this.tTestDesign == 8) {
                titlesVector.add("Gene mean");
                titlesVector.add("Gene std.dev.");
                titlesVector.add("t value");
            }
            titlesVector.add("Degrees of freedom");
            titlesVector.add("Raw p value");
            titlesVector.add("FDR");
            if (significanceMethod == 12 || significanceMethod == 13) {
                if (this.calculateAdjFDRPVals) {
                    titlesVector.add("Adj p value");
                }
            } else {
                titlesVector.add("Adj p value");
            }
            this.auxTitles = new String[titlesVector.size()];
            for (i = 0; i < this.auxTitles.length; ++i) {
                this.auxTitles[i] = (String)titlesVector.get(i);
            }
            this.auxData = new Object[experiment.getNumberOfGenes()][this.auxTitles.length];
            for (i = 0; i < this.auxData.length; ++i) {
                int counter = 0;
                if (this.tTestDesign == 7 || this.tTestDesign == 11) {
                    this.auxData[i][counter++] = this.meansA.get(i);
                    this.auxData[i][counter++] = this.sdA.get(i);
                    this.auxData[i][counter++] = this.meansB.get(i);
                    this.auxData[i][counter++] = this.sdB.get(i);
                } else if (this.tTestDesign == 8) {
                    this.auxData[i][counter++] = this.oneClassMeans.get(i);
                    this.auxData[i][counter++] = this.oneClassSDs.get(i);
                }
                this.auxData[i][counter++] = this.tValues.get(i);
                this.auxData[i][counter++] = this.dfValues.get(i);
                this.auxData[i][counter++] = this.rawPValues.get(i);
                this.auxData[i][counter++] = this.qValues.get(i);
                if (significanceMethod == 12 || significanceMethod == 13) {
                    if (!this.calculateAdjFDRPVals) continue;
                    this.auxData[i][counter++] = this.adjPValues.get(i);
                    continue;
                }
                this.auxData[i][counter++] = this.adjPValues.get(i);
            }
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(result_cluster, info);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    protected String getPValueBasedOn(boolean isPerm) {
        String str = "";
        str = isPerm ? "permutation" : "t-distribution";
        return str;
    }

    protected String getSigMethod(int sigMethod) {
        String methodName = "";
        if (sigMethod == 4) {
            methodName = "Just alpha";
        } else if (sigMethod == 5) {
            methodName = "Standard Bonferroni correction";
        } else if (sigMethod == 6) {
            methodName = "Adjusted Bonferroni correction";
        } else if (sigMethod == 10) {
            methodName = "Step-down Westfall Young: Min P";
        } else if (sigMethod == 9) {
            methodName = "Step-down Westfall Young: Max T";
        } else if (sigMethod == 12) {
            methodName = "False significant number: " + this.falseNum + " or less";
        } else if (sigMethod == 13) {
            methodName = "False significant proportion: " + this.falseProp + " or less";
        }
        return methodName;
    }

    protected DefaultMutableTreeNode createResultTree(Cluster result_cluster, GeneralInfo info) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("T Tests");
        this.addResultNodes(root, result_cluster, info);
        return root;
    }

    protected void addResultNodes(DefaultMutableTreeNode root, Cluster result_cluster, GeneralInfo info) {
        this.addExpressionImages(root);
        this.addHierarchicalTrees(root, result_cluster, info);
        this.addCentroidViews(root);
        this.addTableViews(root);
        this.addClusterInfo(root);
        this.addVolcanoPlot(root);
        this.addGeneralInfo(root, info);
    }

    protected void addTableViews(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Table Views");
        TTestClusterTableViewer tabViewer = new TTestClusterTableViewer(this.experiment, ClusterWrapper.wrapClusters((int[][])this.clusters), this.data, this.ttestResult);
        for (int i = 0; i < this.clusters.length; ++i) {
            if (i < this.clusters.length - 1) {
                node.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", (IViewer)tabViewer, (Object)new Integer(i))));
                continue;
            }
            if (i != this.clusters.length - 1) continue;
            node.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)tabViewer, (Object)new Integer(i))));
        }
        root.add(node);
    }

    protected void addExpressionImages(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Expression Images");
        TtestExperimentViewer expViewer = new TtestExperimentViewer(this.experiment, this.clusters, this.tTestDesign, (Vector)this.oneClassMeans, (Vector)this.oneClassSDs, (Vector)this.meansA, (Vector)this.meansB, (Vector)this.sdA, (Vector)this.sdB, (Vector)this.rawPValues, (Vector)this.adjPValues, (Vector)this.tValues, (Vector)this.dfValues);
        for (int i = 0; i < this.clusters.length; ++i) {
            if (i < this.clusters.length - 1) {
                node.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", (IViewer)expViewer, (Object)new Integer(i))));
                continue;
            }
            if (i != this.clusters.length - 1) continue;
            node.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)expViewer, (Object)new Integer(i))));
        }
        root.add(node);
    }

    protected void addHierarchicalTrees(DefaultMutableTreeNode root, Cluster result_cluster, GeneralInfo info) {
        if (!info.hcl) {
            return;
        }
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Hierarchical Trees");
        NodeList nodeList = result_cluster.getNodeList();
        if (!this.drawSigTreesOnly) {
            for (int i = 0; i < nodeList.getSize(); ++i) {
                if (i < nodeList.getSize() - 1) {
                    node.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", this.createHCLViewer(nodeList.getNode(i), info))));
                    continue;
                }
                if (i != nodeList.getSize() - 1) continue;
                node.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", this.createHCLViewer(nodeList.getNode(i), info))));
            }
        } else {
            node.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", this.createHCLViewer(nodeList.getNode(0), info))));
        }
        root.add(node);
    }

    protected IViewer createHCLViewer(Node clusterNode, GeneralInfo info) {
        HCLTreeData genes_result;
        HCLTreeData hCLTreeData = genes_result = info.hcl_genes ? this.getResult(clusterNode, 0) : null;
        HCLTreeData samples_result = info.hcl_samples ? this.getResult(clusterNode, info.hcl_genes ? 4 : 0) : null;
        return new HCLViewer(this.experiment, clusterNode.getFeaturesIndexes(), genes_result, samples_result);
    }

    protected HCLTreeData getResult(Node clusterNode, int pos) {
        HCLTreeData data = new HCLTreeData();
        NodeValueList valueList = clusterNode.getValues();
        data.child_1_array = (int[])valueList.getNodeValue((int)pos).value;
        data.child_2_array = (int[])valueList.getNodeValue((int)(pos + 1)).value;
        data.node_order = (int[])valueList.getNodeValue((int)(pos + 2)).value;
        data.height = (float[])valueList.getNodeValue((int)(pos + 3)).value;
        return data;
    }

    protected void addClusterInfo(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Cluster Information");
        node.add(new DefaultMutableTreeNode(new LeafInfo("Results (#,%)", (IViewer)new TtestInfoViewer(this.clusters, this.experiment.getNumberOfGenes()))));
        root.add(node);
    }

    protected void addCentroidViews(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode centroidNode = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode expressionNode = new DefaultMutableTreeNode("Expression Graphs");
        TtestCentroidViewer centroidViewer = new TtestCentroidViewer(this.experiment, ClusterWrapper.wrapClusters((int[][])this.clusters), this.ttestResult);
        centroidViewer.setMeans(this.means.A);
        centroidViewer.setVariances(this.variances.A);
        for (int i = 0; i < this.clusters.length; ++i) {
            if (i == 0) {
                centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
                expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
                continue;
            }
            if (i != 1) continue;
            centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
            expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
        }
        TtestCentroidsViewer centroidsViewer = new TtestCentroidsViewer(this.experiment, this.clusters, this.tTestDesign, this.oneClassMeans, this.oneClassSDs, this.meansA, this.meansB, this.sdA, this.sdB, this.rawPValues, this.adjPValues, this.tValues, this.dfValues);
        centroidsViewer.setMeans(this.means.A);
        centroidsViewer.setVariances(this.variances.A);
        centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("All Genes", (IViewer)centroidsViewer, (Object)new Integer(0))));
        expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("All Genes", (IViewer)centroidsViewer, (Object)new Integer(1))));
        root.add(centroidNode);
        root.add(expressionNode);
    }

    protected void addVolcanoPlot(DefaultMutableTreeNode root) {
        TTestVolcanoPlotViewer volcanoPlotViewer = new TTestVolcanoPlotViewer(this.experiment, this.ttestResult);
        root.add(new DefaultMutableTreeNode(new LeafInfo("Volcano Plot", (IViewer)volcanoPlotViewer)));
    }

    protected void addGeneralInfo(DefaultMutableTreeNode root, GeneralInfo info) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("General Information");
        node.add(new DefaultMutableTreeNode("Test design: " + info.getTestDesign()));
        node.add(this.getGroupAssignmentInfo());
        if (this.tTestDesign == 8) {
            node.add(new DefaultMutableTreeNode("Mean tested against: " + this.oneClassMean));
        }
        if (this.tTestDesign == 7) {
            if (this.useWelchDf) {
                node.add(new DefaultMutableTreeNode("used Welch approximation"));
            } else {
                node.add(new DefaultMutableTreeNode("assumed equal variances"));
            }
        }
        if (info.sigMethod.startsWith("False")) {
            node.add(new DefaultMutableTreeNode("Confidence (1 - alpha) : " + (1.0 - info.alpha) * 100.0 + " %"));
        } else {
            node.add(new DefaultMutableTreeNode("Alpha (overall threshold p-value): " + info.alpha));
        }
        node.add(new DefaultMutableTreeNode("P-values based on: " + info.pValueBasedOn));
        if (this.isPermutations) {
            node.add(new DefaultMutableTreeNode("All permutations used: " + info.useAllCombs));
            node.add(new DefaultMutableTreeNode("Number of permutations per gene: " + info.numCombs));
        }
        if (info.sigMethod.startsWith("False")) {
            node.add(new DefaultMutableTreeNode(info.sigMethod));
        } else {
            node.add(new DefaultMutableTreeNode("Significance determined by: " + info.sigMethod));
        }
        if (info.sigMethod.startsWith("False")) {
            if (this.doFastFDRApprox) {
                node.add(new DefaultMutableTreeNode("False discovery calculation: fast approximation"));
            } else {
                node.add(new DefaultMutableTreeNode("False discovery calculation: exhaustive computation"));
            }
        }
        node.add(new DefaultMutableTreeNode("HCL: " + info.getMethodName()));
        node.add(new DefaultMutableTreeNode("Time: " + String.valueOf(info.time) + " ms"));
        if (info.hcl) {
            node.add(new DefaultMutableTreeNode(info.function));
        }
        root.add(node);
    }

    protected DefaultMutableTreeNode getGroupAssignmentInfo() {
        DefaultMutableTreeNode groupAssignmentInfo = new DefaultMutableTreeNode();
        if (this.tTestDesign == 7) {
            groupAssignmentInfo = new DefaultMutableTreeNode("Group assigments ");
            DefaultMutableTreeNode groupA = new DefaultMutableTreeNode("Group A ");
            DefaultMutableTreeNode groupB = new DefaultMutableTreeNode("Group B ");
            DefaultMutableTreeNode neitherGroup = new DefaultMutableTreeNode("Neither group ");
            int neitherGroupCounter = 0;
            for (int i = 0; i < this.groupAssignments.length; ++i) {
                if (this.groupAssignments[i] == 1) {
                    groupA.add(new DefaultMutableTreeNode(this.exptNamesVector.get(i)));
                    continue;
                }
                if (this.groupAssignments[i] == 2) {
                    groupB.add(new DefaultMutableTreeNode(this.exptNamesVector.get(i)));
                    continue;
                }
                neitherGroup.add(new DefaultMutableTreeNode(this.exptNamesVector.get(i)));
                ++neitherGroupCounter;
            }
            groupAssignmentInfo.add(groupA);
            groupAssignmentInfo.add(groupB);
            if (neitherGroupCounter > 0) {
                groupAssignmentInfo.add(neitherGroup);
            }
        } else if (this.tTestDesign == 8) {
            groupAssignmentInfo = new DefaultMutableTreeNode("Sample details");
            DefaultMutableTreeNode in = new DefaultMutableTreeNode("In analysis ");
            DefaultMutableTreeNode out = new DefaultMutableTreeNode("Out of analysis ");
            int outCounter = 0;
            for (int i = 0; i < this.groupAssignments.length; ++i) {
                if (this.groupAssignments[i] == 1) {
                    in.add(new DefaultMutableTreeNode(this.exptNamesVector.get(i)));
                    continue;
                }
                out.add(new DefaultMutableTreeNode(this.exptNamesVector.get(i)));
                ++outCounter;
            }
            if (outCounter == 0) {
                out.add(new DefaultMutableTreeNode("None"));
            }
            groupAssignmentInfo.add(in);
            groupAssignmentInfo.add(out);
        } else if (this.tTestDesign == 11) {
            int i;
            groupAssignmentInfo = new DefaultMutableTreeNode("Pairings ");
            boolean[] paired = new boolean[this.exptNamesVector.size()];
            for (int i2 = 0; i2 < paired.length; ++i2) {
                paired[i2] = false;
            }
            DefaultMutableTreeNode pairs = new DefaultMutableTreeNode("Sample Pairs");
            DefaultMutableTreeNode nonPairs = new DefaultMutableTreeNode("Unpaired Samples");
            for (i = 0; i < this.pairedGroupAExpts.size(); ++i) {
                int currentA = (Integer)this.pairedGroupAExpts.get(i);
                int currentB = (Integer)this.pairedGroupBExpts.get(i);
                pairs.add(new DefaultMutableTreeNode("A: " + this.exptNamesVector.get(currentA) + " - B: " + this.exptNamesVector.get(currentB)));
                paired[currentA] = true;
                paired[currentB] = true;
            }
            for (i = 0; i < paired.length; ++i) {
                if (paired[i]) continue;
                nonPairs.add(new DefaultMutableTreeNode(this.exptNamesVector.get(i)));
            }
            groupAssignmentInfo.add(pairs);
            if (!nonPairs.isLeaf()) {
                groupAssignmentInfo.add(nonPairs);
            }
        }
        return groupAssignmentInfo;
    }

    protected class GeneralInfo {
        public int clusters;
        public String design;
        public String sigMethod;
        public String pValueBasedOn;
        public double alpha;
        public int numCombs;
        public boolean useAllCombs;
        public long time;
        public String function;
        public String fdrFastOrSlow;
        protected boolean hcl;
        protected int hcl_method;
        protected boolean hcl_genes;
        protected boolean hcl_samples;

        protected GeneralInfo() {
        }

        public String getMethodName() {
            return this.hcl ? HCLGUI.GeneralInfo.getMethodName(this.hcl_method) : "no linkage";
        }

        public String getTestDesign() {
            String design = "";
            if (TtestGUI.this.tTestDesign == 8) {
                design = "One-class";
            } else if (TtestGUI.this.tTestDesign == 7) {
                design = "Between-subjects";
            } else if (TtestGUI.this.tTestDesign == 11) {
                design = "Paired";
            }
            return design;
        }
    }

    protected class Listener
    extends DialogListener
    implements AlgorithmListener {
        public void valueChanged(AlgorithmEvent event) {
            switch (event.getId()) {
                case 1: {
                    TtestGUI.this.progress.setUnits(event.getIntValue());
                    TtestGUI.this.progress.setDescription(event.getDescription());
                    break;
                }
                case 2: {
                    TtestGUI.this.progress.setValue(event.getIntValue());
                    TtestGUI.this.progress.setDescription(event.getDescription());
                    break;
                }
                case 3: {
                    int value = event.getIntValue();
                    if (value != -1) break;
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("cancel-command")) {
                TtestGUI.this.algorithm.abort();
                TtestGUI.this.progress.dispose();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            TtestGUI.this.algorithm.abort();
            TtestGUI.this.progress.dispose();
        }
    }
}

