/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ttest;

import java.awt.Component;
import java.awt.Frame;
import java.beans.Expression;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.ClusterWrapper;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExpressionFileFilter;
import org.tigr.microarray.mev.cluster.gui.helpers.ExpressionFileView;
import org.tigr.util.FloatMatrix;

public class TtestExperimentViewer
extends ExperimentViewer {
    private Vector<Float> tValues;
    private Vector<Float> rawPValues;
    private Vector<Float> adjPValues;
    private Vector<Float> dfValues;
    private Vector<Float> meansA;
    private Vector<Float> meansB;
    private Vector<Float> sdA;
    private Vector<Float> sdB;
    private Vector<Float> oneClassMeans;
    private Vector<Float> oneClassSDs;
    private int tTestDesign;

    public TtestExperimentViewer(Experiment experiment, int[][] clusters, int tTestDesign, Vector oneClassMeans, Vector oneClassSDs, Vector meansA, Vector meansB, Vector sdA, Vector sdB, Vector rawPValues, Vector adjPValues, Vector tValues, Vector dfValues) {
        super(experiment, clusters);
        this.tTestDesign = tTestDesign;
        this.oneClassMeans = oneClassMeans;
        this.oneClassSDs = oneClassSDs;
        this.rawPValues = rawPValues;
        this.adjPValues = adjPValues;
        this.tValues = tValues;
        this.dfValues = dfValues;
        this.meansA = meansA;
        this.meansB = meansB;
        this.sdA = sdA;
        this.sdB = sdB;
    }

    public TtestExperimentViewer(Experiment e, int[][] clusters, Integer tTestDesign, Vector oneClassMeans, Vector oneClassSDs, Vector meansA, Vector meansB, Vector sdA, Vector sdB, Vector rawPValues, Vector adjPValues, Vector tValues, Vector dfValues) {
        super(e, clusters);
        this.tTestDesign = tTestDesign;
        this.oneClassMeans = oneClassMeans;
        this.oneClassSDs = oneClassSDs;
        this.rawPValues = rawPValues;
        this.adjPValues = adjPValues;
        this.tValues = tValues;
        this.dfValues = dfValues;
        this.meansA = meansA;
        this.meansB = meansB;
        this.sdA = sdA;
        this.sdB = sdB;
    }

    public TtestExperimentViewer(Experiment e, ClusterWrapper clusters, Integer tTestDesign, Vector oneClassMeans, Vector oneClassSDs, Vector meansA, Vector meansB, Vector sdA, Vector sdB, Vector rawPValues, Vector adjPValues, Vector tValues, Vector dfValues) {
        super(e, clusters.getClusters());
        this.tTestDesign = tTestDesign;
        this.oneClassMeans = oneClassMeans;
        this.oneClassSDs = oneClassSDs;
        this.rawPValues = rawPValues;
        this.adjPValues = adjPValues;
        this.tValues = tValues;
        this.dfValues = dfValues;
        this.meansA = meansA;
        this.meansB = meansB;
        this.sdA = sdA;
        this.sdB = sdB;
    }

    public TtestExperimentViewer(Experiment e, ClusterWrapper clusters, Integer tTestDesign, FloatMatrix oneClassMeans, FloatMatrix oneClassSDs, FloatMatrix rawPValues, FloatMatrix adjPValues, FloatMatrix tValues, FloatMatrix dfValues, FloatMatrix meansA, FloatMatrix meansB, FloatMatrix sdA, FloatMatrix sdB) {
        super(e, clusters.getClusters());
        this.tTestDesign = tTestDesign;
        if (oneClassMeans != null && oneClassMeans.A != null && oneClassMeans.A[0] != null) {
            this.oneClassMeans = TtestExperimentViewer.toVector(oneClassMeans.A[0]);
        }
        if (oneClassSDs != null && oneClassSDs.A != null && oneClassSDs.A[0] != null) {
            this.oneClassSDs = TtestExperimentViewer.toVector(oneClassSDs.A[0]);
        }
        if (rawPValues != null && rawPValues.A != null && rawPValues.A[0] != null) {
            this.rawPValues = TtestExperimentViewer.toVector(rawPValues.A[0]);
        }
        if (adjPValues != null && adjPValues.A != null && adjPValues.A[0] != null) {
            this.adjPValues = TtestExperimentViewer.toVector(adjPValues.A[0]);
        }
        if (tValues != null && tValues.A != null && tValues.A[0] != null) {
            this.tValues = TtestExperimentViewer.toVector(tValues.A[0]);
        }
        if (dfValues != null && dfValues.A != null && dfValues.A[0] != null) {
            this.dfValues = TtestExperimentViewer.toVector(dfValues.A[0]);
        }
        if (meansA != null && meansA.A != null && meansA.A[0] != null) {
            this.meansA = TtestExperimentViewer.toVector(meansA.A[0]);
        }
        if (meansB != null && meansB.A != null && meansB.A[0] != null) {
            this.meansB = TtestExperimentViewer.toVector(meansB.A[0]);
        }
        if (sdA != null && sdA.A != null && sdA.A[0] != null) {
            this.sdA = TtestExperimentViewer.toVector(sdA.A[0]);
        }
        if (sdB != null && sdB.A != null && sdB.A[0] != null) {
            this.sdB = TtestExperimentViewer.toVector(sdB.A[0]);
        }
    }

    public Expression getExpression() {
        Object[] superExpressionArgs = super.getExpression().getArguments();
        return new Expression((Object)this, ((Object)((Object)this)).getClass(), "new", new Object[]{superExpressionArgs[0], superExpressionArgs[1], new Integer(this.tTestDesign), TtestExperimentViewer.toFloatMatrix(this.oneClassMeans), TtestExperimentViewer.toFloatMatrix(this.oneClassSDs), TtestExperimentViewer.toFloatMatrix(this.rawPValues), TtestExperimentViewer.toFloatMatrix(this.adjPValues), TtestExperimentViewer.toFloatMatrix(this.tValues), TtestExperimentViewer.toFloatMatrix(this.dfValues), TtestExperimentViewer.toFloatMatrix(this.meansA), TtestExperimentViewer.toFloatMatrix(this.meansB), TtestExperimentViewer.toFloatMatrix(this.sdA), TtestExperimentViewer.toFloatMatrix(this.sdB)});
    }

    private static Vector<Float> toVector(float[] temp) {
        Vector<Float> returnVector = new Vector<Float>(temp.length);
        for (int i = 0; i < temp.length; ++i) {
            returnVector.add(i, Float.valueOf(temp[i]));
        }
        return returnVector;
    }

    private static FloatMatrix toFloatMatrix(Vector<Float> temp) {
        float[] test = new float[temp.size()];
        for (int j = 0; j < temp.size(); ++j) {
            test[j] = temp.get(j).floatValue();
        }
        return new FloatMatrix((float[][])new float[][]{test});
    }

    public void saveClusters(Frame frame) throws Exception {
        frame = frame == null ? JOptionPane.getFrameForComponent((Component)((Object)this)) : frame;
        this.saveExperiment(frame, this.getExperiment(), this.getData(), this.getClusters());
    }

    public void saveCluster(Frame frame) throws Exception {
        frame = frame == null ? JOptionPane.getFrameForComponent((Component)((Object)this)) : frame;
        this.saveExperiment(frame, this.getExperiment(), this.getData(), this.getCluster());
    }

    public void saveExperiment(Frame frame, Experiment experiment, IData data, int[] rows) throws Exception {
        File file = TtestExperimentViewer.getFile(frame);
        if (file != null) {
            this.saveCluster(file, experiment, data, rows);
        }
    }

    public void saveExperiment(Frame frame, Experiment experiment, IData data, int[][] clusters) throws Exception {
        File file = TtestExperimentViewer.getFile(frame);
        if (file != null) {
            for (int i = 0; i < clusters.length; ++i) {
                if (clusters[i] == null || clusters[i].length == 0) continue;
                File aFile = new File(file.getPath() + "-" + String.valueOf(i + 1) + ".txt");
                this.saveCluster(aFile, experiment, data, clusters[i]);
            }
        }
    }

    private void saveCluster(File file, Experiment experiment, IData data, int[] rows) throws Exception {
        int i;
        PrintWriter out = new PrintWriter(new FileOutputStream(file));
        String[] fieldNames = data.getFieldNames();
        out.print("Original row");
        out.print("\t");
        for (i = 0; i < fieldNames.length; ++i) {
            out.print(fieldNames[i]);
            out.print("\t");
        }
        if (this.tTestDesign == 7 || this.tTestDesign == 11) {
            out.print("GroupA mean\t");
            out.print("GroupA std.dev.\t");
            out.print("GroupB mean\t");
            out.print("GroupB std.dev.\t");
            out.print("Absolute t value");
        } else if (this.tTestDesign == 8) {
            out.print("Gene mean\t");
            out.print("Gene std.dev.\t");
            out.print("t value");
        }
        out.print("\t");
        out.print("Degrees of freedom\t");
        out.print("Raw p value\t");
        out.print("Adj p value");
        for (i = 0; i < experiment.getNumberOfSamples(); ++i) {
            out.print("\t");
            out.print(data.getSampleName(experiment.getSampleIndex(i)));
        }
        out.print("\n");
        for (i = 0; i < rows.length; ++i) {
            out.print(Integer.toString(experiment.getGeneIndexMappedToData(rows[i]) + 1));
            out.print("\t");
            for (int k = 0; k < fieldNames.length; ++k) {
                out.print(data.getElementAttribute(experiment.getGeneIndexMappedToData(rows[i]), k));
                out.print("\t");
            }
            if (this.tTestDesign == 7 || this.tTestDesign == 11) {
                out.print(this.meansA.get(rows[i]).floatValue() + "\t");
                out.print(this.sdA.get(rows[i]).floatValue() + "\t");
                out.print(this.meansB.get(rows[i]).floatValue() + "\t");
                out.print(this.sdB.get(rows[i]).floatValue() + "\t");
            } else if (this.tTestDesign == 8) {
                out.print(this.oneClassMeans.get(rows[i]).floatValue() + "\t");
                out.print(this.oneClassSDs.get(rows[i]).floatValue() + "\t");
            }
            out.print("" + this.tValues.get(rows[i]).floatValue());
            out.print("\t");
            out.print("" + this.dfValues.get(rows[i]).intValue());
            out.print("\t");
            out.print("" + this.rawPValues.get(rows[i]).floatValue());
            out.print("\t");
            out.print("" + this.adjPValues.get(rows[i]).floatValue());
            for (int j = 0; j < experiment.getNumberOfSamples(); ++j) {
                out.print("\t");
                out.print(Float.toString(experiment.get(rows[i], j)));
            }
            out.print("\n");
        }
        out.flush();
        out.close();
    }

    private static File getFile(Frame frame) {
        File file = null;
        JFileChooser fc = new JFileChooser(TMEV.getFile((String)"data/"));
        fc.addChoosableFileFilter((FileFilter)new ExpressionFileFilter());
        fc.setFileView((FileView)new ExpressionFileView());
        int ret = fc.showSaveDialog(frame);
        if (ret == 0) {
            file = fc.getSelectedFile();
        }
        return file;
    }
}

