/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ttest;

import java.awt.Frame;
import java.beans.Expression;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExpressionFileFilter;
import org.tigr.microarray.mev.cluster.gui.helpers.ExpressionFileView;
import org.tigr.util.FloatMatrix;

public class TtestCentroidsViewer
extends CentroidsViewer {
    private Vector tValues;
    private Vector rawPValues;
    private Vector adjPValues;
    private Vector dfValues;
    private Vector meansA;
    private Vector meansB;
    private Vector sdA;
    private Vector sdB;
    private Vector oneClassMeans;
    private Vector oneClassSDs;
    private int tTestDesign;

    public TtestCentroidsViewer(Experiment experiment, int[][] clusters, int tTestDesign, Vector oneClassMeans, Vector oneClassSDs, Vector meansA, Vector meansB, Vector sdA, Vector sdB, Vector rawPValues, Vector adjPValues, Vector tValues, Vector dfValues) {
        super(experiment, clusters);
        this.tTestDesign = tTestDesign;
        this.oneClassMeans = oneClassMeans;
        this.oneClassSDs = oneClassSDs;
        this.rawPValues = rawPValues;
        this.adjPValues = adjPValues;
        this.tValues = tValues;
        this.dfValues = dfValues;
        this.meansA = meansA;
        this.meansB = meansB;
        this.sdA = sdA;
        this.sdB = sdB;
    }

    public TtestCentroidsViewer(CentroidViewer cv, Integer tTestDesign, Vector oneClassMeans, Vector oneClassSDs, Vector meansA, Vector meansB, Vector sdA, Vector sdB, Vector rawPValues, Vector adjPValues, Vector tValues, Vector dfValues) {
        super(cv);
        this.tTestDesign = tTestDesign;
        this.oneClassMeans = oneClassMeans;
        this.oneClassSDs = oneClassSDs;
        this.rawPValues = rawPValues;
        this.adjPValues = adjPValues;
        this.tValues = tValues;
        this.dfValues = dfValues;
        this.meansA = meansA;
        this.meansB = meansB;
        this.sdA = sdA;
        this.sdB = sdB;
    }

    public TtestCentroidsViewer(CentroidViewer cv, Integer tTestDesign, FloatMatrix oneClassMeans, FloatMatrix oneClassSDs, FloatMatrix rawPValues, FloatMatrix adjPValues, FloatMatrix tValues, FloatMatrix dfValues, FloatMatrix meansA, FloatMatrix meansB, FloatMatrix sdA, FloatMatrix sdB) {
        super(cv);
        this.tTestDesign = tTestDesign;
        if (oneClassMeans != null && oneClassMeans.A != null && oneClassMeans.A[0] != null) {
            this.oneClassMeans = TtestCentroidsViewer.toVector(oneClassMeans.A[0]);
        }
        if (oneClassSDs != null && oneClassSDs.A != null && oneClassSDs.A[0] != null) {
            this.oneClassSDs = TtestCentroidsViewer.toVector(oneClassSDs.A[0]);
        }
        if (rawPValues != null && rawPValues.A != null && rawPValues.A[0] != null) {
            this.rawPValues = TtestCentroidsViewer.toVector(rawPValues.A[0]);
        }
        if (adjPValues != null && adjPValues.A != null && adjPValues.A[0] != null) {
            this.adjPValues = TtestCentroidsViewer.toVector(adjPValues.A[0]);
        }
        if (tValues != null && tValues.A != null && tValues.A[0] != null) {
            this.tValues = TtestCentroidsViewer.toVector(tValues.A[0]);
        }
        if (dfValues != null && dfValues.A != null && dfValues.A[0] != null) {
            this.dfValues = TtestCentroidsViewer.toVector(dfValues.A[0]);
        }
        if (meansA != null && meansA.A != null && meansA.A[0] != null) {
            this.meansA = TtestCentroidsViewer.toVector(meansA.A[0]);
        }
        if (meansB != null && meansB.A != null && meansB.A[0] != null) {
            this.meansB = TtestCentroidsViewer.toVector(meansB.A[0]);
        }
        if (sdA != null && sdA.A != null && sdA.A[0] != null) {
            this.sdA = TtestCentroidsViewer.toVector(sdA.A[0]);
        }
        if (sdB != null && sdB.A != null && sdB.A[0] != null) {
            this.sdB = TtestCentroidsViewer.toVector(sdB.A[0]);
        }
    }

    private static Vector<Float> toVector(float[] temp) {
        Vector<Float> returnVector = new Vector<Float>(temp.length);
        for (int i = 0; i < temp.length; ++i) {
            returnVector.add(i, Float.valueOf(temp[i]));
        }
        return returnVector;
    }

    private static FloatMatrix toFloatMatrix(Vector<Float> temp) {
        float[] test = new float[temp.size()];
        for (int j = 0; j < temp.size(); ++j) {
            test[j] = temp.get(j).floatValue();
        }
        return new FloatMatrix((float[][])new float[][]{test});
    }

    public Expression getExpression() {
        return new Expression((Object)this, ((Object)((Object)this)).getClass(), "new", new Object[]{this.centroidViewer, new Integer(this.tTestDesign), TtestCentroidsViewer.toFloatMatrix(this.oneClassMeans), TtestCentroidsViewer.toFloatMatrix(this.oneClassSDs), TtestCentroidsViewer.toFloatMatrix(this.rawPValues), TtestCentroidsViewer.toFloatMatrix(this.adjPValues), TtestCentroidsViewer.toFloatMatrix(this.tValues), TtestCentroidsViewer.toFloatMatrix(this.dfValues), TtestCentroidsViewer.toFloatMatrix(this.meansA), TtestCentroidsViewer.toFloatMatrix(this.meansB), TtestCentroidsViewer.toFloatMatrix(this.sdA), TtestCentroidsViewer.toFloatMatrix(this.sdB)});
    }

    protected void onSaveClusters() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            this.saveExperiment(frame, this.getExperiment(), this.getData(), this.getClusters());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(frame, "Can not save cluster!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    public void saveExperiment(Frame frame, Experiment experiment, IData data, int[][] clusters) throws Exception {
        File file = TtestCentroidsViewer.getFile(frame);
        if (file != null) {
            for (int i = 0; i < clusters.length; ++i) {
                if (clusters[i] == null || clusters[i].length == 0) continue;
                File aFile = new File(file.getPath() + "-" + String.valueOf(i + 1) + ".txt");
                this.saveCluster(aFile, experiment, data, clusters[i]);
            }
        }
    }

    private void saveCluster(File file, Experiment experiment, IData data, int[] rows) throws Exception {
        int i;
        PrintWriter out = new PrintWriter(new FileOutputStream(file));
        String[] fieldNames = data.getFieldNames();
        out.print("Original row");
        out.print("\t");
        for (i = 0; i < fieldNames.length; ++i) {
            out.print(fieldNames[i]);
            out.print("\t");
        }
        if (this.tTestDesign == 7 || this.tTestDesign == 11) {
            out.print("GroupA mean\t");
            out.print("GroupA std.dev.\t");
            out.print("GroupB mean\t");
            out.print("GroupB std.dev.\t");
            out.print("Absolute t value");
        } else if (this.tTestDesign == 8) {
            out.print("Gene mean\t");
            out.print("Gene std.dev.\t");
            out.print("t value");
        }
        out.print("\t");
        out.print("Degrees of freedom\t");
        out.print("Raw p value\t");
        out.print("Adj p value");
        for (i = 0; i < experiment.getNumberOfSamples(); ++i) {
            out.print("\t");
            out.print(data.getSampleName(experiment.getSampleIndex(i)));
        }
        out.print("\n");
        for (i = 0; i < rows.length; ++i) {
            out.print(Integer.toString(experiment.getGeneIndexMappedToData(rows[i]) + 1));
            out.print("\t");
            for (int k = 0; k < fieldNames.length; ++k) {
                out.print(data.getElementAttribute(experiment.getGeneIndexMappedToData(rows[i]), k));
                out.print("\t");
            }
            if (this.tTestDesign == 7 || this.tTestDesign == 11) {
                out.print(((Float)this.meansA.get(rows[i])).floatValue() + "\t");
                out.print(((Float)this.sdA.get(rows[i])).floatValue() + "\t");
                out.print(((Float)this.meansB.get(rows[i])).floatValue() + "\t");
                out.print(((Float)this.sdB.get(rows[i])).floatValue() + "\t");
            } else if (this.tTestDesign == 8) {
                out.print(((Float)this.oneClassMeans.get(rows[i])).floatValue() + "\t");
                out.print(((Float)this.oneClassSDs.get(rows[i])).floatValue() + "\t");
            }
            out.print("" + ((Float)this.tValues.get(rows[i])).floatValue());
            out.print("\t");
            out.print("" + ((Float)this.dfValues.get(rows[i])).intValue());
            out.print("\t");
            out.print("" + ((Float)this.rawPValues.get(rows[i])).floatValue());
            out.print("\t");
            out.print("" + ((Float)this.adjPValues.get(rows[i])).floatValue());
            for (int j = 0; j < experiment.getNumberOfSamples(); ++j) {
                out.print("\t");
                out.print(Float.toString(experiment.get(rows[i], j)));
            }
            out.print("\n");
        }
        out.flush();
        out.close();
    }

    private static File getFile(Frame frame) {
        File file = null;
        JFileChooser fc = new JFileChooser(TMEV.getFile((String)"data/"));
        fc.addChoosableFileFilter((FileFilter)new ExpressionFileFilter());
        fc.setFileView((FileView)new ExpressionFileView());
        int ret = fc.showSaveDialog(frame);
        if (ret == 0) {
            file = fc.getSelectedFile();
        }
        return file;
    }
}

