/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ttest;

import java.awt.Frame;
import java.beans.Expression;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.ClusterWrapper;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExpressionFileFilter;
import org.tigr.microarray.mev.cluster.gui.helpers.ExpressionFileView;
import org.tigr.microarray.mev.cluster.gui.impl.ttest.TTestResults;
import org.tigr.util.FloatMatrix;

public class TtestCentroidViewer
extends CentroidViewer {
    private TTestResults results;

    public TtestCentroidViewer(Experiment experiment, ClusterWrapper clusters, TTestResults results) {
        super(experiment, clusters);
        this.results = results;
    }

    public TtestCentroidViewer(Experiment experiment, int[][] clusters, int tTestDesign, Vector<Float> oneClassMeans, Vector<Float> oneClassSDs, Vector<Float> meansA, Vector<Float> meansB, Vector<Float> sdA, Vector<Float> sdB, Vector<Float> rawPValues, Vector<Float> adjPValues, Vector<Float> tValues, Vector<Float> dfValues) {
        super(experiment, clusters);
        this.results = this.createResults(tTestDesign, oneClassMeans, oneClassSDs, meansA, meansB, sdA, sdB, rawPValues, adjPValues, tValues, dfValues);
    }

    private TTestResults createResults(int tTestDesign, Vector<Float> oneClassMeans, Vector<Float> oneClassSDs, Vector<Float> meansA, Vector<Float> meansB, Vector<Float> sdA, Vector<Float> sdB, Vector<Float> rawPValues, Vector<Float> adjPValues, Vector<Float> tValues, Vector<Float> dfValues) {
        TTestResults temp = new TTestResults();
        temp = new TTestResults();
        temp.setAdjPValuesMatrix(TtestCentroidViewer.toFloatMatrix(adjPValues));
        temp.setDfMatrix(TtestCentroidViewer.toFloatMatrix(dfValues));
        temp.setMeansAMatrix(TtestCentroidViewer.toFloatMatrix(meansA));
        temp.setMeansBMatrix(TtestCentroidViewer.toFloatMatrix(meansB));
        temp.setOneClassMeansMatrix(TtestCentroidViewer.toFloatMatrix(oneClassMeans));
        temp.setOneClassSDsMatrix(TtestCentroidViewer.toFloatMatrix(oneClassSDs));
        temp.setRawPValuesMatrix(TtestCentroidViewer.toFloatMatrix(rawPValues));
        temp.setSdAMatrix(TtestCentroidViewer.toFloatMatrix(sdA));
        temp.setSdBMatrix(TtestCentroidViewer.toFloatMatrix(sdB));
        temp.setTTestDesign(tTestDesign);
        temp.setTValuesMatrix(TtestCentroidViewer.toFloatMatrix(tValues));
        return temp;
    }

    public TtestCentroidViewer(Experiment e, ClusterWrapper clusters, float[][] variances, float[][] means, float[][] codes, Integer tTestDesign, Vector<Float> oneClassMeans, Vector<Float> oneClassSDs, Vector<Float> meansA, Vector<Float> meansB, Vector<Float> sdA, Vector<Float> sdB, Vector<Float> rawPValues, Vector<Float> adjPValues, Vector<Float> tValues, Vector<Float> dfValues) {
        this(e, clusters.getClusters(), variances, means, codes, tTestDesign, oneClassMeans, oneClassSDs, meansA, meansB, sdA, sdB, rawPValues, adjPValues, tValues, dfValues);
    }

    private static FloatMatrix toFloatMatrix(Vector<Float> temp) {
        float[] test = new float[temp.size()];
        for (int j = 0; j < temp.size(); ++j) {
            test[j] = temp.get(j).floatValue();
        }
        return new FloatMatrix((float[][])new float[][]{test});
    }

    public TtestCentroidViewer(Experiment e, int[][] clusters, float[][] variances, float[][] means, float[][] codes, Integer tTestDesign, Vector oneClassMeans, Vector oneClassSDs, Vector meansA, Vector meansB, Vector sdA, Vector sdB, Vector rawPValues, Vector adjPValues, Vector tValues, Vector dfValues) {
        super(e, clusters, variances, means, codes);
        this.results = this.createResults(tTestDesign, oneClassMeans, oneClassSDs, meansA, meansB, sdA, sdB, rawPValues, adjPValues, tValues, dfValues);
    }

    public Expression getExpression() {
        Object[] superExpressionArgs = super.getExpression().getArguments();
        return new Expression((Object)this, ((Object)((Object)this)).getClass(), "new", new Object[]{superExpressionArgs[0], superExpressionArgs[1], this.results});
    }

    protected void onSaveClusters() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            this.saveExperiment(frame, this.getExperiment(), this.getData(), this.getClusters());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(frame, "Can not save clusters!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    protected void onSaveCluster() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            this.saveExperiment(frame, this.getExperiment(), this.getData(), this.getCluster());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(frame, "Can not save cluster!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    public void saveExperiment(Frame frame, Experiment experiment, IData data, int[] rows) throws Exception {
        File file = TtestCentroidViewer.getFile(frame);
        if (file != null) {
            this.saveCluster(file, experiment, data, rows);
        }
    }

    public void saveExperiment(Frame frame, Experiment experiment, IData data, int[][] clusters) throws Exception {
        File file = TtestCentroidViewer.getFile(frame);
        if (file != null) {
            for (int i = 0; i < clusters.length; ++i) {
                if (clusters[i] == null || clusters[i].length == 0) continue;
                File aFile = new File(file.getPath() + "-" + String.valueOf(i + 1) + ".txt");
                this.saveCluster(aFile, experiment, data, clusters[i]);
            }
        }
    }

    private void saveCluster(File file, Experiment experiment, IData data, int[] rows) throws Exception {
        int i;
        PrintWriter out = new PrintWriter(new FileOutputStream(file));
        String[] fieldNames = data.getFieldNames();
        out.print("Original row");
        out.print("\t");
        for (i = 0; i < fieldNames.length; ++i) {
            out.print(fieldNames[i]);
            out.print("\t");
        }
        if (this.results.getTTestDesign() == 7 || this.results.getTTestDesign() == 11) {
            out.print("GroupA mean\t");
            out.print("GroupA std.dev.\t");
            out.print("GroupB mean\t");
            out.print("GroupB std.dev.\t");
            out.print("Absolute t value");
        } else if (this.results.getTTestDesign() == 8) {
            out.print("Gene mean\t");
            out.print("Gene std.dev.\t");
            out.print("t value");
        }
        out.print("\t");
        out.print("Degrees of freedom\t");
        out.print("Raw p value\t");
        out.print("Adj p value");
        for (i = 0; i < experiment.getNumberOfSamples(); ++i) {
            out.print("\t");
            out.print(data.getSampleName(experiment.getSampleIndex(i)));
        }
        out.print("\n");
        for (i = 0; i < rows.length; ++i) {
            out.print(Integer.toString(experiment.getGeneIndexMappedToData(rows[i]) + 1));
            out.print("\t");
            for (int k = 0; k < fieldNames.length; ++k) {
                out.print(data.getElementAttribute(experiment.getGeneIndexMappedToData(rows[i]), k));
                out.print("\t");
            }
            if (this.results.getTTestDesign() == 7 || this.results.getTTestDesign() == 11) {
                out.print(this.results.getMeansAMatrix().get(rows[i], 0) + "\t");
                out.print(this.results.getSdAMatrix().get(rows[i], 0) + "\t");
                out.print(this.results.getMeansBMatrix().get(rows[i], 0) + "\t");
                out.print(this.results.getSdBMatrix().get(rows[i], 0) + "\t");
            } else if (this.results.getTTestDesign() == 8) {
                out.print(this.results.getOneClassMeansMatrix().get(rows[i], 0) + "\t");
                out.print(this.results.getOneClassSDsMatrix().get(rows[i], 0) + "\t");
            }
            out.print("" + this.results.getTValuesMatrix().get(rows[i], 0));
            out.print("\t");
            out.print("" + this.results.getDfMatrix().get(rows[i], 0));
            out.print("\t");
            out.print("" + this.results.getRawPValuesMatrix().get(rows[i], 0));
            out.print("\t");
            out.print("" + this.results.getAdjPValuesMatrix().get(rows[i], 0));
            for (int j = 0; j < experiment.getNumberOfSamples(); ++j) {
                out.print("\t");
                out.print(Float.toString(experiment.get(rows[i], j)));
            }
            out.print("\n");
        }
        out.flush();
        out.close();
    }

    private static File getFile(Frame frame) {
        File file = null;
        JFileChooser fc = new JFileChooser(TMEV.getFile((String)"data/"));
        fc.addChoosableFileFilter((FileFilter)new ExpressionFileFilter());
        fc.setFileView((FileView)new ExpressionFileView());
        int ret = fc.showSaveDialog(frame);
        if (ret == 0) {
            file = fc.getSelectedFile();
        }
        return file;
    }
}

