/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ttest;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExpressionFileFilter;
import org.tigr.microarray.mev.cluster.gui.helpers.ExpressionFileView;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.ttest.TTestResults;
import org.tigr.util.BooleanArray;
import org.tigr.util.FloatMatrix;
import org.tigr.util.awt.ActionInfoDialog;

public class TTestVolcanoPlotViewer
extends JPanel
implements IViewer {
    private Experiment experiment;
    private IFramework framework;
    private IData data;
    private double[] yArray;
    private double[] xArray;
    private boolean[] isSig;
    int originX;
    int originY;
    int currentMouseX;
    int currentMouseY;
    private boolean useRefLines;
    private boolean projectClusters;
    private boolean usePosAndNeg;
    private boolean usePosOnly;
    private boolean useNegOnly;
    private JPopupMenu popup;
    private JCheckBoxMenuItem useRefLinesBox;
    private JCheckBoxMenuItem projectClustersBox;
    int currentXSliderPosition;
    int currentYSliderPosition;
    double currentP;
    double currentMean;
    double oneClassMean;
    private int exptID;
    private TTestResults results;

    public TTestVolcanoPlotViewer(Experiment experiment, TTestResults results) {
        this.experiment = experiment;
        this.results = results;
        this.initialize();
    }

    public TTestVolcanoPlotViewer(Experiment experiment, double[] xArray, double[] yArray, boolean[] isSig, int tTestDesign, double oneClassMean, Vector oneClassMeans, Vector oneClassSDs, Vector meansA, Vector meansB, Vector sdA, Vector sdB, Vector rawPValues, Vector adjPValues, Vector tValues, Vector dfValues) {
        this.experiment = experiment;
        this.setExperimentID(experiment.getId());
        this.results = new TTestResults();
        this.results.setAdjPValuesMatrix(TTestVolcanoPlotViewer.toFloatMatrix(adjPValues));
        this.results.setDfMatrix(TTestVolcanoPlotViewer.toFloatMatrix(dfValues));
        this.results.setMeansAMatrix(TTestVolcanoPlotViewer.toFloatMatrix(meansA));
        this.results.setMeansBMatrix(TTestVolcanoPlotViewer.toFloatMatrix(meansB));
        this.results.setOneClassMeansMatrix(TTestVolcanoPlotViewer.toFloatMatrix(oneClassMeans));
        this.results.setOneClassSDsMatrix(TTestVolcanoPlotViewer.toFloatMatrix(oneClassSDs));
        this.results.setRawPValuesMatrix(TTestVolcanoPlotViewer.toFloatMatrix(rawPValues));
        this.results.setSdAMatrix(TTestVolcanoPlotViewer.toFloatMatrix(sdA));
        this.results.setSdBMatrix(TTestVolcanoPlotViewer.toFloatMatrix(sdB));
        this.results.setTTestDesign(tTestDesign);
        this.results.setTValuesMatrix(TTestVolcanoPlotViewer.toFloatMatrix(tValues));
        this.results.setIsSig(new BooleanArray(isSig));
        this.results.setDiffMeansBA(xArray);
        this.results.setNegLog10PValues(yArray);
        this.initialize();
    }

    private static FloatMatrix toFloatMatrix(Vector<Float> temp) {
        float[] test = new float[temp.size()];
        for (int j = 0; j < temp.size(); ++j) {
            test[j] = temp.get(j).floatValue();
        }
        return new FloatMatrix((float[][])new float[][]{test});
    }

    public TTestVolcanoPlotViewer(Experiment e, double[] xArray, double[] yArray, boolean[] isSig, Integer tTestDesign, Double oneClassMean, Vector oneClassMeans, Vector oneClassSDs, Vector meansA, Vector meansB, Vector sdA, Vector sdB, Vector rawPValues, Vector adjPValues, Vector tValues, Vector dfValues) {
        this(e, xArray, yArray, isSig, (int)tTestDesign, (double)oneClassMean, oneClassMeans, oneClassSDs, meansA, meansB, sdA, sdB, rawPValues, adjPValues, tValues, dfValues);
    }

    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.experiment, this.results});
    }

    private void initialize() {
        try {
            this.xArray = this.results.getDiffMeansBA().toArray();
            this.yArray = this.results.getNegLog10PValues().toArray();
        }
        catch (NullPointerException npe) {
            this.xArray = new double[1];
            this.yArray = new double[1];
        }
        this.isSig = this.results.getIsSig().toArray();
        this.useRefLines = true;
        this.projectClusters = false;
        this.usePosAndNeg = true;
        this.usePosOnly = false;
        this.useNegOnly = false;
        this.currentMouseX = 0;
        this.currentMouseY = 0;
        this.currentXSliderPosition = 0;
        this.currentYSliderPosition = 0;
        this.setBorder(new EtchedBorder());
        this.setBackground(Color.white);
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                if (TTestVolcanoPlotViewer.this.useRefLines) {
                    TTestVolcanoPlotViewer.this.currentMouseX = mouseEvent.getX();
                    TTestVolcanoPlotViewer.this.currentMouseY = mouseEvent.getY();
                    TTestVolcanoPlotViewer.this.repaint();
                }
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
            }
        });
        this.popup = new JPopupMenu();
        this.useRefLinesBox = new JCheckBoxMenuItem("Use reference lines", true);
        this.useRefLinesBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    TTestVolcanoPlotViewer.this.useRefLines = true;
                } else {
                    TTestVolcanoPlotViewer.this.useRefLines = false;
                    TTestVolcanoPlotViewer.this.repaint();
                }
            }
        });
        this.popup.add(this.useRefLinesBox);
        this.popup.addSeparator();
        this.projectClustersBox = new JCheckBoxMenuItem("Project previously stored cluster colors", false);
        this.projectClustersBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    TTestVolcanoPlotViewer.this.projectClusters = true;
                    TTestVolcanoPlotViewer.this.repaint();
                } else {
                    TTestVolcanoPlotViewer.this.projectClusters = false;
                    TTestVolcanoPlotViewer.this.repaint();
                }
            }
        });
        this.popup.add(this.projectClustersBox);
        this.popup.addSeparator();
        JMenuItem showCutoffLines = new JMenuItem("Use gene selection sliders");
        showCutoffLines.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectionSliderPanel ssPanel = new SelectionSliderPanel(TTestVolcanoPlotViewer.this.currentYSliderPosition, TTestVolcanoPlotViewer.this.currentXSliderPosition);
                TTestVolcanoPlotViewer.this.repaint();
                ssPanel.setVisible(true);
            }
        });
        this.popup.add(showCutoffLines);
        this.popup.addSeparator();
        JMenuItem storeClusterItem = new JMenuItem("Store selected genes as cluster", GUIFactory.getIcon("new16.gif"));
        storeClusterItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TTestVolcanoPlotViewer.this.storeCluster();
            }
        });
        this.popup.add(storeClusterItem);
        this.popup.addSeparator();
        JMenuItem launchNewSessionItem = new JMenuItem("Launch new session with selected genes", GUIFactory.getIcon("launch_new_mav.gif"));
        launchNewSessionItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TTestVolcanoPlotViewer.this.launchNewSession();
            }
        });
        this.popup.add(launchNewSessionItem);
        this.popup.addSeparator();
        JMenuItem saveGenesItem = new JMenuItem("Save selected genes as cluster", GUIFactory.getIcon("save16.gif"));
        saveGenesItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TTestVolcanoPlotViewer.this.onSaveCluster();
            }
        });
        this.popup.add(saveGenesItem);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    if (TTestVolcanoPlotViewer.this.currentXSliderPosition == 0 && TTestVolcanoPlotViewer.this.currentYSliderPosition == 0 && TTestVolcanoPlotViewer.this.usePosAndNeg) {
                        for (int i = 6; i < TTestVolcanoPlotViewer.this.popup.getComponentCount(); ++i) {
                            Component item = TTestVolcanoPlotViewer.this.popup.getComponent(i);
                            if (!(item instanceof JMenuItem)) continue;
                            item.setEnabled(false);
                        }
                    } else {
                        for (int i = 6; i < TTestVolcanoPlotViewer.this.popup.getComponentCount(); ++i) {
                            Component item = TTestVolcanoPlotViewer.this.popup.getComponent(i);
                            if (!(item instanceof JMenuItem)) continue;
                            item.setEnabled(true);
                        }
                    }
                    TTestVolcanoPlotViewer.this.popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    public void setExperiment(Experiment e) {
        this.experiment = e;
        this.exptID = e.getId();
    }

    public int getExperimentID() {
        return this.exptID;
    }

    public void setExperimentID(int id) {
        this.exptID = id;
    }

    @Override
    public void paint(Graphics g) {
        int i;
        int i2;
        int i3;
        super.paint(g);
        Graphics2D g2D = (Graphics2D)g;
        int panelWidth = this.getWidth();
        int panelHeight = this.getHeight();
        double[] maxXAndY = this.getMaxXAndY();
        double[] minXAndY = this.getMinXAndY();
        double origMaxXValue = maxXAndY[0];
        double origMaxYValue = maxXAndY[1];
        double origMinXValue = minXAndY[0];
        double origMinYValue = minXAndY[1];
        double xScalingFactor = this.getXScalingFactor(origMaxXValue, origMinXValue);
        double yScalingFactor = this.getYScalingFactor(origMaxYValue, origMinYValue);
        float[] dash1 = new float[]{10.0f};
        BasicStroke dashed = new BasicStroke(2.0f, 0, 0, 10.0f, dash1, 0.0f);
        g2D.setStroke(new BasicStroke(2.0f));
        g2D.drawLine(40, 10, this.getWidth() - 10, 10);
        g2D.drawLine(this.getWidth() - 10, 10, this.getWidth() - 10, this.getHeight() - 50);
        this.originX = (int)Math.round((double)(this.getWidth() / 2));
        this.originY = (int)Math.round((double)(this.getHeight() - 50));
        g2D.setColor(Color.black);
        g2D.drawLine(40, (int)Math.round((double)(this.getHeight() - 50)), this.getWidth() - 10, (int)Math.round((double)(this.getHeight() - 50)));
        g2D.drawLine((int)Math.round((double)(this.getWidth() / 2)), 10, (int)Math.round((double)(this.getWidth() / 2)), this.getHeight() - 50);
        g2D.drawLine(40, 10, 40, this.getHeight() - 50);
        g2D.setStroke(new BasicStroke(1.0f));
        if (this.useRefLines && this.currentMouseX >= 40 && this.currentMouseX <= this.getWidth() - 10 && this.currentMouseY >= 10 && this.currentMouseY <= this.getHeight() - 50) {
            g2D.setColor(Color.magenta);
            g2D.drawLine(40, this.currentMouseY, this.getWidth() - 10, this.currentMouseY);
            g2D.drawLine(this.currentMouseX, 10, this.currentMouseX, this.getHeight() - 50);
        }
        g2D.setColor(Color.black);
        g2D.rotate(-1.5707963267948966);
        g2D.drawString("-log10(p)", -1 * this.getHeight() / 2, 15);
        g2D.rotate(1.5707963267948966);
        double[] xIntervalArray = new double[6];
        double xIncrement = 0.0;
        xIncrement = Math.abs(origMaxXValue) > Math.abs(origMinXValue) ? Math.abs(origMaxXValue / 5.0) : Math.abs(origMinXValue / 5.0);
        double xCounter = 0.0;
        for (i3 = 0; i3 < xIntervalArray.length; ++i3) {
            xIntervalArray[i3] = xCounter;
            xCounter += xIncrement;
        }
        g2D.setStroke(new BasicStroke(2.0f));
        for (i3 = 1; i3 < xIntervalArray.length; ++i3) {
            g2D.drawLine((int)Math.round(xIntervalArray[i3] * xScalingFactor) + this.getWidth() / 2, this.getHeight() - 50 - 5, (int)Math.round(xIntervalArray[i3] * xScalingFactor) + this.getWidth() / 2, this.getHeight() - 50 + 5);
        }
        for (i3 = 1; i3 < xIntervalArray.length; ++i3) {
            g2D.drawLine(this.getWidth() / 2 - (int)Math.round(xIntervalArray[i3] * xScalingFactor), this.getHeight() - 50 - 5, this.getWidth() / 2 - (int)Math.round(xIntervalArray[i3] * xScalingFactor), this.getHeight() - 50 + 5);
        }
        DecimalFormat nf = new DecimalFormat();
        nf.setMaximumFractionDigits(2);
        for (i2 = 1; i2 < xIntervalArray.length; ++i2) {
            g2D.drawString(nf.format(xIntervalArray[i2]), (int)Math.round(xIntervalArray[i2] * xScalingFactor) + this.getWidth() / 2 - 10, this.getHeight() - 30);
        }
        for (i2 = 1; i2 < xIntervalArray.length; ++i2) {
            g2D.drawString("-" + nf.format(xIntervalArray[i2]), this.getWidth() / 2 - (int)Math.round(xIntervalArray[i2] * xScalingFactor) - 10, this.getHeight() - 30);
        }
        if (this.results.getTTestDesign() == 8) {
            g2D.drawString("Gene Mean - Hypothesized Mean (" + this.oneClassMean + ")", this.getWidth() / 2 - 85, this.getHeight() - 15);
        } else {
            g2D.drawString("Mean(GroupB) - Mean(GroupA)", this.getWidth() / 2 - 85, this.getHeight() - 15);
        }
        int maxYInt = (int)Math.round(origMaxYValue);
        g2D.setColor(Color.gray);
        g2D.setStroke(new BasicStroke(1.0f));
        for (int currY = 1; currY <= maxYInt && this.getHeight() - 50 - (int)Math.round((double)currY * yScalingFactor) >= 10; ++currY) {
            g2D.drawLine(40, this.getHeight() - 50 - (int)Math.round((double)currY * yScalingFactor), this.getWidth() - 10, this.getHeight() - 50 - (int)Math.round((double)currY * yScalingFactor));
        }
        g2D.setColor(Color.black);
        for (i = 1; i <= maxYInt; ++i) {
            int position = 25;
            if (i >= 10) {
                position = 20;
            }
            if (this.getHeight() - 50 - (int)Math.round((double)i * yScalingFactor) < 10) continue;
            g2D.drawString(nf.format(i), position, this.getHeight() - 50 - (int)Math.round((double)i * yScalingFactor));
        }
        for (i = 0; i < this.xArray.length; ++i) {
            if (Double.isNaN(this.xArray[i]) || Double.isNaN(this.yArray[i]) || Double.isInfinite(this.xArray[i]) || Double.isInfinite(this.yArray[i])) continue;
            if (!this.projectClusters) {
                if (this.currentXSliderPosition == 0 && this.currentYSliderPosition == 0 && this.usePosAndNeg) {
                    if (this.isSig[i]) {
                        g2D.setColor(Color.red);
                    } else {
                        g2D.setColor(Color.black);
                    }
                } else if (this.usePosAndNeg) {
                    if (Math.abs(this.xArray[i]) >= this.currentMean && this.yArray[i] >= this.currentP) {
                        g2D.setColor(Color.green);
                    } else if (this.isSig[i]) {
                        g2D.setColor(Color.red);
                    } else {
                        g2D.setColor(Color.black);
                    }
                } else if (this.usePosOnly) {
                    if (this.xArray[i] >= this.currentMean && this.yArray[i] >= this.currentP) {
                        g2D.setColor(Color.green);
                    } else if (this.isSig[i]) {
                        g2D.setColor(Color.red);
                    } else {
                        g2D.setColor(Color.black);
                    }
                } else if (this.useNegOnly) {
                    if (this.xArray[i] <= -1.0 * this.currentMean && this.yArray[i] >= this.currentP) {
                        g2D.setColor(Color.green);
                    } else if (this.isSig[i]) {
                        g2D.setColor(Color.red);
                    } else {
                        g2D.setColor(Color.black);
                    }
                }
            } else {
                Color pointColor = this.data.getProbeColor(this.experiment.getGeneIndexMappedToData(i));
                if (pointColor == null) {
                    pointColor = Color.black;
                }
                g2D.setColor(pointColor);
            }
            this.drawPoint(g2D, this.xArray[i], this.yArray[i], this.getXScalingFactor(origMaxXValue, origMinXValue), this.getYScalingFactor(origMaxYValue, origMinYValue), 5);
        }
        g2D.setColor(Color.black);
        if (this.currentYSliderPosition > 0) {
            g2D.setStroke(dashed);
            g2D.drawLine(40, (int)Math.round((double)(this.getHeight() - 50) - this.currentP * yScalingFactor), this.getWidth() - 10, (int)Math.round((double)(this.getHeight() - 50) - this.currentP * yScalingFactor));
        }
        if (this.currentXSliderPosition > 0) {
            g2D.setStroke(dashed);
            if (this.usePosAndNeg) {
                g2D.drawLine((int)Math.round((double)Math.round(this.getWidth() / 2) - this.currentMean * xScalingFactor), 10, (int)Math.round((double)Math.round(this.getWidth() / 2) - this.currentMean * xScalingFactor), Math.round(this.getHeight() - 50));
                g2D.drawLine((int)Math.round((double)Math.round(this.getWidth() / 2) + this.currentMean * xScalingFactor), 10, (int)Math.round((double)Math.round(this.getWidth() / 2) + this.currentMean * xScalingFactor), Math.round(this.getHeight() - 50));
            } else if (this.usePosOnly) {
                g2D.drawLine((int)Math.round((double)Math.round(this.getWidth() / 2) + this.currentMean * xScalingFactor), 10, (int)Math.round((double)Math.round(this.getWidth() / 2) + this.currentMean * xScalingFactor), Math.round(this.getHeight() - 50));
            } else if (this.useNegOnly) {
                g2D.drawLine((int)Math.round((double)Math.round(this.getWidth() / 2) - this.currentMean * xScalingFactor), 10, (int)Math.round((double)Math.round(this.getWidth() / 2) - this.currentMean * xScalingFactor), Math.round(this.getHeight() - 50));
            }
        }
        g2D.setStroke(new BasicStroke(2.0f));
        g2D.setColor(Color.black);
    }

    private void drawPoint(Graphics2D g2D, double xValue, double yValue, double xScale, double yScale, int diameter) {
        int xRaw = (int)Math.round(xValue * xScale);
        int yRaw = (int)Math.round(yValue * yScale);
        int xCoord = 0;
        int yCoord = 0;
        xCoord = (int)Math.round((double)(this.getWidth() / 2)) + xRaw;
        yCoord = (int)Math.round((double)(this.getHeight() - 50)) - yRaw;
        g2D.fillOval(xCoord, yCoord, diameter, diameter);
    }

    public void setClusterColor(Color color) {
        if (color == null) {
            this.framework.removeCluster(this.getArrayMappedToData(), this.experiment, 0);
        }
    }

    public void storeCluster() {
        this.framework.storeSubCluster(this.getArrayMappedToData(), this.experiment, 0);
        this.onDataChanged(this.data);
    }

    public void setData(IData data) {
        this.data = data;
    }

    private int[] getArrayMappedToData() {
        int[] clusterIndices = this.getCluster();
        if (clusterIndices == null || clusterIndices.length < 1) {
            return clusterIndices;
        }
        int[] dataIndices = new int[clusterIndices.length];
        for (int i = 0; i < clusterIndices.length; ++i) {
            dataIndices[i] = this.experiment.getGeneIndexMappedToData(clusterIndices[i]);
        }
        return dataIndices;
    }

    private int[] getCluster() {
        Vector<Integer> clusterVector = new Vector<Integer>();
        for (int i = 0; i < this.xArray.length; ++i) {
            if (this.usePosAndNeg) {
                if (!(Math.abs(this.xArray[i]) >= this.currentMean) || !(this.yArray[i] >= this.currentP)) continue;
                clusterVector.add(new Integer(i));
                continue;
            }
            if (this.usePosOnly) {
                if (!(this.xArray[i] >= this.currentMean) || !(this.yArray[i] >= this.currentP)) continue;
                clusterVector.add(new Integer(i));
                continue;
            }
            if (!this.useNegOnly || !(this.xArray[i] <= -1.0 * this.currentMean) || !(this.yArray[i] >= this.currentP)) continue;
            clusterVector.add(new Integer(i));
        }
        int[] clust = new int[clusterVector.size()];
        for (int i = 0; i < clust.length; ++i) {
            clust[i] = (Integer)clusterVector.get(i);
        }
        return clust;
    }

    public void launchNewSession() {
        this.framework.launchNewMAV(this.getArrayMappedToData(), this.experiment, "Multiple Experiment Viewer - Volcano Plot Selected Genes Viewer", 0);
    }

    private static File getFile(Frame frame) {
        File file = null;
        JFileChooser fc = new JFileChooser(TMEV.getFile((String)"data/"));
        fc.addChoosableFileFilter((FileFilter)new ExpressionFileFilter());
        fc.setFileView((FileView)new ExpressionFileView());
        int ret = fc.showSaveDialog(frame);
        if (ret == 0) {
            file = fc.getSelectedFile();
        }
        return file;
    }

    private void onSaveCluster() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            this.saveExperiment(frame, this.getExperiment(), this.getData(), this.getCluster());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(frame, "Can not save cluster!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    public IData getData() {
        return this.data;
    }

    public void saveExperiment(Frame frame, Experiment experiment, IData data, int[] rows) throws Exception {
        File file = TTestVolcanoPlotViewer.getFile(frame);
        if (file != null) {
            this.saveCluster(file, experiment, data, rows);
        }
    }

    private void saveCluster(File file, Experiment experiment, IData data, int[] rows) throws Exception {
        int i;
        PrintWriter out = new PrintWriter(new FileOutputStream(file));
        String[] fieldNames = data.getFieldNames();
        out.print("Original row");
        out.print("\t");
        for (i = 0; i < fieldNames.length; ++i) {
            out.print(fieldNames[i]);
            out.print("\t");
        }
        if (this.results.getTTestDesign() == 7) {
            out.print("GroupA mean\t");
            out.print("GroupA std.dev.\t");
            out.print("GroupB mean\t");
            out.print("GroupB std.dev.\t");
            out.print("Absolute t value");
        } else if (this.results.getTTestDesign() == 8) {
            out.print("Gene mean\t");
            out.print("Gene std.dev.\t");
            out.print("t value");
        }
        out.print("\t");
        out.print("Degrees of freedom\t");
        out.print("Raw p value\t");
        out.print("Adj p value");
        for (i = 0; i < experiment.getNumberOfSamples(); ++i) {
            out.print("\t");
            out.print(data.getSampleName(experiment.getSampleIndex(i)));
        }
        out.print("\n");
        for (i = 0; i < rows.length; ++i) {
            out.print(Integer.toString(experiment.getGeneIndexMappedToData(rows[i]) + 1));
            out.print("\t");
            for (int k = 0; k < fieldNames.length; ++k) {
                out.print(data.getElementAttribute(experiment.getGeneIndexMappedToData(rows[i]), k));
                out.print("\t");
            }
            if (this.results.getTTestDesign() == 7) {
                out.print(this.results.getMeansAMatrix().get(rows[i], 0) + "\t");
                out.print(this.results.getSdAMatrix().get(rows[i], 0) + "\t");
                out.print(this.results.getMeansBMatrix().get(rows[i], 0) + "\t");
                out.print(this.results.getSdBMatrix().get(rows[i], 0) + "\t");
            } else if (this.results.getTTestDesign() == 8) {
                out.print(this.results.getOneClassMeansMatrix().get(rows[i], 0) + "\t");
                out.print(this.results.getOneClassSDsMatrix().get(rows[i], 0) + "\t");
            }
            out.print(this.results.getTValuesMatrix().get(rows[i], 0));
            out.print("\t");
            out.print(this.results.getDfMatrix().get(rows[i], 0));
            out.print("\t");
            out.print(this.results.getRawPValuesMatrix().get(rows[i], 0));
            out.print("\t");
            out.print(this.results.getAdjPValuesMatrix().get(rows[i], 0));
            for (int j = 0; j < experiment.getNumberOfSamples(); ++j) {
                out.print("\t");
                out.print(Float.toString(experiment.get(rows[i], j)));
            }
            out.print("\n");
        }
        out.flush();
        out.close();
    }

    private double[] getMaxXAndY() {
        double[] maxXAndY = new double[2];
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.xArray.length; ++i) {
            if (Double.isInfinite(this.xArray[i]) || Double.isNaN(this.xArray[i]) || Double.isInfinite(this.yArray[i]) || Double.isNaN(this.yArray[i])) continue;
            if (maxX < this.xArray[i]) {
                maxX = this.xArray[i];
            }
            if (!(maxY < this.yArray[i])) continue;
            maxY = this.yArray[i];
        }
        maxXAndY[0] = maxX;
        maxXAndY[1] = maxY;
        return maxXAndY;
    }

    private double[] getMinXAndY() {
        double[] minXAndY = new double[2];
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.xArray.length; ++i) {
            if (Double.isInfinite(this.xArray[i]) || Double.isNaN(this.xArray[i]) || Double.isInfinite(this.yArray[i]) || Double.isNaN(this.yArray[i])) continue;
            if (minX > this.xArray[i]) {
                minX = this.xArray[i];
            }
            if (!(minY > this.yArray[i])) continue;
            minY = this.yArray[i];
        }
        minXAndY[0] = minX;
        minXAndY[1] = minY;
        return minXAndY;
    }

    private double getXScalingFactor(double maxValue, double minValue) {
        double largest = 1.0;
        if (maxValue > 0.0 && minValue > 0.0) {
            largest = maxValue;
        } else if (maxValue > 0.0 && minValue < 0.0) {
            largest = maxValue > Math.abs(minValue) ? maxValue : Math.abs(minValue);
        } else if (maxValue <= 0.0) {
            largest = Math.abs(minValue);
        } else if (minValue == 0.0) {
            largest = maxValue;
        }
        double scalingFactor = (double)(this.getWidth() / 2 - 50) / largest;
        return scalingFactor;
    }

    private double getYScalingFactor(double maxValue, double minValue) {
        double largest = 1.0;
        if (maxValue > 0.0 && minValue > 0.0) {
            largest = maxValue;
        } else if (maxValue > 0.0 && minValue < 0.0) {
            largest = maxValue > Math.abs(minValue) ? maxValue : Math.abs(minValue);
        } else if (maxValue <= 0.0) {
            largest = Math.abs(minValue);
        } else if (minValue == 0.0) {
            largest = maxValue;
        }
        double scalingFactor = (double)(this.getHeight() - 50 - 50) / largest;
        return scalingFactor;
    }

    public void showReferenceLines() {
    }

    public void onDeselected() {
    }

    public void onDataChanged(IData data) {
        this.setData(data);
    }

    public void onClosed() {
    }

    public JComponent getContentComponent() {
        return this;
    }

    public BufferedImage getImage() {
        return null;
    }

    public void onSelected(IFramework framework) {
        this.framework = framework;
        this.setData(framework.getData());
    }

    public void onMenuChanged(IDisplayMenu menu) {
    }

    public JComponent getHeaderComponent() {
        return null;
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    public int[][] getClusters() {
        return null;
    }

    public int getViewerType() {
        return 0;
    }

    class SelectionSliderPanel
    extends ActionInfoDialog {
        JSlider pValueSlider;
        JSlider meanSlider;
        JTextField pValueField;
        JTextField meanField;
        JRadioButton posAndNeg;
        JRadioButton posOnly;
        JRadioButton negOnly;
        JButton closeButton;
        JButton resetButton;
        int initP;
        int initMean;
        double maxP;
        double maxMean;

        SelectionSliderPanel(int initP, int initMean) {
            super((JFrame)JOptionPane.getFrameForComponent(TTestVolcanoPlotViewer.this), "Select genes", true);
            this.setBackground(Color.white);
            this.initP = initP;
            this.initMean = initMean;
            this.maxP = TTestVolcanoPlotViewer.this.getMaxXAndY()[1];
            this.maxMean = Math.max(Math.abs(TTestVolcanoPlotViewer.this.getMaxXAndY()[0]), Math.abs(TTestVolcanoPlotViewer.this.getMinXAndY()[0]));
            this.setBounds(0, 0, 450, 200);
            this.setDefaultCloseOperation(2);
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            JPanel pane = new JPanel();
            pane.setLayout(gridbag);
            JPanel sliderPanel = new JPanel();
            GridBagLayout grid1 = new GridBagLayout();
            sliderPanel.setLayout(grid1);
            JLabel pValueLabel = new JLabel("Select -log10(p) cutoff: ");
            TTestVolcanoPlotViewer.this.buildConstraints(constraints, 0, 0, 1, 1, 30, 50);
            grid1.setConstraints(pValueLabel, constraints);
            sliderPanel.add(pValueLabel);
            this.pValueSlider = new JSlider(0, 100, initP);
            this.pValueField = new JTextField("" + this.getDisplayPValue(initP), 7);
            this.pValueField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        String s = SelectionSliderPanel.this.pValueField.getText();
                        double f = Double.parseDouble(s);
                        int sliderValue = (int)Math.round(f * 100.0 / SelectionSliderPanel.this.maxP);
                        if (sliderValue >= 100) {
                            SelectionSliderPanel.this.pValueSlider.setValue(100);
                            SelectionSliderPanel.this.pValueField.setText("" + (float)SelectionSliderPanel.this.maxP);
                        } else if (sliderValue <= 0) {
                            SelectionSliderPanel.this.pValueSlider.setValue(0);
                            SelectionSliderPanel.this.pValueField.setText("0.0");
                        } else {
                            SelectionSliderPanel.this.pValueSlider.setValue(sliderValue);
                            SelectionSliderPanel.this.pValueField.setText("" + (float)f);
                        }
                    }
                    catch (Exception exc) {
                        SelectionSliderPanel.this.pValueSlider.setValue(0);
                        SelectionSliderPanel.this.pValueField.setText("0.0");
                    }
                    TTestVolcanoPlotViewer.this.currentYSliderPosition = SelectionSliderPanel.this.pValueSlider.getValue();
                    TTestVolcanoPlotViewer.this.currentP = SelectionSliderPanel.this.getDisplayPValue(TTestVolcanoPlotViewer.this.currentYSliderPosition);
                    TTestVolcanoPlotViewer.this.repaint();
                }
            });
            this.pValueField.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    try {
                        String s = SelectionSliderPanel.this.pValueField.getText();
                        double f = Double.parseDouble(s);
                        int sliderValue = (int)Math.round(f * 100.0 / SelectionSliderPanel.this.maxP);
                        if (sliderValue >= 100) {
                            SelectionSliderPanel.this.pValueSlider.setValue(100);
                            SelectionSliderPanel.this.pValueField.setText("" + (float)SelectionSliderPanel.this.maxP);
                        } else if (sliderValue <= 0) {
                            SelectionSliderPanel.this.pValueSlider.setValue(0);
                            SelectionSliderPanel.this.pValueField.setText("0.0");
                        } else {
                            SelectionSliderPanel.this.pValueSlider.setValue(sliderValue);
                            SelectionSliderPanel.this.pValueField.setText("" + (float)f);
                        }
                    }
                    catch (Exception exc) {
                        SelectionSliderPanel.this.pValueSlider.setValue(0);
                        SelectionSliderPanel.this.pValueField.setText("0.0");
                    }
                    TTestVolcanoPlotViewer.this.currentYSliderPosition = SelectionSliderPanel.this.pValueSlider.getValue();
                    TTestVolcanoPlotViewer.this.currentP = SelectionSliderPanel.this.getDisplayPValue(TTestVolcanoPlotViewer.this.currentYSliderPosition);
                    TTestVolcanoPlotViewer.this.repaint();
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
            this.pValueSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int value = SelectionSliderPanel.this.pValueSlider.getValue();
                    double displayValue = (double)value * SelectionSliderPanel.this.maxP / 100.0;
                    if (value == 0) {
                        displayValue = 0.0;
                    }
                    SelectionSliderPanel.this.pValueField.setText("" + (float)displayValue);
                    TTestVolcanoPlotViewer.this.currentYSliderPosition = SelectionSliderPanel.this.pValueSlider.getValue();
                    TTestVolcanoPlotViewer.this.currentP = SelectionSliderPanel.this.getDisplayPValue(TTestVolcanoPlotViewer.this.currentYSliderPosition);
                    TTestVolcanoPlotViewer.this.repaint();
                }
            });
            this.pValueSlider.setBackground(Color.white);
            TTestVolcanoPlotViewer.this.buildConstraints(constraints, 1, 0, 1, 1, 50, 0);
            grid1.setConstraints(this.pValueSlider, constraints);
            sliderPanel.add(this.pValueSlider);
            TTestVolcanoPlotViewer.this.buildConstraints(constraints, 2, 0, 1, 1, 20, 0);
            grid1.setConstraints(this.pValueField, constraints);
            sliderPanel.add(this.pValueField);
            JLabel meanLabel = new JLabel("Select mean diff. cutoff: ");
            TTestVolcanoPlotViewer.this.buildConstraints(constraints, 0, 1, 1, 1, 30, 50);
            grid1.setConstraints(meanLabel, constraints);
            sliderPanel.add(meanLabel);
            this.meanSlider = new JSlider(0, 100, initMean);
            this.meanField = new JTextField("" + this.getDisplayMean(initMean), 7);
            this.meanSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int value = SelectionSliderPanel.this.meanSlider.getValue();
                    double displayValue = (double)value * SelectionSliderPanel.this.maxMean / 100.0;
                    if (value == 0) {
                        displayValue = 0.0;
                    }
                    SelectionSliderPanel.this.meanField.setText("" + (float)displayValue);
                    TTestVolcanoPlotViewer.this.currentXSliderPosition = SelectionSliderPanel.this.meanSlider.getValue();
                    TTestVolcanoPlotViewer.this.currentMean = SelectionSliderPanel.this.getDisplayMean(TTestVolcanoPlotViewer.this.currentXSliderPosition);
                    TTestVolcanoPlotViewer.this.repaint();
                }
            });
            this.meanField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        String s = SelectionSliderPanel.this.meanField.getText();
                        double f = Double.parseDouble(s);
                        int sliderValue = (int)Math.round(f * 100.0 / SelectionSliderPanel.this.maxMean);
                        if (sliderValue >= 100) {
                            SelectionSliderPanel.this.meanSlider.setValue(100);
                            SelectionSliderPanel.this.meanField.setText("" + (float)SelectionSliderPanel.this.maxMean);
                        } else if (sliderValue <= 0) {
                            SelectionSliderPanel.this.meanSlider.setValue(0);
                            SelectionSliderPanel.this.meanField.setText("0.0");
                        } else {
                            SelectionSliderPanel.this.meanSlider.setValue(sliderValue);
                            SelectionSliderPanel.this.meanField.setText("" + (float)f);
                        }
                    }
                    catch (Exception exc) {
                        SelectionSliderPanel.this.meanSlider.setValue(0);
                        SelectionSliderPanel.this.meanField.setText("0.0");
                    }
                    TTestVolcanoPlotViewer.this.currentXSliderPosition = SelectionSliderPanel.this.meanSlider.getValue();
                    TTestVolcanoPlotViewer.this.currentMean = SelectionSliderPanel.this.getDisplayMean(TTestVolcanoPlotViewer.this.currentXSliderPosition);
                    TTestVolcanoPlotViewer.this.repaint();
                }
            });
            this.meanField.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    try {
                        String s = SelectionSliderPanel.this.meanField.getText();
                        double f = Double.parseDouble(s);
                        int sliderValue = (int)Math.round(f * 100.0 / SelectionSliderPanel.this.maxMean);
                        if (sliderValue >= 100) {
                            SelectionSliderPanel.this.meanSlider.setValue(100);
                            SelectionSliderPanel.this.meanField.setText("" + (float)SelectionSliderPanel.this.maxMean);
                        } else if (sliderValue <= 0) {
                            SelectionSliderPanel.this.meanSlider.setValue(0);
                            SelectionSliderPanel.this.meanField.setText("0.0");
                        } else {
                            SelectionSliderPanel.this.meanSlider.setValue(sliderValue);
                            SelectionSliderPanel.this.meanField.setText("" + (float)f);
                        }
                    }
                    catch (Exception exc) {
                        SelectionSliderPanel.this.meanSlider.setValue(0);
                        SelectionSliderPanel.this.meanField.setText("0.0");
                    }
                    TTestVolcanoPlotViewer.this.currentXSliderPosition = SelectionSliderPanel.this.meanSlider.getValue();
                    TTestVolcanoPlotViewer.this.currentMean = SelectionSliderPanel.this.getDisplayMean(TTestVolcanoPlotViewer.this.currentXSliderPosition);
                    TTestVolcanoPlotViewer.this.repaint();
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
            this.meanSlider.setBackground(Color.white);
            TTestVolcanoPlotViewer.this.buildConstraints(constraints, 1, 1, 1, 1, 50, 0);
            grid1.setConstraints(this.meanSlider, constraints);
            sliderPanel.add(this.meanSlider);
            TTestVolcanoPlotViewer.this.buildConstraints(constraints, 2, 1, 1, 1, 20, 0);
            grid1.setConstraints(this.meanField, constraints);
            sliderPanel.add(this.meanField);
            JPanel chooseMeansPanel = new JPanel();
            GridBagLayout grid2 = new GridBagLayout();
            chooseMeansPanel.setLayout(grid2);
            ButtonGroup group = new ButtonGroup();
            this.posAndNeg = new JRadioButton("Both pos. and neg.");
            this.posOnly = new JRadioButton("Pos. only");
            this.negOnly = new JRadioButton("Neg. only");
            if (TTestVolcanoPlotViewer.this.usePosAndNeg) {
                this.posAndNeg.setSelected(true);
                this.posOnly.setSelected(false);
                this.negOnly.setSelected(false);
            } else if (TTestVolcanoPlotViewer.this.usePosOnly) {
                this.posAndNeg.setSelected(false);
                this.posOnly.setSelected(true);
                this.negOnly.setSelected(false);
            } else if (TTestVolcanoPlotViewer.this.useNegOnly) {
                this.posAndNeg.setSelected(false);
                this.posOnly.setSelected(false);
                this.negOnly.setSelected(true);
            }
            this.posAndNeg.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TTestVolcanoPlotViewer.this.usePosAndNeg = true;
                    TTestVolcanoPlotViewer.this.usePosOnly = false;
                    TTestVolcanoPlotViewer.this.useNegOnly = false;
                    TTestVolcanoPlotViewer.this.repaint();
                }
            });
            this.posAndNeg.setBackground(Color.white);
            this.posOnly.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TTestVolcanoPlotViewer.this.usePosAndNeg = false;
                    TTestVolcanoPlotViewer.this.usePosOnly = true;
                    TTestVolcanoPlotViewer.this.useNegOnly = false;
                    TTestVolcanoPlotViewer.this.repaint();
                }
            });
            this.posOnly.setBackground(Color.white);
            this.negOnly.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TTestVolcanoPlotViewer.this.usePosAndNeg = false;
                    TTestVolcanoPlotViewer.this.usePosOnly = false;
                    TTestVolcanoPlotViewer.this.useNegOnly = true;
                    TTestVolcanoPlotViewer.this.repaint();
                }
            });
            this.negOnly.setBackground(Color.white);
            group.add(this.posAndNeg);
            group.add(this.posOnly);
            group.add(this.negOnly);
            TTestVolcanoPlotViewer.this.buildConstraints(constraints, 0, 0, 1, 1, 33, 100);
            grid2.setConstraints(this.posAndNeg, constraints);
            chooseMeansPanel.add(this.posAndNeg);
            TTestVolcanoPlotViewer.this.buildConstraints(constraints, 1, 0, 1, 1, 33, 0);
            grid2.setConstraints(this.posOnly, constraints);
            chooseMeansPanel.add(this.posOnly);
            TTestVolcanoPlotViewer.this.buildConstraints(constraints, 2, 0, 1, 1, 34, 0);
            grid2.setConstraints(this.negOnly, constraints);
            chooseMeansPanel.add(this.negOnly);
            JPanel resetClosePanel = new JPanel();
            GridBagLayout grid3 = new GridBagLayout();
            resetClosePanel.setLayout(grid3);
            this.resetButton = new JButton("Reset");
            this.resetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectionSliderPanel.this.pValueSlider.setValue(0);
                    SelectionSliderPanel.this.pValueField.setText("0.0");
                    SelectionSliderPanel.this.meanSlider.setValue(0);
                    SelectionSliderPanel.this.meanField.setText("0.0");
                    SelectionSliderPanel.this.posAndNeg.setSelected(true);
                    TTestVolcanoPlotViewer.this.usePosAndNeg = true;
                    TTestVolcanoPlotViewer.this.usePosOnly = false;
                    TTestVolcanoPlotViewer.this.useNegOnly = false;
                    TTestVolcanoPlotViewer.this.currentXSliderPosition = 0;
                    TTestVolcanoPlotViewer.this.currentYSliderPosition = 0;
                }
            });
            TTestVolcanoPlotViewer.this.buildConstraints(constraints, 0, 0, 1, 1, 50, 100);
            constraints.anchor = 13;
            grid3.setConstraints(this.resetButton, constraints);
            resetClosePanel.add(this.resetButton);
            this.closeButton = new JButton("OK");
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SelectionSliderPanel.this.dispose();
                }
            });
            TTestVolcanoPlotViewer.this.buildConstraints(constraints, 1, 0, 1, 1, 50, 0);
            constraints.anchor = 17;
            grid3.setConstraints(this.closeButton, constraints);
            resetClosePanel.add(this.closeButton);
            constraints.anchor = 10;
            sliderPanel.setBorder(new EtchedBorder());
            chooseMeansPanel.setBorder(new EtchedBorder());
            resetClosePanel.setBorder(new EtchedBorder());
            sliderPanel.setBackground(Color.white);
            chooseMeansPanel.setBackground(Color.white);
            resetClosePanel.setBackground(Color.white);
            constraints.fill = 1;
            TTestVolcanoPlotViewer.this.buildConstraints(constraints, 0, 0, 1, 1, 100, 40);
            gridbag.setConstraints(sliderPanel, constraints);
            pane.add(sliderPanel);
            TTestVolcanoPlotViewer.this.buildConstraints(constraints, 0, 1, 1, 1, 0, 30);
            gridbag.setConstraints(chooseMeansPanel, constraints);
            pane.add(chooseMeansPanel);
            TTestVolcanoPlotViewer.this.buildConstraints(constraints, 0, 2, 1, 1, 0, 30);
            gridbag.setConstraints(resetClosePanel, constraints);
            pane.add(resetClosePanel);
            this.setContentPane(pane);
        }

        private float getDisplayPValue(int pSliderVal) {
            double d = (double)pSliderVal * this.maxP / 100.0;
            return (float)d;
        }

        private float getDisplayMean(int meanSliderVal) {
            double d = (double)meanSliderVal * this.maxMean / 100.0;
            return (float)d;
        }

        public void setVisible(boolean visible) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
            super.setVisible(visible);
        }
    }
}

