/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ttest;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;
import org.tigr.util.QSort;

public class TStatsTableViewer
extends ViewerAdapter {
    private JComponent header;
    private JComponent content;
    private Experiment experiment;
    private int[][] clusters;
    private boolean sig;
    private int[] rows;
    private String[] fieldNames;
    private JTable tValuesTable;
    private TValuesTableModel tModel;
    private int tTestDesign;
    private Vector pValues;
    private Vector tValues;
    private Vector dfValues;
    private Vector meansA;
    private Vector meansB;
    private Vector sdA;
    private Vector sdB;
    private Vector oneClassMeans;
    private Vector oneClassSDs;
    private IData data;
    private JPopupMenu popup;
    private Object[][] origData;
    private boolean[] sortedAscending;

    public TStatsTableViewer(Experiment experiment, int[][] clusters, IData data, int tTestDesign, Vector oneClassMeans, Vector oneClassSDs, Vector meansA, Vector meansB, Vector sdA, Vector sdB, Vector pValues, Vector tValues, Vector dfValues, boolean sig) {
        int i;
        this.experiment = experiment;
        this.clusters = clusters;
        this.data = data;
        this.fieldNames = data.getFieldNames();
        this.tTestDesign = tTestDesign;
        this.oneClassMeans = oneClassMeans;
        this.oneClassSDs = oneClassSDs;
        this.pValues = pValues;
        this.tValues = tValues;
        this.dfValues = dfValues;
        this.meansA = meansA;
        this.meansB = meansB;
        this.sdA = sdA;
        this.sdB = sdB;
        this.sig = sig;
        this.rows = sig ? clusters[0] : clusters[1];
        this.tModel = new TValuesTableModel(tTestDesign);
        this.tValuesTable = new JTable(this.tModel);
        this.origData = new Object[this.tModel.getRowCount()][this.tModel.getColumnCount()];
        for (i = 0; i < this.origData.length; ++i) {
            for (int j = 0; j < this.origData[i].length; ++j) {
                this.origData[i][j] = this.tModel.getValueAt(i, j);
            }
        }
        this.sortedAscending = new boolean[this.tModel.getColumnCount()];
        for (i = 0; i < this.sortedAscending.length; ++i) {
            this.sortedAscending[i] = false;
        }
        TableColumn column = null;
        for (int i2 = 0; i2 < this.tModel.getColumnCount(); ++i2) {
            column = this.tValuesTable.getColumnModel().getColumn(i2);
            column.setMinWidth(30);
        }
        this.addMouseListenerToHeaderInTable(this.tValuesTable);
        this.header = this.tValuesTable.getTableHeader();
        this.setMaxWidth(this.getContentComponent(), this.getHeaderComponent());
    }

    @Override
    public void onSelected(IFramework framework) {
        this.data = framework.getData();
    }

    @Override
    public JComponent getContentComponent() {
        JPanel panel = new JPanel();
        panel.setBackground(Color.white);
        GridBagConstraints constraints = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();
        panel.setLayout(gridbag);
        constraints.fill = 2;
        constraints.anchor = 11;
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 100);
        gridbag.setConstraints(this.tValuesTable, constraints);
        panel.add(this.tValuesTable);
        final JFileChooser fc = new JFileChooser(TMEV.getDataPath());
        fc.setDialogTitle("Save gene t-statistics");
        this.popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Save Gene t-statistics", GUIFactory.getIcon("save16.gif"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int returnVal = fc.showSaveDialog(TStatsTableViewer.this.getHeaderComponent());
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    try {
                        int i;
                        PrintWriter out = new PrintWriter(new FileOutputStream(file));
                        for (i = 0; i < TStatsTableViewer.this.fieldNames.length; ++i) {
                            out.print(TStatsTableViewer.this.fieldNames[i]);
                            if (i >= TStatsTableViewer.this.fieldNames.length - 1) continue;
                            out.print("\t");
                        }
                        if (TStatsTableViewer.this.tTestDesign == 7) {
                            out.print("\tGroupA mean\tGroupA std.dev.\tGroupB mean\tGroupB std.dev.\tt-ratio\tdf\tp-value\n");
                        } else if (TStatsTableViewer.this.tTestDesign == 8) {
                            out.print("\tGene mean\tGene std.dev.\tt-ratio\tdf\tp-value\n");
                        }
                        for (i = 0; i < TStatsTableViewer.this.rows.length; ++i) {
                            for (int k = 0; k < TStatsTableViewer.this.fieldNames.length; ++k) {
                                out.print(TStatsTableViewer.this.data.getElementAttribute(TStatsTableViewer.this.experiment.getGeneIndexMappedToData(TStatsTableViewer.this.rows[i]), k));
                                if (k >= TStatsTableViewer.this.fieldNames.length - 1) continue;
                                out.print("\t");
                            }
                            if (TStatsTableViewer.this.tTestDesign == 7) {
                                out.print("\t" + ((Float)TStatsTableViewer.this.meansA.get(TStatsTableViewer.this.rows[i])).floatValue());
                                out.print("\t" + ((Float)TStatsTableViewer.this.sdA.get(TStatsTableViewer.this.rows[i])).floatValue());
                                out.print("\t" + ((Float)TStatsTableViewer.this.meansB.get(TStatsTableViewer.this.rows[i])).floatValue());
                                out.print("\t" + ((Float)TStatsTableViewer.this.sdB.get(TStatsTableViewer.this.rows[i])).floatValue());
                            } else if (TStatsTableViewer.this.tTestDesign == 8) {
                                out.print("\t" + ((Float)TStatsTableViewer.this.oneClassMeans.get(TStatsTableViewer.this.rows[i])).floatValue());
                                out.print("\t" + ((Float)TStatsTableViewer.this.oneClassSDs.get(TStatsTableViewer.this.rows[i])).floatValue());
                            }
                            out.print("\t" + ((Float)TStatsTableViewer.this.tValues.get(TStatsTableViewer.this.rows[i])).floatValue());
                            out.print("\t" + ((Float)TStatsTableViewer.this.dfValues.get(TStatsTableViewer.this.rows[i])).intValue());
                            out.print("\t" + ((Float)TStatsTableViewer.this.pValues.get(TStatsTableViewer.this.rows[i])).floatValue());
                            out.print("\n");
                        }
                        out.println();
                        out.flush();
                        out.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.popup.add(menuItem);
        this.tValuesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    TStatsTableViewer.this.popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        return panel;
    }

    @Override
    public JComponent getHeaderComponent() {
        JPanel panel = new JPanel();
        panel.setBackground(Color.white);
        GridBagConstraints constraints = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();
        panel.setLayout(gridbag);
        constraints.fill = 2;
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 100);
        gridbag.setConstraints(this.header, constraints);
        panel.add(this.header);
        return panel;
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    private void setMaxWidth(JComponent content, JComponent header) {
        int c_width = content.getPreferredSize().width;
        int h_width = header.getPreferredSize().width;
        if (c_width > h_width) {
            header.setPreferredSize(new Dimension(c_width, header.getPreferredSize().height));
        } else {
            content.setPreferredSize(new Dimension(h_width, content.getPreferredSize().height));
        }
    }

    public void addMouseListenerToHeaderInTable(JTable table) {
        final JTable tableView = table;
        tableView.setColumnSelectionAllowed(false);
        MouseAdapter listMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = tableView.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = tableView.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 1 && column != -1) {
                    int shiftPressed = e.getModifiers() & 1;
                    int controlPressed = e.getModifiers() & 2;
                    boolean originalOrder = controlPressed != 0;
                    TStatsTableViewer.this.sortByColumn(column, !TStatsTableViewer.this.sortedAscending[column], originalOrder);
                    boolean bl = ((TStatsTableViewer)TStatsTableViewer.this).sortedAscending[column] = !TStatsTableViewer.this.sortedAscending[column];
                    if (originalOrder) {
                        for (int i = 0; i < TStatsTableViewer.this.tModel.getColumnCount(); ++i) {
                            ((TStatsTableViewer)TStatsTableViewer.this).sortedAscending[i] = false;
                        }
                    }
                }
            }
        };
        JTableHeader th = tableView.getTableHeader();
        th.addMouseListener(listMouseListener);
    }

    public void sortByColumn(int column, boolean ascending, boolean originalOrder) {
        int j;
        int i;
        int i2;
        if (originalOrder) {
            for (int i3 = 0; i3 < this.tModel.getRowCount(); ++i3) {
                for (int j2 = 0; j2 < this.tModel.getColumnCount(); ++j2) {
                    this.tModel.setValueAt(this.origData[i3][j2], i3, j2);
                }
            }
            return;
        }
        Object[][] sortedData = new Object[this.tValuesTable.getRowCount()][this.tValuesTable.getColumnCount()];
        float[] origArray = new float[this.rows.length];
        Object[] sortFields = new SortableField[this.rows.length];
        if (column < this.fieldNames.length) {
            for (i2 = 0; i2 < sortFields.length; ++i2) {
                sortFields[i2] = new SortableField(i2, column);
            }
            Arrays.sort(sortFields);
        } else if (this.tTestDesign == 7) {
            if (column == this.fieldNames.length) {
                for (i2 = 0; i2 < origArray.length; ++i2) {
                    origArray[i2] = ((Float)this.meansA.get(this.rows[i2])).floatValue();
                }
            } else if (column == this.fieldNames.length + 1) {
                for (i2 = 0; i2 < origArray.length; ++i2) {
                    origArray[i2] = ((Float)this.sdA.get(this.rows[i2])).floatValue();
                }
            } else if (column == this.fieldNames.length + 2) {
                for (i2 = 0; i2 < origArray.length; ++i2) {
                    origArray[i2] = ((Float)this.meansB.get(this.rows[i2])).floatValue();
                }
            } else if (column == this.fieldNames.length + 3) {
                for (i2 = 0; i2 < origArray.length; ++i2) {
                    origArray[i2] = ((Float)this.sdB.get(this.rows[i2])).floatValue();
                }
            } else if (column == this.fieldNames.length + 4) {
                for (i2 = 0; i2 < origArray.length; ++i2) {
                    origArray[i2] = ((Float)this.tValues.get(this.rows[i2])).floatValue();
                }
            } else if (column == this.fieldNames.length + 5) {
                for (i2 = 0; i2 < origArray.length; ++i2) {
                    origArray[i2] = ((Float)this.dfValues.get(this.rows[i2])).floatValue();
                }
            } else if (column == this.fieldNames.length + 6) {
                for (i2 = 0; i2 < origArray.length; ++i2) {
                    origArray[i2] = ((Float)this.pValues.get(this.rows[i2])).floatValue();
                }
            }
        } else if (this.tTestDesign == 8) {
            if (column == this.fieldNames.length) {
                for (i2 = 0; i2 < origArray.length; ++i2) {
                    origArray[i2] = ((Float)this.oneClassMeans.get(this.rows[i2])).floatValue();
                }
            } else if (column == this.fieldNames.length + 1) {
                for (i2 = 0; i2 < origArray.length; ++i2) {
                    origArray[i2] = ((Float)this.oneClassSDs.get(this.rows[i2])).floatValue();
                }
            } else if (column == this.fieldNames.length + 2) {
                for (i2 = 0; i2 < origArray.length; ++i2) {
                    origArray[i2] = ((Float)this.tValues.get(this.rows[i2])).floatValue();
                }
            } else if (column == this.fieldNames.length + 3) {
                for (i2 = 0; i2 < origArray.length; ++i2) {
                    origArray[i2] = ((Float)this.dfValues.get(this.rows[i2])).floatValue();
                }
            } else if (column == this.fieldNames.length + 4) {
                for (i2 = 0; i2 < origArray.length; ++i2) {
                    origArray[i2] = ((Float)this.pValues.get(this.rows[i2])).floatValue();
                }
            }
        }
        int[] sortedIndices = new int[this.rows.length];
        if (column >= this.fieldNames.length) {
            QSort sortArray = new QSort(origArray);
            sortedIndices = sortArray.getOrigIndx();
        } else {
            for (int i4 = 0; i4 < sortedIndices.length; ++i4) {
                sortedIndices[i4] = ((SortableField)sortFields[i4]).getIndex();
            }
        }
        if (!ascending) {
            sortedIndices = this.reverse(sortedIndices);
        }
        for (i = 0; i < sortedData.length; ++i) {
            for (j = 0; j < sortedData[i].length; ++j) {
                sortedData[i][j] = this.origData[sortedIndices[i]][j];
            }
        }
        for (i = 0; i < sortedData.length; ++i) {
            for (j = 0; j < sortedData[i].length; ++j) {
                this.tModel.setValueAt(sortedData[i][j], i, j);
            }
        }
    }

    private int[] reverse(int[] arr) {
        int[] revArr = new int[arr.length];
        int revCount = 0;
        int count = arr.length - 1;
        for (int i = 0; i < arr.length; ++i) {
            revArr[revCount] = arr[count];
            ++revCount;
            --count;
        }
        return revArr;
    }

    private class SortableField
    implements Comparable {
        private String field;
        private int index;

        SortableField(int index, int column) {
            this.index = index;
            this.field = (String)TStatsTableViewer.this.origData[index][column];
        }

        public int compareTo(Object other) {
            SortableField otherField = (SortableField)other;
            return this.field.compareTo(otherField.getField());
        }

        public int getIndex() {
            return this.index;
        }

        public String getField() {
            return this.field;
        }
    }

    class TValuesTableModel
    extends AbstractTableModel
    implements Serializable {
        String[] columnNames;
        Object[][] tableData;

        public TValuesTableModel(int design) {
            block29: {
                block28: {
                    if (design != 7) break block28;
                    this.columnNames = new String[TStatsTableViewer.this.fieldNames.length + 7];
                    for (int counter = 0; counter < TStatsTableViewer.this.fieldNames.length; ++counter) {
                        this.columnNames[counter] = TStatsTableViewer.this.fieldNames[counter];
                    }
                    this.columnNames[counter] = "GroupA mean";
                    this.columnNames[counter + 1] = "GroupA std.dev";
                    this.columnNames[counter + 2] = "GroupB mean";
                    this.columnNames[counter + 3] = "GroupB std.dev.";
                    this.columnNames[counter + 4] = "t-ratio";
                    this.columnNames[counter + 5] = "df";
                    this.columnNames[counter + 6] = "p-value";
                    this.tableData = new Object[TStatsTableViewer.this.rows.length][this.columnNames.length];
                    for (int i = 0; i < this.tableData.length; ++i) {
                        for (int j = 0; j < this.tableData[i].length; ++j) {
                            float f;
                            if (j < TStatsTableViewer.this.fieldNames.length) {
                                this.tableData[i][j] = TStatsTableViewer.this.data.getElementAttribute(TStatsTableViewer.this.experiment.getGeneIndexMappedToData(TStatsTableViewer.this.rows[i]), j);
                                continue;
                            }
                            if (j == TStatsTableViewer.this.fieldNames.length) {
                                f = ((Float)TStatsTableViewer.this.meansA.get(TStatsTableViewer.this.rows[i])).floatValue();
                                if (Float.isNaN(f)) {
                                    this.tableData[i][j] = "N/A";
                                    continue;
                                }
                                this.tableData[i][j] = (Float)TStatsTableViewer.this.meansA.get(TStatsTableViewer.this.rows[i]);
                                continue;
                            }
                            if (j == TStatsTableViewer.this.fieldNames.length + 1) {
                                f = ((Float)TStatsTableViewer.this.sdA.get(TStatsTableViewer.this.rows[i])).floatValue();
                                if (Float.isNaN(f)) {
                                    this.tableData[i][j] = "N/A";
                                    continue;
                                }
                                this.tableData[i][j] = (Float)TStatsTableViewer.this.sdA.get(TStatsTableViewer.this.rows[i]);
                                continue;
                            }
                            if (j == TStatsTableViewer.this.fieldNames.length + 2) {
                                f = ((Float)TStatsTableViewer.this.meansB.get(TStatsTableViewer.this.rows[i])).floatValue();
                                if (Float.isNaN(f)) {
                                    this.tableData[i][j] = "N/A";
                                    continue;
                                }
                                this.tableData[i][j] = (Float)TStatsTableViewer.this.meansB.get(TStatsTableViewer.this.rows[i]);
                                continue;
                            }
                            if (j == TStatsTableViewer.this.fieldNames.length + 3) {
                                f = ((Float)TStatsTableViewer.this.sdB.get(TStatsTableViewer.this.rows[i])).floatValue();
                                if (Float.isNaN(f)) {
                                    this.tableData[i][j] = "N/A";
                                    continue;
                                }
                                this.tableData[i][j] = (Float)TStatsTableViewer.this.sdB.get(TStatsTableViewer.this.rows[i]);
                                continue;
                            }
                            if (j == TStatsTableViewer.this.fieldNames.length + 4) {
                                f = ((Float)TStatsTableViewer.this.tValues.get(TStatsTableViewer.this.rows[i])).floatValue();
                                if (Float.isNaN(f)) {
                                    this.tableData[i][j] = "N/A";
                                    continue;
                                }
                                this.tableData[i][j] = (Float)TStatsTableViewer.this.tValues.get(TStatsTableViewer.this.rows[i]);
                                continue;
                            }
                            if (j == TStatsTableViewer.this.fieldNames.length + 5) {
                                f = ((Float)TStatsTableViewer.this.dfValues.get(TStatsTableViewer.this.rows[i])).floatValue();
                                if (Float.isNaN(f)) {
                                    this.tableData[i][j] = "N/A";
                                    continue;
                                }
                                this.tableData[i][j] = (Float)TStatsTableViewer.this.dfValues.get(TStatsTableViewer.this.rows[i]);
                                continue;
                            }
                            if (j != TStatsTableViewer.this.fieldNames.length + 6) continue;
                            f = ((Float)TStatsTableViewer.this.pValues.get(TStatsTableViewer.this.rows[i])).floatValue();
                            this.tableData[i][j] = Float.isNaN(f) ? "N/A" : (Float)TStatsTableViewer.this.pValues.get(TStatsTableViewer.this.rows[i]);
                        }
                    }
                    break block29;
                }
                if (design != 8) break block29;
                this.columnNames = new String[TStatsTableViewer.this.fieldNames.length + 5];
                for (int counter = 0; counter < TStatsTableViewer.this.fieldNames.length; ++counter) {
                    this.columnNames[counter] = TStatsTableViewer.this.fieldNames[counter];
                }
                this.columnNames[counter] = "Gene mean";
                this.columnNames[counter + 1] = "Gene std.dev";
                this.columnNames[counter + 2] = "t-ratio";
                this.columnNames[counter + 3] = "df";
                this.columnNames[counter + 4] = "p-value";
                this.tableData = new Object[TStatsTableViewer.this.rows.length][this.columnNames.length];
                for (int i = 0; i < this.tableData.length; ++i) {
                    for (int j = 0; j < this.tableData[i].length; ++j) {
                        float f;
                        if (j < TStatsTableViewer.this.fieldNames.length) {
                            this.tableData[i][j] = TStatsTableViewer.this.data.getElementAttribute(TStatsTableViewer.this.experiment.getGeneIndexMappedToData(TStatsTableViewer.this.rows[i]), j);
                            continue;
                        }
                        if (j == TStatsTableViewer.this.fieldNames.length) {
                            f = ((Float)TStatsTableViewer.this.oneClassMeans.get(TStatsTableViewer.this.rows[i])).floatValue();
                            if (Float.isNaN(f)) {
                                this.tableData[i][j] = "N/A";
                                continue;
                            }
                            this.tableData[i][j] = (Float)TStatsTableViewer.this.oneClassMeans.get(TStatsTableViewer.this.rows[i]);
                            continue;
                        }
                        if (j == TStatsTableViewer.this.fieldNames.length + 1) {
                            f = ((Float)TStatsTableViewer.this.oneClassSDs.get(TStatsTableViewer.this.rows[i])).floatValue();
                            if (Float.isNaN(f)) {
                                this.tableData[i][j] = "N/A";
                                continue;
                            }
                            this.tableData[i][j] = (Float)TStatsTableViewer.this.oneClassSDs.get(TStatsTableViewer.this.rows[i]);
                            continue;
                        }
                        if (j == TStatsTableViewer.this.fieldNames.length + 2) {
                            f = ((Float)TStatsTableViewer.this.tValues.get(TStatsTableViewer.this.rows[i])).floatValue();
                            if (Float.isNaN(f)) {
                                this.tableData[i][j] = "N/A";
                                continue;
                            }
                            this.tableData[i][j] = (Float)TStatsTableViewer.this.tValues.get(TStatsTableViewer.this.rows[i]);
                            continue;
                        }
                        if (j == TStatsTableViewer.this.fieldNames.length + 3) {
                            f = ((Float)TStatsTableViewer.this.dfValues.get(TStatsTableViewer.this.rows[i])).floatValue();
                            if (Float.isNaN(f)) {
                                this.tableData[i][j] = "N/A";
                                continue;
                            }
                            this.tableData[i][j] = (Float)TStatsTableViewer.this.dfValues.get(TStatsTableViewer.this.rows[i]);
                            continue;
                        }
                        if (j != TStatsTableViewer.this.fieldNames.length + 4) continue;
                        f = ((Float)TStatsTableViewer.this.pValues.get(TStatsTableViewer.this.rows[i])).floatValue();
                        this.tableData[i][j] = Float.isNaN(f) ? "N/A" : (Float)TStatsTableViewer.this.pValues.get(TStatsTableViewer.this.rows[i]);
                    }
                }
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.tableData.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.tableData[row][col];
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.tableData[row][col] = value;
            this.fireTableCellUpdated(row, col);
        }
    }
}

