/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.tfa;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterSelector;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.HCLSigOnlyPanel;

public class TFAInitBox2
extends AlgorithmDialog {
    public static final int JUST_ALPHA = 4;
    public static final int STD_BONFERRONI = 5;
    public static final int ADJ_BONFERRONI = 6;
    public static final int MAX_T = 9;
    public static final int MIN_P = 10;
    boolean okPressed = false;
    protected boolean oneSamplePerCell = false;
    Vector exptNames;
    String[] factorNames;
    int[] numFactorLevels;
    GroupExptsPanel gPanel;
    PValuePanel pPanel;
    PValueAdjustmentPanel pAdjPanel;
    HCLSigOnlyPanel hclOpsPanel;
    JTabbedPane tabbedSelectors;
    ClusterSelector clusterSelectorA;
    ClusterSelector clusterSelectorB;
    ClusterRepository repository;

    public TFAInitBox2(JFrame parentFrame, boolean modality, Vector exptNames, String[] factorNames, int[] numFactorLevels, ClusterRepository repository) {
        super(parentFrame, "Two-factor ANOVA Initialization", modality);
        this.exptNames = exptNames;
        this.factorNames = factorNames;
        this.numFactorLevels = numFactorLevels;
        this.repository = repository;
        this.setBounds(0, 0, 1000, 720);
        this.setBackground(Color.white);
        this.setDefaultCloseOperation(2);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        GridBagConstraints c = new GridBagConstraints();
        constraints.fill = 1;
        JPanel pane = new JPanel();
        pane.setLayout(gridbag);
        this.gPanel = new GroupExptsPanel();
        this.clusterSelectorA = new ClusterSelector(repository, numFactorLevels[0]);
        this.clusterSelectorB = new ClusterSelector(repository, numFactorLevels[1]);
        if (repository != null) {
            this.clusterSelectorA.setClusterType(factorNames[0]);
            this.clusterSelectorB.setClusterType(factorNames[1]);
        }
        JPanel clusterSelectorPanel = new JPanel();
        clusterSelectorPanel.setLayout(new GridBagLayout());
        c.fill = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.anchor = 20;
        clusterSelectorPanel.add((Component)this.clusterSelectorA, c);
        c.gridx = 1;
        clusterSelectorPanel.add((Component)this.clusterSelectorB, c);
        this.tabbedSelectors = new JTabbedPane();
        this.tabbedSelectors.add("Button Selection", this.gPanel);
        this.tabbedSelectors.add("Cluster Selection", clusterSelectorPanel);
        this.tabbedSelectors.setSelectedIndex(1);
        if (repository == null || repository.isEmpty()) {
            this.tabbedSelectors.setSelectedIndex(0);
        }
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 80);
        gridbag.setConstraints(this.tabbedSelectors, constraints);
        pane.add(this.tabbedSelectors);
        this.pPanel = new PValuePanel();
        this.buildConstraints(constraints, 0, 1, 1, 1, 0, 8);
        gridbag.setConstraints(this.pPanel, constraints);
        pane.add(this.pPanel);
        this.pAdjPanel = new PValueAdjustmentPanel();
        this.buildConstraints(constraints, 0, 2, 1, 1, 0, 8);
        gridbag.setConstraints(this.pAdjPanel, constraints);
        pane.add(this.pAdjPanel);
        this.hclOpsPanel = new HCLSigOnlyPanel();
        this.buildConstraints(constraints, 0, 3, 1, 1, 0, 4);
        gridbag.setConstraints(this.hclOpsPanel, constraints);
        pane.add(this.hclOpsPanel);
        this.addContent(pane);
        EventListener listener = new EventListener();
        this.setActionListeners(listener);
        this.addWindowListener(listener);
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public boolean allCellsHaveOneSample() {
        return this.oneSamplePerCell;
    }

    public boolean usePerms() {
        return this.pPanel.permutButton.isSelected();
    }

    public float getAlpha() {
        return Float.parseFloat(this.pPanel.alphaInputField.getText());
    }

    public int getNumPerms() {
        return Integer.parseInt(this.pPanel.timesField.getText());
    }

    public int getSelectionType() {
        return this.tabbedSelectors.getSelectedIndex();
    }

    public boolean isBalancedDesign() {
        boolean balanced = true;
        Vector[][] bothFactorAssignments = this.getBothFactorAssignments();
        int[] cellSizes = new int[bothFactorAssignments.length * bothFactorAssignments[0].length];
        int cellCounter = 0;
        for (int i = 0; i < bothFactorAssignments.length; ++i) {
            for (int j = 0; j < bothFactorAssignments[i].length; ++j) {
                cellSizes[cellCounter] = bothFactorAssignments[i][j].size();
                ++cellCounter;
            }
        }
        int numPerCell = cellSizes[0];
        for (int i = 1; i < cellSizes.length; ++i) {
            if (cellSizes[i] == numPerCell) continue;
            balanced = false;
            break;
        }
        return balanced;
    }

    public int getAdjustmentMethod() {
        if (this.pAdjPanel.justAlphaButton.isSelected()) {
            return 4;
        }
        if (this.pAdjPanel.stdBonfButton.isSelected()) {
            return 5;
        }
        if (this.pAdjPanel.adjBonfButton.isSelected()) {
            return 6;
        }
        if (this.pAdjPanel.maxTButton.isSelected()) {
            return 9;
        }
        if (this.pAdjPanel.minPButton.isSelected()) {
            return 10;
        }
        return -1;
    }

    public boolean drawTrees() {
        return this.hclOpsPanel.isHCLSelected();
    }

    public boolean drawSigTreesOnly() {
        return this.hclOpsPanel.drawSigTreesOnly();
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    @Override
    public void setVisible(boolean visible) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        super.setVisible(visible);
        if (visible) {
            // empty if block
        }
    }

    public int[] getFactorAAssignments() {
        return this.gPanel.factorAPanel.getGroupAssignments();
    }

    public int[] getFactorBAssignments() {
        return this.gPanel.factorBPanel.getGroupAssignments();
    }

    public int[] getFactorAClusterAssignments() {
        int j;
        int i;
        int[] groupAssignments = new int[this.exptNames.size()];
        ArrayList[] arraylistArray = new ArrayList[this.numFactorLevels[0]];
        for (i = 0; i < this.numFactorLevels[0]; ++i) {
            j = i + 1;
            arraylistArray[i] = this.clusterSelectorA.getGroupSamples("Group " + j);
        }
        for (i = 0; i < this.exptNames.size(); ++i) {
            boolean doubleAssigned = false;
            groupAssignments[i] = 0;
            for (j = 0; j < this.numFactorLevels[0]; ++j) {
                if (!arraylistArray[j].contains(i)) continue;
                if (doubleAssigned) {
                    Object[] optionst = new Object[]{"OK"};
                    JOptionPane.showOptionDialog(null, "The clusters you have chosen " + this.factorNames[0] + " have overlapping samples. \n Each group must contain unique samples.", "Multiple Ownership Error", 1, 3, null, optionst, optionst[0]);
                    return null;
                }
                groupAssignments[i] = j + 1;
                doubleAssigned = true;
            }
        }
        return groupAssignments;
    }

    public int[] getFactorBClusterAssignments() {
        int j;
        int i;
        int[] groupAssignments = new int[this.exptNames.size()];
        ArrayList[] arraylistArray = new ArrayList[this.numFactorLevels[1]];
        for (i = 0; i < this.numFactorLevels[1]; ++i) {
            j = i + 1;
            arraylistArray[i] = this.clusterSelectorB.getGroupSamples("Group " + j);
        }
        for (i = 0; i < this.exptNames.size(); ++i) {
            boolean doubleAssigned = false;
            groupAssignments[i] = 0;
            for (j = 0; j < this.numFactorLevels[1]; ++j) {
                if (!arraylistArray[j].contains(i)) continue;
                if (doubleAssigned) {
                    Object[] optionst = new Object[]{"OK"};
                    JOptionPane.showOptionDialog(null, "The clusters you have chosen for " + this.factorNames[1] + " have overlapping samples. \n Each group must contain unique samples.", "Multiple Ownership Error", 1, 3, null, optionst, optionst[0]);
                    return null;
                }
                groupAssignments[i] = j + 1;
                doubleAssigned = true;
            }
        }
        return groupAssignments;
    }

    public boolean isButtonSelectionMethod() {
        return this.tabbedSelectors.getSelectedIndex() == 0;
    }

    public Vector[][] getBothFactorAssignments() {
        int[] factorBAssgn;
        int[] factorAAssgn;
        Vector[][] bothFactorAssignments = new Vector[this.numFactorLevels[0]][this.numFactorLevels[1]];
        for (int i = 0; i < bothFactorAssignments.length; ++i) {
            for (int j = 0; j < bothFactorAssignments[i].length; ++j) {
                bothFactorAssignments[i][j] = new Vector();
            }
        }
        if (this.isButtonSelectionMethod()) {
            factorAAssgn = this.getFactorAAssignments();
            factorBAssgn = this.getFactorBAssignments();
        } else {
            factorAAssgn = this.getFactorAClusterAssignments();
            factorBAssgn = this.getFactorBClusterAssignments();
        }
        if (factorAAssgn == null || factorBAssgn == null) {
            return null;
        }
        for (int i = 0; i < factorAAssgn.length; ++i) {
            if (factorAAssgn[i] == 0 || factorBAssgn[i] == 0) continue;
            bothFactorAssignments[factorAAssgn[i] - 1][factorBAssgn[i] - 1].add(new Integer(i));
        }
        return bothFactorAssignments;
    }

    public static void main(String[] args) {
        JFrame dummyFrame = new JFrame();
        Vector<String> dummyVect = new Vector<String>();
        dummyVect.add("same");
        dummyVect.add("same");
        dummyVect.add("same");
        dummyVect.add("same");
        dummyVect.add("same");
        for (int i = 0; i < 95; ++i) {
            dummyVect.add("Expt " + i);
        }
        String[] factorNames = new String[]{"Factor A", "Factor BEE"};
        int[] numFactorLevels = new int[]{4, 3};
        TFAInitBox2 tfaBox = new TFAInitBox2(dummyFrame, true, dummyVect, factorNames, numFactorLevels, null);
        tfaBox.setVisible(true);
    }

    public class EventListener
    extends WindowAdapter
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            String command = ae.getActionCommand();
            if (command.equals("ok-command")) {
                int i;
                if (TFAInitBox2.this.getSelectionType() == 1 && (TFAInitBox2.this.repository == null || TFAInitBox2.this.repository.isEmpty())) {
                    JOptionPane.showMessageDialog(new JPanel(), "Sample cluster repository is empty", "Error", 2);
                    return;
                }
                Vector[][] bothFactorAssignments = TFAInitBox2.this.getBothFactorAssignments();
                if (bothFactorAssignments == null) {
                    return;
                }
                int[] cellSizes = new int[bothFactorAssignments.length * bothFactorAssignments[0].length];
                int cellCounter = 0;
                for (i = 0; i < bothFactorAssignments.length; ++i) {
                    for (int j = 0; j < bothFactorAssignments[i].length; ++j) {
                        cellSizes[cellCounter] = bothFactorAssignments[i][j].size();
                        ++cellCounter;
                    }
                }
                if (cellSizes[0] == 1) {
                    boolean allOne = true;
                    for (int i2 = 1; i2 < cellSizes.length; ++i2) {
                        if (cellSizes[i2] == 1) continue;
                        allOne = false;
                        break;
                    }
                    if (!allOne) {
                        JOptionPane.showMessageDialog(null, "All factor combinations must contain more than one sample, or else they must all contain exactly one sample each", "Error", 0);
                        TFAInitBox2.this.okPressed = false;
                        return;
                    }
                    TFAInitBox2.this.oneSamplePerCell = true;
                } else {
                    for (i = 0; i < cellSizes.length; ++i) {
                        if (cellSizes[i] >= 2) continue;
                        JOptionPane.showMessageDialog(null, "All factor combinations must contain more than one sample, or else they must all contain exactly one sample each\n\n\tFactor A: Group " + (i / bothFactorAssignments[0].length + 1) + " - Factor B: Group " + (i % bothFactorAssignments[0].length + 1) + " is missing samples.", "Error", 0);
                        TFAInitBox2.this.okPressed = false;
                        return;
                    }
                }
                if (TFAInitBox2.this.usePerms()) {
                    try {
                        int numPerms = TFAInitBox2.this.getNumPerms();
                        if (numPerms <= 0) {
                            JOptionPane.showMessageDialog(null, "Number of permutations should be an integer > 0", "Error", 0);
                            TFAInitBox2.this.okPressed = false;
                            return;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        JOptionPane.showMessageDialog(null, "Number of permutations should be an integer > 0", "Error", 0);
                        TFAInitBox2.this.okPressed = false;
                        return;
                    }
                }
                try {
                    float alpha = TFAInitBox2.this.getAlpha();
                    if (alpha <= 0.0f || alpha >= 1.0f) {
                        JOptionPane.showMessageDialog(null, "Critical p-value should be between 0 and 1", "Error", 0);
                        TFAInitBox2.this.okPressed = false;
                        return;
                    }
                }
                catch (NumberFormatException nfe) {
                    JOptionPane.showMessageDialog(null, "Critical p-value should be between 0 and 1", "Error", 0);
                    TFAInitBox2.this.okPressed = false;
                    return;
                }
                TFAInitBox2.this.okPressed = true;
                TFAInitBox2.this.hide();
                TFAInitBox2.this.dispose();
            } else {
                if (command.equals("reset-command")) {
                    TFAInitBox2.this.okPressed = false;
                    TFAInitBox2.this.gPanel.reset();
                    return;
                }
                if (command.equals("cancel-command")) {
                    TFAInitBox2.this.okPressed = false;
                    TFAInitBox2.this.setVisible(false);
                    TFAInitBox2.this.dispose();
                } else if (command.equals("info-command")) {
                    // empty if block
                }
            }
        }
    }

    class PValueAdjustmentPanel
    extends JPanel {
        JRadioButton minPButton;
        JRadioButton maxTButton;
        JRadioButton justAlphaButton;
        JRadioButton stdBonfButton;
        JRadioButton adjBonfButton;

        PValueAdjustmentPanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(1), "Alpha Corrections", 0, 0, new Font("Dialog", 1, 12), Color.black));
            this.setBackground(Color.white);
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(gridbag);
            ButtonGroup sigGroup = new ButtonGroup();
            this.justAlphaButton = new JRadioButton("just alpha (no correction)", true);
            this.justAlphaButton.setFocusPainted(false);
            this.justAlphaButton.setForeground(UIManager.getColor("Label.foreground"));
            this.justAlphaButton.setBackground(Color.white);
            sigGroup.add(this.justAlphaButton);
            this.stdBonfButton = new JRadioButton("standard Bonferroni correction", false);
            this.stdBonfButton.setEnabled(false);
            this.stdBonfButton.setFocusPainted(false);
            this.stdBonfButton.setForeground(UIManager.getColor("Label.foreground"));
            this.stdBonfButton.setBackground(Color.white);
            sigGroup.add(this.stdBonfButton);
            this.adjBonfButton = new JRadioButton("adjusted Bonferroni correction", false);
            this.adjBonfButton.setEnabled(false);
            this.adjBonfButton.setFocusPainted(false);
            this.adjBonfButton.setForeground(UIManager.getColor("Label.foreground"));
            this.adjBonfButton.setBackground(Color.white);
            sigGroup.add(this.adjBonfButton);
            this.minPButton = new JRadioButton("minP", false);
            this.minPButton.setEnabled(false);
            this.minPButton.setFocusPainted(false);
            this.minPButton.setForeground(UIManager.getColor("Label.foreground"));
            this.minPButton.setBackground(Color.white);
            sigGroup.add(this.minPButton);
            this.maxTButton = new JRadioButton("maxT", false);
            this.maxTButton.setEnabled(false);
            this.maxTButton.setFocusPainted(false);
            this.maxTButton.setForeground(UIManager.getColor("Label.foreground"));
            this.maxTButton.setBackground(Color.white);
            sigGroup.add(this.maxTButton);
            TFAInitBox2.this.buildConstraints(constraints, 0, 0, 1, 1, 33, 50);
            gridbag.setConstraints(this.justAlphaButton, constraints);
            this.add(this.justAlphaButton);
            TFAInitBox2.this.buildConstraints(constraints, 1, 0, 1, 1, 33, 0);
            gridbag.setConstraints(this.stdBonfButton, constraints);
            this.add(this.stdBonfButton);
            TFAInitBox2.this.buildConstraints(constraints, 2, 0, 1, 1, 34, 0);
            gridbag.setConstraints(this.adjBonfButton, constraints);
            this.add(this.adjBonfButton);
            JPanel westfallYoungPanel = new JPanel();
            westfallYoungPanel.setBackground(Color.white);
            westfallYoungPanel.setBorder(new EtchedBorder());
            GridBagLayout grid2 = new GridBagLayout();
            westfallYoungPanel.setLayout(grid2);
            JLabel stepDownLabel = new JLabel("Step-down Westfall and Young methods (for permutations only): ");
            TFAInitBox2.this.buildConstraints(constraints, 0, 0, 1, 1, 34, 100);
            grid2.setConstraints(stepDownLabel, constraints);
            westfallYoungPanel.add(stepDownLabel);
            TFAInitBox2.this.buildConstraints(constraints, 1, 0, 1, 1, 33, 0);
            grid2.setConstraints(this.minPButton, constraints);
            westfallYoungPanel.add(this.minPButton);
            TFAInitBox2.this.buildConstraints(constraints, 2, 0, 1, 1, 33, 0);
            grid2.setConstraints(this.maxTButton, constraints);
            westfallYoungPanel.add(this.maxTButton);
            TFAInitBox2.this.buildConstraints(constraints, 0, 1, 3, 1, 100, 50);
            gridbag.setConstraints(westfallYoungPanel, constraints);
            this.add(westfallYoungPanel);
        }
    }

    class PValuePanel
    extends JPanel {
        JRadioButton tDistButton;
        JRadioButton permutButton;
        JLabel numPermsLabel;
        JTextField timesField;
        JTextField alphaInputField;

        PValuePanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(1), "P-Value Parameters", 0, 0, new Font("Dialog", 1, 12), Color.black));
            this.setBackground(Color.white);
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(gridbag);
            ButtonGroup chooseP = new ButtonGroup();
            this.tDistButton = new JRadioButton("p-values based on F-distribution", true);
            this.tDistButton.setFocusPainted(false);
            this.tDistButton.setForeground(UIManager.getColor("Label.foreground"));
            this.tDistButton.setBackground(Color.white);
            this.numPermsLabel = new JLabel("Enter number of permutations");
            this.numPermsLabel.setEnabled(false);
            this.timesField = new JTextField("1000", 7);
            this.timesField.setEnabled(false);
            this.timesField.setBackground(Color.darkGray);
            this.tDistButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PValuePanel.this.numPermsLabel.setEnabled(false);
                    PValuePanel.this.timesField.setEnabled(false);
                    PValuePanel.this.timesField.setBackground(Color.darkGray);
                    TFAInitBox2.this.pAdjPanel.maxTButton.setEnabled(false);
                    TFAInitBox2.this.pAdjPanel.minPButton.setEnabled(false);
                }
            });
            chooseP.add(this.tDistButton);
            this.permutButton = new JRadioButton("p-values based on permutation:  ", false);
            this.permutButton.setFocusPainted(false);
            this.permutButton.setForeground(UIManager.getColor("Label.foreground"));
            this.permutButton.setBackground(Color.white);
            this.permutButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PValuePanel.this.numPermsLabel.setEnabled(true);
                    PValuePanel.this.timesField.setEnabled(true);
                    PValuePanel.this.timesField.setBackground(Color.white);
                }
            });
            chooseP.add(this.permutButton);
            TFAInitBox2.this.buildConstraints(constraints, 0, 0, 3, 1, 100, 30);
            constraints.anchor = 17;
            gridbag.setConstraints(this.tDistButton, constraints);
            this.add(this.tDistButton);
            TFAInitBox2.this.buildConstraints(constraints, 0, 1, 1, 1, 30, 30);
            constraints.anchor = 17;
            gridbag.setConstraints(this.permutButton, constraints);
            this.add(this.permutButton);
            TFAInitBox2.this.buildConstraints(constraints, 1, 1, 1, 1, 30, 0);
            gridbag.setConstraints(this.numPermsLabel, constraints);
            this.add(this.numPermsLabel);
            TFAInitBox2.this.buildConstraints(constraints, 2, 1, 1, 1, 40, 0);
            gridbag.setConstraints(this.timesField, constraints);
            this.add(this.timesField);
            JLabel alphaLabel = new JLabel("Enter critical p-value");
            TFAInitBox2.this.buildConstraints(constraints, 0, 2, 2, 1, 60, 40);
            gridbag.setConstraints(alphaLabel, constraints);
            this.add(alphaLabel);
            this.alphaInputField = new JTextField("0.01", 7);
            TFAInitBox2.this.buildConstraints(constraints, 1, 2, 1, 1, 40, 0);
            constraints.anchor = 17;
            gridbag.setConstraints(this.alphaInputField, constraints);
            this.add(this.alphaInputField);
        }
    }

    class MultiGroupExperimentsPanel
    extends JPanel {
        JLabel[] expLabels;
        JRadioButton[][] exptGroupRadioButtons;
        JRadioButton[] notInGroupRadioButtons;
        int numGroups;

        MultiGroupExperimentsPanel(String factorName, int numGroups) {
            this.setBorder(new TitledBorder(new EtchedBorder(), factorName + " assignments", 0, 0, new Font("Dialog", 1, 12), Color.black));
            this.numGroups = numGroups;
            this.setBackground(Color.white);
            JPanel panel1 = new JPanel();
            this.expLabels = new JLabel[TFAInitBox2.this.exptNames.size()];
            this.exptGroupRadioButtons = new JRadioButton[numGroups][TFAInitBox2.this.exptNames.size()];
            this.notInGroupRadioButtons = new JRadioButton[TFAInitBox2.this.exptNames.size()];
            ButtonGroup[] chooseGroup = new ButtonGroup[TFAInitBox2.this.exptNames.size()];
            GridBagLayout gridbag = new GridBagLayout();
            GridBagLayout gridbag2 = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(gridbag2);
            panel1.setLayout(gridbag);
            for (int i = 0; i < TFAInitBox2.this.exptNames.size(); ++i) {
                int j;
                String s1 = (String)TFAInitBox2.this.exptNames.get(i);
                this.expLabels[i] = new JLabel(s1);
                chooseGroup[i] = new ButtonGroup();
                for (j = 0; j < numGroups; ++j) {
                    this.exptGroupRadioButtons[j][i] = new JRadioButton("Group " + (j + 1) + "     ", j == 0);
                    chooseGroup[i].add(this.exptGroupRadioButtons[j][i]);
                }
                this.notInGroupRadioButtons[i] = new JRadioButton("Not in groups", false);
                chooseGroup[i].add(this.notInGroupRadioButtons[i]);
                for (j = 0; j < numGroups; ++j) {
                    TFAInitBox2.this.buildConstraints(constraints, j, i, 1, 1, 100, 100);
                    gridbag.setConstraints(this.exptGroupRadioButtons[j][i], constraints);
                    panel1.add(this.exptGroupRadioButtons[j][i]);
                }
                TFAInitBox2.this.buildConstraints(constraints, numGroups + 1, i, 1, 1, 100, 100);
                gridbag.setConstraints(this.notInGroupRadioButtons[i], constraints);
                panel1.add(this.notInGroupRadioButtons[i]);
            }
            int maxLabelWidth = 0;
            for (int i = 0; i < this.expLabels.length; ++i) {
                if (!(this.expLabels[i].getPreferredSize().getWidth() > (double)maxLabelWidth)) continue;
                maxLabelWidth = (int)Math.ceil(this.expLabels[i].getPreferredSize().getWidth());
            }
            JScrollPane scroll = new JScrollPane(panel1);
            scroll.setHorizontalScrollBarPolicy(32);
            scroll.setVerticalScrollBarPolicy(22);
            JPanel exptNameHeaderPanel = new JPanel();
            GridBagLayout exptHeaderGridbag = new GridBagLayout();
            exptNameHeaderPanel.setSize(50, panel1.getPreferredSize().height);
            exptNameHeaderPanel.setPreferredSize(new Dimension(maxLabelWidth + 10, panel1.getPreferredSize().height));
            exptNameHeaderPanel.setLayout(exptHeaderGridbag);
            for (int i = 0; i < this.expLabels.length; ++i) {
                TFAInitBox2.this.buildConstraints(constraints, 0, i, 1, 1, 100, 100);
                constraints.fill = 1;
                exptHeaderGridbag.setConstraints(this.expLabels[i], constraints);
                exptNameHeaderPanel.add(this.expLabels[i]);
            }
            scroll.setRowHeaderView(exptNameHeaderPanel);
            TFAInitBox2.this.buildConstraints(constraints, 0, 0, 1, 1, 100, 100);
            constraints.fill = 1;
            gridbag2.setConstraints(scroll, constraints);
            this.add(scroll);
        }

        public void reset() {
            for (int i = 0; i < TFAInitBox2.this.exptNames.size(); ++i) {
                this.exptGroupRadioButtons[0][i].setSelected(true);
            }
        }

        public int[] getGroupAssignments() {
            int i;
            int[] groupAssignments = new int[TFAInitBox2.this.exptNames.size()];
            for (i = 0; i < groupAssignments.length; ++i) {
                groupAssignments[i] = 0;
            }
            block1: for (i = 0; i < groupAssignments.length; ++i) {
                for (int j = 0; j < this.numGroups; ++j) {
                    if (!this.exptGroupRadioButtons[j][i].isSelected()) continue;
                    groupAssignments[i] = j + 1;
                    continue block1;
                }
            }
            return groupAssignments;
        }

        public void setGroupAssignments(int[] assignments) {
            for (int i = 0; i < assignments.length; ++i) {
                if (assignments[i] == 0) {
                    this.notInGroupRadioButtons[i].setSelected(true);
                    continue;
                }
                this.exptGroupRadioButtons[assignments[i] - 1][i].setSelected(true);
            }
        }
    }

    class GroupExptsPanel
    extends JPanel {
        MultiGroupExperimentsPanel factorAPanel;
        MultiGroupExperimentsPanel factorBPanel;
        JPanel panel2;

        GroupExptsPanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(), "Group Assignments", 0, 0, new Font("Dialog", 1, 12), Color.black));
            this.setBackground(Color.white);
            this.factorAPanel = new MultiGroupExperimentsPanel(TFAInitBox2.this.factorNames[0], TFAInitBox2.this.numFactorLevels[0]);
            this.factorBPanel = new MultiGroupExperimentsPanel(TFAInitBox2.this.factorNames[1], TFAInitBox2.this.numFactorLevels[1]);
            GridBagLayout grid1 = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(grid1);
            TFAInitBox2.this.buildConstraints(constraints, 0, 0, 1, 1, 50, 90);
            constraints.fill = 1;
            grid1.setConstraints(this.factorAPanel, constraints);
            this.add(this.factorAPanel);
            TFAInitBox2.this.buildConstraints(constraints, 1, 0, 1, 1, 50, 0);
            constraints.fill = 1;
            grid1.setConstraints(this.factorBPanel, constraints);
            this.add(this.factorBPanel);
            JPanel panel2 = new JPanel();
            GridBagLayout gridbag3 = new GridBagLayout();
            panel2.setLayout(gridbag3);
            panel2.setBackground(Color.white);
            JButton saveButton = new JButton("  Save settings  ");
            saveButton.setFocusPainted(false);
            saveButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
            JButton loadButton = new JButton("  Load settings  ");
            loadButton.setFocusPainted(false);
            loadButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
            JButton resetButton = new JButton("  Reset  ");
            resetButton.setFocusPainted(false);
            resetButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
            resetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    GroupExptsPanel.this.factorAPanel.reset();
                    GroupExptsPanel.this.factorBPanel.reset();
                }
            });
            JFileChooser fc = new JFileChooser(TMEV.getDataPath());
            saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    GroupExptsPanel.this.saveAssignments();
                }
            });
            loadButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    GroupExptsPanel.this.loadAssignments();
                }
            });
            constraints.anchor = 10;
            constraints.fill = 0;
            constraints.insets = new Insets(5, 5, 5, 5);
            TFAInitBox2.this.buildConstraints(constraints, 0, 0, 1, 1, 33, 100);
            gridbag3.setConstraints(saveButton, constraints);
            panel2.add(saveButton);
            TFAInitBox2.this.buildConstraints(constraints, 1, 0, 1, 1, 33, 0);
            gridbag3.setConstraints(loadButton, constraints);
            panel2.add(loadButton);
            TFAInitBox2.this.buildConstraints(constraints, 2, 0, 1, 1, 34, 0);
            gridbag3.setConstraints(resetButton, constraints);
            panel2.add(resetButton);
            constraints.insets = new Insets(0, 0, 0, 0);
            TFAInitBox2.this.buildConstraints(constraints, 0, 1, 2, 1, 100, 5);
            constraints.anchor = 10;
            grid1.setConstraints(panel2, constraints);
            this.add(panel2);
        }

        private void saveAssignments() {
            JFileChooser fileChooser = new JFileChooser(TMEV.getDataPath());
            if (fileChooser.showSaveDialog(this) == 0) {
                File file = fileChooser.getSelectedFile();
                try {
                    PrintWriter pw = new PrintWriter(new FileWriter(file));
                    Date currDate = new Date(System.currentTimeMillis());
                    String dateString = currDate.toString();
                    String userName = System.getProperty("user.name");
                    pw.println("# Assignment File");
                    pw.println("# User: " + userName + " Save Date: " + dateString);
                    pw.println("#");
                    pw.print("Module:\t");
                    pw.println("2-Factor ANOVA");
                    for (int i = 0; i < Math.max(TFAInitBox2.this.numFactorLevels[0], TFAInitBox2.this.numFactorLevels[1]); ++i) {
                        pw.print("Group " + (i + 1) + " Label:\t");
                        pw.println("Group " + (i + 1));
                    }
                    pw.println("#");
                    pw.println("Sample Index\tSample Name\tGroup Assignment");
                    int[] groupAAssgn = TFAInitBox2.this.getFactorAAssignments();
                    int[] groupBAssgn = TFAInitBox2.this.getFactorBAssignments();
                    for (int sample = 0; sample < TFAInitBox2.this.exptNames.size(); ++sample) {
                        pw.print(String.valueOf(sample + 1) + "\t");
                        pw.print(TFAInitBox2.this.exptNames.get(sample) + "\t");
                        if (groupAAssgn[sample] != 0) {
                            pw.print("Group " + groupAAssgn[sample]);
                        } else {
                            pw.print("Exclude");
                        }
                        if (groupBAssgn[sample] != 0) {
                            pw.println("\tGroup " + groupBAssgn[sample]);
                            continue;
                        }
                        pw.println("\tExclude");
                    }
                    pw.flush();
                    pw.close();
                }
                catch (FileNotFoundException fnfe) {
                    fnfe.printStackTrace();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }

        private void loadAssignments() {
            JFileChooser fileChooser = new JFileChooser(TMEV.getDataPath());
            if (fileChooser.showOpenDialog(this) == 0) {
                File file = fileChooser.getSelectedFile();
                try {
                    String line;
                    BufferedReader br = new BufferedReader(new FileReader(file));
                    Vector<String> data = new Vector<String>();
                    while ((line = br.readLine()) != null) {
                        data.add(line.trim());
                    }
                    br.close();
                    Vector<String> groupNames = new Vector<String>();
                    Vector<Integer> sampleIndices = new Vector<Integer>();
                    Vector<String> sampleNames = new Vector<String>();
                    Vector<String> groupAAssignments = new Vector<String>();
                    Vector<String> groupBAssignments = new Vector<String>();
                    boolean bothloaded = true;
                    for (int row = 0; row < data.size(); ++row) {
                        line = (String)data.get(row);
                        if (line.startsWith("#") || line.startsWith("SampleIndex")) continue;
                        String[] lineArray = line.split("\t");
                        if (lineArray[0].startsWith("Module:")) {
                            if (lineArray[1].equals("2-Factor ANOVA")) continue;
                            Object[] optionst = new Object[]{"Continue", "Cancel"};
                            if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different module, " + lineArray[1] + ". \n Would you like MeV to try to load it anyway?", "File type warning", 1, 3, null, optionst, optionst[0]) == 0) continue;
                            return;
                        }
                        if (lineArray[0].startsWith("Group ") && lineArray[0].endsWith("Label:")) {
                            groupNames.add(lineArray[1]);
                            continue;
                        }
                        try {
                            Integer.parseInt(lineArray[0]);
                        }
                        catch (NumberFormatException nfe) {
                            continue;
                        }
                        sampleIndices.add(new Integer(lineArray[0]));
                        sampleNames.add(lineArray[1]);
                        groupAAssignments.add(lineArray[2]);
                        try {
                            groupBAssignments.add(lineArray[3]);
                            continue;
                        }
                        catch (Exception e) {
                            bothloaded = false;
                        }
                    }
                    if (!bothloaded) {
                        JOptionPane.showMessageDialog(null, "The loaded file contained only 1 Factor.  Only " + TFAInitBox2.this.factorNames[0] + " will be loaded.", "Error", 0);
                    }
                    if (TFAInitBox2.this.exptNames.size() != sampleNames.size()) {
                        System.out.println(TFAInitBox2.this.exptNames.size() + "  " + sampleNames.size());
                        System.out.println(TFAInitBox2.this.exptNames.size() + " s length " + sampleNames.size());
                        JOptionPane.showMessageDialog(this, "<html>Error -- number of samples designated in assignment file (" + String.valueOf(sampleNames.size()) + ")<br>" + "does not match the number of samples loaded in MeV (" + TFAInitBox2.this.exptNames.size() + ").<br>" + "Assignments are not set.</html>", "File Compatibility Error", 0);
                        return;
                    }
                    Vector<String> currSampleVector = new Vector<String>();
                    for (int i = 0; i < TFAInitBox2.this.exptNames.size(); ++i) {
                        currSampleVector.add((String)TFAInitBox2.this.exptNames.get(i));
                    }
                    int fileSampleIndexA = 0;
                    int groupIndexA = 0;
                    int fileSampleIndexB = 0;
                    int groupIndexB = 0;
                    for (int sample = 0; sample < TFAInitBox2.this.exptNames.size(); ++sample) {
                        boolean doIndex = false;
                        for (int i = 0; i < TFAInitBox2.this.exptNames.size(); ++i) {
                            if (i == sample || !TFAInitBox2.this.exptNames.get(i).equals(TFAInitBox2.this.exptNames.get(sample))) continue;
                            doIndex = true;
                        }
                        fileSampleIndexA = sampleNames.indexOf(TFAInitBox2.this.exptNames.get(sample));
                        if (fileSampleIndexA == -1) {
                            doIndex = true;
                        }
                        if (bothloaded && (fileSampleIndexB = sampleNames.indexOf(TFAInitBox2.this.exptNames.get(sample))) == -1) {
                            doIndex = true;
                            break;
                        }
                        if (doIndex) {
                            this.setStateBasedOnIndex(groupAAssignments, groupBAssignments, groupNames, bothloaded);
                            break;
                        }
                        String groupAName = (String)groupAAssignments.get(fileSampleIndexA);
                        groupIndexA = groupNames.indexOf(groupAName);
                        try {
                            TFAInitBox2.this.gPanel.factorAPanel.exptGroupRadioButtons[groupIndexA][sample].setSelected(true);
                        }
                        catch (Exception e) {
                            TFAInitBox2.this.gPanel.factorAPanel.notInGroupRadioButtons[sample].setSelected(true);
                        }
                        if (!bothloaded) continue;
                        String groupBName = groupBAssignments.get(fileSampleIndexB);
                        groupIndexB = groupNames.indexOf(groupBName);
                        try {
                            TFAInitBox2.this.gPanel.factorBPanel.exptGroupRadioButtons[groupIndexB][sample].setSelected(true);
                            continue;
                        }
                        catch (Exception e) {
                            TFAInitBox2.this.gPanel.factorBPanel.notInGroupRadioButtons[sample].setSelected(true);
                        }
                    }
                    this.repaint();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this, "<html>The file format cannot be read.</html>", "File Compatibility Error", 0);
                }
            }
        }

        private void setStateBasedOnIndex(Vector<String> groupAAssignments, Vector<String> groupBAssignments, Vector<String> groupNames, boolean bothloaded) {
            int sample;
            Object[] optionst = new Object[]{"Continue", "Cancel"};
            if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different sample annotation. \n Would you like MeV to try to load it by index order?", "File type warning", 1, 3, null, optionst, optionst[0]) == 1) {
                return;
            }
            for (sample = 0; sample < TFAInitBox2.this.exptNames.size(); ++sample) {
                try {
                    TFAInitBox2.this.gPanel.factorAPanel.exptGroupRadioButtons[groupNames.indexOf(groupAAssignments.get(sample))][sample].setSelected(true);
                    continue;
                }
                catch (Exception e) {
                    TFAInitBox2.this.gPanel.factorAPanel.notInGroupRadioButtons[sample].setSelected(true);
                }
            }
            if (bothloaded) {
                for (sample = 0; sample < TFAInitBox2.this.exptNames.size(); ++sample) {
                    try {
                        TFAInitBox2.this.gPanel.factorBPanel.exptGroupRadioButtons[groupNames.indexOf(groupBAssignments.get(sample))][sample].setSelected(true);
                        continue;
                    }
                    catch (Exception e) {
                        TFAInitBox2.this.gPanel.factorBPanel.notInGroupRadioButtons[sample].setSelected(true);
                    }
                }
            }
        }

        public void reset() {
            this.factorAPanel.reset();
            this.factorBPanel.reset();
        }
    }
}

