/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.tfa;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;

public class TFAInitBox1
extends AlgorithmDialog {
    boolean okPressed = false;
    JTextField factorANameField;
    JTextField factorBNameField;
    JTextField factorALevelsField;
    JTextField factorBLevelsField;

    public TFAInitBox1(JFrame parentFrame, boolean modality) {
        super(parentFrame, "TFA - set factor names and levels", modality);
        this.okButton.setText("Next >");
        this.setBounds(0, 0, 600, 200);
        this.setBackground(Color.white);
        this.setDefaultCloseOperation(2);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 0;
        JPanel pane = new JPanel();
        pane.setBackground(Color.white);
        pane.setBorder(new EtchedBorder());
        pane.setLayout(gridbag);
        JLabel factorAName = new JLabel("Factor A name: ");
        this.buildConstraints(constraints, 0, 0, 1, 1, 25, 50);
        gridbag.setConstraints(factorAName, constraints);
        pane.add(factorAName);
        this.factorANameField = new JTextField("Factor A", 10);
        this.buildConstraints(constraints, 1, 0, 1, 1, 25, 0);
        gridbag.setConstraints(this.factorANameField, constraints);
        pane.add(this.factorANameField);
        JLabel factorALevels = new JLabel("No. of levels of Factor A: ");
        this.buildConstraints(constraints, 2, 0, 1, 1, 25, 0);
        gridbag.setConstraints(factorALevels, constraints);
        pane.add(factorALevels);
        this.factorALevelsField = new JTextField(10);
        this.buildConstraints(constraints, 3, 0, 1, 1, 25, 0);
        gridbag.setConstraints(this.factorALevelsField, constraints);
        pane.add(this.factorALevelsField);
        JLabel factorBName = new JLabel("Factor B name: ");
        this.buildConstraints(constraints, 0, 1, 1, 1, 25, 50);
        gridbag.setConstraints(factorBName, constraints);
        pane.add(factorBName);
        this.factorBNameField = new JTextField("Factor B", 10);
        this.buildConstraints(constraints, 1, 1, 1, 1, 25, 0);
        gridbag.setConstraints(this.factorBNameField, constraints);
        pane.add(this.factorBNameField);
        JLabel factorBLevels = new JLabel("No. of levels of Factor B: ");
        this.buildConstraints(constraints, 2, 1, 1, 1, 25, 0);
        gridbag.setConstraints(factorBLevels, constraints);
        pane.add(factorBLevels);
        this.factorBLevelsField = new JTextField(10);
        this.buildConstraints(constraints, 3, 1, 1, 1, 25, 0);
        gridbag.setConstraints(this.factorBLevelsField, constraints);
        pane.add(this.factorBLevelsField);
        this.addContent(pane);
        EventListener listener = new EventListener();
        this.setActionListeners(listener);
        this.addWindowListener(listener);
    }

    @Override
    public void setVisible(boolean visible) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        super.setVisible(visible);
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public String getFactorAName() {
        return this.factorANameField.getText();
    }

    public String getFactorBName() {
        return this.factorBNameField.getText();
    }

    public int getNumFactorALevels() {
        return Integer.parseInt(this.factorALevelsField.getText());
    }

    public int getNumFactorBLevels() {
        return Integer.parseInt(this.factorBLevelsField.getText());
    }

    protected boolean isBlank(String str) {
        boolean blank = true;
        char[] charArr = str.toCharArray();
        for (int i = 0; i < charArr.length; ++i) {
            if (charArr[i] == ' ') continue;
            blank = false;
            break;
        }
        return blank;
    }

    public static void main(String[] args) {
        TFAInitBox1 tBox = new TFAInitBox1(new JFrame(), true);
        tBox.setVisible(true);
        System.out.println("Factor A = " + tBox.getFactorAName().length());
    }

    public class EventListener
    extends WindowAdapter
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            String command = ae.getActionCommand();
            if (command.equals("ok-command")) {
                try {
                    if (TFAInitBox1.this.getNumFactorALevels() <= 1 || TFAInitBox1.this.getNumFactorBLevels() <= 1) {
                        JOptionPane.showMessageDialog(null, "Invalid number of levels", "Error", 0);
                        return;
                    }
                    if (TFAInitBox1.this.getFactorAName().length() == 0 || TFAInitBox1.this.getFactorBName().length() == 0 || TFAInitBox1.this.isBlank(TFAInitBox1.this.getFactorAName()) || TFAInitBox1.this.isBlank(TFAInitBox1.this.getFactorBName())) {
                        JOptionPane.showMessageDialog(null, "Enter names for both factors", "Error", 0);
                        return;
                    }
                    TFAInitBox1.this.okPressed = true;
                    TFAInitBox1.this.dispose();
                }
                catch (NumberFormatException nfe) {
                    JOptionPane.showMessageDialog(null, "Invalid number of levels", "Error", 0);
                }
            } else if (command.equals("reset-command")) {
                TFAInitBox1.this.factorANameField.setText("");
                TFAInitBox1.this.factorBNameField.setText("");
                TFAInitBox1.this.factorALevelsField.setText("");
                TFAInitBox1.this.factorBLevelsField.setText("");
                TFAInitBox1.this.okPressed = false;
            } else if (command.equals("cancel-command")) {
                TFAInitBox1.this.okPressed = false;
                TFAInitBox1.this.dispose();
            } else if (command.equals("info-command")) {
                // empty if block
            }
        }
    }
}

