/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.tfa;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLGUI;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLViewer;
import org.tigr.microarray.mev.cluster.gui.impl.tfa.TFACentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.tfa.TFACentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.tfa.TFAExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.tfa.TFAInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.tfa.TFAInitBox1;
import org.tigr.microarray.mev.cluster.gui.impl.tfa.TFAInitBox2;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.util.FloatMatrix;

public class TFAGUI
implements IClusterGUI,
IScriptGUI {
    public static final int JUST_ALPHA = 4;
    public static final int STD_BONFERRONI = 5;
    public static final int ADJ_BONFERRONI = 6;
    public static final int MAX_T = 9;
    public static final int MIN_P = 10;
    protected Algorithm algorithm;
    protected Progress progress;
    protected Experiment experiment;
    protected IData data;
    protected int[][] clusters;
    protected FloatMatrix means;
    protected FloatMatrix variances;
    protected Vector exptNamesVector;
    protected String[] factorNames;
    protected int[] numFactorLevels;
    protected int[] factorAAssignments;
    protected int[] factorBAssignments;
    protected Object[][] auxData;
    protected String[] auxTitles;
    protected String[] clusterLabels;
    protected boolean usePerms;
    protected boolean drawSigTreesOnly;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework framework) throws AlgorithmException {
        IDistanceMenu menu;
        int function;
        this.experiment = framework.getData().getExperiment();
        this.data = framework.getData();
        int number_of_samples = this.experiment.getNumberOfSamples();
        int number_of_genes = this.experiment.getNumberOfGenes();
        this.exptNamesVector = new Vector();
        for (int i = 0; i < number_of_samples; ++i) {
            this.exptNamesVector.add(framework.getData().getFullSampleName(this.experiment.getSampleIndex(i)));
        }
        TFAInitBox1 t1Box = new TFAInitBox1((JFrame)framework.getFrame(), true);
        t1Box.setVisible(true);
        if (!t1Box.isOkPressed()) {
            return null;
        }
        this.factorNames = new String[2];
        this.numFactorLevels = new int[2];
        this.factorNames[0] = t1Box.getFactorAName();
        this.factorNames[1] = t1Box.getFactorBName();
        String[] localClustNames = new String[]{this.factorNames[0] + " significant", this.factorNames[1] + " significant", "Interaction signficant", this.factorNames[0] + " non-significant", this.factorNames[1] + " non-significant", "Interaction non-signficant", "Non-significant for all effects"};
        this.clusterLabels = new String[localClustNames.length];
        for (int i = 0; i < this.clusterLabels.length; ++i) {
            this.clusterLabels[i] = localClustNames[i];
        }
        this.numFactorLevels[0] = t1Box.getNumFactorALevels();
        this.numFactorLevels[1] = t1Box.getNumFactorBLevels();
        TFAInitBox2 t2Box = new TFAInitBox2((JFrame)framework.getFrame(), true, this.exptNamesVector, this.factorNames, this.numFactorLevels, framework.getClusterRepository(1));
        t2Box.setVisible(true);
        if (!t2Box.isOkPressed()) {
            return null;
        }
        boolean allCellsHaveOneSample = t2Box.allCellsHaveOneSample();
        boolean isHierarchicalTree = t2Box.drawTrees();
        this.drawSigTreesOnly = true;
        if (isHierarchicalTree) {
            this.drawSigTreesOnly = t2Box.drawSigTreesOnly();
        }
        int adjustmentMethod = t2Box.getAdjustmentMethod();
        float alpha = t2Box.getAlpha();
        if (t2Box.isButtonSelectionMethod()) {
            this.factorAAssignments = t2Box.getFactorAAssignments();
            this.factorBAssignments = t2Box.getFactorBAssignments();
        } else {
            this.factorAAssignments = t2Box.getFactorAClusterAssignments();
            this.factorBAssignments = t2Box.getFactorBClusterAssignments();
        }
        Object[][] bothFactorAssignments = t2Box.getBothFactorAssignments();
        boolean isBalancedDesign = false;
        if (!allCellsHaveOneSample) {
            isBalancedDesign = t2Box.isBalancedDesign();
        }
        this.usePerms = t2Box.usePerms();
        int numPerms = 0;
        if (this.usePerms) {
            numPerms = t2Box.getNumPerms();
        }
        if ((function = (menu = framework.getDistanceMenu()).getDistanceFunction()) == 0) {
            function = 1;
        }
        int hcl_method = 0;
        boolean hcl_samples = false;
        boolean hcl_genes = false;
        int hcl_function = 4;
        boolean hcl_absolute = false;
        if (isHierarchicalTree) {
            HCLInitDialog hcl_dialog = new HCLInitDialog(framework.getFrame(), menu.getFunctionName(function), menu.isAbsoluteDistance(), true);
            if (hcl_dialog.showModal() != 0) {
                return null;
            }
            hcl_method = hcl_dialog.getMethod();
            hcl_samples = hcl_dialog.isClusterExperiments();
            hcl_genes = hcl_dialog.isClusterGenes();
            hcl_function = hcl_dialog.getDistanceMetric();
            hcl_absolute = hcl_dialog.getAbsoluteSelection();
        }
        Listener listener = new Listener();
        try {
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("TFA");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            int genes = this.experiment.getNumberOfGenes();
            this.progress = new Progress(framework.getFrame(), "Finding significant genes", listener);
            this.progress.show();
            AlgorithmData data = new AlgorithmData();
            data.addMatrix("experiment", this.experiment.getMatrix());
            data.addParam("distance-factor", String.valueOf(1.0f));
            data.addParam("distance-absolute", String.valueOf(menu.isAbsoluteDistance()));
            data.addParam("distance-function", String.valueOf(function));
            data.addIntArray("numFactorLevels", this.numFactorLevels);
            data.addParam("allCellsHaveOneSample", String.valueOf(allCellsHaveOneSample));
            data.addParam("adjustmentMethod", String.valueOf(adjustmentMethod));
            data.addParam("alpha", String.valueOf(alpha));
            data.addIntArray("factorAAssignments", this.factorAAssignments);
            data.addIntArray("factorBAssignments", this.factorBAssignments);
            data.addObjectMatrix("bothFactorAssignments", bothFactorAssignments);
            data.addParam("isBalancedDesign", String.valueOf(isBalancedDesign));
            data.addParam("usePerms", String.valueOf(this.usePerms));
            data.addParam("numPerms", String.valueOf(numPerms));
            if (isHierarchicalTree) {
                data.addParam("hierarchical-tree", String.valueOf(true));
                data.addParam("draw-sig-trees-only", String.valueOf(this.drawSigTreesOnly));
                data.addParam("method-linkage", String.valueOf(hcl_method));
                data.addParam("calculate-genes", String.valueOf(hcl_genes));
                data.addParam("calculate-experiments", String.valueOf(hcl_samples));
                data.addParam("hcl-distance-function", String.valueOf(hcl_function));
                data.addParam("hcl-distance-absolute", String.valueOf(hcl_absolute));
            }
            long start = System.currentTimeMillis();
            AlgorithmData result = this.algorithm.execute(data);
            long time = System.currentTimeMillis() - start;
            Cluster result_cluster = result.getCluster("cluster");
            NodeList nodeList = result_cluster.getNodeList();
            int k = 7;
            this.clusters = new int[k][];
            for (int i = 0; i < k; ++i) {
                this.clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
            }
            this.means = result.getMatrix("clusters_means");
            this.variances = result.getMatrix("clusters_variances");
            FloatMatrix factorAFValuesMatrix = result.getMatrix("factorAFValuesMatrix");
            FloatMatrix factorBFValuesMatrix = result.getMatrix("factorBFValuesMatrix");
            FloatMatrix interactionFValuesMatrix = result.getMatrix("interactionFValuesMatrix");
            FloatMatrix factorADfValuesMatrix = result.getMatrix("factorADfValuesMatrix");
            FloatMatrix factorBDfValuesMatrix = result.getMatrix("factorBDfValuesMatrix");
            FloatMatrix interactionDfValuesMatrix = result.getMatrix("interactionDfValuesMatrix");
            FloatMatrix errorDfValuesMatrix = result.getMatrix("errorDfValuesMatrix");
            FloatMatrix origFactorAPValuesMatrix = result.getMatrix("origFactorAPValuesMatrix");
            FloatMatrix origFactorBPValuesMatrix = result.getMatrix("origFactorBPValuesMatrix");
            FloatMatrix origInteractionPValuesMatrix = result.getMatrix("origInteractionPValuesMatrix");
            FloatMatrix adjFactorAPValuesMatrix = result.getMatrix("adjFactorAPValuesMatrix");
            FloatMatrix adjFactorBPValuesMatrix = result.getMatrix("adjFactorBPValuesMatrix");
            FloatMatrix adjInteractionPValuesMatrix = result.getMatrix("adjInteractionPValuesMatrix");
            this.auxTitles = new String[13];
            this.auxTitles[0] = "Adj. p-values (" + this.factorNames[0] + ")";
            this.auxTitles[1] = "Adj. p-values (" + this.factorNames[1] + ")";
            this.auxTitles[2] = "Adj. p-values (interaction)";
            this.auxTitles[3] = "Orig. p-values (" + this.factorNames[0] + ")";
            this.auxTitles[4] = "Orig. p-values (" + this.factorNames[1] + ")";
            this.auxTitles[5] = "Orig. p-values (interaction)";
            this.auxTitles[6] = "F-ratio (" + this.factorNames[0] + ")";
            this.auxTitles[7] = "F-ratio (" + this.factorNames[1] + ")";
            this.auxTitles[8] = "F-ratio (interaction)";
            this.auxTitles[9] = "df (" + this.factorNames[0] + ")";
            this.auxTitles[10] = "df (" + this.factorNames[1] + ")";
            this.auxTitles[11] = "df (interaction)";
            this.auxTitles[12] = "df (error)";
            this.auxData = new Object[factorAFValuesMatrix.A.length][13];
            for (int i = 0; i < this.auxData.length; ++i) {
                this.auxData[i][0] = new Float(adjFactorAPValuesMatrix.A[i][0]);
                this.auxData[i][1] = new Float(adjFactorBPValuesMatrix.A[i][0]);
                this.auxData[i][2] = new Float(adjInteractionPValuesMatrix.A[i][0]);
                this.auxData[i][3] = new Float(origFactorAPValuesMatrix.A[i][0]);
                this.auxData[i][4] = new Float(origFactorBPValuesMatrix.A[i][0]);
                this.auxData[i][5] = new Float(origInteractionPValuesMatrix.A[i][0]);
                this.auxData[i][6] = new Float(factorAFValuesMatrix.A[i][0]);
                this.auxData[i][7] = new Float(factorBFValuesMatrix.A[i][0]);
                this.auxData[i][8] = new Float(interactionFValuesMatrix.A[i][0]);
                this.auxData[i][9] = new Integer((int)factorADfValuesMatrix.A[i][0]);
                this.auxData[i][10] = new Integer((int)factorBDfValuesMatrix.A[i][0]);
                this.auxData[i][11] = new Integer((int)interactionDfValuesMatrix.A[i][0]);
                this.auxData[i][12] = new Integer((int)errorDfValuesMatrix.A[i][0]);
            }
            GeneralInfo info = new GeneralInfo();
            info.time = time;
            info.alpha = alpha;
            info.adjMethod = this.getAdjMethod(adjustmentMethod);
            info.pValueBasedOn = this.getPValueBasedOn(this.usePerms);
            if (this.usePerms) {
                info.numPerms = numPerms;
            }
            info.function = menu.getFunctionName(function);
            info.hcl = isHierarchicalTree;
            info.hcl_genes = hcl_genes;
            info.hcl_samples = hcl_samples;
            info.hcl_method = hcl_method;
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(result_cluster, info);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    public AlgorithmData getScriptParameters(IFramework framework) {
        IDistanceMenu menu;
        int function;
        this.experiment = framework.getData().getExperiment();
        this.data = framework.getData();
        int number_of_samples = this.experiment.getNumberOfSamples();
        int number_of_genes = this.experiment.getNumberOfGenes();
        this.exptNamesVector = new Vector();
        for (int i = 0; i < number_of_samples; ++i) {
            this.exptNamesVector.add(framework.getData().getFullSampleName(this.experiment.getSampleIndex(i)));
        }
        TFAInitBox1 t1Box = new TFAInitBox1((JFrame)framework.getFrame(), true);
        t1Box.setVisible(true);
        if (!t1Box.isOkPressed()) {
            return null;
        }
        this.factorNames = new String[2];
        this.numFactorLevels = new int[2];
        this.factorNames[0] = t1Box.getFactorAName();
        this.factorNames[1] = t1Box.getFactorBName();
        String[] localClustNames = new String[]{this.factorNames[0] + " significant", this.factorNames[1] + " significant", "Interaction signficant", this.factorNames[0] + " non-significant", this.factorNames[1] + " non-significant", "Interaction non-signficant", "Non-significant for all effects"};
        this.clusterLabels = new String[localClustNames.length];
        for (int i = 0; i < this.clusterLabels.length; ++i) {
            this.clusterLabels[i] = localClustNames[i];
        }
        this.numFactorLevels[0] = t1Box.getNumFactorALevels();
        this.numFactorLevels[1] = t1Box.getNumFactorBLevels();
        TFAInitBox2 t2Box = new TFAInitBox2((JFrame)framework.getFrame(), true, this.exptNamesVector, this.factorNames, this.numFactorLevels, framework.getClusterRepository(1));
        t2Box.setVisible(true);
        if (!t2Box.isOkPressed()) {
            return null;
        }
        boolean allCellsHaveOneSample = t2Box.allCellsHaveOneSample();
        boolean isHierarchicalTree = t2Box.drawTrees();
        this.drawSigTreesOnly = true;
        if (isHierarchicalTree) {
            this.drawSigTreesOnly = t2Box.drawSigTreesOnly();
        }
        int adjustmentMethod = t2Box.getAdjustmentMethod();
        float alpha = t2Box.getAlpha();
        if (t2Box.isButtonSelectionMethod()) {
            this.factorAAssignments = t2Box.getFactorAAssignments();
            this.factorBAssignments = t2Box.getFactorBAssignments();
        } else {
            this.factorAAssignments = t2Box.getFactorAClusterAssignments();
            this.factorBAssignments = t2Box.getFactorBClusterAssignments();
        }
        Object[][] bothFactorAssignments = t2Box.getBothFactorAssignments();
        boolean isBalancedDesign = false;
        if (!allCellsHaveOneSample) {
            isBalancedDesign = t2Box.isBalancedDesign();
        }
        this.usePerms = t2Box.usePerms();
        int numPerms = 0;
        if (this.usePerms) {
            numPerms = t2Box.getNumPerms();
        }
        if ((function = (menu = framework.getDistanceMenu()).getDistanceFunction()) == 0) {
            function = 1;
        }
        int hcl_method = 0;
        boolean hcl_samples = false;
        boolean hcl_genes = false;
        int hcl_function = 4;
        boolean hcl_absolute = false;
        if (isHierarchicalTree) {
            HCLInitDialog hcl_dialog = new HCLInitDialog(framework.getFrame(), menu.getFunctionName(function), menu.isAbsoluteDistance(), true);
            if (hcl_dialog.showModal() != 0) {
                return null;
            }
            hcl_method = hcl_dialog.getMethod();
            hcl_samples = hcl_dialog.isClusterExperiments();
            hcl_genes = hcl_dialog.isClusterGenes();
            hcl_function = hcl_dialog.getDistanceMetric();
            hcl_absolute = hcl_dialog.getAbsoluteSelection();
        }
        int genes = this.experiment.getNumberOfGenes();
        AlgorithmData data = new AlgorithmData();
        data.addStringArray("cluster-labels", this.clusterLabels);
        data.addStringArray("factor-names", this.factorNames);
        data.addParam("distance-factor", String.valueOf(1.0f));
        data.addParam("distance-absolute", String.valueOf(menu.isAbsoluteDistance()));
        data.addParam("distance-function", String.valueOf(function));
        data.addIntArray("numFactorLevels", this.numFactorLevels);
        data.addParam("allCellsHaveOneSample", String.valueOf(allCellsHaveOneSample));
        data.addParam("adjustmentMethod", String.valueOf(adjustmentMethod));
        data.addParam("alpha", String.valueOf(alpha));
        data.addIntArray("factorAAssignments", this.factorAAssignments);
        data.addIntArray("factorBAssignments", this.factorBAssignments);
        data.addObjectMatrix("bothFactorAssignments", bothFactorAssignments);
        data.addParam("isBalancedDesign", String.valueOf(isBalancedDesign));
        data.addParam("usePerms", String.valueOf(this.usePerms));
        data.addParam("numPerms", String.valueOf(numPerms));
        if (isHierarchicalTree) {
            data.addParam("hierarchical-tree", String.valueOf(true));
            data.addParam("draw-sig-trees-only", String.valueOf(this.drawSigTreesOnly));
            data.addParam("method-linkage", String.valueOf(hcl_method));
            data.addParam("calculate-genes", String.valueOf(hcl_genes));
            data.addParam("calculate-experiments", String.valueOf(hcl_samples));
            data.addParam("hcl-distance-function", String.valueOf(hcl_function));
            data.addParam("hcl-distance-absolute", String.valueOf(hcl_absolute));
        }
        data.addParam("name", "2 Fact. ANOVA");
        data.addParam("alg-type", "cluster-genes");
        data.addParam("output-class", "partition-output");
        data.addStringArray("output-nodes", this.clusterLabels);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode executeScript(IFramework framework, AlgorithmData algData, Experiment experiment) throws AlgorithmException {
        this.experiment = experiment;
        this.data = framework.getData();
        this.exptNamesVector = new Vector();
        for (int i = 0; i < this.data.getFeaturesCount(); ++i) {
            this.exptNamesVector.add(framework.getData().getFullSampleName(i));
        }
        this.clusterLabels = algData.getStringArray("cluster-labels");
        this.factorNames = algData.getStringArray("factor-names");
        this.factorAAssignments = algData.getIntArray("factorAAssignments");
        this.factorBAssignments = algData.getIntArray("factorBAssignments");
        this.drawSigTreesOnly = algData.getParams().getBoolean("draw-sig-trees-only");
        algData.addMatrix("experiment", experiment.getMatrix());
        Listener listener = new Listener();
        try {
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("TFA");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            int genes = experiment.getNumberOfGenes();
            this.progress = new Progress(framework.getFrame(), "Finding significant genes", listener);
            this.progress.show();
            long start = System.currentTimeMillis();
            AlgorithmData result = this.algorithm.execute(algData);
            long time = System.currentTimeMillis() - start;
            Cluster result_cluster = result.getCluster("cluster");
            NodeList nodeList = result_cluster.getNodeList();
            int k = 7;
            this.clusters = new int[k][];
            for (int i = 0; i < k; ++i) {
                this.clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
            }
            this.means = result.getMatrix("clusters_means");
            this.variances = result.getMatrix("clusters_variances");
            FloatMatrix factorAFValuesMatrix = result.getMatrix("factorAFValuesMatrix");
            FloatMatrix factorBFValuesMatrix = result.getMatrix("factorBFValuesMatrix");
            FloatMatrix interactionFValuesMatrix = result.getMatrix("interactionFValuesMatrix");
            FloatMatrix factorADfValuesMatrix = result.getMatrix("factorADfValuesMatrix");
            FloatMatrix factorBDfValuesMatrix = result.getMatrix("factorBDfValuesMatrix");
            FloatMatrix interactionDfValuesMatrix = result.getMatrix("interactionDfValuesMatrix");
            FloatMatrix errorDfValuesMatrix = result.getMatrix("errorDfValuesMatrix");
            FloatMatrix origFactorAPValuesMatrix = result.getMatrix("origFactorAPValuesMatrix");
            FloatMatrix origFactorBPValuesMatrix = result.getMatrix("origFactorBPValuesMatrix");
            FloatMatrix origInteractionPValuesMatrix = result.getMatrix("origInteractionPValuesMatrix");
            FloatMatrix adjFactorAPValuesMatrix = result.getMatrix("adjFactorAPValuesMatrix");
            FloatMatrix adjFactorBPValuesMatrix = result.getMatrix("adjFactorBPValuesMatrix");
            FloatMatrix adjInteractionPValuesMatrix = result.getMatrix("adjInteractionPValuesMatrix");
            this.auxTitles = new String[13];
            this.auxTitles[0] = "Adj. p-values (" + this.factorNames[0] + ")";
            this.auxTitles[1] = "Adj. p-values (" + this.factorNames[1] + ")";
            this.auxTitles[2] = "Adj. p-values (interaction)";
            this.auxTitles[3] = "Orig. p-values (" + this.factorNames[0] + ")";
            this.auxTitles[4] = "Orig. p-values (" + this.factorNames[1] + ")";
            this.auxTitles[5] = "Orig. p-values (interaction)";
            this.auxTitles[6] = "F-ratio (" + this.factorNames[0] + ")";
            this.auxTitles[7] = "F-ratio (" + this.factorNames[1] + ")";
            this.auxTitles[8] = "F-ratio (interaction)";
            this.auxTitles[9] = "df (" + this.factorNames[0] + ")";
            this.auxTitles[10] = "df (" + this.factorNames[1] + ")";
            this.auxTitles[11] = "df (interaction)";
            this.auxTitles[12] = "df (error)";
            this.auxData = new Object[factorAFValuesMatrix.A.length][13];
            for (int i = 0; i < this.auxData.length; ++i) {
                this.auxData[i][0] = new Float(adjFactorAPValuesMatrix.A[i][0]);
                this.auxData[i][1] = new Float(adjFactorBPValuesMatrix.A[i][0]);
                this.auxData[i][2] = new Float(adjInteractionPValuesMatrix.A[i][0]);
                this.auxData[i][3] = new Float(origFactorAPValuesMatrix.A[i][0]);
                this.auxData[i][4] = new Float(origFactorBPValuesMatrix.A[i][0]);
                this.auxData[i][5] = new Float(origInteractionPValuesMatrix.A[i][0]);
                this.auxData[i][6] = new Float(factorAFValuesMatrix.A[i][0]);
                this.auxData[i][7] = new Float(factorBFValuesMatrix.A[i][0]);
                this.auxData[i][8] = new Float(interactionFValuesMatrix.A[i][0]);
                this.auxData[i][9] = new Integer((int)factorADfValuesMatrix.A[i][0]);
                this.auxData[i][10] = new Integer((int)factorBDfValuesMatrix.A[i][0]);
                this.auxData[i][11] = new Integer((int)interactionDfValuesMatrix.A[i][0]);
                this.auxData[i][12] = new Integer((int)errorDfValuesMatrix.A[i][0]);
            }
            AlgorithmParameters params = algData.getParams();
            GeneralInfo info = new GeneralInfo();
            info.time = time;
            info.alpha = params.getFloat("alpha");
            info.adjMethod = this.getAdjMethod(params.getInt("adjustmentMethod"));
            info.pValueBasedOn = this.getPValueBasedOn(params.getBoolean("usePerms"));
            if (this.usePerms) {
                info.numPerms = params.getInt("numPerms");
            }
            int function = params.getInt("distance-function");
            info.function = framework.getDistanceMenu().getFunctionName(function);
            info.hcl = params.getBoolean("hierarchical-tree");
            info.hcl_genes = params.getBoolean("calculate-genes");
            info.hcl_samples = params.getBoolean("calculate-experiments");
            if (info.hcl) {
                info.hcl_method = params.getInt("method-linkage");
            }
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(result_cluster, info);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    protected String getPValueBasedOn(boolean isPerm) {
        String str = "";
        str = isPerm ? "permutation" : "F-distribution";
        return str;
    }

    protected String getAdjMethod(int adjMethod) {
        String methodName = "";
        if (adjMethod == 4) {
            methodName = "None";
        } else if (adjMethod == 5) {
            methodName = "Standard Bonferroni correction";
        } else if (adjMethod == 6) {
            methodName = "Adjusted Bonferroni correction";
        } else if (adjMethod == 10) {
            methodName = "Step-down Westfall Young: Min P";
        } else if (adjMethod == 9) {
            methodName = "Step-down Westfall Young: Max T";
        }
        return methodName;
    }

    protected DefaultMutableTreeNode createResultTree(Cluster result_cluster, GeneralInfo info) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Two-factor ANOVA");
        this.addResultNodes(root, result_cluster, info);
        return root;
    }

    protected void addResultNodes(DefaultMutableTreeNode root, Cluster result_cluster, GeneralInfo info) {
        this.addExpressionImages(root);
        this.addHierarchicalTrees(root, result_cluster, info);
        this.addCentroidViews(root);
        this.addClusterInfo(root);
        this.addTableViews(root);
        this.addGeneralInfo(root, info);
    }

    protected void addExpressionImages(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Expression Images");
        TFAExperimentViewer expViewer = new TFAExperimentViewer(this.experiment, this.clusters, this.auxTitles, this.auxData);
        for (int i = 0; i < this.clusters.length; ++i) {
            node.add(new DefaultMutableTreeNode(new LeafInfo(this.clusterLabels[i], (IViewer)expViewer, (Object)new Integer(i))));
        }
        root.add(node);
    }

    protected void addTableViews(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Table views");
        ClusterTableViewer tableViewer = new ClusterTableViewer(this.experiment, this.clusters, this.data, this.auxTitles, this.auxData);
        for (int i = 0; i < this.clusters.length; ++i) {
            node.add(new DefaultMutableTreeNode(new LeafInfo(this.clusterLabels[i], (IViewer)tableViewer, (Object)new Integer(i))));
        }
        root.add(node);
    }

    protected void addHierarchicalTrees(DefaultMutableTreeNode root, Cluster result_cluster, GeneralInfo info) {
        if (!info.hcl) {
            return;
        }
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Hierarchical Trees");
        NodeList nodeList = result_cluster.getNodeList();
        if (!this.drawSigTreesOnly) {
            for (int i = 0; i < nodeList.getSize(); ++i) {
                node.add(new DefaultMutableTreeNode(new LeafInfo(this.clusterLabels[i], this.createHCLViewer(nodeList.getNode(i), info))));
            }
        } else {
            for (int i = 0; i < nodeList.getSize(); ++i) {
                if (i > 2) continue;
                node.add(new DefaultMutableTreeNode(new LeafInfo(this.clusterLabels[i], this.createHCLViewer(nodeList.getNode(i), info))));
            }
        }
        root.add(node);
    }

    protected IViewer createHCLViewer(Node clusterNode, GeneralInfo info) {
        HCLTreeData genes_result;
        HCLTreeData hCLTreeData = genes_result = info.hcl_genes ? this.getResult(clusterNode, 0) : null;
        HCLTreeData samples_result = info.hcl_samples ? this.getResult(clusterNode, info.hcl_genes ? 4 : 0) : null;
        return new HCLViewer(this.experiment, clusterNode.getFeaturesIndexes(), genes_result, samples_result);
    }

    protected void addCentroidViews(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode centroidNode = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode expressionNode = new DefaultMutableTreeNode("Expression Graphs");
        TFACentroidViewer centroidViewer = new TFACentroidViewer(this.experiment, this.clusters, this.auxTitles, this.auxData);
        centroidViewer.setMeans(this.means.A);
        centroidViewer.setVariances(this.variances.A);
        for (int i = 0; i < this.clusters.length; ++i) {
            centroidNode.add(new DefaultMutableTreeNode(new LeafInfo(this.clusterLabels[i], (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
            expressionNode.add(new DefaultMutableTreeNode(new LeafInfo(this.clusterLabels[i], (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
        }
        TFACentroidsViewer centroidsViewer = new TFACentroidsViewer(this.experiment, this.clusters, this.auxTitles, this.auxData);
        centroidsViewer.setMeans(this.means.A);
        centroidsViewer.setVariances(this.variances.A);
        centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("All Genes", (IViewer)centroidsViewer, (Object)new Integer(0))));
        expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("All Genes", (IViewer)centroidsViewer, (Object)new Integer(1))));
        root.add(centroidNode);
        root.add(expressionNode);
    }

    protected HCLTreeData getResult(Node clusterNode, int pos) {
        HCLTreeData data = new HCLTreeData();
        NodeValueList valueList = clusterNode.getValues();
        data.child_1_array = (int[])valueList.getNodeValue((int)pos).value;
        data.child_2_array = (int[])valueList.getNodeValue((int)(pos + 1)).value;
        data.node_order = (int[])valueList.getNodeValue((int)(pos + 2)).value;
        data.height = (float[])valueList.getNodeValue((int)(pos + 3)).value;
        return data;
    }

    protected void addClusterInfo(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Cluster Information");
        node.add(new DefaultMutableTreeNode(new LeafInfo("Results (#,%)", (IViewer)new TFAInfoViewer(this.clusters, this.experiment.getNumberOfGenes(), this.factorNames))));
        root.add(node);
    }

    protected void addGeneralInfo(DefaultMutableTreeNode root, GeneralInfo info) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("General Information");
        node.add(this.getGroupAssignmentInfo());
        node.add(new DefaultMutableTreeNode("Alpha (overall threshold p-value): " + info.alpha));
        node.add(new DefaultMutableTreeNode("P-values based on: " + info.pValueBasedOn));
        if (this.usePerms) {
            node.add(new DefaultMutableTreeNode("Number of permutations per gene: " + info.numPerms));
        }
        node.add(new DefaultMutableTreeNode("P-value adjustment: " + info.adjMethod));
        node.add(new DefaultMutableTreeNode("HCL: " + info.getMethodName()));
        node.add(new DefaultMutableTreeNode("Time: " + String.valueOf(info.time) + " ms"));
        node.add(new DefaultMutableTreeNode(info.function));
        root.add(node);
    }

    protected DefaultMutableTreeNode getGroupAssignmentInfo() {
        DefaultMutableTreeNode groupAssignmentInfo = new DefaultMutableTreeNode("Factor Assignments");
        DefaultMutableTreeNode factorANode = new DefaultMutableTreeNode(this.factorNames[0]);
        DefaultMutableTreeNode factorBNode = new DefaultMutableTreeNode(this.factorNames[1]);
        for (int i = 0; i < this.exptNamesVector.size(); ++i) {
            if (this.factorAAssignments[i] != 0) {
                factorANode.add(new DefaultMutableTreeNode((String)this.exptNamesVector.get(i) + ": Group " + this.factorAAssignments[i]));
            } else {
                factorANode.add(new DefaultMutableTreeNode((String)this.exptNamesVector.get(i) + ": Unassigned"));
            }
            if (this.factorBAssignments[i] != 0) {
                factorBNode.add(new DefaultMutableTreeNode((String)this.exptNamesVector.get(i) + ": Group " + this.factorBAssignments[i]));
                continue;
            }
            factorBNode.add(new DefaultMutableTreeNode((String)this.exptNamesVector.get(i) + ": Unassigned"));
        }
        groupAssignmentInfo.add(factorANode);
        groupAssignmentInfo.add(factorBNode);
        return groupAssignmentInfo;
    }

    protected class GeneralInfo {
        public int clusters;
        public String adjMethod;
        public String pValueBasedOn;
        public float alpha;
        public int numPerms;
        public long time;
        public String function;
        protected boolean hcl;
        protected int hcl_method;
        protected boolean hcl_genes;
        protected boolean hcl_samples;

        protected GeneralInfo() {
        }

        public String getMethodName() {
            return this.hcl ? HCLGUI.GeneralInfo.getMethodName(this.hcl_method) : "no linkage";
        }
    }

    protected class Listener
    extends DialogListener
    implements AlgorithmListener {
        protected Listener() {
        }

        public void valueChanged(AlgorithmEvent event) {
            switch (event.getId()) {
                case 1: {
                    TFAGUI.this.progress.setUnits(event.getIntValue());
                    TFAGUI.this.progress.setDescription(event.getDescription());
                    break;
                }
                case 2: {
                    TFAGUI.this.progress.setValue(event.getIntValue());
                    TFAGUI.this.progress.setDescription(event.getDescription());
                    break;
                }
                case 3: {
                    int value = event.getIntValue();
                    if (value != -1) break;
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("cancel-command")) {
                TFAGUI.this.algorithm.abort();
                TFAGUI.this.progress.dispose();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            TFAGUI.this.algorithm.abort();
            TFAGUI.this.progress.dispose();
        }
    }
}

