/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.tfa;

import java.awt.Frame;
import java.beans.Expression;
import javax.swing.JOptionPane;
import org.tigr.microarray.mev.cluster.ClusterWrapper;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentViewer;

public class TFAExperimentViewer
extends ExperimentViewer {
    String[] auxTitles;
    Object[][] auxData;

    public TFAExperimentViewer(Experiment experiment, int[][] clusters, String[] auxTitles, Object[][] auxData) {
        super(experiment, clusters);
        this.initialize(auxTitles, auxData);
    }

    public TFAExperimentViewer(Experiment e, int[][] clusters, int[] samplesOrder, boolean drawAnnotations, String[] auxTitles, Object[][] auxData) {
        super(e, clusters, samplesOrder, drawAnnotations);
        this.initialize(auxTitles, auxData);
    }

    public TFAExperimentViewer(Experiment e, ClusterWrapper clusters, ClusterWrapper samplesOrder, Boolean drawAnnotations, String[] auxTitles, Object[][] auxData) {
        super(e, clusters.getClusters(), samplesOrder.getClusters()[0], drawAnnotations);
        this.initialize(auxTitles, auxData);
    }

    public Expression getExpression() {
        Object[] parentConstructorArgs = super.getExpression().getArguments();
        Object[] temp = new Object[parentConstructorArgs.length + 2];
        int i = 0;
        for (i = 0; i < parentConstructorArgs.length; ++i) {
            temp[i] = parentConstructorArgs[i];
        }
        temp[i] = this.auxTitles;
        temp[i + 1] = this.auxData;
        return new Expression((Object)this, ((Object)((Object)this)).getClass(), "new", temp);
    }

    private void initialize(String[] auxTitles, Object[][] auxData) {
        this.auxTitles = auxTitles;
        this.auxData = auxData;
    }

    protected void onSaveClusters() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            ExperimentUtil.saveAllGeneClustersWithAux((Frame)frame, (Experiment)this.getExperiment(), (IData)this.getData(), (int[][])this.getClusters(), (String[])this.auxTitles, (Object[][])this.auxData);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(frame, "Can not save clusters!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    protected void onSaveCluster() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            ExperimentUtil.saveGeneClusterWithAux((Frame)frame, (Experiment)this.getExperiment(), (IData)this.getData(), (int[])this.getCluster(), (String[])this.auxTitles, (Object[][])this.auxData);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(frame, "Can not save cluster!", e.toString(), 0);
            e.printStackTrace();
        }
    }
}

