/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.terrain;

import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.geometry.Text2D;
import com.sun.j3d.utils.picking.PickCanvas;
import com.sun.j3d.utils.picking.PickIntersection;
import com.sun.j3d.utils.picking.PickResult;
import com.sun.j3d.utils.universe.PlatformGeometry;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.util.ArrayList;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.Behavior;
import javax.media.j3d.Billboard;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Light;
import javax.media.j3d.Node;
import javax.media.j3d.PickCone;
import javax.media.j3d.PointLight;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Screen3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextArea;
import javax.swing.JToolTip;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.vecmath.Color3f;
import javax.vecmath.Point2f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple2f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.tigr.microarray.mev.ShowThrowableDialog;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ListDialog;
import org.tigr.microarray.mev.cluster.gui.impl.terrain.ControlPanel;
import org.tigr.microarray.mev.cluster.gui.impl.terrain.DomainUtil;
import org.tigr.microarray.mev.cluster.gui.impl.terrain.DriftInterpolator;
import org.tigr.microarray.mev.cluster.gui.impl.terrain.GenesShape;
import org.tigr.microarray.mev.cluster.gui.impl.terrain.KeyMotionBehavior;
import org.tigr.microarray.mev.cluster.gui.impl.terrain.Landscape;
import org.tigr.microarray.mev.cluster.gui.impl.terrain.LinksShape;
import org.tigr.microarray.mev.cluster.gui.impl.terrain.PickBehavior;
import org.tigr.microarray.mev.cluster.gui.impl.terrain.PickListener;
import org.tigr.microarray.mev.cluster.gui.impl.terrain.SelectionShape;
import org.tigr.microarray.mev.cluster.gui.impl.terrain.TerrainBillboard;
import org.tigr.microarray.mev.cluster.gui.impl.util.IntArray;

public class TerrainViewer
extends JPanel
implements IViewer {
    private IData data;
    private IFramework framework;
    private int labelIndex = -1;
    private boolean isGenes = true;
    private int[][] clusters;
    private float[][] weights;
    private float[][] locations;
    private float sigma;
    private int grid_size = 65;
    private boolean isBillboard = false;
    private final Color3f BLACK_COLOR = new Color3f(0.0f, 0.0f, 0.0f);
    private final Color3f WHITE_COLOR = new Color3f(1.0f, 1.0f, 1.0f);
    private static final BoundingSphere BILLBOARD_BOUNDS = new BoundingSphere(new Point3d(), 100.0);
    private static final Point3f BILLBOARD_P3F = new Point3f(-0.008f, 8.0E-4f, 0.0f);
    private static final String FILL_POLYGON_CMD = "fill-polygone-cmd";
    private static final String ZOOM_IN_CMD = "zoom-in-cmd";
    private static final String UNDO_CMD = "undo-cmd";
    private static final String SHOW_ALL_CMD = "show-all-cmd";
    private static final String POINTS_SHAPE_CMD = "points-shape-cmd";
    private static final String CUBES_SHAPE_CMD = "cubes-shape-cmd";
    private static final String SPHERES_SHAPE_CMD = "spheres-shape-cmd";
    private static final String GRID_SIZE_CMD = "grid-size-cmd";
    private static final String SHOW_ELEMENTS_CMD = "show-elements-cmd";
    private static final String DESELECT_CMD = "deselect-cmd";
    private static final String SHOW_CONTROLS_CMD = "show-controls-cmd";
    private static final String DRIFT_DIALOG_CMD = "drift-dialog-cmd";
    private static final String LAUNCH_SESSION_CMD = "launch-session-cmd";
    private static final String SET_CLUSTER_CMD = "set-cluster-cmd";
    private static final String SHOW_LINKS_CMD = "show-links-cmd";
    private static final String LINKS_THRESHOLD_CMD = "links-threshold-cmd";
    private static final String LINKS_WIDTH_CMD = "links-width-cmd";
    private static final String HIDE_LABELS_CMD = "hide-labels-cmd";
    private static final String USE_BILLBOARD_CMD = "use-billboard-cmd";
    private JPopupMenu popup;
    private JWindow tipWindow;
    private ControlPanel controlPanel;
    private SimpleUniverse universe;
    private Canvas3D onScreenCanvas;
    private Canvas3D offScreenCanvas;
    private TransformGroup view_tg;
    private GenesShape genesShape;
    private BranchGroup sceneGroup;
    private Landscape landscape;
    private LinksShape linksShape;
    private SelectionShape selectionShape;
    private BranchGroup labelsGroup;
    private KeyMotionBehavior keyMotionBehavior;
    private DriftInterpolator driftInterpolator;
    private PickBehavior pickBehavior;
    private Point2f up_left_point = new Point2f(0.0f, 0.0f);
    private Point2f bottom_right_point = new Point2f(1.0f, 1.0f);
    private UndoManager undoManager = new UndoManager();
    private Experiment experiment;
    private int exptID = 0;
    private static boolean enabled3D;

    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{new Boolean(this.isGenes), this.experiment, this.clusters, this.weights, this.locations, new Float(this.sigma), new Integer(this.labelIndex)});
    }

    public TerrainViewer(Boolean isGenes, Experiment experiment, int[][] clusters, float[][] weights, float[][] locations, Float sigma, Integer labelIndex) {
        this((boolean)isGenes, experiment, clusters, weights, locations, sigma.floatValue(), (int)labelIndex);
    }

    public TerrainViewer(boolean isGenes, Experiment experiment, int[][] clusters, float[][] weights, float[][] locations, float sigma, int labelIndex) {
        this.isGenes = isGenes;
        this.experiment = experiment;
        this.exptID = experiment.getId();
        this.clusters = clusters;
        this.weights = weights;
        this.locations = locations;
        this.sigma = sigma;
        this.setPreferredSize(new Dimension(10, 10));
        Listener listener = new Listener();
        if (enabled3D) {
            try {
                GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
                this.onScreenCanvas = new Canvas3D(config);
                this.universe = new SimpleUniverse(this.onScreenCanvas);
                this.offScreenCanvas = new Canvas3D(config, true);
                Screen3D sOn = this.onScreenCanvas.getScreen3D();
                Screen3D sOff = this.offScreenCanvas.getScreen3D();
                sOff.setSize(sOn.getSize());
                sOff.setPhysicalScreenWidth(sOn.getPhysicalScreenWidth());
                sOff.setPhysicalScreenHeight(sOn.getPhysicalScreenHeight());
                this.universe.getViewer().getView().addCanvas3D(this.offScreenCanvas);
                BoundingLeaf boundingLeaf = new BoundingLeaf((Bounds)new BoundingSphere(new Point3d(), 100.0));
                boundingLeaf.setCapability(12);
                PlatformGeometry platformGeometry = new PlatformGeometry();
                platformGeometry.addChild((Node)boundingLeaf);
                platformGeometry.compile();
                this.universe.getViewingPlatform().setPlatformGeometry(platformGeometry);
                this.universe.getViewer().getView().setFrontClipDistance(0.001);
                this.universe.getViewer().getView().setBackClipDistance(0.5);
                Point3d basis = new Point3d(0.5, 0.0, 0.5);
                this.view_tg = this.universe.getViewingPlatform().getViewPlatformTransform();
                this.setInitialViewPoint(this.view_tg, basis);
                this.driftInterpolator = new DriftInterpolator(this.view_tg, boundingLeaf);
                float[][] heights = DomainUtil.getHeights(this.locations, this.grid_size, this.sigma);
                this.selectionShape = new SelectionShape();
                this.landscape = new Landscape(heights);
                this.landscape.setPoligonMode(2);
                TransformGroup landTransform = new TransformGroup();
                landTransform.setCapability(17);
                landTransform.setCapability(18);
                landTransform.addChild((Node)this.landscape);
                this.linksShape = new LinksShape(clusters, weights, locations);
                this.keyMotionBehavior = this.createKeyMotionBehavior(this.view_tg, basis, boundingLeaf);
                this.controlPanel = new ControlPanel(landTransform, this.keyMotionBehavior, boundingLeaf);
                Behavior sliderBehavior = this.controlPanel.getSliderBehavior();
                this.genesShape = new GenesShape(0, this.locations, this.up_left_point, this.bottom_right_point);
                this.genesShape.setBounds(boundingLeaf.getRegion());
                this.labelIndex = labelIndex;
                Node[] nodes = new Node[]{this.selectionShape, landTransform, sliderBehavior, this.keyMotionBehavior, this.driftInterpolator, this.genesShape, this.linksShape};
                this.sceneGroup = this.createSceneGraph(nodes, boundingLeaf);
                this.pickBehavior = new PickBehavior(this.sceneGroup, this.onScreenCanvas, boundingLeaf.getRegion());
                this.pickBehavior.setPickListener(listener);
                this.sceneGroup.addChild((Node)this.pickBehavior);
                this.sceneGroup.compile();
                this.setLayout(new BorderLayout());
                this.add((Component)this.onScreenCanvas, "Center");
                this.add((Component)this.controlPanel, "South");
                this.popup = this.createJPopupMenu(listener);
                this.onScreenCanvas.addMouseListener((MouseListener)listener);
                this.onScreenCanvas.addMouseMotionListener((MouseMotionListener)listener);
                this.onScreenCanvas.addKeyListener((KeyListener)listener);
                enabled3D = true;
            }
            catch (UnsatisfiedLinkError ule) {
                ShowThrowableDialog.show((Frame)new Frame(), (String)"No Java 3D detected", (Throwable)new Exception("Java3D is not installed. The 3D viewer cannot be created."));
                enabled3D = false;
                this.add(this.getJ3DErrorPlaceholderContent());
            }
            catch (NoClassDefFoundError ncdfe) {
                ShowThrowableDialog.show((Frame)new Frame(), (String)"No Java 3D detected", (Throwable)new Exception("Java3D is not installed. The 3D viewer cannot be created."));
                enabled3D = false;
                this.add(this.getJ3DErrorPlaceholderContent());
            }
        } else {
            this.add(this.getJ3DErrorPlaceholderContent());
        }
    }

    private JTextArea getJ3DErrorPlaceholderContent() {
        JTextArea area = new JTextArea(20, 20);
        area.setEditable(false);
        area.setMargin(new Insets(0, 10, 0, 0));
        area.setText("No 3D viewer is available. To view the results of this analysis, please install Java3D, available at java.sun.com. \nUse the File -> Save Analysis As option to save your results. \nAfter installing Java3D, restart MeV and load the saved analysis file to view these results in an interactive form. \n");
        area.setCaretPosition(0);
        return area;
    }

    public void setExperiment(Experiment e) {
        this.experiment = e;
    }

    public JComponent getContentComponent() {
        return this;
    }

    public JComponent getHeaderComponent() {
        return null;
    }

    public void onSelected(IFramework framework) {
        if (enabled3D) {
            this.framework = framework;
            if (this.tipWindow == null) {
                this.tipWindow = new JWindow(framework.getFrame());
            }
            this.universe.addBranchGraph(this.sceneGroup);
            this.data = framework.getData();
            this.onDataChanged(this.data);
            this.onMenuChanged(framework.getDisplayMenu());
        }
    }

    public void onDataChanged(IData data) {
        this.data = data;
        if (this.isGenes) {
            this.genesShape.updateColors(this.data.getColorIndices(), this.data.getColors());
        } else {
            this.genesShape.updateColors(this.data.getExperimentColorIndices(), this.data.getExperimentColors());
        }
    }

    public void onMenuChanged(IDisplayMenu menu) {
        if (this.labelIndex == menu.getLabelIndex()) {
            return;
        }
        this.labelIndex = menu.getLabelIndex();
        this.updateLabelsGroup();
    }

    public void onDeselected() {
        if (enabled3D) {
            this.sceneGroup.detach();
        }
    }

    public void onClosed() {
    }

    public BufferedImage getImage() {
        ImageComponent2D buffer = new ImageComponent2D(1, new BufferedImage(this.onScreenCanvas.getWidth(), this.onScreenCanvas.getHeight(), 5));
        this.offScreenCanvas.setOffScreenLocation(this.onScreenCanvas.getLocationOnScreen());
        this.offScreenCanvas.setOffScreenBuffer(buffer);
        this.offScreenCanvas.renderOffScreenBuffer();
        this.offScreenCanvas.waitForOffScreenRendering();
        BufferedImage offImage = this.offScreenCanvas.getOffScreenBuffer().getImage();
        BufferedImage image = new BufferedImage(offImage.getWidth(), offImage.getHeight(), 5);
        image.setData(offImage.getData());
        return image;
    }

    private void setInitialViewPoint(TransformGroup tg, Point3d basis) {
        Transform3D t3d = new Transform3D();
        t3d.lookAt(new Point3d(1.42, 1.0, 1.42), basis, new Vector3d(0.0, 1.0, 0.0));
        t3d.invert();
        tg.setTransform(t3d);
    }

    private BranchGroup createSceneGraph(Node[] nodes, BoundingLeaf boundingLeaf) {
        BranchGroup objRoot = new BranchGroup();
        objRoot.setCapability(17);
        objRoot.setCapability(14);
        objRoot.setCapability(13);
        Background bg = new Background(this.BLACK_COLOR);
        bg.setApplicationBoundingLeaf(boundingLeaf);
        objRoot.addChild((Node)bg);
        objRoot.addChild((Node)this.createAmbientLight(boundingLeaf));
        objRoot.addChild((Node)this.createPointLight(new Point3f(1.5f, 0.5f, 0.5f), boundingLeaf));
        objRoot.addChild((Node)this.createPointLight(new Point3f(0.5f, 0.5f, 1.5f), boundingLeaf));
        for (int i = 0; i < nodes.length; ++i) {
            objRoot.addChild(nodes[i]);
        }
        return objRoot;
    }

    private TransformGroup createLight(Bounds bounds, Vector3d vector) {
        Transform3D t = new Transform3D();
        t.set(vector);
        TransformGroup lightGroup = new TransformGroup(t);
        lightGroup.setCapability(18);
        lightGroup.setCapability(17);
        lightGroup.setCapability(1);
        ColoringAttributes attr = new ColoringAttributes();
        Color3f color = new Color3f(1.0f, 1.0f, 1.0f);
        attr.setColor(color);
        Appearance appearance = new Appearance();
        appearance.setColoringAttributes(attr);
        lightGroup.addChild((Node)new Sphere(0.01f, 1, 15, appearance));
        PointLight light = new PointLight(color, new Point3f(0.0f, 0.0f, 0.0f), new Point3f(1.0f, 0.0f, 0.0f));
        light.setInfluencingBounds(bounds);
        lightGroup.addChild((Node)light);
        return lightGroup;
    }

    private Billboard createLabelBillboard(TransformGroup label_tg) {
        label_tg.setCapability(18);
        TerrainBillboard billboard = new TerrainBillboard(label_tg, 1, BILLBOARD_P3F, this.view_tg);
        billboard.setSchedulingBounds((Bounds)BILLBOARD_BOUNDS);
        return billboard;
    }

    private BranchGroup createLabelsGroup(int labelIndex, float[][] locations, Point2f start, Point2f end) {
        PolygonAttributes pa = new PolygonAttributes();
        pa.setCullFace(0);
        BranchGroup labels = new BranchGroup();
        labels.setCapability(17);
        if (this.isGenes && labelIndex < 0) {
            return labels;
        }
        Transform3D transform = new Transform3D();
        Vector3f vector3f = new Vector3f();
        float scale = Math.max(Math.abs(start.x - end.x), Math.abs(start.y - end.y));
        for (int i = 0; i < locations.length; ++i) {
            float x = locations[i][0];
            float y = locations[i][1];
            if (!(x >= start.x) || !(x <= start.x + scale) || !(y >= start.y) || !(y <= start.y + scale)) continue;
            vector3f.set((x - start.x) / scale + 0.008f, -0.008f, (y - start.y) / scale);
            transform.set(vector3f);
            TransformGroup position_tg = new TransformGroup(transform);
            TransformGroup label_tg = new TransformGroup();
            String label = this.isGenes ? this.data.getElementAttribute(i, labelIndex) : this.data.getSampleName(i);
            label_tg.addChild((Node)this.createText2D(label, this.WHITE_COLOR, pa));
            position_tg.addChild((Node)label_tg);
            labels.addChild((Node)position_tg);
            if (!this.isBillboard) continue;
            Billboard billboard = this.createLabelBillboard(label_tg);
            labels.addChild((Node)billboard);
        }
        labels.compile();
        return labels;
    }

    private BranchGroup createViewBehavior(TransformGroup tg, Point3d basis, BoundingLeaf boundingLeaf) {
        BranchGroup behRoot = new BranchGroup();
        behRoot.setCapability(17);
        behRoot.addChild((Node)this.createKeyMotionBehavior(tg, basis, boundingLeaf));
        return behRoot;
    }

    private KeyMotionBehavior createKeyMotionBehavior(TransformGroup tg, Point3d basis, BoundingLeaf boundingLeaf) {
        KeyMotionBehavior key = new KeyMotionBehavior(tg);
        key.setSchedulingBoundingLeaf(boundingLeaf);
        key.setBasis(basis);
        return key;
    }

    private AmbientLight createAmbientLight(BoundingLeaf boundingLeaf) {
        AmbientLight light = new AmbientLight();
        light.setInfluencingBoundingLeaf(boundingLeaf);
        return light;
    }

    private Light createDirectionLight(BoundingLeaf boundingLeaf) {
        DirectionalLight light = new DirectionalLight(this.WHITE_COLOR, new Vector3f(-1.0f, 0.0f, -1.0f));
        light.setInfluencingBoundingLeaf(boundingLeaf);
        return light;
    }

    private PointLight createPointLight(Point3f position, BoundingLeaf boundingLeaf) {
        PointLight light = new PointLight(this.WHITE_COLOR, position, new Point3f(1.0f, 0.0f, 0.0f));
        light.setInfluencingBoundingLeaf(boundingLeaf);
        return light;
    }

    private Node createTransformGroup(Transform3D transform, Node node) {
        TransformGroup tg = new TransformGroup(transform);
        tg.addChild(node);
        return tg;
    }

    private Text2D createText2D(String text, Color3f color, PolygonAttributes pa) {
        Text2D text2D = new Text2D("", color, "Arial", 12, 1);
        text2D.setRectangleScaleFactor(0.001f);
        text2D.setString(text);
        text2D.getAppearance().setPolygonAttributes(pa);
        text2D.setCapability(12);
        text2D.getGeometry().setCapability(18);
        text2D.getGeometry().setCapability(8);
        text2D.getGeometry().setCapability(17);
        text2D.getGeometry().setCapability(0);
        return text2D;
    }

    private JPopupMenu createJPopupMenu(Listener listener) {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem menuItem = new JCheckBoxMenuItem("Control Panel");
        menuItem.setSelected(true);
        menuItem.setActionCommand(SHOW_CONTROLS_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Grid...");
        menuItem.setActionCommand(GRID_SIZE_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JCheckBoxMenuItem("Fill Polygon");
        menuItem.setSelected(true);
        menuItem.setActionCommand(FILL_POLYGON_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        JMenu shape_menu = new JMenu("Element Shape");
        ButtonGroup buttonGroup = new ButtonGroup();
        menuItem = new JRadioButtonMenuItem("Point");
        menuItem.setSelected(true);
        menuItem.setActionCommand(POINTS_SHAPE_CMD);
        menuItem.addActionListener(listener);
        buttonGroup.add(menuItem);
        shape_menu.add(menuItem);
        menuItem = new JRadioButtonMenuItem("Cube");
        menuItem.setActionCommand(CUBES_SHAPE_CMD);
        menuItem.addActionListener(listener);
        buttonGroup.add(menuItem);
        shape_menu.add(menuItem);
        menuItem = new JRadioButtonMenuItem("Sphere");
        menuItem.setActionCommand(SPHERES_SHAPE_CMD);
        menuItem.addActionListener(listener);
        buttonGroup.add(menuItem);
        shape_menu.add(menuItem);
        menu.add(shape_menu);
        JMenu labels_menu = new JMenu("Labels");
        menuItem = new JCheckBoxMenuItem("Hide");
        menuItem.setSelected(true);
        menuItem.setActionCommand(HIDE_LABELS_CMD);
        menuItem.addActionListener(listener);
        labels_menu.add(menuItem);
        menuItem = new JCheckBoxMenuItem("Billboard");
        menuItem.setSelected(false);
        menuItem.setActionCommand(USE_BILLBOARD_CMD);
        menuItem.addActionListener(listener);
        labels_menu.add(menuItem);
        menu.add(labels_menu);
        menu.addSeparator();
        JMenu zoom_menu = new JMenu("Zoom");
        menuItem = new JMenuItem("In");
        menuItem.setActionCommand(ZOOM_IN_CMD);
        menuItem.addActionListener(listener);
        zoom_menu.add(menuItem);
        menuItem = new JMenuItem("Undo");
        menuItem.setActionCommand(UNDO_CMD);
        menuItem.addActionListener(listener);
        zoom_menu.add(menuItem);
        menuItem = new JMenuItem("Show All");
        menuItem.setActionCommand(SHOW_ALL_CMD);
        menuItem.addActionListener(listener);
        zoom_menu.add(menuItem);
        menu.add(zoom_menu);
        menu.addSeparator();
        JMenu links_menu = new JMenu("Links");
        menuItem = new JCheckBoxMenuItem("Show");
        menuItem.setSelected(false);
        menuItem.setActionCommand(SHOW_LINKS_CMD);
        menuItem.addActionListener(listener);
        links_menu.add(menuItem);
        menuItem = new JMenuItem("Threshold...");
        menuItem.setActionCommand(LINKS_THRESHOLD_CMD);
        menuItem.addActionListener(listener);
        links_menu.add(menuItem);
        menuItem = new JMenuItem("Thickness...");
        menuItem.setActionCommand(LINKS_WIDTH_CMD);
        menuItem.addActionListener(listener);
        links_menu.add(menuItem);
        menu.add(links_menu);
        menu.addSeparator();
        menuItem = new JMenuItem("Store cluster");
        menuItem.setActionCommand(SET_CLUSTER_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Launch New Session");
        menuItem.setActionCommand(LAUNCH_SESSION_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Deselect");
        menuItem.setActionCommand(DESELECT_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Show Elements");
        menuItem.setActionCommand(SHOW_ELEMENTS_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Drift...");
        menuItem.setActionCommand(DRIFT_DIALOG_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        return menu;
    }

    private JMenuItem getJMenuItem(JPopupMenu menu, String command) {
        Component[] components = menu.getComponents();
        for (int i = 0; i < components.length; ++i) {
            JMenuItem item;
            if (components[i] instanceof JMenu && (item = this.getJMenuItem(((JMenu)components[i]).getPopupMenu(), command)) != null) {
                return item;
            }
            if (!(components[i] instanceof JMenuItem) || !((JMenuItem)components[i]).getActionCommand().equals(command)) continue;
            return (JMenuItem)components[i];
        }
        return null;
    }

    private void setEnableMenuItem(String command, boolean enable) {
        JMenuItem item = this.getJMenuItem(this.popup, command);
        if (item == null) {
            return;
        }
        item.setEnabled(enable);
    }

    private void onPicked(MouseEvent event, PickCanvas canvas) {
        canvas.setShapeLocation(event);
        PickResult pickResult = canvas.pickClosest();
        if (pickResult != null && pickResult.getObject() == this.genesShape) {
            PickIntersection pi = pickResult.getClosestIntersection(canvas.getStartPosition());
            int[] indices = pi.getPrimitiveVertexIndices();
            final int index = this.genesShape.getShapeIndex(indices[0]);
            if (index < 0) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TerrainViewer.this.onPicked(index);
                }
            });
        }
    }

    private void onPicked(int shapeIndex) {
        if (this.isGenes) {
            this.framework.displaySlideElementInfo(0, shapeIndex);
        }
    }

    private void onCtrlPicked(MouseEvent event, PickCanvas canvas) {
        canvas.setShapeLocation(event);
        PickResult pickResult = canvas.pickClosest();
        if (pickResult != null) {
            if (pickResult.getObject() == this.genesShape) {
                PickIntersection pi = pickResult.getClosestIntersection(canvas.getStartPosition());
                int[] indices = pi.getPrimitiveVertexIndices();
                int index = this.genesShape.getShapeIndex(indices[0]);
                if (index < 0) {
                    return;
                }
                float scale = Math.max(Math.abs(this.up_left_point.x - this.bottom_right_point.x), Math.abs(this.up_left_point.y - this.bottom_right_point.y));
                float x = (this.locations[index][0] - this.up_left_point.x) / scale;
                float y = (this.locations[index][1] - this.up_left_point.y) / scale;
                this.driftInterpolator.drift(new Point3d((double)x, 0.0, (double)y), new Vector3f(0.0f, 0.0f, 1.0f));
            } else if (pickResult.getObject() == this.landscape) {
                PickIntersection pi = pickResult.getClosestIntersection(canvas.getStartPosition());
                Point3d point = pi.getPointCoordinates();
                point.y += this.controlPanel.getSliderValue();
                Vector3f normal = pi.getPointNormal();
                this.driftInterpolator.drift(point, normal);
            }
        }
    }

    private void onSetCluster() {
        float scale = Math.max(Math.abs(this.up_left_point.x - this.bottom_right_point.x), Math.abs(this.up_left_point.y - this.bottom_right_point.y));
        Point2f start = this.selectionShape.getStartCoords();
        Point2f end = this.selectionShape.getEndCoords();
        start.scale(scale);
        end.scale(scale);
        start.add((Tuple2f)this.up_left_point);
        end.add((Tuple2f)this.up_left_point);
        IntArray ids = new IntArray();
        for (int i = 0; i < this.locations.length; ++i) {
            float x = this.locations[i][0];
            float y = this.locations[i][1];
            if (!(x > start.x) || !(x < end.x) || !(y > start.y) || !(y < end.y)) continue;
            ids.add(i);
        }
        if (this.isGenes) {
            this.framework.storeSubCluster(ids.toArray(), this.experiment, 0);
            this.genesShape.updateColors(this.data.getColorIndices(), this.data.getColors());
        } else {
            this.framework.storeSubCluster(ids.toArray(), this.experiment, 1);
            this.genesShape.updateColors(this.data.getExperimentColorIndices(), this.data.getExperimentColors());
        }
        this.selectionShape.clearSelection();
    }

    private void onLaunchNewSession() {
        float scale = Math.max(Math.abs(this.up_left_point.x - this.bottom_right_point.x), Math.abs(this.up_left_point.y - this.bottom_right_point.y));
        Point2f start = this.selectionShape.getStartCoords();
        Point2f end = this.selectionShape.getEndCoords();
        start.scale(scale);
        end.scale(scale);
        start.add((Tuple2f)this.up_left_point);
        end.add((Tuple2f)this.up_left_point);
        IntArray ids = new IntArray();
        for (int i = 0; i < this.locations.length; ++i) {
            float x = this.locations[i][0];
            float y = this.locations[i][1];
            if (!(x > start.x) || !(x < end.x) || !(y > start.y) || !(y < end.y)) continue;
            ids.add(i);
        }
        if (this.isGenes) {
            this.framework.launchNewMAV(ids.toArray(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 0);
        } else {
            this.framework.launchNewMAV(ids.toArray(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 1);
        }
        this.selectionShape.clearSelection();
    }

    private int[] getIDataRowIndices(int[] expIndices) {
        int[] dataIndices = new int[expIndices.length];
        for (int i = 0; i < expIndices.length; ++i) {
            dataIndices[i] = this.experiment.getGeneIndexMappedToData(i);
        }
        return dataIndices;
    }

    private void onFillPolygon() {
        JMenuItem item = this.getJMenuItem(this.popup, FILL_POLYGON_CMD);
        if (item.isSelected()) {
            this.landscape.setPoligonMode(2);
        } else {
            this.landscape.setPoligonMode(1);
        }
    }

    private void onShowControls() {
        JMenuItem item = this.getJMenuItem(this.popup, SHOW_CONTROLS_CMD);
        if (item.isSelected()) {
            this.controlPanel.setVisible(true);
        } else {
            this.controlPanel.setVisible(false);
        }
    }

    private Point3d getIntersectionPoint(MouseEvent event, PickCanvas canvas) {
        float tolerance = canvas.getTolerance();
        canvas.setTolerance(2.0f);
        Point3d o3d = new Point3d();
        Vector3d d3d = new Vector3d();
        canvas.setShapeLocation(event);
        PickCone ps = (PickCone)canvas.getPickShape();
        canvas.setTolerance(tolerance);
        ps.getOrigin(o3d);
        ps.getDirection(d3d);
        double x0 = o3d.x - o3d.y * d3d.x / d3d.y;
        double z0 = o3d.z - o3d.y * d3d.z / d3d.y;
        if (o3d.y < 0.0 || x0 < 0.0 || z0 < 0.0 || x0 > 1.0 || z0 > 1.0) {
            return null;
        }
        return new Point3d(x0, 0.0, z0);
    }

    private void onStartSelection(MouseEvent event, PickCanvas canvas) {
        this.selectionShape.startSelection(this.getIntersectionPoint(event, canvas));
    }

    private void onDragSelection(MouseEvent event, PickCanvas canvas) {
        this.selectionShape.dragSelection(this.getIntersectionPoint(event, canvas));
    }

    private void onReleaseSelection() {
    }

    private void onDeselect() {
        this.selectionShape.clearSelection();
    }

    private void onShowAll() {
        this.doZoom(new Point2f(0.0f, 0.0f), new Point2f(1.0f, 1.0f));
    }

    private void onZoom() {
        this.undoManager.addEdit(new ZoomUndoable(this.up_left_point, this.bottom_right_point));
        Point2f start = this.selectionShape.getStartCoords();
        Point2f end = this.selectionShape.getEndCoords();
        float minSide = Math.min(end.x - start.x, end.y - start.y);
        end.set(start.x + minSide, start.y + minSide);
        float scale = Math.max(Math.abs(this.up_left_point.x - this.bottom_right_point.x), Math.abs(this.up_left_point.y - this.bottom_right_point.y));
        start.scale(scale);
        end.scale(scale);
        start.add((Tuple2f)this.up_left_point);
        end.add((Tuple2f)this.up_left_point);
        this.doZoom(start, end);
    }

    private void doZoom(Point2f start, Point2f end) {
        this.up_left_point.set((Tuple2f)start);
        this.bottom_right_point.set((Tuple2f)end);
        float scale = Math.max(Math.abs(this.up_left_point.x - this.bottom_right_point.x), Math.abs(this.up_left_point.y - this.bottom_right_point.y));
        float[][] heights = DomainUtil.getHeights(this.locations, this.grid_size, this.sigma * scale, this.up_left_point, this.bottom_right_point);
        this.landscape.setHeights(heights);
        this.genesShape.setZoom(this.up_left_point, this.bottom_right_point);
        this.linksShape.setZoom(this.up_left_point, this.bottom_right_point);
        this.selectionShape.clearSelection();
        this.updateLabelsGroup();
    }

    private void onUndo() {
        this.undoManager.undo();
    }

    private void onPointsShape() {
        this.pickBehavior.setTolerance(1.0f);
        this.genesShape.setType(0);
    }

    private void onSpheresShape() {
        this.pickBehavior.setTolerance(0.0f);
        this.genesShape.setType(2);
    }

    private void onCubesShape() {
        this.pickBehavior.setTolerance(0.0f);
        this.genesShape.setType(1);
    }

    private void onGridSize() {
        String value = (String)JOptionPane.showInputDialog(this, "Enter in a number of the grid cells per side.", "Input", 2, null, null, String.valueOf(this.grid_size - 1));
        if (value == null || value.equals("")) {
            return;
        }
        try {
            int size = Integer.parseInt(value);
            if (size <= 2 || size >= 500) {
                throw new NumberFormatException("value must be more than 2 and less than 500.");
            }
            this.grid_size = size + 1;
            float scale = Math.max(Math.abs(this.up_left_point.x - this.bottom_right_point.x), Math.abs(this.up_left_point.y - this.bottom_right_point.y));
            float[][] heights = DomainUtil.getHeights(this.locations, this.grid_size, this.sigma * scale, this.up_left_point, this.bottom_right_point);
            this.landscape.setHeights(heights);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "Illegal number: " + e.getMessage(), "Error", 0);
        }
    }

    private void onDriftDialog() {
        String value = (String)JOptionPane.showInputDialog(this, "Enter in a minimal distance.", "Input", 2, null, null, String.valueOf(this.driftInterpolator.getMinDistance()));
        if (value == null || value.equals("")) {
            return;
        }
        try {
            float distance = Float.parseFloat(value);
            if (distance <= 0.0f || distance >= 1.0f) {
                throw new NumberFormatException("value must be more than 0 and less than 1.");
            }
            this.driftInterpolator.setMinDistance(distance);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "Illegal number: " + e.getMessage(), "Error", 0);
        }
    }

    private void onShowLinks() {
        JMenuItem item = this.getJMenuItem(this.popup, SHOW_LINKS_CMD);
        if (item.isSelected()) {
            this.linksShape.setVisible(true);
        } else {
            this.linksShape.setVisible(false);
        }
    }

    private void onLinksThreshold() {
        String value = (String)JOptionPane.showInputDialog(this, "Enter in links threshold (between 0 and 1).", "Input", 2, null, null, String.valueOf(this.linksShape.getThreshold()));
        if (value == null || value.equals("")) {
            return;
        }
        try {
            float threshold = Float.parseFloat(value);
            if (threshold < 0.0f || threshold > 1.0f) {
                throw new NumberFormatException("value must be between 0 and 1.");
            }
            this.linksShape.setThreshold(threshold);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "Illegal number: " + e.getMessage(), "Error", 0);
        }
    }

    private void onLinksWidth() {
        String value = (String)JOptionPane.showInputDialog(this, "Enter in links thickness (between 1 and 10).", "Input", 2, null, null, String.valueOf(this.linksShape.getLinksWidth()));
        if (value == null || value.equals("")) {
            return;
        }
        try {
            float thickness = Float.parseFloat(value);
            if (thickness < 1.0f || thickness > 10.0f) {
                throw new NumberFormatException("value must be between 1 and 10.");
            }
            this.linksShape.setLinksWidth(thickness);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "Illegal number: " + e.getMessage(), "Error", 0);
        }
    }

    private void onHideLabels() {
        JMenuItem item = this.getJMenuItem(this.popup, HIDE_LABELS_CMD);
        if (!item.isSelected()) {
            this.labelsGroup = this.createLabelsGroup(this.labelIndex, this.locations, this.up_left_point, this.bottom_right_point);
            this.sceneGroup.addChild((Node)this.labelsGroup);
        } else {
            this.labelsGroup.detach();
            this.labelsGroup = null;
        }
    }

    private void onUseBillboard() {
        JMenuItem hide_item;
        JMenuItem bill_item = this.getJMenuItem(this.popup, USE_BILLBOARD_CMD);
        this.isBillboard = bill_item.isSelected();
        if (this.labelsGroup != null) {
            this.labelsGroup.detach();
        }
        if (!(hide_item = this.getJMenuItem(this.popup, HIDE_LABELS_CMD)).isSelected()) {
            this.labelsGroup = this.createLabelsGroup(this.labelIndex, this.locations, this.up_left_point, this.bottom_right_point);
            this.sceneGroup.addChild((Node)this.labelsGroup);
        }
    }

    private void onShowElements() {
        float scale = Math.max(Math.abs(this.up_left_point.x - this.bottom_right_point.x), Math.abs(this.up_left_point.y - this.bottom_right_point.y));
        Point2f start = this.selectionShape.getStartCoords();
        Point2f end = this.selectionShape.getEndCoords();
        start.scale(scale);
        end.scale(scale);
        start.add((Tuple2f)this.up_left_point);
        end.add((Tuple2f)this.up_left_point);
        ArrayList<String> info = new ArrayList<String>();
        for (int i = 0; i < this.locations.length; ++i) {
            float x = this.locations[i][0];
            float y = this.locations[i][1];
            if (!(x >= start.x) || !(x <= end.x) || !(y >= start.y) || !(y <= end.y)) continue;
            info.add(new String("Element[" + String.valueOf(i) + 1 + "]: " + (this.isGenes ? this.data.getElementAttribute(this.experiment.getGeneIndexMappedToData(i), this.labelIndex) : this.data.getSampleName(i))));
        }
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        String title = "Selected Elements";
        ListDialog list = new ListDialog(frame, title, info.toArray(new String[info.size()]));
        list.showModal();
    }

    private void updateLabelsGroup() {
        JMenuItem item;
        if (this.labelsGroup != null) {
            this.labelsGroup.detach();
            this.labelsGroup = null;
        }
        if (!(item = this.getJMenuItem(this.popup, HIDE_LABELS_CMD)).isSelected()) {
            this.labelsGroup = this.createLabelsGroup(this.labelIndex, this.locations, this.up_left_point, this.bottom_right_point);
            this.sceneGroup.addChild((Node)this.labelsGroup);
        }
    }

    private void showElementTip(int x, int y) {
        if (this.isGenes && this.labelIndex < 0) {
            return;
        }
        PickCanvas canvas = new PickCanvas(this.onScreenCanvas, this.sceneGroup);
        canvas.setTolerance(this.pickBehavior.getTolerance());
        canvas.setShapeLocation(x, y);
        PickResult[] pickResult = canvas.pickAllSorted();
        if (pickResult == null) {
            return;
        }
        for (int i = 0; i < pickResult.length; ++i) {
            if (pickResult[i].getObject() != this.genesShape) continue;
            PickIntersection pi = pickResult[i].getClosestIntersection(canvas.getStartPosition());
            if (pi == null) {
                return;
            }
            int[] indices = pi.getPrimitiveVertexIndices();
            int index = this.genesShape.getShapeIndex(indices[0]);
            if (index < 0) {
                return;
            }
            String text = this.isGenes ? this.data.getElementAttribute(index, this.labelIndex) : this.data.getSampleName(index);
            JToolTip tooltip = new JToolTip();
            tooltip.setTipText(text);
            Dimension size = tooltip.getPreferredSize();
            Point screenLocation = this.onScreenCanvas.getLocationOnScreen();
            this.tipWindow.getContentPane().add((Component)tooltip, "Center");
            this.tipWindow.setLocation(screenLocation.x + x, screenLocation.y + y + 20);
            this.tipWindow.pack();
            this.tipWindow.setVisible(true);
            return;
        }
    }

    private void hideElementTip() {
        this.tipWindow.getContentPane().removeAll();
        this.tipWindow.setVisible(false);
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    public int[][] getClusters() {
        return this.clusters;
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    public int getViewerType() {
        return -1;
    }

    public int getExperimentID() {
        return this.exptID;
    }

    public void setExperimentID(int id) {
        this.exptID = id;
    }

    static {
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        enabled3D = true;
    }

    private class ZoomUndoable
    extends AbstractUndoableEdit {
        private Point2f start;
        private Point2f end;

        public ZoomUndoable(Point2f start, Point2f end) {
            this.start = new Point2f(start);
            this.end = new Point2f(end);
        }

        @Override
        public void undo() throws CannotUndoException {
            TerrainViewer.this.doZoom(this.start, this.end);
        }

        @Override
        public void redo() throws CannotRedoException {
        }

        @Override
        public String getPresentationName() {
            return "Zoom";
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener,
    MouseMotionListener,
    KeyListener,
    PickListener {
        private Timer timer = new Timer(1000, this);
        private int x = 0;
        private int y = 0;

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.timer) {
                this.onTimerEvent();
                return;
            }
            String command = event.getActionCommand();
            if (command.equals(TerrainViewer.SET_CLUSTER_CMD)) {
                TerrainViewer.this.onSetCluster();
            } else if (command.equals(TerrainViewer.SHOW_ELEMENTS_CMD)) {
                TerrainViewer.this.onShowElements();
            } else if (command.equals(TerrainViewer.FILL_POLYGON_CMD)) {
                TerrainViewer.this.onFillPolygon();
            } else if (command.equals(TerrainViewer.SHOW_CONTROLS_CMD)) {
                TerrainViewer.this.onShowControls();
            } else if (command.equals(TerrainViewer.ZOOM_IN_CMD)) {
                TerrainViewer.this.onZoom();
            } else if (command.equals(TerrainViewer.UNDO_CMD)) {
                TerrainViewer.this.onUndo();
            } else if (command.equals(TerrainViewer.DESELECT_CMD)) {
                TerrainViewer.this.onDeselect();
            } else if (command.equals(TerrainViewer.SHOW_ALL_CMD)) {
                TerrainViewer.this.onShowAll();
            } else if (command.equals(TerrainViewer.POINTS_SHAPE_CMD)) {
                TerrainViewer.this.onPointsShape();
            } else if (command.equals(TerrainViewer.SPHERES_SHAPE_CMD)) {
                TerrainViewer.this.onSpheresShape();
            } else if (command.equals(TerrainViewer.CUBES_SHAPE_CMD)) {
                TerrainViewer.this.onCubesShape();
            } else if (command.equals(TerrainViewer.GRID_SIZE_CMD)) {
                TerrainViewer.this.onGridSize();
            } else if (command.equals(TerrainViewer.DRIFT_DIALOG_CMD)) {
                TerrainViewer.this.onDriftDialog();
            } else if (command.equals(TerrainViewer.SHOW_LINKS_CMD)) {
                TerrainViewer.this.onShowLinks();
            } else if (command.equals(TerrainViewer.HIDE_LABELS_CMD)) {
                TerrainViewer.this.onHideLabels();
            } else if (command.equals(TerrainViewer.USE_BILLBOARD_CMD)) {
                TerrainViewer.this.onUseBillboard();
            } else if (command.equals(TerrainViewer.LINKS_THRESHOLD_CMD)) {
                TerrainViewer.this.onLinksThreshold();
            } else if (command.equals(TerrainViewer.LINKS_WIDTH_CMD)) {
                TerrainViewer.this.onLinksWidth();
            } else if (command.equals(TerrainViewer.LAUNCH_SESSION_CMD)) {
                TerrainViewer.this.onLaunchNewSession();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                TerrainViewer.this.setEnableMenuItem(TerrainViewer.ZOOM_IN_CMD, TerrainViewer.this.selectionShape.hasSelection());
                TerrainViewer.this.setEnableMenuItem(TerrainViewer.DESELECT_CMD, TerrainViewer.this.selectionShape.hasSelection());
                TerrainViewer.this.setEnableMenuItem(TerrainViewer.SET_CLUSTER_CMD, TerrainViewer.this.selectionShape.hasSelection());
                TerrainViewer.this.setEnableMenuItem(TerrainViewer.SHOW_ELEMENTS_CMD, TerrainViewer.this.selectionShape.hasSelection());
                TerrainViewer.this.setEnableMenuItem(TerrainViewer.UNDO_CMD, TerrainViewer.this.undoManager.canUndo());
                TerrainViewer.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void onMousePressed(MouseEvent event, PickCanvas canvas) {
            TerrainViewer.this.hideElementTip();
            if (event.isMetaDown() || event.isAltDown()) {
                return;
            }
            if (event.isShiftDown()) {
                TerrainViewer.this.onStartSelection(event, canvas);
            } else if (event.isControlDown()) {
                TerrainViewer.this.onCtrlPicked(event, canvas);
            } else {
                TerrainViewer.this.onPicked(event, canvas);
            }
        }

        @Override
        public void onMouseDragged(MouseEvent event, PickCanvas canvas) {
            if (event.isShiftDown()) {
                TerrainViewer.this.onDragSelection(event, canvas);
            }
        }

        @Override
        public void onMouseReleased(MouseEvent event, PickCanvas canvas) {
            TerrainViewer.this.onReleaseSelection();
        }

        private PickResult[] getPickSortedResult(MouseEvent event, PickCanvas canvas) {
            canvas.setShapeLocation(event);
            return canvas.pickAllSorted();
        }

        private PickResult[] getPickAllResult(MouseEvent event, PickCanvas canvas) {
            canvas.setShapeLocation(event);
            return canvas.pickAll();
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            TerrainViewer.this.keyMotionBehavior.onKeyEvent(e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        public Listener() {
            this.timer.setRepeats(false);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.timer.start();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.timer.stop();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.x = e.getX();
            this.y = e.getY();
            TerrainViewer.this.hideElementTip();
            this.timer.restart();
        }

        private void onTimerEvent() {
            TerrainViewer.this.showElementTip(this.x, this.y);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }
    }
}

