/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.terrain;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class TerrainInitDialog
extends AlgorithmDialog {
    private int result;
    private JRadioButton genRadio;
    private JRadioButton expRadio;
    private JTextField neighboursField;

    public TerrainInitDialog(Frame parent) {
        super((JFrame)parent, "Terrain Initialization", true);
        Listener listener = new Listener();
        this.addWindowListener(listener);
        JPanel parameters = new JPanel(new GridBagLayout());
        parameters.setBorder(new EmptyBorder(20, 10, 20, 10));
        parameters.setBackground(Color.white);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        this.genRadio = new JRadioButton("Genes");
        this.genRadio.setFocusPainted(false);
        this.genRadio.setBackground(Color.white);
        this.genRadio.setForeground(UIManager.getColor("Label.foreground"));
        gbc.gridx = 0;
        gbc.gridy = 0;
        parameters.add((Component)this.genRadio, gbc);
        this.expRadio = new JRadioButton("Samples");
        this.expRadio.setForeground(UIManager.getColor("Label.foreground"));
        this.expRadio.setFocusPainted(false);
        this.expRadio.setBackground(Color.white);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets.left = 25;
        parameters.add((Component)this.expRadio, gbc);
        gbc.insets.left = 0;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets.top = 20;
        parameters.add((Component)new JLabel("Neighbors:"), gbc);
        gbc.gridx = 1;
        gbc.insets.left = 25;
        this.neighboursField = new JTextField(String.valueOf(20), 5);
        parameters.add((Component)this.neighboursField, gbc);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.genRadio);
        bg.add(this.expRadio);
        this.genRadio.setSelected(true);
        JPanel panel3 = new JPanel(new BorderLayout());
        panel3.setForeground(Color.white);
        panel3.setBorder(BorderFactory.createLineBorder(Color.gray));
        panel3.setBackground(Color.white);
        panel3.add((Component)parameters, "West");
        panel3.add((Component)new JLabel(GUIFactory.getIcon("dialog_button_bar.gif")), "East");
        this.setActionListeners(listener);
        this.addContent(panel3);
        this.pack();
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public boolean isGenes() {
        return this.genRadio.isSelected();
    }

    public int getNeighbours() {
        return Integer.parseInt(this.neighboursField.getText());
    }

    public static void main(String[] args) {
        TerrainInitDialog dlg = new TerrainInitDialog(new JFrame());
        if (dlg.showModal() == 0) {
            System.out.println("ok");
        }
        System.exit(0);
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("ok-command")) {
                try {
                    int value = Integer.parseInt(TerrainInitDialog.this.neighboursField.getText());
                    if (value < 1) {
                        throw new NumberFormatException("value must be more than 0.");
                    }
                    TerrainInitDialog.this.result = 0;
                    TerrainInitDialog.this.dispose();
                }
                catch (NumberFormatException nfe) {
                    JOptionPane.showMessageDialog(TerrainInitDialog.this, "Error number: " + nfe.getMessage(), "Input Error!", 0);
                }
            } else if (command.equals("cancel-command")) {
                TerrainInitDialog.this.result = 2;
                TerrainInitDialog.this.dispose();
            } else {
                if (command.equals("reset-command")) {
                    TerrainInitDialog.this.genRadio.setSelected(true);
                    TerrainInitDialog.this.neighboursField.setText("20");
                    TerrainInitDialog.this.result = 2;
                    return;
                }
                if (command.equals("info-command")) {
                    HelpWindow.launchBrowser(TerrainInitDialog.this, "Terrain Map Initialization Dialog");
                }
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            TerrainInitDialog.this.result = -1;
            TerrainInitDialog.this.dispose();
        }
    }
}

