/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.terrain;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.terrain.TerrainInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.terrain.TerrainViewer;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.util.FloatMatrix;

public class TerrainGUI
implements IClusterGUI,
IScriptGUI {
    private Algorithm algorithm;
    private Progress progress;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework framework) throws AlgorithmException {
        TerrainInitDialog dialog = new TerrainInitDialog(framework.getFrame());
        if (dialog.showModal() != 0) {
            return null;
        }
        boolean use_genes = dialog.isGenes();
        int neighbours = dialog.getNeighbours();
        AlgorithmData data = new AlgorithmData();
        FloatMatrix experiment = framework.getData().getExperiment().getMatrix();
        data.addMatrix("experiment", experiment);
        data.addParam("distance-factor", String.valueOf(1.0f));
        data.addParam("distance-absolute", String.valueOf(framework.getDistanceMenu().isAbsoluteDistance()));
        int function = framework.getDistanceMenu().getDistanceFunction();
        function = function == 0 ? 7 : function;
        data.addParam("distance-function", String.valueOf(function));
        data.addParam("neighbors", String.valueOf(neighbours));
        data.addParam("use-genes", String.valueOf(use_genes));
        GeneralInfo gi = new GeneralInfo();
        gi.function = framework.getDistanceMenu().getFunctionName(function);
        gi.absolute = framework.getDistanceMenu().isAbsoluteDistance();
        gi.neighbours = neighbours;
        gi.isGenes = use_genes;
        Listener listener = new Listener();
        this.progress = new Progress(framework.getFrame(), "Calculating Terrain", listener);
        this.progress.show();
        try {
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("Terrain");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            long start = System.currentTimeMillis();
            AlgorithmData result = this.algorithm.execute(data);
            gi.time = System.currentTimeMillis() - start;
            this.progress.setDescription("Creating 3D View...");
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(result, gi, framework);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    public AlgorithmData getScriptParameters(IFramework framework) {
        TerrainInitDialog dialog = new TerrainInitDialog(framework.getFrame());
        if (dialog.showModal() != 0) {
            return null;
        }
        boolean use_genes = dialog.isGenes();
        int neighbours = dialog.getNeighbours();
        AlgorithmData data = new AlgorithmData();
        data.addParam("distance-factor", String.valueOf(1.0f));
        data.addParam("distance-absolute", String.valueOf(framework.getDistanceMenu().isAbsoluteDistance()));
        int function = framework.getDistanceMenu().getDistanceFunction();
        function = function == 0 ? 7 : function;
        data.addParam("distance-function", String.valueOf(function));
        data.addParam("neighbors", String.valueOf(neighbours));
        data.addParam("use-genes", String.valueOf(use_genes));
        data.addParam("name", "TRN");
        data.addParam("alg-type", "data-visualization");
        data.addParam("output-class", "single-output");
        String[] outputNodes = new String[]{"Data Visualization"};
        data.addStringArray("output-nodes", outputNodes);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode executeScript(IFramework framework, AlgorithmData algData, Experiment experiment) throws AlgorithmException {
        FloatMatrix matrix = framework.getData().getExperiment().getMatrix();
        algData.addMatrix("experiment", matrix);
        GeneralInfo gi = new GeneralInfo();
        AlgorithmParameters params = algData.getParams();
        gi.function = framework.getDistanceMenu().getFunctionName(params.getInt("distance-function"));
        gi.absolute = params.getBoolean("distance-absolute");
        gi.neighbours = params.getInt("neighbors");
        gi.isGenes = params.getBoolean("use-genes");
        Listener listener = new Listener();
        this.progress = new Progress(framework.getFrame(), "Calculating Terrain", listener);
        this.progress.show();
        try {
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("Terrain");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            long start = System.currentTimeMillis();
            AlgorithmData result = this.algorithm.execute(algData);
            gi.time = System.currentTimeMillis() - start;
            this.progress.setDescription("Creating 3D View...");
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(result, gi, framework);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    private DefaultMutableTreeNode createResultTree(AlgorithmData result, GeneralInfo gi, IFramework framework) throws AlgorithmException {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Terrain");
        this.addTerrainView(root, result, framework, gi);
        this.addGeneralInfo(root, gi);
        return root;
    }

    private void addTerrainView(DefaultMutableTreeNode root, AlgorithmData result, IFramework framework, GeneralInfo gi) throws AlgorithmException {
        FloatMatrix locations = result.getMatrix("locations");
        this.checkLocations(locations.A);
        Cluster cluster = result.getCluster("links");
        int[][] clusters = this.convert2int(cluster);
        float[][] weights = this.convert2float(cluster);
        AlgorithmParameters params = result.getParams();
        float sigma = params.getFloat("sigma");
        TerrainViewer viewer = new TerrainViewer(gi.isGenes, framework.getData().getExperiment(), clusters, weights, locations.A, sigma, framework.getDisplayMenu().getLabelIndex());
        root.add(new DefaultMutableTreeNode(new LeafInfo("Map", (IViewer)viewer)));
    }

    private void checkLocations(float[][] locations) throws AlgorithmException {
        if (locations == null) {
            throw new AlgorithmException("Locations is null.");
        }
        for (int i = 0; i < locations.length; ++i) {
            for (int j = 0; j < locations[i].length; ++j) {
                if (!Float.isNaN(locations[i][j])) continue;
                throw new AlgorithmException("Location[" + i + "][" + j + "] is NaN.");
            }
        }
    }

    private void addGeneralInfo(DefaultMutableTreeNode root, GeneralInfo gi) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("General Information");
        node.add(new DefaultMutableTreeNode("Time: " + String.valueOf(gi.time) + " ms"));
        node.add(new DefaultMutableTreeNode("Distance: " + gi.function));
        node.add(new DefaultMutableTreeNode("Absolute: " + gi.absolute));
        node.add(new DefaultMutableTreeNode("Neighbours: " + gi.neighbours));
        node.add(new DefaultMutableTreeNode("Data Type: " + (gi.isGenes ? "Genes" : "Samples")));
        root.add(node);
    }

    private int[][] convert2int(Cluster cluster) throws AlgorithmException {
        NodeList nodeList = cluster.getNodeList();
        int nodeListSize = nodeList.getSize();
        int[][] result = new int[nodeListSize][];
        for (int i = 0; i < nodeListSize; ++i) {
            result[i] = nodeList.getNode(i).getFeaturesIndexes();
            if (result[i] != null) continue;
            throw new AlgorithmException("Cluster " + i + " does not contain indices.");
        }
        return result;
    }

    private float[][] convert2float(Cluster cluster) throws AlgorithmException {
        NodeList nodeList = cluster.getNodeList();
        int nodeListSize = nodeList.getSize();
        float[][] result = new float[nodeListSize][];
        int i = 0;
        try {
            for (i = 0; i < nodeListSize; ++i) {
                result[i] = (float[])nodeList.getNode((int)i).getValues().getNodeValue((int)0).value;
                if (result[i] != null) continue;
                throw new Exception();
            }
        }
        catch (Exception e) {
            throw new AlgorithmException("Cluster " + i + " does not contain weights.");
        }
        return result;
    }

    private class GeneralInfo {
        public long time;
        public String function;
        public boolean absolute;
        public int neighbours;
        public boolean isGenes;

        private GeneralInfo() {
        }
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent event) {
            switch (event.getId()) {
                case 1: {
                    TerrainGUI.this.progress.setUnits(event.getIntValue());
                    TerrainGUI.this.progress.setDescription(event.getDescription());
                    break;
                }
                case 2: {
                    TerrainGUI.this.progress.setValue(event.getIntValue());
                    TerrainGUI.this.progress.setDescription(event.getDescription());
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("cancel-command")) {
                TerrainGUI.this.algorithm.abort();
                TerrainGUI.this.progress.dispose();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            TerrainGUI.this.algorithm.abort();
            TerrainGUI.this.progress.dispose();
        }
    }
}

