/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.terrain;

import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.vecmath.Vector3d;

public class SliderBehavior
extends Behavior
implements ChangeListener {
    private TransformGroup target;
    private WakeupCriterion criterion;
    private double scale = 0.01;
    private JSlider slider;

    public SliderBehavior(TransformGroup target) {
        this.target = target;
        this.slider = new JSlider();
        this.slider.addChangeListener(this);
    }

    public void setOrientation(int orientation) {
        this.slider.setOrientation(orientation);
    }

    public void setMinimum(int min) {
        this.slider.setMinimum(min);
    }

    public void setMaximum(int max) {
        this.slider.setMaximum(max);
    }

    public void setValue(int value) {
        this.slider.setValue(value);
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public JSlider getSlider() {
        return this.slider;
    }

    public void initialize() {
        this.criterion = new WakeupOnBehaviorPost((Behavior)this, 506);
        this.wakeupOn((WakeupCondition)this.criterion);
    }

    public void processStimulus(Enumeration enumeration) {
        double value = this.scale * (double)this.slider.getValue();
        Transform3D target_t3d = new Transform3D();
        this.target.getTransform(target_t3d);
        Vector3d target_v3d = new Vector3d();
        target_t3d.get(target_v3d);
        target_v3d.y = value - target_v3d.y;
        Transform3D t3d = new Transform3D();
        t3d.set(target_v3d);
        target_t3d.mul(t3d);
        this.target.setTransform(target_t3d);
        this.wakeupOn((WakeupCondition)this.criterion);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.postId(506);
    }
}

