/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.terrain;

import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Material;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Point2f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;

public class SelectionShape
extends Shape3D {
    private Point3d from = new Point3d();
    private Point3d to = new Point3d();
    private static final float[] normals = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f};

    public SelectionShape() {
        this.setCapability(12);
        this.setGeometry(this.createGeometry());
        this.setAppearance(this.createAppearance());
    }

    public void startSelection(Point3d from) {
        if (from == null) {
            return;
        }
        this.from = from;
    }

    public void dragSelection(Point3d to) {
        if (to == null) {
            return;
        }
        this.to = to;
        this.updateCoords((GeometryArray)this.getGeometry(), this.from, this.to);
    }

    public boolean hasSelection() {
        return !this.from.equals((Tuple3d)this.to);
    }

    public Point2f getStartCoords() {
        float x1 = (float)Math.min(this.from.x, this.to.x);
        float z1 = (float)Math.min(this.from.z, this.to.z);
        return new Point2f(x1, z1);
    }

    public Point2f getEndCoords() {
        float x2 = (float)Math.max(this.from.x, this.to.x);
        float z2 = (float)Math.max(this.from.z, this.to.z);
        return new Point2f(x2, z2);
    }

    public void clearSelection() {
        this.from.set(0.0, 0.0, 0.0);
        this.to.set(0.0, 0.0, 0.0);
        this.updateCoords((GeometryArray)this.getGeometry(), this.from, this.to);
    }

    protected Appearance createAppearance() {
        PolygonAttributes pa = new PolygonAttributes();
        pa.setCullFace(0);
        TransparencyAttributes ta = new TransparencyAttributes();
        ta.setTransparency(0.5f);
        ta.setTransparencyMode(2);
        Material material = new Material();
        material.setDiffuseColor(0.5f, 0.5f, 0.5f);
        Appearance appearance = new Appearance();
        appearance.setTransparencyAttributes(ta);
        appearance.setPolygonAttributes(pa);
        appearance.setMaterial(material);
        return appearance;
    }

    protected Geometry createGeometry() {
        QuadArray geometry = new QuadArray(24, 3);
        geometry.setCapability(1);
        geometry.setNormals(0, normals);
        geometry.setCapability(18);
        geometry.setCapability(8);
        geometry.setCapability(17);
        geometry.setCapability(0);
        return geometry;
    }

    public void updateData(Geometry geometry) {
        this.updateCoords((GeometryArray)geometry, this.from, this.to);
    }

    protected void updateCoords(GeometryArray geometry, Point3d from, Point3d to) {
        float x1 = (float)Math.min(from.x, to.x);
        float z1 = (float)Math.min(from.z, to.z);
        float x2 = (float)Math.max(from.x, to.x);
        float z2 = (float)Math.max(from.z, to.z);
        float y1 = 0.0f;
        float y2 = from.equals((Tuple3d)to) ? 0.0f : 0.25f;
        Point3f p3f = new Point3f();
        p3f.set(x1, y1, z2);
        geometry.setCoordinate(0, p3f);
        p3f.set(x2, y1, z2);
        geometry.setCoordinate(1, p3f);
        p3f.set(x2, y2, z2);
        geometry.setCoordinate(2, p3f);
        p3f.set(x1, y2, z2);
        geometry.setCoordinate(3, p3f);
        p3f.set(x1, y1, z1);
        geometry.setCoordinate(4, p3f);
        p3f.set(x1, y2, z1);
        geometry.setCoordinate(5, p3f);
        p3f.set(x2, y2, z1);
        geometry.setCoordinate(6, p3f);
        p3f.set(x2, y1, z1);
        geometry.setCoordinate(7, p3f);
        p3f.set(x1, y1, z1);
        geometry.setCoordinate(8, p3f);
        p3f.set(x1, y1, z2);
        geometry.setCoordinate(9, p3f);
        p3f.set(x1, y2, z2);
        geometry.setCoordinate(10, p3f);
        p3f.set(x1, y2, z1);
        geometry.setCoordinate(11, p3f);
        p3f.set(x2, y1, z2);
        geometry.setCoordinate(12, p3f);
        p3f.set(x2, y1, z1);
        geometry.setCoordinate(13, p3f);
        p3f.set(x2, y2, z1);
        geometry.setCoordinate(14, p3f);
        p3f.set(x2, y2, z2);
        geometry.setCoordinate(15, p3f);
        p3f.set(x1, y2, z1);
        geometry.setCoordinate(16, p3f);
        p3f.set(x1, y2, z2);
        geometry.setCoordinate(17, p3f);
        p3f.set(x2, y2, z2);
        geometry.setCoordinate(18, p3f);
        p3f.set(x2, y2, z1);
        geometry.setCoordinate(19, p3f);
        p3f.set(x1, y1, z1);
        geometry.setCoordinate(20, p3f);
        p3f.set(x2, y1, z1);
        geometry.setCoordinate(21, p3f);
        p3f.set(x2, y1, z2);
        geometry.setCoordinate(22, p3f);
        p3f.set(x1, y1, z2);
        geometry.setCoordinate(23, p3f);
    }
}

