/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.terrain;

import com.sun.j3d.utils.picking.PickCanvas;
import java.awt.AWTEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOr;
import org.tigr.microarray.mev.cluster.gui.impl.terrain.PickListener;

public class PickBehavior
extends Behavior {
    private PickCanvas pickCanvas;
    private PickListener listener;
    private WakeupOr wakeupCondition;

    public PickBehavior(BranchGroup branchgroup, Canvas3D canvas3d, Bounds bounds) {
        this.pickCanvas = new PickCanvas(canvas3d, branchgroup);
        this.pickCanvas.setTolerance(1.0f);
        this.pickCanvas.setMode(1024);
        this.setSchedulingBounds(bounds);
    }

    public void setTolerance(float value) {
        this.pickCanvas.setTolerance(value);
    }

    public float getTolerance() {
        return this.pickCanvas.getTolerance();
    }

    public void initialize() {
        WakeupCriterion[] conditions = new WakeupCriterion[]{new WakeupOnAWTEvent(502), new WakeupOnAWTEvent(501), new WakeupOnAWTEvent(506)};
        this.wakeupCondition = new WakeupOr(conditions);
        this.wakeupOn((WakeupCondition)this.wakeupCondition);
    }

    public void setPickListener(PickListener listener) {
        this.listener = listener;
    }

    public void processStimulus(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            AWTEvent[] events;
            WakeupCriterion wakeupcriterion = (WakeupCriterion)enumeration.nextElement();
            if (!(wakeupcriterion instanceof WakeupOnAWTEvent) || (events = ((WakeupOnAWTEvent)wakeupcriterion).getAWTEvent()).length <= 0) continue;
            for (int i = 0; i < events.length - 1; ++i) {
                if (events[i].getID() == events[i + 1].getID()) continue;
                this.processMouseEvent((MouseEvent)events[i]);
            }
            this.processMouseEvent((MouseEvent)events[events.length - 1]);
        }
        this.wakeupOn((WakeupCondition)this.wakeupCondition);
    }

    private void processMouseEvent(MouseEvent event) {
        if (this.listener == null) {
            return;
        }
        switch (event.getID()) {
            case 501: {
                this.listener.onMousePressed(event, this.pickCanvas);
                break;
            }
            case 502: {
                this.listener.onMouseReleased(event, this.pickCanvas);
                break;
            }
            case 506: {
                this.listener.onMouseDragged(event, this.pickCanvas);
            }
        }
    }
}

