/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.terrain;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.terrain.KeyMotionBehavior;

public class NavigationPanel
extends JPanel
implements ChangeListener,
ActionListener {
    private static final int FWD_CMD = 0;
    private static final int BWD_CMD = 1;
    private static final int UP_CMD = 2;
    private static final int DOWN_CMD = 3;
    private static final int LEFT_CMD = 4;
    private static final int RIGHT_CMD = 5;
    private AbstractButton lu_btn;
    private AbstractButton lm_btn;
    private AbstractButton lb_btn;
    private AbstractButton mu_btn;
    private AbstractButton mm_btn;
    private AbstractButton mb_btn;
    private AbstractButton ru_btn;
    private AbstractButton rm_btn;
    private AbstractButton rb_btn;
    private TimerHandler timerHandler;
    private KeyMotionBehavior behavior;
    private static final int MOVE_MODE = 0;
    private static final int TURN_MODE = 1;
    private static final int ROT_MODE = 2;
    private static Icon[] mode_icons = new Icon[3];
    private int state = 0;

    public NavigationPanel() {
    }

    public NavigationPanel(KeyMotionBehavior behavior) {
        this.setLayout(new GridBagLayout());
        this.behavior = behavior;
        this.timerHandler = new TimerHandler();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.lu_btn = this.createJButton("left-up-command", GUIFactory.getIcon("arrow_left_up.gif"));
        this.add((Component)this.lu_btn, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        this.mu_btn = this.createJButton("middle-up-command", GUIFactory.getIcon("arrow_up.gif"));
        this.add((Component)this.mu_btn, gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        this.ru_btn = this.createJButton("right-up-command", GUIFactory.getIcon("arrow_right_up.gif"));
        this.add((Component)this.ru_btn, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.lm_btn = this.createJButton("left-middle-command", GUIFactory.getIcon("arrow_left.gif"));
        this.add((Component)this.lm_btn, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        this.mm_btn = this.createStateButton("middle-middle-command", mode_icons[0]);
        this.add((Component)this.mm_btn, gbc);
        gbc.gridx = 2;
        gbc.gridy = 1;
        this.rm_btn = this.createJButton("right-middle-command", GUIFactory.getIcon("arrow_right.gif"));
        this.add((Component)this.rm_btn, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        this.lb_btn = this.createJButton("left-bottom-command", GUIFactory.getIcon("arrow_left_down.gif"));
        this.add((Component)this.lb_btn, gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        this.mb_btn = this.createJButton("middle-bottom-command", GUIFactory.getIcon("arrow_down.gif"));
        this.add((Component)this.mb_btn, gbc);
        gbc.gridx = 2;
        gbc.gridy = 2;
        this.rb_btn = this.createJButton("right-bottom-command", GUIFactory.getIcon("arrow_right_down.gif"));
        this.add((Component)this.rb_btn, gbc);
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.gridheight = 3;
        JButton reset = new JButton("<html><body><table cellspacing=0 cellpadding=0><tr><td>R</td></tr><tr><td>E</td></tr><tr><td>S</td></tr><tr><td>E</td></tr><tr><td>T</td></tr></table></body></html>");
        reset.setActionCommand("reset-command");
        reset.addActionListener(this);
        this.add((Component)reset, gbc);
        this.setTooltips(this.state);
    }

    protected AbstractButton createStateButton(String command, Icon icon) {
        JButton button = new JButton(icon);
        this.configureButton(button);
        button.setActionCommand(command);
        button.addActionListener(this);
        return button;
    }

    protected AbstractButton createJButton(String command, Icon icon) {
        JButton button = new JButton(icon);
        this.configureButton(button);
        button.setActionCommand(command);
        button.addChangeListener(this);
        return button;
    }

    protected void configureButton(AbstractButton button) {
        button.setContentAreaFilled(false);
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setFocusPainted(false);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        AbstractButton button = (AbstractButton)e.getSource();
        ButtonModel model = button.getModel();
        if (model.isPressed() && model.isArmed()) {
            this.timerHandler.start(button.getActionCommand());
        } else {
            this.timerHandler.stop();
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("middle-middle-command")) {
            if (this.state == 2) {
                this.state = -1;
            }
            ++this.state;
            this.mm_btn.setIcon(mode_icons[this.state]);
            this.setTooltips(this.state);
        } else if (command.equals("reset-command")) {
            this.behavior.execute(18);
        } else if (command.equals("left-up-command")) {
            this.behavior.execute(this.getMotionCommand(0));
        } else if (command.equals("middle-up-command")) {
            this.behavior.execute(this.getMotionCommand(2));
        } else if (command.equals("right-up-command")) {
            this.behavior.execute(this.getMotionCommand(0));
        } else if (command.equals("left-middle-command")) {
            this.behavior.execute(this.getMotionCommand(4));
        } else if (command.equals("right-middle-command")) {
            this.behavior.execute(this.getMotionCommand(5));
        } else if (command.equals("left-bottom-command")) {
            this.behavior.execute(this.getMotionCommand(1));
        } else if (command.equals("middle-bottom-command")) {
            this.behavior.execute(this.getMotionCommand(3));
        } else if (command.equals("right-bottom-command")) {
            this.behavior.execute(this.getMotionCommand(1));
        }
    }

    protected int getMotionCommand(int code) {
        switch (this.state) {
            case 0: {
                switch (code) {
                    case 0: {
                        return 2;
                    }
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 4;
                    }
                    case 3: {
                        return 5;
                    }
                    case 4: {
                        return 0;
                    }
                    case 5: {
                        return 1;
                    }
                }
                break;
            }
            case 1: {
                switch (code) {
                    case 0: {
                        return 11;
                    }
                    case 1: {
                        return 10;
                    }
                    case 2: {
                        return 8;
                    }
                    case 3: {
                        return 9;
                    }
                    case 4: {
                        return 6;
                    }
                    case 5: {
                        return 7;
                    }
                }
                break;
            }
            case 2: {
                switch (code) {
                    case 0: {
                        return 14;
                    }
                    case 1: {
                        return 17;
                    }
                    case 2: {
                        return 12;
                    }
                    case 3: {
                        return 15;
                    }
                    case 4: {
                        return 16;
                    }
                    case 5: {
                        return 13;
                    }
                }
            }
        }
        return -1;
    }

    protected void setTooltips(int mode) {
        switch (mode) {
            case 0: {
                this.lu_btn.setToolTipText("move view forward");
                this.lm_btn.setToolTipText("move view left");
                this.lb_btn.setToolTipText("move view backward");
                this.mu_btn.setToolTipText("move view up");
                this.mm_btn.setToolTipText("switch to turn mode");
                this.mb_btn.setToolTipText("move view down");
                this.ru_btn.setToolTipText("move view forward");
                this.rm_btn.setToolTipText("move view right");
                this.rb_btn.setToolTipText("move view backward");
                break;
            }
            case 1: {
                this.lu_btn.setToolTipText("tilt view right");
                this.lm_btn.setToolTipText("turn view left");
                this.lb_btn.setToolTipText("tilt view left");
                this.mu_btn.setToolTipText("turn view up");
                this.mm_btn.setToolTipText("switch to rotation mode");
                this.mb_btn.setToolTipText("turn view down");
                this.ru_btn.setToolTipText("tilt view right");
                this.rm_btn.setToolTipText("turn view right");
                this.rb_btn.setToolTipText("tilt view left");
                break;
            }
            case 2: {
                this.lu_btn.setToolTipText("rotate z");
                this.lm_btn.setToolTipText("rotate y");
                this.lb_btn.setToolTipText("rotate z");
                this.mu_btn.setToolTipText("rotate x");
                this.mm_btn.setToolTipText("switch to motion mode");
                this.mb_btn.setToolTipText("rotate x");
                this.ru_btn.setToolTipText("rotate z");
                this.rm_btn.setToolTipText("rotate y");
                this.rb_btn.setToolTipText("rotate z");
            }
        }
    }

    static {
        NavigationPanel.mode_icons[0] = GUIFactory.getIcon("move_mode.gif");
        NavigationPanel.mode_icons[1] = GUIFactory.getIcon("turn_mode.gif");
        NavigationPanel.mode_icons[2] = GUIFactory.getIcon("rot_mode.gif");
    }

    private class TimerHandler
    implements ActionListener {
        private Timer timer = new Timer(100, this);
        private String command;

        public void start(String command) {
            this.command = command;
            this.actionPerformed(null);
            this.timer.start();
        }

        public void stop() {
            this.timer.stop();
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            NavigationPanel.this.actionPerformed(new ActionEvent(this, 1001, this.command));
        }
    }
}

