/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.terrain;

import java.awt.geom.Rectangle2D;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.Shape3D;
import javax.vecmath.Point2f;
import javax.vecmath.Tuple2f;
import org.tigr.microarray.mev.cluster.gui.impl.util.FloatArray;

public class LinksShape
extends Shape3D {
    private int[][] subnets;
    private float[][] weights;
    private float[][] locations;
    private Point2f left_up = new Point2f(0.0f, 0.0f);
    private Point2f right_bottom = new Point2f(1.0f, 1.0f);
    private float threshold = 0.8f;
    private boolean visible = false;
    private static final float[][] EMPTY_BUF = new float[][]{{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}};

    public LinksShape(int[][] subnets, float[][] weights, float[][] locations) {
        this.setCapability(12);
        this.setCapability(13);
        this.setCapability(14);
        this.subnets = subnets;
        this.weights = weights;
        this.locations = locations;
        this.updateGeometry();
        this.setAppearance(this.createAppearance());
    }

    public void setZoom(Point2f left_up, Point2f right_bottom) {
        this.left_up.set((Tuple2f)left_up);
        this.right_bottom.set((Tuple2f)right_bottom);
        this.updateGeometry();
    }

    public void setThreshold(float threshold) {
        this.threshold = threshold;
        this.updateGeometry();
    }

    public float getThreshold() {
        return this.threshold;
    }

    public void setVisible(boolean value) {
        if (this.visible == value) {
            return;
        }
        this.visible = value;
        this.updateGeometry();
    }

    public void setLinksWidth(float value) {
        Appearance appearance = this.getAppearance();
        LineAttributes la = appearance.getLineAttributes();
        la.setLineWidth(value);
    }

    public float getLinksWidth() {
        Appearance appearance = this.getAppearance();
        LineAttributes la = appearance.getLineAttributes();
        return la.getLineWidth();
    }

    private void updateGeometry() {
        this.setGeometry(this.createGeometry());
    }

    private Geometry createGeometry() {
        float[][] vertCoords = this.createLinksCoordinaties();
        LineArray geometry = new LineArray(vertCoords[0].length / 3, 5);
        geometry.setCoordinates(0, vertCoords[0]);
        geometry.setColors(0, vertCoords[1]);
        geometry.setCapability(18);
        geometry.setCapability(8);
        geometry.setCapability(17);
        geometry.setCapability(0);
        return geometry;
    }

    private float[][] createLinksCoordinaties() {
        if (!this.visible) {
            return EMPTY_BUF;
        }
        Point2f p1 = new Point2f();
        Point2f p2 = new Point2f();
        Point2f n1 = new Point2f();
        Point2f n2 = new Point2f();
        Rectangle2D.Float bounds = new Rectangle2D.Float(0.0f, 0.0f, 1.0f, 1.0f);
        float scale = 1.0f / Math.max(this.right_bottom.x - this.left_up.x, this.right_bottom.y - this.left_up.y);
        boolean coordPos = false;
        FloatArray coords = new FloatArray(100);
        FloatArray colors = new FloatArray(100);
        for (int i = 0; i < this.subnets.length; ++i) {
            if (this.subnets[i].length <= 1) continue;
            float x1 = (this.locations[i][0] - this.left_up.x) * scale;
            float y1 = (this.locations[i][1] - this.left_up.y) * scale;
            if (!(x1 >= 0.0f) || !(x1 <= 1.0f) || !(y1 >= 0.0f) || !(y1 <= 1.0f)) continue;
            for (int j = 1; j < this.subnets[i].length; ++j) {
                float x2 = (this.locations[this.subnets[i][j]][0] - this.left_up.x) * scale;
                float y2 = (this.locations[this.subnets[i][j]][1] - this.left_up.y) * scale;
                p1.set(x1, y1);
                p2.set(x2, y2);
                if (!(Math.abs(this.weights[i][j]) > this.threshold) || !this.isLineIntersects(bounds, p1, p2, n1, n2)) continue;
                coords.add(n1.x);
                coords.add(0.0f);
                coords.add(n1.y);
                coords.add(n2.x);
                coords.add(0.0f);
                coords.add(n2.y);
                colors.add(this.weights[i][j]);
                colors.add(0.0f);
                colors.add(1.0f - this.weights[i][j]);
                colors.add(this.weights[i][j]);
                colors.add(0.0f);
                colors.add(1.0f - this.weights[i][j]);
            }
        }
        if (coords.getSize() == 0) {
            return EMPTY_BUF;
        }
        float[][] result = new float[][]{coords.toArray(), colors.toArray()};
        return result;
    }

    private final boolean isIntersectVerticalLine(Point2f p1, Point2f p2, float x, float y1, float y2, Point2f point) {
        if (p1.x < x && p2.x < x || p1.x > x && p2.x > x) {
            return false;
        }
        float tan = (p2.y - p1.y) / (p2.x - p1.x);
        float delta = tan * (x - p1.x);
        point.x = x;
        point.y = p1.y + delta;
        return point.y > Math.min(y1, y2) && point.y < Math.max(y1, y2);
    }

    private final boolean isIntersectHorizontalLine(Point2f p1, Point2f p2, float y, float x1, float x2, Point2f point) {
        if (p1.y < y && p2.y < y || p1.y > y && p2.y > y) {
            return false;
        }
        float tan = (p2.y - p1.y) / (p2.x - p1.x);
        float delta = (y - p1.y) / tan;
        point.x = p1.x + delta;
        point.y = y;
        return point.x > Math.min(x1, x2) && point.x < Math.max(x1, x2);
    }

    private final boolean isInternalPoint(Rectangle2D.Float rect, Point2f p1, Point2f p2, Point2f n) {
        boolean p1b = rect.contains(p1.x, p1.y);
        boolean p2b = rect.contains(p2.x, p2.y);
        if (p1b) {
            n.set((Tuple2f)p1);
            return true;
        }
        if (p2b) {
            n.set((Tuple2f)p2);
            return true;
        }
        return false;
    }

    private final boolean isLineIntersects(Rectangle2D.Float rect, Point2f p1, Point2f p2, Point2f n1, Point2f n2) {
        n1.set((Tuple2f)p1);
        n2.set((Tuple2f)p2);
        if (rect.contains(p1.x, p1.y) && rect.contains(p2.x, p2.y)) {
            return true;
        }
        if (p1.x < rect.x && p2.x < rect.x) {
            return false;
        }
        if (p1.y < rect.y && p2.y < rect.y) {
            return false;
        }
        if (p1.x > rect.x + rect.width && p2.x > rect.x + rect.width) {
            return false;
        }
        if (p1.y > rect.y + rect.height && p2.y > rect.y + rect.height) {
            return false;
        }
        if (p1.x == p2.x) {
            if (p1.y < rect.y) {
                n1.y = rect.y;
            } else if (p1.y > rect.y + rect.height) {
                n1.y = rect.y + rect.height;
            }
            if (p2.y < rect.y) {
                n2.y = rect.y;
            } else if (p2.y > rect.y + rect.height) {
                n2.y = rect.y + rect.height;
            }
            return true;
        }
        if (p1.y == p2.y) {
            if (p1.x < rect.x) {
                n1.x = rect.x;
            } else if (p1.x > rect.x + rect.width) {
                n1.x = rect.x + rect.width;
            }
            if (p2.x < rect.x) {
                n2.x = rect.x;
            } else if (p2.x > rect.x + rect.width) {
                n2.x = rect.x + rect.width;
            }
            return true;
        }
        if (this.isIntersectVerticalLine(p1, p2, rect.x, rect.y, rect.y + rect.height, n1)) {
            return this.isIntersectVerticalLine(p1, p2, rect.x + rect.width, rect.y, rect.y + rect.height, n2) || this.isIntersectHorizontalLine(p1, p2, rect.y, rect.x, rect.x + rect.width, n2) || this.isIntersectHorizontalLine(p1, p2, rect.y + rect.height, rect.x, rect.x + rect.width, n2) || this.isInternalPoint(rect, p1, p2, n2);
            {
            }
        }
        if (this.isIntersectVerticalLine(p1, p2, rect.x + rect.width, rect.y, rect.y + rect.height, n1)) {
            return this.isIntersectHorizontalLine(p1, p2, rect.y + rect.height, rect.x, rect.x + rect.width, n2) || this.isIntersectHorizontalLine(p1, p2, rect.y, rect.x, rect.x + rect.width, n2) || this.isInternalPoint(rect, p1, p2, n2);
            {
            }
        }
        if (this.isIntersectHorizontalLine(p1, p2, rect.y, rect.x, rect.x + rect.width, n1)) {
            return this.isIntersectHorizontalLine(p1, p2, rect.y + rect.height, rect.x, rect.x + rect.width, n2) || this.isInternalPoint(rect, p1, p2, n2);
            {
            }
        }
        if (this.isIntersectHorizontalLine(p1, p2, rect.y + rect.height, rect.x, rect.x + rect.width, n1)) {
            return this.isInternalPoint(rect, p1, p2, n2);
            {
            }
        }
        return false;
    }

    protected Appearance createAppearance() {
        LineAttributes la = new LineAttributes();
        la.setCapability(0);
        la.setCapability(1);
        Appearance appearance = new Appearance();
        appearance.setCapability(16);
        appearance.setCapability(17);
        appearance.setLineAttributes(la);
        appearance.setMaterial(new Material());
        return appearance;
    }
}

