/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.terrain;

import java.awt.image.BufferedImage;
import java.util.Arrays;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GeometryUpdater;
import javax.media.j3d.Material;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.tigr.microarray.mev.cluster.gui.impl.terrain.DomainUtil;

public class Landscape
extends Shape3D
implements GeometryUpdater {
    private float[][] heights;
    private float[] coords;
    private float[] colors;
    private float[] normals;

    public Landscape(float[][] heights) {
        this.heights = heights;
        this.setCapability(12);
        this.setCapability(13);
        this.setCapability(14);
        this.setCapability(1);
        this.initBuffers(heights.length);
        Landscape.updateCoords(this.coords, this.heights);
        Landscape.updateColors(this.colors, this.heights);
        Landscape.updateNormals(this.normals, this.heights);
        this.setGeometry(this.createGeometry(heights.length, this.coords, this.colors, this.normals));
        this.setAppearance(this.createAppearance());
    }

    private void initBuffers(int size) {
        this.coords = new float[(size - 1) * size * 2 * 3];
        this.colors = new float[(size - 1) * size * 2 * 3];
        this.normals = new float[(size - 1) * size * 2 * 3];
    }

    public void setHeights(float[][] heights) {
        if (this.heights.length != heights.length) {
            this.initBuffers(heights.length);
            this.setGeometry(this.createGeometry(heights.length, this.coords, this.colors, this.normals));
        }
        this.heights = heights;
        ((GeometryArray)this.getGeometry()).updateData((GeometryUpdater)this);
    }

    public void setPoligonMode(int mode) {
        Appearance appearance = this.getAppearance();
        PolygonAttributes pa = appearance.getPolygonAttributes();
        pa.setPolygonMode(mode);
    }

    private Geometry createGeometry(int size, float[] coords, float[] colors, float[] normals) {
        int[] stripVertexCounts = new int[size - 1];
        Arrays.fill(stripVertexCounts, size * 2);
        TriangleStripArray geometry = new TriangleStripArray(coords.length / 3, 135, stripVertexCounts);
        geometry.setCapability(8);
        geometry.setCapability(17);
        geometry.setCapability(18);
        geometry.setCapability(19);
        geometry.setCoordRefFloat(coords);
        geometry.setColorRefFloat(colors);
        geometry.setNormalRefFloat(normals);
        return geometry;
    }

    private Appearance createAppearance() {
        PolygonAttributes pa = new PolygonAttributes();
        pa.setCapability(3);
        pa.setCullFace(0);
        Appearance appearance = new Appearance();
        appearance.setCapability(14);
        appearance.setCapability(15);
        appearance.setPolygonAttributes(pa);
        appearance.setMaterial(new Material());
        return appearance;
    }

    public void updateData(Geometry geometry) {
        Landscape.updateCoords(this.coords, this.heights);
        Landscape.updateColors(this.colors, this.heights);
        Landscape.updateNormals(this.normals, this.heights);
    }

    public static void updateCoords(float[] coords, float[][] heights) {
        int size = heights.length;
        int stride = 6;
        float step = 1.0f / (float)size;
        float x = step / 2.0f;
        float y = step / 2.0f;
        for (int i = 0; i < size - 1; ++i) {
            for (int j = 0; j < size; ++j) {
                int pos = (i * size + j) * 6;
                coords[pos++] = x;
                coords[pos++] = heights[i][j];
                coords[pos++] = y;
                coords[pos++] = x;
                coords[pos++] = heights[i + 1][j];
                coords[pos++] = y + step;
                x += step;
            }
            x = step / 2.0f;
            y += step;
        }
    }

    public static void updateColors(float[] colors, float[][] heights) {
        int size = heights.length;
        int stride = 6;
        float step = 1.0f / (float)size;
        float x = step / 2.0f;
        float y = step / 2.0f;
        float scale = (float)(size - 1) / Landscape.getMaxValue(heights);
        BufferedImage gradient = DomainUtil.createGradientImage(size);
        for (int i = 0; i < size - 1; ++i) {
            for (int j = 0; j < size; ++j) {
                int pos = (i * size + j) * 6;
                int rgb1 = gradient.getRGB((int)(heights[i][j] * scale), 0);
                int rgb2 = gradient.getRGB((int)(heights[i + 1][j] * scale), 0);
                colors[pos++] = (float)(rgb1 >> 16 & 0xFF) / 255.0f;
                colors[pos++] = (float)(rgb1 >> 8 & 0xFF) / 255.0f;
                colors[pos++] = (float)(rgb1 >> 0 & 0xFF) / 255.0f;
                colors[pos++] = (float)(rgb2 >> 16 & 0xFF) / 255.0f;
                colors[pos++] = (float)(rgb2 >> 8 & 0xFF) / 255.0f;
                colors[pos++] = (float)(rgb2 >> 0 & 0xFF) / 255.0f;
                x += step;
            }
            x = step / 2.0f;
            y += step;
        }
    }

    protected static void updateNormals(float[] normals, float[][] heights) {
        int j;
        int i;
        int size = heights.length;
        float[][][] buff = new float[size][size][3];
        float step = 1.0f / (float)size;
        Vector3f v0 = new Vector3f();
        Vector3f south = new Vector3f();
        Vector3f east = new Vector3f();
        Vector3f normal = new Vector3f();
        for (i = 0; i < size; ++i) {
            for (j = 0; j < size; ++j) {
                if (i == size - 1) {
                    south.set(0.0f, 0.0f, step);
                } else {
                    south.set(0.0f, heights[i + 1][j], step);
                }
                if (j == size - 1) {
                    east.set(step, 0.0f, 0.0f);
                } else {
                    east.set(step, heights[i][j + 1], 0.0f);
                }
                v0.set(0.0f, heights[i][j], 0.0f);
                south.sub((Tuple3f)v0);
                east.sub((Tuple3f)v0);
                normal.cross(south, east);
                normal.normalize();
                buff[i][j][0] = normal.x;
                buff[i][j][1] = normal.y;
                buff[i][j][2] = normal.z;
            }
        }
        for (i = 0; i < size - 1; ++i) {
            for (j = 0; j < size; ++j) {
                int pos = (i * size + j) * 6;
                normals[pos++] = buff[i][j][0];
                normals[pos++] = buff[i][j][1];
                normals[pos++] = buff[i][j][2];
                normals[pos++] = buff[i + 1][j][0];
                normals[pos++] = buff[i + 1][j][1];
                normals[pos++] = buff[i + 1][j][2];
            }
        }
    }

    private static float getMaxValue(float[][] heights) {
        int size = heights.length;
        float max = -3.4028235E38f;
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                max = Math.max(max, heights[i][j]);
            }
        }
        return max;
    }
}

