/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.terrain;

import java.awt.event.KeyEvent;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class KeyMotionBehavior
extends Behavior {
    public static final int MOVE_LEFT_CMD = 0;
    public static final int MOVE_RIGHT_CMD = 1;
    public static final int MOVE_FWD_CMD = 2;
    public static final int MOVE_BWD_CMD = 3;
    public static final int MOVE_UP_CMD = 4;
    public static final int MOVE_DOWN_CMD = 5;
    public static final int TURN_LEFT_CMD = 6;
    public static final int TURN_RIGHT_CMD = 7;
    public static final int TURN_UP_CMD = 8;
    public static final int TURN_DOWN_CMD = 9;
    public static final int TILT_LEFT_CMD = 10;
    public static final int TILT_RIGHT_CMD = 11;
    public static final int ROT_X_POS_CMD = 12;
    public static final int ROT_Y_POS_CMD = 13;
    public static final int ROT_Z_POS_CMD = 14;
    public static final int ROT_X_NEG_CMD = 15;
    public static final int ROT_Y_NEG_CMD = 16;
    public static final int ROT_Z_NEG_CMD = 17;
    public static final int RESET_CMD = 18;
    private float STEP = 0.01f;
    private float UNGLE = (float)Math.PI / 180;
    private TransformGroup target;
    private Point3d basis;
    private Transform3D initialTransform = new Transform3D();
    private WakeupOnBehaviorPost wakeupCondition;

    public KeyMotionBehavior(TransformGroup target) {
        this.target = target;
        this.target.getTransform(this.initialTransform);
        this.wakeupCondition = new WakeupOnBehaviorPost((Behavior)this, 0);
    }

    public void execute(int command) {
        this.postId(command);
    }

    public void onKeyEvent(KeyEvent e) {
        this.execute(KeyMotionBehavior.key2command(e));
    }

    public void setBasis(Point3d basis) {
        this.basis = basis;
    }

    public void initialize() {
        this.wakeupOn((WakeupCondition)this.wakeupCondition);
    }

    public void processStimulus(Enumeration criteria) {
        while (criteria.hasMoreElements()) {
            WakeupCriterion wakeup = (WakeupCriterion)criteria.nextElement();
            if (wakeup != this.wakeupCondition) continue;
            this.processCommand(this.wakeupCondition.getTriggeringPostId());
        }
        this.wakeupOn((WakeupCondition)this.wakeupCondition);
    }

    private void processCommand(int id) {
        switch (id) {
            case 0: {
                this.move_left();
                break;
            }
            case 1: {
                this.move_right();
                break;
            }
            case 2: {
                this.move_forward();
                break;
            }
            case 3: {
                this.move_backward();
                break;
            }
            case 4: {
                this.move_up();
                break;
            }
            case 5: {
                this.move_down();
                break;
            }
            case 6: {
                this.turn_left();
                break;
            }
            case 7: {
                this.turn_right();
                break;
            }
            case 8: {
                this.turn_up();
                break;
            }
            case 9: {
                this.turn_down();
                break;
            }
            case 10: {
                this.tilt_left();
                break;
            }
            case 11: {
                this.tilt_right();
                break;
            }
            case 12: {
                this.rotate(this.basis, new AxisAngle4d(1.0, 0.0, 0.0, (double)this.UNGLE));
                break;
            }
            case 13: {
                this.rotate(this.basis, new AxisAngle4d(0.0, 1.0, 0.0, (double)this.UNGLE));
                break;
            }
            case 14: {
                this.rotate(this.basis, new AxisAngle4d(0.0, 0.0, 1.0, (double)this.UNGLE));
                break;
            }
            case 15: {
                this.rotate(this.basis, new AxisAngle4d(1.0, 0.0, 0.0, (double)(-this.UNGLE)));
                break;
            }
            case 16: {
                this.rotate(this.basis, new AxisAngle4d(0.0, 1.0, 0.0, (double)(-this.UNGLE)));
                break;
            }
            case 17: {
                this.rotate(this.basis, new AxisAngle4d(0.0, 0.0, 1.0, (double)(-this.UNGLE)));
                break;
            }
            case 18: {
                this.reset();
            }
        }
    }

    private static int key2command(KeyEvent e) {
        int code = e.getKeyCode();
        if (e.isShiftDown()) {
            switch (code) {
                case 37: {
                    return 6;
                }
                case 39: {
                    return 7;
                }
                case 38: {
                    return 8;
                }
                case 40: {
                    return 9;
                }
            }
        } else if (e.isControlDown()) {
            switch (code) {
                case 37: {
                    return 10;
                }
                case 39: {
                    return 11;
                }
                case 88: {
                    return 12;
                }
                case 89: {
                    return 13;
                }
                case 90: {
                    return 14;
                }
            }
        } else {
            switch (code) {
                case 37: {
                    return 0;
                }
                case 39: {
                    return 1;
                }
                case 38: {
                    return 2;
                }
                case 40: {
                    return 3;
                }
                case 33: {
                    return 4;
                }
                case 34: {
                    return 5;
                }
                case 88: {
                    return 15;
                }
                case 89: {
                    return 16;
                }
                case 90: {
                    return 17;
                }
                case 82: {
                    return 18;
                }
            }
        }
        return -1;
    }

    protected void reset() {
        this.target.setTransform(this.initialTransform);
    }

    protected void turn_left() {
        this.turnHorizontal(this.UNGLE);
    }

    protected void turn_right() {
        this.turnHorizontal(-this.UNGLE);
    }

    protected void turn_up() {
        this.turnVertical(this.UNGLE);
    }

    protected void turn_down() {
        this.turnVertical(-this.UNGLE);
    }

    protected void tilt_left() {
        this.turnFront(this.UNGLE);
    }

    protected void tilt_right() {
        this.turnFront(-this.UNGLE);
    }

    protected void move_left() {
        this.move(new Vector3f(-this.STEP, 0.0f, 0.0f));
    }

    protected void move_right() {
        this.move(new Vector3f(this.STEP, 0.0f, 0.0f));
    }

    protected void move_backward() {
        this.move(new Vector3f(0.0f, 0.0f, this.STEP));
    }

    protected void move_forward() {
        this.move(new Vector3f(0.0f, 0.0f, -this.STEP));
    }

    protected void move_up() {
        this.move(new Vector3f(0.0f, this.STEP, 0.0f));
    }

    protected void move_down() {
        this.move(new Vector3f(0.0f, -this.STEP, 0.0f));
    }

    protected void rotate(Point3d basis, AxisAngle4d axis) {
        if (basis == null || axis == null) {
            return;
        }
        Transform3D target_t3d = new Transform3D();
        this.target.getTransform(target_t3d);
        Matrix3d scale_m3d = new Matrix3d();
        target_t3d.getRotationScale(scale_m3d);
        Vector3d vector3d = new Vector3d();
        target_t3d.get(vector3d);
        Point3d target_p3d = new Point3d((Tuple3d)vector3d);
        Point3d diff_p3d = new Point3d(basis);
        diff_p3d.sub((Tuple3d)target_p3d);
        Matrix3d basis_m3d = new Matrix3d();
        basis_m3d.m00 = diff_p3d.x;
        basis_m3d.m10 = diff_p3d.y;
        basis_m3d.m20 = diff_p3d.z;
        scale_m3d.transpose();
        scale_m3d.mul(basis_m3d);
        Vector3d direction_v3d = new Vector3d();
        scale_m3d.getColumn(0, direction_v3d);
        Transform3D move_t3d = new Transform3D();
        move_t3d.set(direction_v3d);
        target_t3d.mul(move_t3d);
        Transform3D rotx_t3d = new Transform3D();
        rotx_t3d.set(axis);
        target_t3d.mul(rotx_t3d);
        direction_v3d.negate();
        move_t3d.set(direction_v3d);
        target_t3d.mul(move_t3d);
        this.target.setTransform(target_t3d);
    }

    protected void move(Vector3f direction) {
        Transform3D transform = new Transform3D();
        transform.set(direction);
        this.mul(transform);
    }

    protected void turnHorizontal(double ungle) {
        Transform3D transform = new Transform3D();
        transform.rotY(ungle);
        this.mul(transform);
    }

    protected void turnFront(double ungle) {
        Transform3D transform = new Transform3D();
        transform.rotZ(ungle);
        this.mul(transform);
    }

    protected void turnVertical(double ungle) {
        Transform3D transform = new Transform3D();
        transform.rotX(ungle);
        this.mul(transform);
    }

    private void mul(Transform3D transform) {
        Transform3D t3D = new Transform3D();
        this.target.getTransform(t3D);
        t3D.mul(transform);
        this.target.setTransform(t3D);
    }
}

