/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.terrain;

import com.sun.j3d.utils.geometry.Sphere;
import java.awt.Color;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GeometryUpdater;
import javax.media.j3d.LineArray;
import javax.media.j3d.Material;
import javax.media.j3d.PointArray;
import javax.media.j3d.PointAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Color3f;
import javax.vecmath.Point2f;
import javax.vecmath.Tuple2f;
import org.tigr.microarray.mev.cluster.gui.impl.util.IntArray;

public class GenesShape
extends Shape3D
implements GeometryUpdater {
    public static final int POINTS = 0;
    public static final int CUBES = 1;
    public static final int SPHERES = 2;
    private int type = 0;
    private float size = 0.005f;
    private float[] coords;
    private float[] colors;
    private float[] normals;
    private float[][] locations;
    private IntArray shapeIndices;
    private Point2f start = new Point2f();
    private Point2f end = new Point2f();
    private int[] colorIndices;
    private Color3f[] colors_c3f;
    private static final float[] cubeverts = new float[]{1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f};
    private static final float[] cubenormals = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f};
    private static final float[] sphereverts;
    private static final float[] spherenormals;
    private static final int[] spherestrips;

    public GenesShape(int type, float[][] locations, Point2f start, Point2f end) {
        this.type = type;
        this.locations = locations;
        this.start.set((Tuple2f)start);
        this.end.set((Tuple2f)end);
        this.setCapability(1);
        this.setCapability(12);
        this.setCapability(13);
        this.shapeIndices = this.getShapeIndices();
        this.initBuffers();
        this.initData();
        this.setGeometry(this.createGeometry());
        this.setAppearance(this.createAppearance());
        this.setBoundsAutoCompute(false);
    }

    public void setType(int type) {
        this.type = type;
        this.initBuffers();
        this.initData();
        this.setGeometry(this.createGeometry());
    }

    public void setZoom(Point2f start, Point2f end) {
        this.start.set((Tuple2f)start);
        this.end.set((Tuple2f)end);
        this.shapeIndices = this.getShapeIndices();
        this.initBuffers();
        this.initData();
        this.setGeometry(this.createGeometry());
    }

    public void updateColors(int[] colorIndices, Color[] colors) {
        this.colorIndices = colorIndices;
        this.colors_c3f = new Color3f[colors.length];
        for (int i = 0; i < this.colors_c3f.length; ++i) {
            this.colors_c3f[i] = new Color3f(colors[i]);
        }
        ((GeometryArray)this.getGeometry()).updateData((GeometryUpdater)this);
    }

    public int getShapeIndex(int vertexIndex) {
        if (vertexIndex < 0 || vertexIndex >= this.coords.length / 3) {
            return -1;
        }
        switch (this.type) {
            case 0: {
                return this.shapeIndices.get(vertexIndex);
            }
            case 1: {
                return this.shapeIndices.get(3 * vertexIndex / cubeverts.length);
            }
            case 2: {
                return this.shapeIndices.get(3 * vertexIndex / sphereverts.length);
            }
        }
        return -1;
    }

    private void initBuffers() {
        int size = this.shapeIndices.getSize() * GenesShape.getVerticesNumber(this.type) * 3;
        this.coords = new float[size];
        this.colors = new float[size];
        this.normals = new float[size];
    }

    private Geometry createGeometry() {
        GeometryArray geometry = null;
        if (this.shapeIndices.getSize() < 1) {
            geometry = this.createEmptyGeometry();
            return geometry;
        }
        switch (this.type) {
            case 0: {
                geometry = this.createPointsGeometry();
                break;
            }
            case 1: {
                geometry = this.createCubesGeometry();
                break;
            }
            case 2: {
                geometry = this.createSpheresGeometry();
            }
        }
        this.setCapabilities((Geometry)geometry);
        geometry.setCoordRefFloat(this.coords);
        geometry.setColorRefFloat(this.colors);
        geometry.setNormalRefFloat(this.normals);
        return geometry;
    }

    private void setCapabilities(Geometry geometry) {
        geometry.setCapability(18);
        geometry.setCapability(8);
        geometry.setCapability(17);
        geometry.setCapability(18);
        geometry.setCapability(19);
    }

    private Appearance createAppearance() {
        Appearance appearance = new Appearance();
        appearance.setMaterial(new Material());
        appearance.setPointAttributes(new PointAttributes(this.size * 1000.0f, true));
        return appearance;
    }

    private void initData() {
        this.initCoords();
        this.initColors();
        this.initNormals();
    }

    private void initCoords() {
        int shapeIndex = 0;
        float scale = Math.max(this.end.x - this.start.x, this.end.y - this.start.y);
        for (int i = 0; i < this.locations.length; ++i) {
            float x = this.locations[i][0];
            float y = this.locations[i][1];
            if (!(x >= this.start.x) || !(x <= this.start.x + scale) || !(y >= this.start.y) || !(y <= this.start.y + scale)) continue;
            this.setCoords(shapeIndex++, (x - this.start.x) / scale, 0.0f, (y - this.start.y) / scale);
        }
    }

    private void setCoords(int shapeIndex, float x, float y, float z) {
        switch (this.type) {
            case 0: {
                this.setPointCoords(shapeIndex, x, y, z);
                break;
            }
            case 1: {
                this.setCubeCoords(shapeIndex, x, y, z);
                break;
            }
            case 2: {
                this.setSphereCoords(shapeIndex, x, y, z);
            }
        }
    }

    private void setPointCoords(int shapeIndex, float x, float y, float z) {
        int pos = shapeIndex * 3;
        this.coords[pos++] = x;
        this.coords[pos++] = y;
        this.coords[pos++] = z;
    }

    private void setCubeCoords(int shapeIndex, float x, float y, float z) {
        int pos = shapeIndex * cubeverts.length;
        for (int i = 0; i < cubeverts.length; i += 3) {
            this.coords[pos++] = cubeverts[i + 0] * this.size + x;
            this.coords[pos++] = cubeverts[i + 1] * this.size + y;
            this.coords[pos++] = cubeverts[i + 2] * this.size + z;
        }
    }

    private void setSphereCoords(int shapeIndex, float x, float y, float z) {
        int pos = shapeIndex * sphereverts.length;
        for (int i = 0; i < sphereverts.length; i += 3) {
            this.coords[pos++] = sphereverts[i + 0] * this.size + x;
            this.coords[pos++] = sphereverts[i + 1] * this.size + y;
            this.coords[pos++] = sphereverts[i + 2] * this.size + z;
        }
    }

    private void initColors() {
        for (int i = 0; i < this.colors.length; ++i) {
            this.colors[i] = 0.6f;
        }
        if (this.colors_c3f == null || this.colorIndices == null) {
            return;
        }
        for (int i = 0; i < this.shapeIndices.getSize(); ++i) {
            int colorIndex = this.colorIndices[this.shapeIndices.get(i)];
            if (colorIndex < 0) continue;
            this.setShapeColor(i, this.colors_c3f[colorIndex]);
        }
    }

    private void setShapeColor(int shapeIndex, Color3f color) {
        int vertexNumber = GenesShape.getVerticesNumber(this.type);
        int pos = vertexNumber * 3 * shapeIndex;
        for (int i = 0; i < vertexNumber; ++i) {
            this.colors[pos++] = color.x;
            this.colors[pos++] = color.y;
            this.colors[pos++] = color.z;
        }
    }

    private void initNormals() {
        switch (this.type) {
            case 0: {
                this.initPointsNormals();
                break;
            }
            case 1: {
                this.initCubesNormals();
                break;
            }
            case 2: {
                this.initSpheresNormals();
            }
        }
    }

    private void initPointsNormals() {
        for (int i = 0; i < this.normals.length; i += 3) {
            this.normals[i + 0] = 0.0f;
            this.normals[i + 1] = 0.0f;
            this.normals[i + 2] = 1.0f;
        }
    }

    private void initCubesNormals() {
        for (int i = 0; i < this.normals.length; i += cubenormals.length) {
            for (int j = 0; j < cubenormals.length; ++j) {
                this.normals[i + j] = cubenormals[j];
            }
        }
    }

    private void initSpheresNormals() {
        for (int i = 0; i < this.normals.length; i += spherenormals.length) {
            for (int j = 0; j < spherenormals.length; ++j) {
                this.normals[i + j] = spherenormals[j];
            }
        }
    }

    private GeometryArray createEmptyGeometry() {
        LineArray geometry = new LineArray(2, 1);
        geometry.setCoordinates(0, new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f});
        geometry.setCapability(8);
        geometry.setCapability(17);
        geometry.setCapability(0);
        return geometry;
    }

    private GeometryArray createPointsGeometry() {
        PointArray geometry = new PointArray(this.coords.length / 3, 135);
        return geometry;
    }

    private GeometryArray createCubesGeometry() {
        QuadArray geometry = new QuadArray(this.coords.length / 3, 135);
        return geometry;
    }

    private GeometryArray createSpheresGeometry() {
        int[] stripVertexCounts = new int[spherestrips.length * this.shapeIndices.getSize()];
        for (int i = 0; i < stripVertexCounts.length; i += spherestrips.length) {
            for (int j = 0; j < spherestrips.length; ++j) {
                stripVertexCounts[i + j] = spherestrips[j];
            }
        }
        TriangleStripArray geometry = new TriangleStripArray(this.coords.length / 3, 135, stripVertexCounts);
        return geometry;
    }

    private IntArray getShapeIndices() {
        IntArray indices = new IntArray();
        float scale = Math.max(this.end.x - this.start.x, this.end.y - this.start.y);
        for (int i = 0; i < this.locations.length; ++i) {
            float x = this.locations[i][0];
            float y = this.locations[i][1];
            if (!(x >= this.start.x) || !(x <= this.start.x + scale) || !(y >= this.start.y) || !(y <= this.start.y + scale)) continue;
            indices.add(i);
        }
        return indices;
    }

    public void updateData(Geometry geometry) {
        this.initColors();
    }

    private static int getVerticesNumber(int shapeType) {
        switch (shapeType) {
            case 0: {
                return 1;
            }
            case 1: {
                return cubeverts.length / 3;
            }
            case 2: {
                return sphereverts.length / 3;
            }
        }
        return 0;
    }

    static {
        Sphere sphere = new Sphere(1.0f, 1, 9);
        TriangleStripArray geometry = (TriangleStripArray)sphere.getShape().getGeometry();
        int count = geometry.getVertexCount();
        sphereverts = new float[count * 3];
        spherenormals = new float[count * 3];
        spherestrips = new int[geometry.getNumStrips()];
        geometry.getCoordinates(0, sphereverts);
        geometry.getNormals(0, spherenormals);
        geometry.getStripVertexCounts(spherestrips);
    }
}

