/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.terrain;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.vecmath.Point2f;

public class DomainUtil {
    private static final float MAX_HEIGHT = 0.2f;

    public static float[][] getHeights(float[][] locations, int size, float sigma) {
        return DomainUtil.getHeights(locations, size, sigma, new Point2f(), new Point2f(1.0f, 1.0f));
    }

    public static float[][] getHeights(float[][] locations, int size, float sigma, Point2f p1, Point2f p2) {
        float side_size = Math.max(Math.abs(p2.x - p1.x), Math.abs(p2.y - p1.y));
        float step = side_size / (float)size;
        float x1 = p1.x + step / 2.0f;
        float y1 = p1.y + step / 2.0f;
        float[][] heights = new float[size][size];
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                float sum = 0.0f;
                for (int gene = 0; gene < locations.length; ++gene) {
                    float x2 = locations[gene][0];
                    float y2 = locations[gene][1];
                    sum = (float)((double)sum + DomainUtil.disperse(sigma, x1, y1, x2, y2));
                }
                heights[i][j] = sum;
                x1 += step;
            }
            x1 = p1.x + step / 2.0f;
            y1 += step;
        }
        DomainUtil.normalize(heights);
        return heights;
    }

    private static void normalize(float[][] heights) {
        int size = heights.length;
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                min = Math.min(min, heights[i][j]);
                max = Math.max(max, heights[i][j]);
            }
        }
        float scale = max == min ? 1.0f : 0.2f / (max - min);
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                heights[i][j] = (heights[i][j] - min) * scale;
            }
        }
    }

    private static double disperse(float sigma, float x1, float y1, float x2, float y2) {
        float r2 = (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2);
        float sigma2 = sigma * sigma;
        if (r2 > 4.0f * sigma2) {
            return 0.0;
        }
        return Math.exp(-r2 / (2.0f * sigma2));
    }

    public static BufferedImage createGradientImage(int size) {
        BufferedImage gradient = new BufferedImage(size, 1, 5);
        Graphics2D graphics = gradient.createGraphics();
        GradientPaint gp = new GradientPaint(0.0f, 0.0f, Color.green, size - 1, 0.0f, Color.red);
        graphics.setPaint(gp);
        graphics.drawRect(0, 0, size - 1, 1);
        graphics.dispose();
        return gradient;
    }
}

